// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains details of a table archival operation.
type ArchivalSummary struct {

	// The Amazon Resource Name (ARN) of the backup the table was archived to, when
	// applicable in the archival reason. If you wish to restore this backup to the
	// same table name, you will need to delete the original table.
	ArchivalBackupArn *string

	// The date and time when table archival was initiated by DynamoDB, in UNIX epoch
	// time format.
	ArchivalDateTime *time.Time

	// The reason DynamoDB archived the table. Currently, the only possible value
	// is:
	//
	// * INACCESSIBLE_ENCRYPTION_CREDENTIALS - The table was archived due to the
	// table's KMS key being inaccessible for more than seven days. An On-Demand backup
	// was created at the archival time.
	ArchivalReason *string

	noSmithyDocumentSerde
}

// Represents an attribute for describing the key schema for the table and indexes.
type AttributeDefinition struct {

	// A name for the attribute.
	//
	// This member is required.
	AttributeName *string

	// The data type for the attribute, where:
	//
	// * S - the attribute is of type
	// String
	//
	// * N - the attribute is of type Number
	//
	// * B - the attribute is of type
	// Binary
	//
	// This member is required.
	AttributeType ScalarAttributeType

	noSmithyDocumentSerde
}

// Represents the data for an attribute. Each attribute value is described as a
// name-value pair. The name is the data type, and the value is the data itself.
// For more information, see Data Types
// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes)
// in the Amazon DynamoDB Developer Guide.
//
// The following types satisfy this interface:
//  AttributeValueMemberB
//  AttributeValueMemberBOOL
//  AttributeValueMemberBS
//  AttributeValueMemberL
//  AttributeValueMemberM
//  AttributeValueMemberN
//  AttributeValueMemberNS
//  AttributeValueMemberNULL
//  AttributeValueMemberS
//  AttributeValueMemberSS
type AttributeValue interface {
	isAttributeValue()
}

// An attribute of type Binary. For example: "B":
// "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"
type AttributeValueMemberB struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*AttributeValueMemberB) isAttributeValue() {}

// An attribute of type Boolean. For example: "BOOL": true
type AttributeValueMemberBOOL struct {
	Value bool

	noSmithyDocumentSerde
}

func (*AttributeValueMemberBOOL) isAttributeValue() {}

// An attribute of type Binary Set. For example: "BS": ["U3Vubnk=", "UmFpbnk=",
// "U25vd3k="]
type AttributeValueMemberBS struct {
	Value [][]byte

	noSmithyDocumentSerde
}

func (*AttributeValueMemberBS) isAttributeValue() {}

// An attribute of type List. For example: "L": [ {"S": "Cookies"} , {"S":
// "Coffee"}, {"N", "3.14159"}]
type AttributeValueMemberL struct {
	Value []AttributeValue

	noSmithyDocumentSerde
}

func (*AttributeValueMemberL) isAttributeValue() {}

// An attribute of type Map. For example: "M": {"Name": {"S": "Joe"}, "Age": {"N":
// "35"}}
type AttributeValueMemberM struct {
	Value map[string]AttributeValue

	noSmithyDocumentSerde
}

func (*AttributeValueMemberM) isAttributeValue() {}

// An attribute of type Number. For example: "N": "123.45" Numbers are sent across
// the network to DynamoDB as strings, to maximize compatibility across languages
// and libraries. However, DynamoDB treats them as number type attributes for
// mathematical operations.
type AttributeValueMemberN struct {
	Value string

	noSmithyDocumentSerde
}

func (*AttributeValueMemberN) isAttributeValue() {}

// An attribute of type Number Set. For example: "NS": ["42.2", "-19", "7.5",
// "3.14"] Numbers are sent across the network to DynamoDB as strings, to maximize
// compatibility across languages and libraries. However, DynamoDB treats them as
// number type attributes for mathematical operations.
type AttributeValueMemberNS struct {
	Value []string

	noSmithyDocumentSerde
}

func (*AttributeValueMemberNS) isAttributeValue() {}

// An attribute of type Null. For example: "NULL": true
type AttributeValueMemberNULL struct {
	Value bool

	noSmithyDocumentSerde
}

func (*AttributeValueMemberNULL) isAttributeValue() {}

// An attribute of type String. For example: "S": "Hello"
type AttributeValueMemberS struct {
	Value string

	noSmithyDocumentSerde
}

func (*AttributeValueMemberS) isAttributeValue() {}

// An attribute of type String Set. For example: "SS": ["Giraffe", "Hippo"
// ,"Zebra"]
type AttributeValueMemberSS struct {
	Value []string

	noSmithyDocumentSerde
}

func (*AttributeValueMemberSS) isAttributeValue() {}

// For the UpdateItem operation, represents the attributes to be modified, the
// action to perform on each, and the new value for each. You cannot use UpdateItem
// to update any primary key attributes. Instead, you will need to delete the item,
// and then use PutItem to create a new item with new attributes. Attribute values
// cannot be null; string and binary type attributes must have lengths greater than
// zero; and set type attributes must not be empty. Requests with empty values will
// be rejected with a ValidationException exception.
type AttributeValueUpdate struct {

	// Specifies how to perform the update. Valid values are PUT (default), DELETE, and
	// ADD. The behavior depends on whether the specified primary key already exists in
	// the table. If an item with the specified Key is found in the table:
	//
	// * PUT -
	// Adds the specified attribute to the item. If the attribute already exists, it is
	// replaced by the new value.
	//
	// * DELETE - If no value is specified, the attribute
	// and its value are removed from the item. The data type of the specified value
	// must match the existing value's data type. If a set of values is specified, then
	// those values are subtracted from the old set. For example, if the attribute
	// value was the set [a,b,c] and the DELETE action specified [a,c], then the final
	// attribute value would be [b]. Specifying an empty set is an error.
	//
	// * ADD - If
	// the attribute does not already exist, then the attribute and its values are
	// added to the item. If the attribute does exist, then the behavior of ADD depends
	// on the data type of the attribute:
	//
	// * If the existing attribute is a number, and
	// if Value is also a number, then the Value is mathematically added to the
	// existing attribute. If Value is a negative number, then it is subtracted from
	// the existing attribute. If you use ADD to increment or decrement a number value
	// for an item that doesn't exist before the update, DynamoDB uses 0 as the initial
	// value. In addition, if you use ADD to update an existing item, and intend to
	// increment or decrement an attribute value which does not yet exist, DynamoDB
	// uses 0 as the initial value. For example, suppose that the item you want to
	// update does not yet have an attribute named itemcount, but you decide to ADD the
	// number 3 to this attribute anyway, even though it currently does not exist.
	// DynamoDB will create the itemcount attribute, set its initial value to 0, and
	// finally add 3 to it. The result will be a new itemcount attribute in the item,
	// with a value of 3.
	//
	// * If the existing data type is a set, and if the Value is
	// also a set, then the Value is added to the existing set. (This is a set
	// operation, not mathematical addition.) For example, if the attribute value was
	// the set [1,2], and the ADD action specified [3], then the final attribute value
	// would be [1,2,3]. An error occurs if an Add action is specified for a set
	// attribute and the attribute type specified does not match the existing set type.
	// Both sets must have the same primitive data type. For example, if the existing
	// data type is a set of strings, the Value must also be a set of strings. The same
	// holds true for number sets and binary sets.
	//
	// This action is only valid for an
	// existing attribute whose data type is number or is a set. Do not use ADD for any
	// other data types.
	//
	// If no item with the specified Key is found:
	//
	// * PUT - DynamoDB
	// creates a new item with the specified primary key, and then adds the
	// attribute.
	//
	// * DELETE - Nothing happens; there is no attribute to delete.
	//
	// * ADD
	// - DynamoDB creates an item with the supplied primary key and number (or set of
	// numbers) for the attribute value. The only data types allowed are number and
	// number set; no other data types can be specified.
	Action AttributeAction

	// Represents the data for an attribute. Each attribute value is described as a
	// name-value pair. The name is the data type, and the value is the data itself.
	// For more information, see Data Types
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes)
	// in the Amazon DynamoDB Developer Guide.
	Value AttributeValue

	noSmithyDocumentSerde
}

// Represents the properties of the scaling policy.
type AutoScalingPolicyDescription struct {

	// The name of the scaling policy.
	PolicyName *string

	// Represents a target tracking scaling policy configuration.
	TargetTrackingScalingPolicyConfiguration *AutoScalingTargetTrackingScalingPolicyConfigurationDescription

	noSmithyDocumentSerde
}

// Represents the auto scaling policy to be modified.
type AutoScalingPolicyUpdate struct {

	// Represents a target tracking scaling policy configuration.
	//
	// This member is required.
	TargetTrackingScalingPolicyConfiguration *AutoScalingTargetTrackingScalingPolicyConfigurationUpdate

	// The name of the scaling policy.
	PolicyName *string

	noSmithyDocumentSerde
}

// Represents the auto scaling settings for a global table or global secondary
// index.
type AutoScalingSettingsDescription struct {

	// Disabled auto scaling for this global table or global secondary index.
	AutoScalingDisabled *bool

	// Role ARN used for configuring the auto scaling policy.
	AutoScalingRoleArn *string

	// The maximum capacity units that a global table or global secondary index should
	// be scaled up to.
	MaximumUnits *int64

	// The minimum capacity units that a global table or global secondary index should
	// be scaled down to.
	MinimumUnits *int64

	// Information about the scaling policies.
	ScalingPolicies []AutoScalingPolicyDescription

	noSmithyDocumentSerde
}

// Represents the auto scaling settings to be modified for a global table or global
// secondary index.
type AutoScalingSettingsUpdate struct {

	// Disabled auto scaling for this global table or global secondary index.
	AutoScalingDisabled *bool

	// Role ARN used for configuring auto scaling policy.
	AutoScalingRoleArn *string

	// The maximum capacity units that a global table or global secondary index should
	// be scaled up to.
	MaximumUnits *int64

	// The minimum capacity units that a global table or global secondary index should
	// be scaled down to.
	MinimumUnits *int64

	// The scaling policy to apply for scaling target global table or global secondary
	// index capacity units.
	ScalingPolicyUpdate *AutoScalingPolicyUpdate

	noSmithyDocumentSerde
}

// Represents the properties of a target tracking scaling policy.
type AutoScalingTargetTrackingScalingPolicyConfigurationDescription struct {

	// The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
	// (Base 10) or 2e-360 to 2e360 (Base 2).
	//
	// This member is required.
	TargetValue *float64

	// Indicates whether scale in by the target tracking policy is disabled. If the
	// value is true, scale in is disabled and the target tracking policy won't remove
	// capacity from the scalable resource. Otherwise, scale in is enabled and the
	// target tracking policy can remove capacity from the scalable resource. The
	// default value is false.
	DisableScaleIn *bool

	// The amount of time, in seconds, after a scale in activity completes before
	// another scale in activity can start. The cooldown period is used to block
	// subsequent scale in requests until it has expired. You should scale in
	// conservatively to protect your application's availability. However, if another
	// alarm triggers a scale out policy during the cooldown period after a scale-in,
	// application auto scaling scales out your scalable target immediately.
	ScaleInCooldown *int32

	// The amount of time, in seconds, after a scale out activity completes before
	// another scale out activity can start. While the cooldown period is in effect,
	// the capacity that has been added by the previous scale out event that initiated
	// the cooldown is calculated as part of the desired capacity for the next scale
	// out. You should continuously (but not excessively) scale out.
	ScaleOutCooldown *int32

	noSmithyDocumentSerde
}

// Represents the settings of a target tracking scaling policy that will be
// modified.
type AutoScalingTargetTrackingScalingPolicyConfigurationUpdate struct {

	// The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
	// (Base 10) or 2e-360 to 2e360 (Base 2).
	//
	// This member is required.
	TargetValue *float64

	// Indicates whether scale in by the target tracking policy is disabled. If the
	// value is true, scale in is disabled and the target tracking policy won't remove
	// capacity from the scalable resource. Otherwise, scale in is enabled and the
	// target tracking policy can remove capacity from the scalable resource. The
	// default value is false.
	DisableScaleIn *bool

	// The amount of time, in seconds, after a scale in activity completes before
	// another scale in activity can start. The cooldown period is used to block
	// subsequent scale in requests until it has expired. You should scale in
	// conservatively to protect your application's availability. However, if another
	// alarm triggers a scale out policy during the cooldown period after a scale-in,
	// application auto scaling scales out your scalable target immediately.
	ScaleInCooldown *int32

	// The amount of time, in seconds, after a scale out activity completes before
	// another scale out activity can start. While the cooldown period is in effect,
	// the capacity that has been added by the previous scale out event that initiated
	// the cooldown is calculated as part of the desired capacity for the next scale
	// out. You should continuously (but not excessively) scale out.
	ScaleOutCooldown *int32

	noSmithyDocumentSerde
}

// Contains the description of the backup created for the table.
type BackupDescription struct {

	// Contains the details of the backup created for the table.
	BackupDetails *BackupDetails

	// Contains the details of the table when the backup was created.
	SourceTableDetails *SourceTableDetails

	// Contains the details of the features enabled on the table when the backup was
	// created. For example, LSIs, GSIs, streams, TTL.
	SourceTableFeatureDetails *SourceTableFeatureDetails

	noSmithyDocumentSerde
}

// Contains the details of the backup created for the table.
type BackupDetails struct {

	// ARN associated with the backup.
	//
	// This member is required.
	BackupArn *string

	// Time at which the backup was created. This is the request time of the backup.
	//
	// This member is required.
	BackupCreationDateTime *time.Time

	// Name of the requested backup.
	//
	// This member is required.
	BackupName *string

	// Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
	//
	// This member is required.
	BackupStatus BackupStatus

	// BackupType:
	//
	// * USER - You create and manage these using the on-demand backup
	// feature.
	//
	// * SYSTEM - If you delete a table with point-in-time recovery enabled,
	// a SYSTEM backup is automatically created and is retained for 35 days (at no
	// additional cost). System backups allow you to restore the deleted table to the
	// state it was in just before the point of deletion.
	//
	// * AWS_BACKUP - On-demand
	// backup created by you from Backup service.
	//
	// This member is required.
	BackupType BackupType

	// Time at which the automatic on-demand backup created by DynamoDB will expire.
	// This SYSTEM on-demand backup expires automatically 35 days after its creation.
	BackupExpiryDateTime *time.Time

	// Size of the backup in bytes.
	BackupSizeBytes *int64

	noSmithyDocumentSerde
}

// Contains details for the backup.
type BackupSummary struct {

	// ARN associated with the backup.
	BackupArn *string

	// Time at which the backup was created.
	BackupCreationDateTime *time.Time

	// Time at which the automatic on-demand backup created by DynamoDB will expire.
	// This SYSTEM on-demand backup expires automatically 35 days after its creation.
	BackupExpiryDateTime *time.Time

	// Name of the specified backup.
	BackupName *string

	// Size of the backup in bytes.
	BackupSizeBytes *int64

	// Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
	BackupStatus BackupStatus

	// BackupType:
	//
	// * USER - You create and manage these using the on-demand backup
	// feature.
	//
	// * SYSTEM - If you delete a table with point-in-time recovery enabled,
	// a SYSTEM backup is automatically created and is retained for 35 days (at no
	// additional cost). System backups allow you to restore the deleted table to the
	// state it was in just before the point of deletion.
	//
	// * AWS_BACKUP - On-demand
	// backup created by you from Backup service.
	BackupType BackupType

	// ARN associated with the table.
	TableArn *string

	// Unique identifier for the table.
	TableId *string

	// Name of the table.
	TableName *string

	noSmithyDocumentSerde
}

// An error associated with a statement in a PartiQL batch that was run.
type BatchStatementError struct {

	// The error code associated with the failed PartiQL batch statement.
	Code BatchStatementErrorCodeEnum

	// The error message associated with the PartiQL batch resposne.
	Message *string

	noSmithyDocumentSerde
}

// A PartiQL batch statement request.
type BatchStatementRequest struct {

	// A valid PartiQL statement.
	//
	// This member is required.
	Statement *string

	// The read consistency of the PartiQL batch request.
	ConsistentRead *bool

	// The parameters associated with a PartiQL statement in the batch request.
	Parameters []AttributeValue

	noSmithyDocumentSerde
}

// A PartiQL batch statement response..
type BatchStatementResponse struct {

	// The error associated with a failed PartiQL batch statement.
	Error *BatchStatementError

	// A DynamoDB item associated with a BatchStatementResponse
	Item map[string]AttributeValue

	// The table name associated with a failed PartiQL batch statement.
	TableName *string

	noSmithyDocumentSerde
}

// Contains the details for the read/write capacity mode.
type BillingModeSummary struct {

	// Controls how you are charged for read and write throughput and how you manage
	// capacity. This setting can be changed later.
	//
	// * PROVISIONED - Sets the
	// read/write capacity mode to PROVISIONED. We recommend using PROVISIONED for
	// predictable workloads.
	//
	// * PAY_PER_REQUEST - Sets the read/write capacity mode to
	// PAY_PER_REQUEST. We recommend using PAY_PER_REQUEST for unpredictable workloads.
	BillingMode BillingMode

	// Represents the time when PAY_PER_REQUEST was last set as the read/write capacity
	// mode.
	LastUpdateToPayPerRequestDateTime *time.Time

	noSmithyDocumentSerde
}

// An ordered list of errors for each item in the request which caused the
// transaction to get cancelled. The values of the list are ordered according to
// the ordering of the TransactWriteItems request parameter. If no error occurred
// for the associated item an error with a Null code and Null message will be
// present.
type CancellationReason struct {

	// Status code for the result of the cancelled transaction.
	Code *string

	// Item in the request which caused the transaction to get cancelled.
	Item map[string]AttributeValue

	// Cancellation reason message description.
	Message *string

	noSmithyDocumentSerde
}

// Represents the amount of provisioned throughput capacity consumed on a table or
// an index.
type Capacity struct {

	// The total number of capacity units consumed on a table or an index.
	CapacityUnits *float64

	// The total number of read capacity units consumed on a table or an index.
	ReadCapacityUnits *float64

	// The total number of write capacity units consumed on a table or an index.
	WriteCapacityUnits *float64

	noSmithyDocumentSerde
}

// Represents the selection criteria for a Query or Scan operation:
//
// * For a Query
// operation, Condition is used for specifying the KeyConditions to use when
// querying a table or an index. For KeyConditions, only the following comparison
// operators are supported: EQ | LE | LT | GE | GT | BEGINS_WITH | BETWEENCondition
// is also used in a QueryFilter, which evaluates the query results and returns
// only the desired values.
//
// * For a Scan operation, Condition is used in a
// ScanFilter, which evaluates the scan results and returns only the desired
// values.
type Condition struct {

	// A comparator for evaluating attributes. For example, equals, greater than, less
	// than, etc. The following comparison operators are available: EQ | NE | LE | LT |
	// GE | GT | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS | BEGINS_WITH | IN | BETWEEN
	// The following are descriptions of each comparison operator.
	//
	// * EQ : Equal. EQ is
	// supported for all data types, including lists and maps. AttributeValueList can
	// contain only one AttributeValue element of type String, Number, Binary, String
	// Set, Number Set, or Binary Set. If an item contains an AttributeValue element of
	// a different type than the one provided in the request, the value does not match.
	// For example, {"S":"6"} does not equal {"N":"6"}. Also, {"N":"6"} does not equal
	// {"NS":["6", "2", "1"]}.
	//
	// * NE : Not equal. NE is supported for all data types,
	// including lists and maps. AttributeValueList can contain only one AttributeValue
	// of type String, Number, Binary, String Set, Number Set, or Binary Set. If an
	// item contains an AttributeValue of a different type than the one provided in the
	// request, the value does not match. For example, {"S":"6"} does not equal
	// {"N":"6"}. Also, {"N":"6"} does not equal {"NS":["6", "2", "1"]}.
	//
	// * LE : Less
	// than or equal. AttributeValueList can contain only one AttributeValue element of
	// type String, Number, or Binary (not a set type). If an item contains an
	// AttributeValue element of a different type than the one provided in the request,
	// the value does not match. For example, {"S":"6"} does not equal {"N":"6"}. Also,
	// {"N":"6"} does not compare to {"NS":["6", "2", "1"]}.
	//
	// * LT : Less than.
	// AttributeValueList can contain only one AttributeValue of type String, Number,
	// or Binary (not a set type). If an item contains an AttributeValue element of a
	// different type than the one provided in the request, the value does not match.
	// For example, {"S":"6"} does not equal {"N":"6"}. Also, {"N":"6"} does not
	// compare to {"NS":["6", "2", "1"]}.
	//
	// * GE : Greater than or equal.
	// AttributeValueList can contain only one AttributeValue element of type String,
	// Number, or Binary (not a set type). If an item contains an AttributeValue
	// element of a different type than the one provided in the request, the value does
	// not match. For example, {"S":"6"} does not equal {"N":"6"}. Also, {"N":"6"} does
	// not compare to {"NS":["6", "2", "1"]}.
	//
	// * GT : Greater than. AttributeValueList
	// can contain only one AttributeValue element of type String, Number, or Binary
	// (not a set type). If an item contains an AttributeValue element of a different
	// type than the one provided in the request, the value does not match. For
	// example, {"S":"6"} does not equal {"N":"6"}. Also, {"N":"6"} does not compare to
	// {"NS":["6", "2", "1"]}.
	//
	// * NOT_NULL : The attribute exists. NOT_NULL is
	// supported for all data types, including lists and maps. This operator tests for
	// the existence of an attribute, not its data type. If the data type of attribute
	// "a" is null, and you evaluate it using NOT_NULL, the result is a Boolean true.
	// This result is because the attribute "a" exists; its data type is not relevant
	// to the NOT_NULL comparison operator.
	//
	// * NULL : The attribute does not exist.
	// NULL is supported for all data types, including lists and maps. This operator
	// tests for the nonexistence of an attribute, not its data type. If the data type
	// of attribute "a" is null, and you evaluate it using NULL, the result is a
	// Boolean false. This is because the attribute "a" exists; its data type is not
	// relevant to the NULL comparison operator.
	//
	// * CONTAINS : Checks for a
	// subsequence, or value in a set. AttributeValueList can contain only one
	// AttributeValue element of type String, Number, or Binary (not a set type). If
	// the target attribute of the comparison is of type String, then the operator
	// checks for a substring match. If the target attribute of the comparison is of
	// type Binary, then the operator looks for a subsequence of the target that
	// matches the input. If the target attribute of the comparison is a set ("SS",
	// "NS", or "BS"), then the operator evaluates to true if it finds an exact match
	// with any member of the set. CONTAINS is supported for lists: When evaluating "a
	// CONTAINS b", "a" can be a list; however, "b" cannot be a set, a map, or a
	// list.
	//
	// * NOT_CONTAINS : Checks for absence of a subsequence, or absence of a
	// value in a set. AttributeValueList can contain only one AttributeValue element
	// of type String, Number, or Binary (not a set type). If the target attribute of
	// the comparison is a String, then the operator checks for the absence of a
	// substring match. If the target attribute of the comparison is Binary, then the
	// operator checks for the absence of a subsequence of the target that matches the
	// input. If the target attribute of the comparison is a set ("SS", "NS", or "BS"),
	// then the operator evaluates to true if it does not find an exact match with any
	// member of the set. NOT_CONTAINS is supported for lists: When evaluating "a NOT
	// CONTAINS b", "a" can be a list; however, "b" cannot be a set, a map, or a
	// list.
	//
	// * BEGINS_WITH : Checks for a prefix. AttributeValueList can contain only
	// one AttributeValue of type String or Binary (not a Number or a set type). The
	// target attribute of the comparison must be of type String or Binary (not a
	// Number or a set type).
	//
	// * IN : Checks for matching elements in a list.
	// AttributeValueList can contain one or more AttributeValue elements of type
	// String, Number, or Binary. These attributes are compared against an existing
	// attribute of an item. If any elements of the input are equal to the item
	// attribute, the expression evaluates to true.
	//
	// * BETWEEN : Greater than or equal
	// to the first value, and less than or equal to the second value.
	// AttributeValueList must contain two AttributeValue elements of the same type,
	// either String, Number, or Binary (not a set type). A target attribute matches if
	// the target value is greater than, or equal to, the first element and less than,
	// or equal to, the second element. If an item contains an AttributeValue element
	// of a different type than the one provided in the request, the value does not
	// match. For example, {"S":"6"} does not compare to {"N":"6"}. Also, {"N":"6"}
	// does not compare to {"NS":["6", "2", "1"]}
	//
	// For usage examples of
	// AttributeValueList and ComparisonOperator, see Legacy Conditional Parameters
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html)
	// in the Amazon DynamoDB Developer Guide.
	//
	// This member is required.
	ComparisonOperator ComparisonOperator

	// One or more values to evaluate against the supplied attribute. The number of
	// values in the list depends on the ComparisonOperator being used. For type
	// Number, value comparisons are numeric. String value comparisons for greater
	// than, equals, or less than are based on ASCII character code values. For
	// example, a is greater than A, and a is greater than B. For a list of code
	// values, see http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters
	// (http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters). For Binary,
	// DynamoDB treats each byte of the binary data as unsigned when it compares binary
	// values.
	AttributeValueList []AttributeValue

	noSmithyDocumentSerde
}

// Represents a request to perform a check that an item exists or to check the
// condition of specific attributes of the item.
type ConditionCheck struct {

	// A condition that must be satisfied in order for a conditional update to succeed.
	//
	// This member is required.
	ConditionExpression *string

	// The primary key of the item to be checked. Each element consists of an attribute
	// name and a value for that attribute.
	//
	// This member is required.
	Key map[string]AttributeValue

	// Name of the table for the check item request.
	//
	// This member is required.
	TableName *string

	// One or more substitution tokens for attribute names in an expression.
	ExpressionAttributeNames map[string]string

	// One or more values that can be substituted in an expression.
	ExpressionAttributeValues map[string]AttributeValue

	// Use ReturnValuesOnConditionCheckFailure to get the item attributes if the
	// ConditionCheck condition fails. For ReturnValuesOnConditionCheckFailure, the
	// valid values are: NONE and ALL_OLD.
	ReturnValuesOnConditionCheckFailure ReturnValuesOnConditionCheckFailure

	noSmithyDocumentSerde
}

// The capacity units consumed by an operation. The data returned includes the
// total provisioned throughput consumed, along with statistics for the table and
// any indexes involved in the operation. ConsumedCapacity is only returned if the
// request asked for it. For more information, see Provisioned Throughput
// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html)
// in the Amazon DynamoDB Developer Guide.
type ConsumedCapacity struct {

	// The total number of capacity units consumed by the operation.
	CapacityUnits *float64

	// The amount of throughput consumed on each global index affected by the
	// operation.
	GlobalSecondaryIndexes map[string]Capacity

	// The amount of throughput consumed on each local index affected by the operation.
	LocalSecondaryIndexes map[string]Capacity

	// The total number of read capacity units consumed by the operation.
	ReadCapacityUnits *float64

	// The amount of throughput consumed on the table affected by the operation.
	Table *Capacity

	// The name of the table that was affected by the operation.
	TableName *string

	// The total number of write capacity units consumed by the operation.
	WriteCapacityUnits *float64

	noSmithyDocumentSerde
}

// Represents the continuous backups and point in time recovery settings on the
// table.
type ContinuousBackupsDescription struct {

	// ContinuousBackupsStatus can be one of the following states: ENABLED, DISABLED
	//
	// This member is required.
	ContinuousBackupsStatus ContinuousBackupsStatus

	// The description of the point in time recovery settings applied to the table.
	PointInTimeRecoveryDescription *PointInTimeRecoveryDescription

	noSmithyDocumentSerde
}

// Represents a Contributor Insights summary entry.
type ContributorInsightsSummary struct {

	// Describes the current status for contributor insights for the given table and
	// index, if applicable.
	ContributorInsightsStatus ContributorInsightsStatus

	// Name of the index associated with the summary, if any.
	IndexName *string

	// Name of the table associated with the summary.
	TableName *string

	noSmithyDocumentSerde
}

// Represents a new global secondary index to be added to an existing table.
type CreateGlobalSecondaryIndexAction struct {

	// The name of the global secondary index to be created.
	//
	// This member is required.
	IndexName *string

	// The key schema for the global secondary index.
	//
	// This member is required.
	KeySchema []KeySchemaElement

	// Represents attributes that are copied (projected) from the table into an index.
	// These are in addition to the primary key attributes and index key attributes,
	// which are automatically projected.
	//
	// This member is required.
	Projection *Projection

	// Represents the provisioned throughput settings for the specified global
	// secondary index. For current minimum and maximum provisioned throughput values,
	// see Service, Account, and Table Quotas
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	ProvisionedThroughput *ProvisionedThroughput

	noSmithyDocumentSerde
}

// Represents a replica to be added.
type CreateReplicaAction struct {

	// The Region of the replica to be added.
	//
	// This member is required.
	RegionName *string

	noSmithyDocumentSerde
}

// Represents a replica to be created.
type CreateReplicationGroupMemberAction struct {

	// The Region where the new replica will be created.
	//
	// This member is required.
	RegionName *string

	// Replica-specific global secondary index settings.
	GlobalSecondaryIndexes []ReplicaGlobalSecondaryIndex

	// The KMS key that should be used for KMS encryption in the new replica. To
	// specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias
	// ARN. Note that you should only provide this parameter if the key is different
	// from the default DynamoDB KMS key alias/aws/dynamodb.
	KMSMasterKeyId *string

	// Replica-specific provisioned throughput. If not specified, uses the source
	// table's provisioned throughput settings.
	ProvisionedThroughputOverride *ProvisionedThroughputOverride

	// Replica-specific table class. If not specified, uses the source table's table
	// class.
	TableClassOverride TableClass

	noSmithyDocumentSerde
}

// Represents a request to perform a DeleteItem operation.
type Delete struct {

	// The primary key of the item to be deleted. Each element consists of an attribute
	// name and a value for that attribute.
	//
	// This member is required.
	Key map[string]AttributeValue

	// Name of the table in which the item to be deleted resides.
	//
	// This member is required.
	TableName *string

	// A condition that must be satisfied in order for a conditional delete to succeed.
	ConditionExpression *string

	// One or more substitution tokens for attribute names in an expression.
	ExpressionAttributeNames map[string]string

	// One or more values that can be substituted in an expression.
	ExpressionAttributeValues map[string]AttributeValue

	// Use ReturnValuesOnConditionCheckFailure to get the item attributes if the Delete
	// condition fails. For ReturnValuesOnConditionCheckFailure, the valid values are:
	// NONE and ALL_OLD.
	ReturnValuesOnConditionCheckFailure ReturnValuesOnConditionCheckFailure

	noSmithyDocumentSerde
}

// Represents a global secondary index to be deleted from an existing table.
type DeleteGlobalSecondaryIndexAction struct {

	// The name of the global secondary index to be deleted.
	//
	// This member is required.
	IndexName *string

	noSmithyDocumentSerde
}

// Represents a replica to be removed.
type DeleteReplicaAction struct {

	// The Region of the replica to be removed.
	//
	// This member is required.
	RegionName *string

	noSmithyDocumentSerde
}

// Represents a replica to be deleted.
type DeleteReplicationGroupMemberAction struct {

	// The Region where the replica exists.
	//
	// This member is required.
	RegionName *string

	noSmithyDocumentSerde
}

// Represents a request to perform a DeleteItem operation on an item.
type DeleteRequest struct {

	// A map of attribute name to attribute values, representing the primary key of the
	// item to delete. All of the table's primary key attributes must be specified, and
	// their data types must match those of the table's key schema.
	//
	// This member is required.
	Key map[string]AttributeValue

	noSmithyDocumentSerde
}

// An endpoint information details.
type Endpoint struct {

	// IP address of the endpoint.
	//
	// This member is required.
	Address *string

	// Endpoint cache time to live (TTL) value.
	//
	// This member is required.
	CachePeriodInMinutes int64

	noSmithyDocumentSerde
}

// Represents a condition to be compared with an attribute value. This condition
// can be used with DeleteItem, PutItem, or UpdateItem operations; if the
// comparison evaluates to true, the operation succeeds; if not, the operation
// fails. You can use ExpectedAttributeValue in one of two different ways:
//
// * Use
// AttributeValueList to specify one or more values to compare against an
// attribute. Use ComparisonOperator to specify how you want to perform the
// comparison. If the comparison evaluates to true, then the conditional operation
// succeeds.
//
// * Use Value to specify a value that DynamoDB will compare against an
// attribute. If the values match, then ExpectedAttributeValue evaluates to true
// and the conditional operation succeeds. Optionally, you can also set Exists to
// false, indicating that you do not expect to find the attribute value in the
// table. In this case, the conditional operation succeeds only if the comparison
// evaluates to false.
//
// Value and Exists are incompatible with AttributeValueList
// and ComparisonOperator. Note that if you use both sets of parameters at once,
// DynamoDB will return a ValidationException exception.
type ExpectedAttributeValue struct {

	// One or more values to evaluate against the supplied attribute. The number of
	// values in the list depends on the ComparisonOperator being used. For type
	// Number, value comparisons are numeric. String value comparisons for greater
	// than, equals, or less than are based on ASCII character code values. For
	// example, a is greater than A, and a is greater than B. For a list of code
	// values, see http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters
	// (http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters). For Binary,
	// DynamoDB treats each byte of the binary data as unsigned when it compares binary
	// values. For information on specifying data types in JSON, see JSON Data Format
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataFormat.html)
	// in the Amazon DynamoDB Developer Guide.
	AttributeValueList []AttributeValue

	// A comparator for evaluating attributes in the AttributeValueList. For example,
	// equals, greater than, less than, etc. The following comparison operators are
	// available: EQ | NE | LE | LT | GE | GT | NOT_NULL | NULL | CONTAINS |
	// NOT_CONTAINS | BEGINS_WITH | IN | BETWEEN The following are descriptions of each
	// comparison operator.
	//
	// * EQ : Equal. EQ is supported for all data types,
	// including lists and maps. AttributeValueList can contain only one AttributeValue
	// element of type String, Number, Binary, String Set, Number Set, or Binary Set.
	// If an item contains an AttributeValue element of a different type than the one
	// provided in the request, the value does not match. For example, {"S":"6"} does
	// not equal {"N":"6"}. Also, {"N":"6"} does not equal {"NS":["6", "2", "1"]}.
	//
	// *
	// NE : Not equal. NE is supported for all data types, including lists and maps.
	// AttributeValueList can contain only one AttributeValue of type String, Number,
	// Binary, String Set, Number Set, or Binary Set. If an item contains an
	// AttributeValue of a different type than the one provided in the request, the
	// value does not match. For example, {"S":"6"} does not equal {"N":"6"}. Also,
	// {"N":"6"} does not equal {"NS":["6", "2", "1"]}.
	//
	// * LE : Less than or equal.
	// AttributeValueList can contain only one AttributeValue element of type String,
	// Number, or Binary (not a set type). If an item contains an AttributeValue
	// element of a different type than the one provided in the request, the value does
	// not match. For example, {"S":"6"} does not equal {"N":"6"}. Also, {"N":"6"} does
	// not compare to {"NS":["6", "2", "1"]}.
	//
	// * LT : Less than. AttributeValueList can
	// contain only one AttributeValue of type String, Number, or Binary (not a set
	// type). If an item contains an AttributeValue element of a different type than
	// the one provided in the request, the value does not match. For example,
	// {"S":"6"} does not equal {"N":"6"}. Also, {"N":"6"} does not compare to
	// {"NS":["6", "2", "1"]}.
	//
	// * GE : Greater than or equal. AttributeValueList can
	// contain only one AttributeValue element of type String, Number, or Binary (not a
	// set type). If an item contains an AttributeValue element of a different type
	// than the one provided in the request, the value does not match. For example,
	// {"S":"6"} does not equal {"N":"6"}. Also, {"N":"6"} does not compare to
	// {"NS":["6", "2", "1"]}.
	//
	// * GT : Greater than. AttributeValueList can contain
	// only one AttributeValue element of type String, Number, or Binary (not a set
	// type). If an item contains an AttributeValue element of a different type than
	// the one provided in the request, the value does not match. For example,
	// {"S":"6"} does not equal {"N":"6"}. Also, {"N":"6"} does not compare to
	// {"NS":["6", "2", "1"]}.
	//
	// * NOT_NULL : The attribute exists. NOT_NULL is
	// supported for all data types, including lists and maps. This operator tests for
	// the existence of an attribute, not its data type. If the data type of attribute
	// "a" is null, and you evaluate it using NOT_NULL, the result is a Boolean true.
	// This result is because the attribute "a" exists; its data type is not relevant
	// to the NOT_NULL comparison operator.
	//
	// * NULL : The attribute does not exist.
	// NULL is supported for all data types, including lists and maps. This operator
	// tests for the nonexistence of an attribute, not its data type. If the data type
	// of attribute "a" is null, and you evaluate it using NULL, the result is a
	// Boolean false. This is because the attribute "a" exists; its data type is not
	// relevant to the NULL comparison operator.
	//
	// * CONTAINS : Checks for a
	// subsequence, or value in a set. AttributeValueList can contain only one
	// AttributeValue element of type String, Number, or Binary (not a set type). If
	// the target attribute of the comparison is of type String, then the operator
	// checks for a substring match. If the target attribute of the comparison is of
	// type Binary, then the operator looks for a subsequence of the target that
	// matches the input. If the target attribute of the comparison is a set ("SS",
	// "NS", or "BS"), then the operator evaluates to true if it finds an exact match
	// with any member of the set. CONTAINS is supported for lists: When evaluating "a
	// CONTAINS b", "a" can be a list; however, "b" cannot be a set, a map, or a
	// list.
	//
	// * NOT_CONTAINS : Checks for absence of a subsequence, or absence of a
	// value in a set. AttributeValueList can contain only one AttributeValue element
	// of type String, Number, or Binary (not a set type). If the target attribute of
	// the comparison is a String, then the operator checks for the absence of a
	// substring match. If the target attribute of the comparison is Binary, then the
	// operator checks for the absence of a subsequence of the target that matches the
	// input. If the target attribute of the comparison is a set ("SS", "NS", or "BS"),
	// then the operator evaluates to true if it does not find an exact match with any
	// member of the set. NOT_CONTAINS is supported for lists: When evaluating "a NOT
	// CONTAINS b", "a" can be a list; however, "b" cannot be a set, a map, or a
	// list.
	//
	// * BEGINS_WITH : Checks for a prefix. AttributeValueList can contain only
	// one AttributeValue of type String or Binary (not a Number or a set type). The
	// target attribute of the comparison must be of type String or Binary (not a
	// Number or a set type).
	//
	// * IN : Checks for matching elements in a list.
	// AttributeValueList can contain one or more AttributeValue elements of type
	// String, Number, or Binary. These attributes are compared against an existing
	// attribute of an item. If any elements of the input are equal to the item
	// attribute, the expression evaluates to true.
	//
	// * BETWEEN : Greater than or equal
	// to the first value, and less than or equal to the second value.
	// AttributeValueList must contain two AttributeValue elements of the same type,
	// either String, Number, or Binary (not a set type). A target attribute matches if
	// the target value is greater than, or equal to, the first element and less than,
	// or equal to, the second element. If an item contains an AttributeValue element
	// of a different type than the one provided in the request, the value does not
	// match. For example, {"S":"6"} does not compare to {"N":"6"}. Also, {"N":"6"}
	// does not compare to {"NS":["6", "2", "1"]}
	ComparisonOperator ComparisonOperator

	// Causes DynamoDB to evaluate the value before attempting a conditional
	// operation:
	//
	// * If Exists is true, DynamoDB will check to see if that attribute
	// value already exists in the table. If it is found, then the operation succeeds.
	// If it is not found, the operation fails with a ConditionCheckFailedException.
	//
	// *
	// If Exists is false, DynamoDB assumes that the attribute value does not exist in
	// the table. If in fact the value does not exist, then the assumption is valid and
	// the operation succeeds. If the value is found, despite the assumption that it
	// does not exist, the operation fails with a ConditionCheckFailedException.
	//
	// The
	// default setting for Exists is true. If you supply a Value all by itself,
	// DynamoDB assumes the attribute exists: You don't have to set Exists to true,
	// because it is implied. DynamoDB returns a ValidationException if:
	//
	// * Exists is
	// true but there is no Value to check. (You expect a value to exist, but don't
	// specify what that value is.)
	//
	// * Exists is false but you also provide a Value.
	// (You cannot expect an attribute to have a value, while also expecting it not to
	// exist.)
	Exists *bool

	// Represents the data for the expected attribute. Each attribute value is
	// described as a name-value pair. The name is the data type, and the value is the
	// data itself. For more information, see Data Types
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes)
	// in the Amazon DynamoDB Developer Guide.
	Value AttributeValue

	noSmithyDocumentSerde
}

// Represents the properties of the exported table.
type ExportDescription struct {

	// The billable size of the table export.
	BilledSizeBytes *int64

	// The client token that was provided for the export task. A client token makes
	// calls to ExportTableToPointInTimeInput idempotent, meaning that multiple
	// identical calls have the same effect as one single call.
	ClientToken *string

	// The time at which the export task completed.
	EndTime *time.Time

	// The Amazon Resource Name (ARN) of the table export.
	ExportArn *string

	// The format of the exported data. Valid values for ExportFormat are DYNAMODB_JSON
	// or ION.
	ExportFormat ExportFormat

	// The name of the manifest file for the export task.
	ExportManifest *string

	// Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.
	ExportStatus ExportStatus

	// Point in time from which table data was exported.
	ExportTime *time.Time

	// Status code for the result of the failed export.
	FailureCode *string

	// Export failure reason description.
	FailureMessage *string

	// The number of items exported.
	ItemCount *int64

	// The name of the Amazon S3 bucket containing the export.
	S3Bucket *string

	// The ID of the Amazon Web Services account that owns the bucket containing the
	// export.
	S3BucketOwner *string

	// The Amazon S3 bucket prefix used as the file name and path of the exported
	// snapshot.
	S3Prefix *string

	// Type of encryption used on the bucket where export data is stored. Valid values
	// for S3SseAlgorithm are:
	//
	// * AES256 - server-side encryption with Amazon S3
	// managed keys
	//
	// * KMS - server-side encryption with KMS managed keys
	S3SseAlgorithm S3SseAlgorithm

	// The ID of the KMS managed key used to encrypt the S3 bucket where export data is
	// stored (if applicable).
	S3SseKmsKeyId *string

	// The time at which the export task began.
	StartTime *time.Time

	// The Amazon Resource Name (ARN) of the table that was exported.
	TableArn *string

	// Unique ID of the table that was exported.
	TableId *string

	noSmithyDocumentSerde
}

// Summary information about an export task.
type ExportSummary struct {

	// The Amazon Resource Name (ARN) of the export.
	ExportArn *string

	// Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.
	ExportStatus ExportStatus

	noSmithyDocumentSerde
}

// Represents a failure a contributor insights operation.
type FailureException struct {

	// Description of the failure.
	ExceptionDescription *string

	// Exception name.
	ExceptionName *string

	noSmithyDocumentSerde
}

// Specifies an item and related attribute values to retrieve in a TransactGetItem
// object.
type Get struct {

	// A map of attribute names to AttributeValue objects that specifies the primary
	// key of the item to retrieve.
	//
	// This member is required.
	Key map[string]AttributeValue

	// The name of the table from which to retrieve the specified item.
	//
	// This member is required.
	TableName *string

	// One or more substitution tokens for attribute names in the ProjectionExpression
	// parameter.
	ExpressionAttributeNames map[string]string

	// A string that identifies one or more attributes of the specified item to
	// retrieve from the table. The attributes in the expression must be separated by
	// commas. If no attribute names are specified, then all attributes of the
	// specified item are returned. If any of the requested attributes are not found,
	// they do not appear in the result.
	ProjectionExpression *string

	noSmithyDocumentSerde
}

// Represents the properties of a global secondary index.
type GlobalSecondaryIndex struct {

	// The name of the global secondary index. The name must be unique among all other
	// indexes on this table.
	//
	// This member is required.
	IndexName *string

	// The complete key schema for a global secondary index, which consists of one or
	// more pairs of attribute names and key types:
	//
	// * HASH - partition key
	//
	// * RANGE -
	// sort key
	//
	// The partition key of an item is also known as its hash attribute. The
	// term "hash attribute" derives from DynamoDB's usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition key
	// values. The sort key of an item is also known as its range attribute. The term
	// "range attribute" derives from the way DynamoDB stores items with the same
	// partition key physically close together, in sorted order by the sort key value.
	//
	// This member is required.
	KeySchema []KeySchemaElement

	// Represents attributes that are copied (projected) from the table into the global
	// secondary index. These are in addition to the primary key attributes and index
	// key attributes, which are automatically projected.
	//
	// This member is required.
	Projection *Projection

	// Represents the provisioned throughput settings for the specified global
	// secondary index. For current minimum and maximum provisioned throughput values,
	// see Service, Account, and Table Quotas
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	ProvisionedThroughput *ProvisionedThroughput

	noSmithyDocumentSerde
}

// Represents the auto scaling settings of a global secondary index for a global
// table that will be modified.
type GlobalSecondaryIndexAutoScalingUpdate struct {

	// The name of the global secondary index.
	IndexName *string

	// Represents the auto scaling settings to be modified for a global table or global
	// secondary index.
	ProvisionedWriteCapacityAutoScalingUpdate *AutoScalingSettingsUpdate

	noSmithyDocumentSerde
}

// Represents the properties of a global secondary index.
type GlobalSecondaryIndexDescription struct {

	// Indicates whether the index is currently backfilling. Backfilling is the process
	// of reading items from the table and determining whether they can be added to the
	// index. (Not all items will qualify: For example, a partition key cannot have any
	// duplicate values.) If an item can be added to the index, DynamoDB will do so.
	// After all items have been processed, the backfilling operation is complete and
	// Backfilling is false. You can delete an index that is being created during the
	// Backfilling phase when IndexStatus is set to CREATING and Backfilling is true.
	// You can't delete the index that is being created when IndexStatus is set to
	// CREATING and Backfilling is false. For indexes that were created during a
	// CreateTable operation, the Backfilling attribute does not appear in the
	// DescribeTable output.
	Backfilling *bool

	// The Amazon Resource Name (ARN) that uniquely identifies the index.
	IndexArn *string

	// The name of the global secondary index.
	IndexName *string

	// The total size of the specified index, in bytes. DynamoDB updates this value
	// approximately every six hours. Recent changes might not be reflected in this
	// value.
	IndexSizeBytes int64

	// The current state of the global secondary index:
	//
	// * CREATING - The index is
	// being created.
	//
	// * UPDATING - The index is being updated.
	//
	// * DELETING - The index
	// is being deleted.
	//
	// * ACTIVE - The index is ready for use.
	IndexStatus IndexStatus

	// The number of items in the specified index. DynamoDB updates this value
	// approximately every six hours. Recent changes might not be reflected in this
	// value.
	ItemCount int64

	// The complete key schema for a global secondary index, which consists of one or
	// more pairs of attribute names and key types:
	//
	// * HASH - partition key
	//
	// * RANGE -
	// sort key
	//
	// The partition key of an item is also known as its hash attribute. The
	// term "hash attribute" derives from DynamoDB's usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition key
	// values. The sort key of an item is also known as its range attribute. The term
	// "range attribute" derives from the way DynamoDB stores items with the same
	// partition key physically close together, in sorted order by the sort key value.
	KeySchema []KeySchemaElement

	// Represents attributes that are copied (projected) from the table into the global
	// secondary index. These are in addition to the primary key attributes and index
	// key attributes, which are automatically projected.
	Projection *Projection

	// Represents the provisioned throughput settings for the specified global
	// secondary index. For current minimum and maximum provisioned throughput values,
	// see Service, Account, and Table Quotas
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	ProvisionedThroughput *ProvisionedThroughputDescription

	noSmithyDocumentSerde
}

// Represents the properties of a global secondary index for the table when the
// backup was created.
type GlobalSecondaryIndexInfo struct {

	// The name of the global secondary index.
	IndexName *string

	// The complete key schema for a global secondary index, which consists of one or
	// more pairs of attribute names and key types:
	//
	// * HASH - partition key
	//
	// * RANGE -
	// sort key
	//
	// The partition key of an item is also known as its hash attribute. The
	// term "hash attribute" derives from DynamoDB's usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition key
	// values. The sort key of an item is also known as its range attribute. The term
	// "range attribute" derives from the way DynamoDB stores items with the same
	// partition key physically close together, in sorted order by the sort key value.
	KeySchema []KeySchemaElement

	// Represents attributes that are copied (projected) from the table into the global
	// secondary index. These are in addition to the primary key attributes and index
	// key attributes, which are automatically projected.
	Projection *Projection

	// Represents the provisioned throughput settings for the specified global
	// secondary index.
	ProvisionedThroughput *ProvisionedThroughput

	noSmithyDocumentSerde
}

// Represents one of the following:
//
// * A new global secondary index to be added to
// an existing table.
//
// * New provisioned throughput parameters for an existing
// global secondary index.
//
// * An existing global secondary index to be removed from
// an existing table.
type GlobalSecondaryIndexUpdate struct {

	// The parameters required for creating a global secondary index on an existing
	// table:
	//
	// * IndexName
	//
	// * KeySchema
	//
	// * AttributeDefinitions
	//
	// * Projection
	//
	// *
	// ProvisionedThroughput
	Create *CreateGlobalSecondaryIndexAction

	// The name of an existing global secondary index to be removed.
	Delete *DeleteGlobalSecondaryIndexAction

	// The name of an existing global secondary index, along with new provisioned
	// throughput settings to be applied to that index.
	Update *UpdateGlobalSecondaryIndexAction

	noSmithyDocumentSerde
}

// Represents the properties of a global table.
type GlobalTable struct {

	// The global table name.
	GlobalTableName *string

	// The Regions where the global table has replicas.
	ReplicationGroup []Replica

	noSmithyDocumentSerde
}

// Contains details about the global table.
type GlobalTableDescription struct {

	// The creation time of the global table.
	CreationDateTime *time.Time

	// The unique identifier of the global table.
	GlobalTableArn *string

	// The global table name.
	GlobalTableName *string

	// The current state of the global table:
	//
	// * CREATING - The global table is being
	// created.
	//
	// * UPDATING - The global table is being updated.
	//
	// * DELETING - The
	// global table is being deleted.
	//
	// * ACTIVE - The global table is ready for use.
	GlobalTableStatus GlobalTableStatus

	// The Regions where the global table has replicas.
	ReplicationGroup []ReplicaDescription

	noSmithyDocumentSerde
}

// Represents the settings of a global secondary index for a global table that will
// be modified.
type GlobalTableGlobalSecondaryIndexSettingsUpdate struct {

	// The name of the global secondary index. The name must be unique among all other
	// indexes on this table.
	//
	// This member is required.
	IndexName *string

	// Auto scaling settings for managing a global secondary index's write capacity
	// units.
	ProvisionedWriteCapacityAutoScalingSettingsUpdate *AutoScalingSettingsUpdate

	// The maximum number of writes consumed per second before DynamoDB returns a
	// ThrottlingException.
	ProvisionedWriteCapacityUnits *int64

	noSmithyDocumentSerde
}

// Information about item collections, if any, that were affected by the operation.
// ItemCollectionMetrics is only returned if the request asked for it. If the table
// does not have any local secondary indexes, this information is not returned in
// the response.
type ItemCollectionMetrics struct {

	// The partition key value of the item collection. This value is the same as the
	// partition key value of the item.
	ItemCollectionKey map[string]AttributeValue

	// An estimate of item collection size, in gigabytes. This value is a two-element
	// array containing a lower bound and an upper bound for the estimate. The estimate
	// includes the size of all the items in the table, plus the size of all attributes
	// projected into all of the local secondary indexes on that table. Use this
	// estimate to measure whether a local secondary index is approaching its size
	// limit. The estimate is subject to change over time; therefore, do not rely on
	// the precision or accuracy of the estimate.
	SizeEstimateRangeGB []float64

	noSmithyDocumentSerde
}

// Details for the requested item.
type ItemResponse struct {

	// Map of attribute data consisting of the data type and attribute value.
	Item map[string]AttributeValue

	noSmithyDocumentSerde
}

// Represents a set of primary keys and, for each key, the attributes to retrieve
// from the table. For each primary key, you must provide all of the key
// attributes. For example, with a simple primary key, you only need to provide the
// partition key. For a composite primary key, you must provide both the partition
// key and the sort key.
type KeysAndAttributes struct {

	// The primary key attribute values that define the items and the attributes
	// associated with the items.
	//
	// This member is required.
	Keys []map[string]AttributeValue

	// This is a legacy parameter. Use ProjectionExpression instead. For more
	// information, see Legacy Conditional Parameters
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html)
	// in the Amazon DynamoDB Developer Guide.
	AttributesToGet []string

	// The consistency of a read operation. If set to true, then a strongly consistent
	// read is used; otherwise, an eventually consistent read is used.
	ConsistentRead *bool

	// One or more substitution tokens for attribute names in an expression. The
	// following are some use cases for using ExpressionAttributeNames:
	//
	// * To access an
	// attribute whose name conflicts with a DynamoDB reserved word.
	//
	// * To create a
	// placeholder for repeating occurrences of an attribute name in an expression.
	//
	// *
	// To prevent special characters in an attribute name from being misinterpreted in
	// an expression.
	//
	// Use the # character in an expression to dereference an attribute
	// name. For example, consider the following attribute name:
	//
	// * Percentile
	//
	// The
	// name of this attribute conflicts with a reserved word, so it cannot be used
	// directly in an expression. (For the complete list of reserved words, see
	// Reserved Words
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
	// in the Amazon DynamoDB Developer Guide). To work around this, you could specify
	// the following for ExpressionAttributeNames:
	//
	// * {"#P":"Percentile"}
	//
	// You could
	// then use this substitution in an expression, as in this example:
	//
	// * #P =
	// :val
	//
	// Tokens that begin with the : character are expression attribute values,
	// which are placeholders for the actual value at runtime. For more information on
	// expression attribute names, see Accessing Item Attributes
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeNames map[string]string

	// A string that identifies one or more attributes to retrieve from the table.
	// These attributes can include scalars, sets, or elements of a JSON document. The
	// attributes in the ProjectionExpression must be separated by commas. If no
	// attribute names are specified, then all attributes will be returned. If any of
	// the requested attributes are not found, they will not appear in the result. For
	// more information, see Accessing Item Attributes
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ProjectionExpression *string

	noSmithyDocumentSerde
}

// Represents a single element of a key schema. A key schema specifies the
// attributes that make up the primary key of a table, or the key attributes of an
// index. A KeySchemaElement represents exactly one attribute of the primary key.
// For example, a simple primary key would be represented by one KeySchemaElement
// (for the partition key). A composite primary key would require one
// KeySchemaElement for the partition key, and another KeySchemaElement for the
// sort key. A KeySchemaElement must be a scalar, top-level attribute (not a nested
// attribute). The data type must be one of String, Number, or Binary. The
// attribute cannot be nested within a List or a Map.
type KeySchemaElement struct {

	// The name of a key attribute.
	//
	// This member is required.
	AttributeName *string

	// The role that this key attribute will assume:
	//
	// * HASH - partition key
	//
	// * RANGE -
	// sort key
	//
	// The partition key of an item is also known as its hash attribute. The
	// term "hash attribute" derives from DynamoDB's usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition key
	// values. The sort key of an item is also known as its range attribute. The term
	// "range attribute" derives from the way DynamoDB stores items with the same
	// partition key physically close together, in sorted order by the sort key value.
	//
	// This member is required.
	KeyType KeyType

	noSmithyDocumentSerde
}

// Describes a Kinesis data stream destination.
type KinesisDataStreamDestination struct {

	// The current status of replication.
	DestinationStatus DestinationStatus

	// The human-readable string that corresponds to the replica status.
	DestinationStatusDescription *string

	// The ARN for a specific Kinesis data stream.
	StreamArn *string

	noSmithyDocumentSerde
}

// Represents the properties of a local secondary index.
type LocalSecondaryIndex struct {

	// The name of the local secondary index. The name must be unique among all other
	// indexes on this table.
	//
	// This member is required.
	IndexName *string

	// The complete key schema for the local secondary index, consisting of one or more
	// pairs of attribute names and key types:
	//
	// * HASH - partition key
	//
	// * RANGE - sort
	// key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB's usage of an internal hash function to
	// evenly distribute data items across partitions, based on their partition key
	// values. The sort key of an item is also known as its range attribute. The term
	// "range attribute" derives from the way DynamoDB stores items with the same
	// partition key physically close together, in sorted order by the sort key value.
	//
	// This member is required.
	KeySchema []KeySchemaElement

	// Represents attributes that are copied (projected) from the table into the local
	// secondary index. These are in addition to the primary key attributes and index
	// key attributes, which are automatically projected.
	//
	// This member is required.
	Projection *Projection

	noSmithyDocumentSerde
}

// Represents the properties of a local secondary index.
type LocalSecondaryIndexDescription struct {

	// The Amazon Resource Name (ARN) that uniquely identifies the index.
	IndexArn *string

	// Represents the name of the local secondary index.
	IndexName *string

	// The total size of the specified index, in bytes. DynamoDB updates this value
	// approximately every six hours. Recent changes might not be reflected in this
	// value.
	IndexSizeBytes int64

	// The number of items in the specified index. DynamoDB updates this value
	// approximately every six hours. Recent changes might not be reflected in this
	// value.
	ItemCount int64

	// The complete key schema for the local secondary index, consisting of one or more
	// pairs of attribute names and key types:
	//
	// * HASH - partition key
	//
	// * RANGE - sort
	// key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB's usage of an internal hash function to
	// evenly distribute data items across partitions, based on their partition key
	// values. The sort key of an item is also known as its range attribute. The term
	// "range attribute" derives from the way DynamoDB stores items with the same
	// partition key physically close together, in sorted order by the sort key value.
	KeySchema []KeySchemaElement

	// Represents attributes that are copied (projected) from the table into the global
	// secondary index. These are in addition to the primary key attributes and index
	// key attributes, which are automatically projected.
	Projection *Projection

	noSmithyDocumentSerde
}

// Represents the properties of a local secondary index for the table when the
// backup was created.
type LocalSecondaryIndexInfo struct {

	// Represents the name of the local secondary index.
	IndexName *string

	// The complete key schema for a local secondary index, which consists of one or
	// more pairs of attribute names and key types:
	//
	// * HASH - partition key
	//
	// * RANGE -
	// sort key
	//
	// The partition key of an item is also known as its hash attribute. The
	// term "hash attribute" derives from DynamoDB's usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition key
	// values. The sort key of an item is also known as its range attribute. The term
	// "range attribute" derives from the way DynamoDB stores items with the same
	// partition key physically close together, in sorted order by the sort key value.
	KeySchema []KeySchemaElement

	// Represents attributes that are copied (projected) from the table into the global
	// secondary index. These are in addition to the primary key attributes and index
	// key attributes, which are automatically projected.
	Projection *Projection

	noSmithyDocumentSerde
}

// Represents a PartiQL statment that uses parameters.
type ParameterizedStatement struct {

	// A PartiQL statment that uses parameters.
	//
	// This member is required.
	Statement *string

	// The parameter values.
	Parameters []AttributeValue

	noSmithyDocumentSerde
}

// The description of the point in time settings applied to the table.
type PointInTimeRecoveryDescription struct {

	// Specifies the earliest point in time you can restore your table to. You can
	// restore your table to any point in time during the last 35 days.
	EarliestRestorableDateTime *time.Time

	// LatestRestorableDateTime is typically 5 minutes before the current time.
	LatestRestorableDateTime *time.Time

	// The current state of point in time recovery:
	//
	// * ENABLED - Point in time recovery
	// is enabled.
	//
	// * DISABLED - Point in time recovery is disabled.
	PointInTimeRecoveryStatus PointInTimeRecoveryStatus

	noSmithyDocumentSerde
}

// Represents the settings used to enable point in time recovery.
type PointInTimeRecoverySpecification struct {

	// Indicates whether point in time recovery is enabled (true) or disabled (false)
	// on the table.
	//
	// This member is required.
	PointInTimeRecoveryEnabled *bool

	noSmithyDocumentSerde
}

// Represents attributes that are copied (projected) from the table into an index.
// These are in addition to the primary key attributes and index key attributes,
// which are automatically projected.
type Projection struct {

	// Represents the non-key attribute names which will be projected into the index.
	// For local secondary indexes, the total count of NonKeyAttributes summed across
	// all of the local secondary indexes, must not exceed 20. If you project the same
	// attribute into two different indexes, this counts as two distinct attributes
	// when determining the total.
	NonKeyAttributes []string

	// The set of attributes that are projected into the index:
	//
	// * KEYS_ONLY - Only the
	// index and primary keys are projected into the index.
	//
	// * INCLUDE - In addition to
	// the attributes described in KEYS_ONLY, the secondary index will include other
	// non-key attributes that you specify.
	//
	// * ALL - All of the table attributes are
	// projected into the index.
	ProjectionType ProjectionType

	noSmithyDocumentSerde
}

// Represents the provisioned throughput settings for a specified table or index.
// The settings can be modified using the UpdateTable operation. For current
// minimum and maximum provisioned throughput values, see Service, Account, and
// Table Quotas
// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
// in the Amazon DynamoDB Developer Guide.
type ProvisionedThroughput struct {

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException. For more information, see Specifying
	// Read and Write Requirements
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput)
	// in the Amazon DynamoDB Developer Guide. If read/write capacity mode is
	// PAY_PER_REQUEST the value is set to 0.
	//
	// This member is required.
	ReadCapacityUnits *int64

	// The maximum number of writes consumed per second before DynamoDB returns a
	// ThrottlingException. For more information, see Specifying Read and Write
	// Requirements
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput)
	// in the Amazon DynamoDB Developer Guide. If read/write capacity mode is
	// PAY_PER_REQUEST the value is set to 0.
	//
	// This member is required.
	WriteCapacityUnits *int64

	noSmithyDocumentSerde
}

// Represents the provisioned throughput settings for the table, consisting of read
// and write capacity units, along with data about increases and decreases.
type ProvisionedThroughputDescription struct {

	// The date and time of the last provisioned throughput decrease for this table.
	LastDecreaseDateTime *time.Time

	// The date and time of the last provisioned throughput increase for this table.
	LastIncreaseDateTime *time.Time

	// The number of provisioned throughput decreases for this table during this UTC
	// calendar day. For current maximums on provisioned throughput decreases, see
	// Service, Account, and Table Quotas
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	NumberOfDecreasesToday *int64

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException. Eventually consistent reads require less
	// effort than strongly consistent reads, so a setting of 50 ReadCapacityUnits per
	// second provides 100 eventually consistent ReadCapacityUnits per second.
	ReadCapacityUnits *int64

	// The maximum number of writes consumed per second before DynamoDB returns a
	// ThrottlingException.
	WriteCapacityUnits *int64

	noSmithyDocumentSerde
}

// Replica-specific provisioned throughput settings. If not specified, uses the
// source table's provisioned throughput settings.
type ProvisionedThroughputOverride struct {

	// Replica-specific read capacity units. If not specified, uses the source table's
	// read capacity settings.
	ReadCapacityUnits *int64

	noSmithyDocumentSerde
}

// Represents a request to perform a PutItem operation.
type Put struct {

	// A map of attribute name to attribute values, representing the primary key of the
	// item to be written by PutItem. All of the table's primary key attributes must be
	// specified, and their data types must match those of the table's key schema. If
	// any attributes are present in the item that are part of an index key schema for
	// the table, their types must match the index key schema.
	//
	// This member is required.
	Item map[string]AttributeValue

	// Name of the table in which to write the item.
	//
	// This member is required.
	TableName *string

	// A condition that must be satisfied in order for a conditional update to succeed.
	ConditionExpression *string

	// One or more substitution tokens for attribute names in an expression.
	ExpressionAttributeNames map[string]string

	// One or more values that can be substituted in an expression.
	ExpressionAttributeValues map[string]AttributeValue

	// Use ReturnValuesOnConditionCheckFailure to get the item attributes if the Put
	// condition fails. For ReturnValuesOnConditionCheckFailure, the valid values are:
	// NONE and ALL_OLD.
	ReturnValuesOnConditionCheckFailure ReturnValuesOnConditionCheckFailure

	noSmithyDocumentSerde
}

// Represents a request to perform a PutItem operation on an item.
type PutRequest struct {

	// A map of attribute name to attribute values, representing the primary key of an
	// item to be processed by PutItem. All of the table's primary key attributes must
	// be specified, and their data types must match those of the table's key schema.
	// If any attributes are present in the item that are part of an index key schema
	// for the table, their types must match the index key schema.
	//
	// This member is required.
	Item map[string]AttributeValue

	noSmithyDocumentSerde
}

// Represents the properties of a replica.
type Replica struct {

	// The Region where the replica needs to be created.
	RegionName *string

	noSmithyDocumentSerde
}

// Represents the auto scaling settings of the replica.
type ReplicaAutoScalingDescription struct {

	// Replica-specific global secondary index auto scaling settings.
	GlobalSecondaryIndexes []ReplicaGlobalSecondaryIndexAutoScalingDescription

	// The Region where the replica exists.
	RegionName *string

	// Represents the auto scaling settings for a global table or global secondary
	// index.
	ReplicaProvisionedReadCapacityAutoScalingSettings *AutoScalingSettingsDescription

	// Represents the auto scaling settings for a global table or global secondary
	// index.
	ReplicaProvisionedWriteCapacityAutoScalingSettings *AutoScalingSettingsDescription

	// The current state of the replica:
	//
	// * CREATING - The replica is being created.
	//
	// *
	// UPDATING - The replica is being updated.
	//
	// * DELETING - The replica is being
	// deleted.
	//
	// * ACTIVE - The replica is ready for use.
	ReplicaStatus ReplicaStatus

	noSmithyDocumentSerde
}

// Represents the auto scaling settings of a replica that will be modified.
type ReplicaAutoScalingUpdate struct {

	// The Region where the replica exists.
	//
	// This member is required.
	RegionName *string

	// Represents the auto scaling settings of global secondary indexes that will be
	// modified.
	ReplicaGlobalSecondaryIndexUpdates []ReplicaGlobalSecondaryIndexAutoScalingUpdate

	// Represents the auto scaling settings to be modified for a global table or global
	// secondary index.
	ReplicaProvisionedReadCapacityAutoScalingUpdate *AutoScalingSettingsUpdate

	noSmithyDocumentSerde
}

// Contains the details of the replica.
type ReplicaDescription struct {

	// Replica-specific global secondary index settings.
	GlobalSecondaryIndexes []ReplicaGlobalSecondaryIndexDescription

	// The KMS key of the replica that will be used for KMS encryption.
	KMSMasterKeyId *string

	// Replica-specific provisioned throughput. If not described, uses the source
	// table's provisioned throughput settings.
	ProvisionedThroughputOverride *ProvisionedThroughputOverride

	// The name of the Region.
	RegionName *string

	// The time at which the replica was first detected as inaccessible. To determine
	// cause of inaccessibility check the ReplicaStatus property.
	ReplicaInaccessibleDateTime *time.Time

	// The current state of the replica:
	//
	// * CREATING - The replica is being created.
	//
	// *
	// UPDATING - The replica is being updated.
	//
	// * DELETING - The replica is being
	// deleted.
	//
	// * ACTIVE - The replica is ready for use.
	//
	// * REGION_DISABLED - The
	// replica is inaccessible because the Amazon Web Services Region has been
	// disabled. If the Amazon Web Services Region remains inaccessible for more than
	// 20 hours, DynamoDB will remove this replica from the replication group. The
	// replica will not be deleted and replication will stop from and to this
	// region.
	//
	// * INACCESSIBLE_ENCRYPTION_CREDENTIALS  - The KMS key used to encrypt
	// the table is inaccessible. If the KMS key remains inaccessible for more than 20
	// hours, DynamoDB will remove this replica from the replication group. The replica
	// will not be deleted and replication will stop from and to this region.
	ReplicaStatus ReplicaStatus

	// Detailed information about the replica status.
	ReplicaStatusDescription *string

	// Specifies the progress of a Create, Update, or Delete action on the replica as a
	// percentage.
	ReplicaStatusPercentProgress *string

	// Contains details of the table class.
	ReplicaTableClassSummary *TableClassSummary

	noSmithyDocumentSerde
}

// Represents the properties of a replica global secondary index.
type ReplicaGlobalSecondaryIndex struct {

	// The name of the global secondary index.
	//
	// This member is required.
	IndexName *string

	// Replica table GSI-specific provisioned throughput. If not specified, uses the
	// source table GSI's read capacity settings.
	ProvisionedThroughputOverride *ProvisionedThroughputOverride

	noSmithyDocumentSerde
}

// Represents the auto scaling configuration for a replica global secondary index.
type ReplicaGlobalSecondaryIndexAutoScalingDescription struct {

	// The name of the global secondary index.
	IndexName *string

	// The current state of the replica global secondary index:
	//
	// * CREATING - The index
	// is being created.
	//
	// * UPDATING - The index is being updated.
	//
	// * DELETING - The
	// index is being deleted.
	//
	// * ACTIVE - The index is ready for use.
	IndexStatus IndexStatus

	// Represents the auto scaling settings for a global table or global secondary
	// index.
	ProvisionedReadCapacityAutoScalingSettings *AutoScalingSettingsDescription

	// Represents the auto scaling settings for a global table or global secondary
	// index.
	ProvisionedWriteCapacityAutoScalingSettings *AutoScalingSettingsDescription

	noSmithyDocumentSerde
}

// Represents the auto scaling settings of a global secondary index for a replica
// that will be modified.
type ReplicaGlobalSecondaryIndexAutoScalingUpdate struct {

	// The name of the global secondary index.
	IndexName *string

	// Represents the auto scaling settings to be modified for a global table or global
	// secondary index.
	ProvisionedReadCapacityAutoScalingUpdate *AutoScalingSettingsUpdate

	noSmithyDocumentSerde
}

// Represents the properties of a replica global secondary index.
type ReplicaGlobalSecondaryIndexDescription struct {

	// The name of the global secondary index.
	IndexName *string

	// If not described, uses the source table GSI's read capacity settings.
	ProvisionedThroughputOverride *ProvisionedThroughputOverride

	noSmithyDocumentSerde
}

// Represents the properties of a global secondary index.
type ReplicaGlobalSecondaryIndexSettingsDescription struct {

	// The name of the global secondary index. The name must be unique among all other
	// indexes on this table.
	//
	// This member is required.
	IndexName *string

	// The current status of the global secondary index:
	//
	// * CREATING - The global
	// secondary index is being created.
	//
	// * UPDATING - The global secondary index is
	// being updated.
	//
	// * DELETING - The global secondary index is being deleted.
	//
	// *
	// ACTIVE - The global secondary index is ready for use.
	IndexStatus IndexStatus

	// Auto scaling settings for a global secondary index replica's read capacity
	// units.
	ProvisionedReadCapacityAutoScalingSettings *AutoScalingSettingsDescription

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException.
	ProvisionedReadCapacityUnits *int64

	// Auto scaling settings for a global secondary index replica's write capacity
	// units.
	ProvisionedWriteCapacityAutoScalingSettings *AutoScalingSettingsDescription

	// The maximum number of writes consumed per second before DynamoDB returns a
	// ThrottlingException.
	ProvisionedWriteCapacityUnits *int64

	noSmithyDocumentSerde
}

// Represents the settings of a global secondary index for a global table that will
// be modified.
type ReplicaGlobalSecondaryIndexSettingsUpdate struct {

	// The name of the global secondary index. The name must be unique among all other
	// indexes on this table.
	//
	// This member is required.
	IndexName *string

	// Auto scaling settings for managing a global secondary index replica's read
	// capacity units.
	ProvisionedReadCapacityAutoScalingSettingsUpdate *AutoScalingSettingsUpdate

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException.
	ProvisionedReadCapacityUnits *int64

	noSmithyDocumentSerde
}

// Represents the properties of a replica.
type ReplicaSettingsDescription struct {

	// The Region name of the replica.
	//
	// This member is required.
	RegionName *string

	// The read/write capacity mode of the replica.
	ReplicaBillingModeSummary *BillingModeSummary

	// Replica global secondary index settings for the global table.
	ReplicaGlobalSecondaryIndexSettings []ReplicaGlobalSecondaryIndexSettingsDescription

	// Auto scaling settings for a global table replica's read capacity units.
	ReplicaProvisionedReadCapacityAutoScalingSettings *AutoScalingSettingsDescription

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException. For more information, see Specifying
	// Read and Write Requirements
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput)
	// in the Amazon DynamoDB Developer Guide.
	ReplicaProvisionedReadCapacityUnits *int64

	// Auto scaling settings for a global table replica's write capacity units.
	ReplicaProvisionedWriteCapacityAutoScalingSettings *AutoScalingSettingsDescription

	// The maximum number of writes consumed per second before DynamoDB returns a
	// ThrottlingException. For more information, see Specifying Read and Write
	// Requirements
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput)
	// in the Amazon DynamoDB Developer Guide.
	ReplicaProvisionedWriteCapacityUnits *int64

	// The current state of the Region:
	//
	// * CREATING - The Region is being created.
	//
	// *
	// UPDATING - The Region is being updated.
	//
	// * DELETING - The Region is being
	// deleted.
	//
	// * ACTIVE - The Region is ready for use.
	ReplicaStatus ReplicaStatus

	// Contains details of the table class.
	ReplicaTableClassSummary *TableClassSummary

	noSmithyDocumentSerde
}

// Represents the settings for a global table in a Region that will be modified.
type ReplicaSettingsUpdate struct {

	// The Region of the replica to be added.
	//
	// This member is required.
	RegionName *string

	// Represents the settings of a global secondary index for a global table that will
	// be modified.
	ReplicaGlobalSecondaryIndexSettingsUpdate []ReplicaGlobalSecondaryIndexSettingsUpdate

	// Auto scaling settings for managing a global table replica's read capacity units.
	ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate *AutoScalingSettingsUpdate

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException. For more information, see Specifying
	// Read and Write Requirements
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput)
	// in the Amazon DynamoDB Developer Guide.
	ReplicaProvisionedReadCapacityUnits *int64

	// Replica-specific table class. If not specified, uses the source table's table
	// class.
	ReplicaTableClass TableClass

	noSmithyDocumentSerde
}

// Represents one of the following:
//
// * A new replica to be added to an existing
// regional table or global table. This request invokes the CreateTableReplica
// action in the destination Region.
//
// * New parameters for an existing replica.
// This request invokes the UpdateTable action in the destination Region.
//
// * An
// existing replica to be deleted. The request invokes the DeleteTableReplica
// action in the destination Region, deleting the replica and all if its items in
// the destination Region.
type ReplicationGroupUpdate struct {

	// The parameters required for creating a replica for the table.
	Create *CreateReplicationGroupMemberAction

	// The parameters required for deleting a replica for the table.
	Delete *DeleteReplicationGroupMemberAction

	// The parameters required for updating a replica for the table.
	Update *UpdateReplicationGroupMemberAction

	noSmithyDocumentSerde
}

// Represents one of the following:
//
// * A new replica to be added to an existing
// global table.
//
// * New parameters for an existing replica.
//
// * An existing replica
// to be removed from an existing global table.
type ReplicaUpdate struct {

	// The parameters required for creating a replica on an existing global table.
	Create *CreateReplicaAction

	// The name of the existing replica to be removed.
	Delete *DeleteReplicaAction

	noSmithyDocumentSerde
}

// Contains details for the restore.
type RestoreSummary struct {

	// Point in time or source backup time.
	//
	// This member is required.
	RestoreDateTime *time.Time

	// Indicates if a restore is in progress or not.
	//
	// This member is required.
	RestoreInProgress *bool

	// The Amazon Resource Name (ARN) of the backup from which the table was restored.
	SourceBackupArn *string

	// The ARN of the source table of the backup that is being restored.
	SourceTableArn *string

	noSmithyDocumentSerde
}

// Contains the details of the table when the backup was created.
type SourceTableDetails struct {

	// Schema of the table.
	//
	// This member is required.
	KeySchema []KeySchemaElement

	// Read IOPs and Write IOPS on the table when the backup was created.
	//
	// This member is required.
	ProvisionedThroughput *ProvisionedThroughput

	// Time when the source table was created.
	//
	// This member is required.
	TableCreationDateTime *time.Time

	// Unique identifier for the table for which the backup was created.
	//
	// This member is required.
	TableId *string

	// The name of the table for which the backup was created.
	//
	// This member is required.
	TableName *string

	// Controls how you are charged for read and write throughput and how you manage
	// capacity. This setting can be changed later.
	//
	// * PROVISIONED - Sets the
	// read/write capacity mode to PROVISIONED. We recommend using PROVISIONED for
	// predictable workloads.
	//
	// * PAY_PER_REQUEST - Sets the read/write capacity mode to
	// PAY_PER_REQUEST. We recommend using PAY_PER_REQUEST for unpredictable workloads.
	BillingMode BillingMode

	// Number of items in the table. Note that this is an approximate value.
	ItemCount *int64

	// ARN of the table for which backup was created.
	TableArn *string

	// Size of the table in bytes. Note that this is an approximate value.
	TableSizeBytes int64

	noSmithyDocumentSerde
}

// Contains the details of the features enabled on the table when the backup was
// created. For example, LSIs, GSIs, streams, TTL.
type SourceTableFeatureDetails struct {

	// Represents the GSI properties for the table when the backup was created. It
	// includes the IndexName, KeySchema, Projection, and ProvisionedThroughput for the
	// GSIs on the table at the time of backup.
	GlobalSecondaryIndexes []GlobalSecondaryIndexInfo

	// Represents the LSI properties for the table when the backup was created. It
	// includes the IndexName, KeySchema and Projection for the LSIs on the table at
	// the time of backup.
	LocalSecondaryIndexes []LocalSecondaryIndexInfo

	// The description of the server-side encryption status on the table when the
	// backup was created.
	SSEDescription *SSEDescription

	// Stream settings on the table when the backup was created.
	StreamDescription *StreamSpecification

	// Time to Live settings on the table when the backup was created.
	TimeToLiveDescription *TimeToLiveDescription

	noSmithyDocumentSerde
}

// The description of the server-side encryption status on the specified table.
type SSEDescription struct {

	// Indicates the time, in UNIX epoch date format, when DynamoDB detected that the
	// table's KMS key was inaccessible. This attribute will automatically be cleared
	// when DynamoDB detects that the table's KMS key is accessible again. DynamoDB
	// will initiate the table archival process when table's KMS key remains
	// inaccessible for more than seven days from this date.
	InaccessibleEncryptionDateTime *time.Time

	// The KMS key ARN used for the KMS encryption.
	KMSMasterKeyArn *string

	// Server-side encryption type. The only supported value is:
	//
	// * KMS - Server-side
	// encryption that uses Key Management Service. The key is stored in your account
	// and is managed by KMS (KMS charges apply).
	SSEType SSEType

	// Represents the current state of server-side encryption. The only supported
	// values are:
	//
	// * ENABLED - Server-side encryption is enabled.
	//
	// * UPDATING -
	// Server-side encryption is being updated.
	Status SSEStatus

	noSmithyDocumentSerde
}

// Represents the settings used to enable server-side encryption.
type SSESpecification struct {

	// Indicates whether server-side encryption is done using an Amazon Web Services
	// managed key or an Amazon Web Services owned key. If enabled (true), server-side
	// encryption type is set to KMS and an Amazon Web Services managed key is used
	// (KMS charges apply). If disabled (false) or not specified, server-side
	// encryption is set to Amazon Web Services owned key.
	Enabled *bool

	// The KMS key that should be used for the KMS encryption. To specify a key, use
	// its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you
	// should only provide this parameter if the key is different from the default
	// DynamoDB key alias/aws/dynamodb.
	KMSMasterKeyId *string

	// Server-side encryption type. The only supported value is:
	//
	// * KMS - Server-side
	// encryption that uses Key Management Service. The key is stored in your account
	// and is managed by KMS (KMS charges apply).
	SSEType SSEType

	noSmithyDocumentSerde
}

// Represents the DynamoDB Streams configuration for a table in DynamoDB.
type StreamSpecification struct {

	// Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the
	// table.
	//
	// This member is required.
	StreamEnabled *bool

	// When an item in the table is modified, StreamViewType determines what
	// information is written to the stream for this table. Valid values for
	// StreamViewType are:
	//
	// * KEYS_ONLY - Only the key attributes of the modified item
	// are written to the stream.
	//
	// * NEW_IMAGE - The entire item, as it appears after
	// it was modified, is written to the stream.
	//
	// * OLD_IMAGE - The entire item, as it
	// appeared before it was modified, is written to the stream.
	//
	// * NEW_AND_OLD_IMAGES
	// - Both the new and the old item images of the item are written to the stream.
	StreamViewType StreamViewType

	noSmithyDocumentSerde
}

// Represents the auto scaling configuration for a global table.
type TableAutoScalingDescription struct {

	// Represents replicas of the global table.
	Replicas []ReplicaAutoScalingDescription

	// The name of the table.
	TableName *string

	// The current state of the table:
	//
	// * CREATING - The table is being created.
	//
	// *
	// UPDATING - The table is being updated.
	//
	// * DELETING - The table is being
	// deleted.
	//
	// * ACTIVE - The table is ready for use.
	TableStatus TableStatus

	noSmithyDocumentSerde
}

// Contains details of the table class.
type TableClassSummary struct {

	// The date and time at which the table class was last updated.
	LastUpdateDateTime *time.Time

	// The table class of the specified table. Valid values are STANDARD and
	// STANDARD_INFREQUENT_ACCESS.
	TableClass TableClass

	noSmithyDocumentSerde
}

// Represents the properties of a table.
type TableDescription struct {

	// Contains information about the table archive.
	ArchivalSummary *ArchivalSummary

	// An array of AttributeDefinition objects. Each of these objects describes one
	// attribute in the table and index key schema. Each AttributeDefinition object in
	// this array is composed of:
	//
	// * AttributeName - The name of the attribute.
	//
	// *
	// AttributeType - The data type for the attribute.
	AttributeDefinitions []AttributeDefinition

	// Contains the details for the read/write capacity mode.
	BillingModeSummary *BillingModeSummary

	// The date and time when the table was created, in UNIX epoch time
	// (http://www.epochconverter.com/) format.
	CreationDateTime *time.Time

	// The global secondary indexes, if any, on the table. Each index is scoped to a
	// given partition key value. Each element is composed of:
	//
	// * Backfilling - If
	// true, then the index is currently in the backfilling phase. Backfilling occurs
	// only when a new global secondary index is added to the table. It is the process
	// by which DynamoDB populates the new index with data from the table. (This
	// attribute does not appear for indexes that were created during a CreateTable
	// operation.) You can delete an index that is being created during the Backfilling
	// phase when IndexStatus is set to CREATING and Backfilling is true. You can't
	// delete the index that is being created when IndexStatus is set to CREATING and
	// Backfilling is false. (This attribute does not appear for indexes that were
	// created during a CreateTable operation.)
	//
	// * IndexName - The name of the global
	// secondary index.
	//
	// * IndexSizeBytes - The total size of the global secondary
	// index, in bytes. DynamoDB updates this value approximately every six hours.
	// Recent changes might not be reflected in this value.
	//
	// * IndexStatus - The
	// current status of the global secondary index:
	//
	// * CREATING - The index is being
	// created.
	//
	// * UPDATING - The index is being updated.
	//
	// * DELETING - The index is
	// being deleted.
	//
	// * ACTIVE - The index is ready for use.
	//
	// * ItemCount - The number
	// of items in the global secondary index. DynamoDB updates this value
	// approximately every six hours. Recent changes might not be reflected in this
	// value.
	//
	// * KeySchema - Specifies the complete index key schema. The attribute
	// names in the key schema must be between 1 and 255 characters (inclusive). The
	// key schema must begin with the same partition key as the table.
	//
	// * Projection -
	// Specifies attributes that are copied (projected) from the table into the index.
	// These are in addition to the primary key attributes and index key attributes,
	// which are automatically projected. Each attribute specification is composed
	// of:
	//
	// * ProjectionType - One of the following:
	//
	// * KEYS_ONLY - Only the index and
	// primary keys are projected into the index.
	//
	// * INCLUDE - In addition to the
	// attributes described in KEYS_ONLY, the secondary index will include other
	// non-key attributes that you specify.
	//
	// * ALL - All of the table attributes are
	// projected into the index.
	//
	// * NonKeyAttributes - A list of one or more non-key
	// attribute names that are projected into the secondary index. The total count of
	// attributes provided in NonKeyAttributes, summed across all of the secondary
	// indexes, must not exceed 20. If you project the same attribute into two
	// different indexes, this counts as two distinct attributes when determining the
	// total.
	//
	// * ProvisionedThroughput - The provisioned throughput settings for the
	// global secondary index, consisting of read and write capacity units, along with
	// data about increases and decreases.
	//
	// If the table is in the DELETING state, no
	// information about indexes will be returned.
	GlobalSecondaryIndexes []GlobalSecondaryIndexDescription

	// Represents the version of global tables
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html)
	// in use, if the table is replicated across Amazon Web Services Regions.
	GlobalTableVersion *string

	// The number of items in the specified table. DynamoDB updates this value
	// approximately every six hours. Recent changes might not be reflected in this
	// value.
	ItemCount int64

	// The primary key structure for the table. Each KeySchemaElement consists of:
	//
	// *
	// AttributeName - The name of the attribute.
	//
	// * KeyType - The role of the
	// attribute:
	//
	// * HASH - partition key
	//
	// * RANGE - sort key
	//
	// The partition key of an
	// item is also known as its hash attribute. The term "hash attribute" derives from
	// DynamoDB's usage of an internal hash function to evenly distribute data items
	// across partitions, based on their partition key values. The sort key of an item
	// is also known as its range attribute. The term "range attribute" derives from
	// the way DynamoDB stores items with the same partition key physically close
	// together, in sorted order by the sort key value.
	//
	// For more information about
	// primary keys, see Primary Key
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey)
	// in the Amazon DynamoDB Developer Guide.
	KeySchema []KeySchemaElement

	// The Amazon Resource Name (ARN) that uniquely identifies the latest stream for
	// this table.
	LatestStreamArn *string

	// A timestamp, in ISO 8601 format, for this stream. Note that LatestStreamLabel is
	// not a unique identifier for the stream, because it is possible that a stream
	// from another table might have the same timestamp. However, the combination of
	// the following three elements is guaranteed to be unique:
	//
	// * Amazon Web Services
	// customer ID
	//
	// * Table name
	//
	// * StreamLabel
	LatestStreamLabel *string

	// Represents one or more local secondary indexes on the table. Each index is
	// scoped to a given partition key value. Tables with one or more local secondary
	// indexes are subject to an item collection size limit, where the amount of data
	// within a given item collection cannot exceed 10 GB. Each element is composed
	// of:
	//
	// * IndexName - The name of the local secondary index.
	//
	// * KeySchema -
	// Specifies the complete index key schema. The attribute names in the key schema
	// must be between 1 and 255 characters (inclusive). The key schema must begin with
	// the same partition key as the table.
	//
	// * Projection - Specifies attributes that
	// are copied (projected) from the table into the index. These are in addition to
	// the primary key attributes and index key attributes, which are automatically
	// projected. Each attribute specification is composed of:
	//
	// * ProjectionType - One
	// of the following:
	//
	// * KEYS_ONLY - Only the index and primary keys are projected
	// into the index.
	//
	// * INCLUDE - Only the specified table attributes are projected
	// into the index. The list of projected attributes is in NonKeyAttributes.
	//
	// * ALL
	// - All of the table attributes are projected into the index.
	//
	// * NonKeyAttributes
	// - A list of one or more non-key attribute names that are projected into the
	// secondary index. The total count of attributes provided in NonKeyAttributes,
	// summed across all of the secondary indexes, must not exceed 20. If you project
	// the same attribute into two different indexes, this counts as two distinct
	// attributes when determining the total.
	//
	// * IndexSizeBytes - Represents the total
	// size of the index, in bytes. DynamoDB updates this value approximately every six
	// hours. Recent changes might not be reflected in this value.
	//
	// * ItemCount -
	// Represents the number of items in the index. DynamoDB updates this value
	// approximately every six hours. Recent changes might not be reflected in this
	// value.
	//
	// If the table is in the DELETING state, no information about indexes will
	// be returned.
	LocalSecondaryIndexes []LocalSecondaryIndexDescription

	// The provisioned throughput settings for the table, consisting of read and write
	// capacity units, along with data about increases and decreases.
	ProvisionedThroughput *ProvisionedThroughputDescription

	// Represents replicas of the table.
	Replicas []ReplicaDescription

	// Contains details for the restore.
	RestoreSummary *RestoreSummary

	// The description of the server-side encryption status on the specified table.
	SSEDescription *SSEDescription

	// The current DynamoDB Streams configuration for the table.
	StreamSpecification *StreamSpecification

	// The Amazon Resource Name (ARN) that uniquely identifies the table.
	TableArn *string

	// Contains details of the table class.
	TableClassSummary *TableClassSummary

	// Unique identifier for the table for which the backup was created.
	TableId *string

	// The name of the table.
	TableName *string

	// The total size of the specified table, in bytes. DynamoDB updates this value
	// approximately every six hours. Recent changes might not be reflected in this
	// value.
	TableSizeBytes int64

	// The current state of the table:
	//
	// * CREATING - The table is being created.
	//
	// *
	// UPDATING - The table is being updated.
	//
	// * DELETING - The table is being
	// deleted.
	//
	// * ACTIVE - The table is ready for use.
	//
	// *
	// INACCESSIBLE_ENCRYPTION_CREDENTIALS - The KMS key used to encrypt the table in
	// inaccessible. Table operations may fail due to failure to use the KMS key.
	// DynamoDB will initiate the table archival process when a table's KMS key remains
	// inaccessible for more than seven days.
	//
	// * ARCHIVING - The table is being
	// archived. Operations are not allowed until archival is complete.
	//
	// * ARCHIVED -
	// The table has been archived. See the ArchivalReason for more information.
	TableStatus TableStatus

	noSmithyDocumentSerde
}

// Describes a tag. A tag is a key-value pair. You can add up to 50 tags to a
// single DynamoDB table. Amazon Web Services-assigned tag names and values are
// automatically assigned the aws: prefix, which the user cannot assign. Amazon Web
// Services-assigned tag names do not count towards the tag limit of 50.
// User-assigned tag names have the prefix user: in the Cost Allocation Report. You
// cannot backdate the application of a tag. For an overview on tagging DynamoDB
// resources, see Tagging for DynamoDB
// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html)
// in the Amazon DynamoDB Developer Guide.
type Tag struct {

	// The key of the tag. Tag keys are case sensitive. Each DynamoDB table can only
	// have up to one tag with the same key. If you try to add an existing tag (same
	// key), the existing tag value will be updated to the new value.
	//
	// This member is required.
	Key *string

	// The value of the tag. Tag values are case-sensitive and can be null.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The description of the Time to Live (TTL) status on the specified table.
type TimeToLiveDescription struct {

	// The name of the TTL attribute for items in the table.
	AttributeName *string

	// The TTL status for the table.
	TimeToLiveStatus TimeToLiveStatus

	noSmithyDocumentSerde
}

// Represents the settings used to enable or disable Time to Live (TTL) for the
// specified table.
type TimeToLiveSpecification struct {

	// The name of the TTL attribute used to store the expiration time for items in the
	// table.
	//
	// This member is required.
	AttributeName *string

	// Indicates whether TTL is to be enabled (true) or disabled (false) on the table.
	//
	// This member is required.
	Enabled *bool

	noSmithyDocumentSerde
}

// Specifies an item to be retrieved as part of the transaction.
type TransactGetItem struct {

	// Contains the primary key that identifies the item to get, together with the name
	// of the table that contains the item, and optionally the specific attributes of
	// the item to retrieve.
	//
	// This member is required.
	Get *Get

	noSmithyDocumentSerde
}

// A list of requests that can perform update, put, delete, or check operations on
// multiple items in one or more tables atomically.
type TransactWriteItem struct {

	// A request to perform a check item operation.
	ConditionCheck *ConditionCheck

	// A request to perform a DeleteItem operation.
	Delete *Delete

	// A request to perform a PutItem operation.
	Put *Put

	// A request to perform an UpdateItem operation.
	Update *Update

	noSmithyDocumentSerde
}

// Represents a request to perform an UpdateItem operation.
type Update struct {

	// The primary key of the item to be updated. Each element consists of an attribute
	// name and a value for that attribute.
	//
	// This member is required.
	Key map[string]AttributeValue

	// Name of the table for the UpdateItem request.
	//
	// This member is required.
	TableName *string

	// An expression that defines one or more attributes to be updated, the action to
	// be performed on them, and new value(s) for them.
	//
	// This member is required.
	UpdateExpression *string

	// A condition that must be satisfied in order for a conditional update to succeed.
	ConditionExpression *string

	// One or more substitution tokens for attribute names in an expression.
	ExpressionAttributeNames map[string]string

	// One or more values that can be substituted in an expression.
	ExpressionAttributeValues map[string]AttributeValue

	// Use ReturnValuesOnConditionCheckFailure to get the item attributes if the Update
	// condition fails. For ReturnValuesOnConditionCheckFailure, the valid values are:
	// NONE, ALL_OLD, UPDATED_OLD, ALL_NEW, UPDATED_NEW.
	ReturnValuesOnConditionCheckFailure ReturnValuesOnConditionCheckFailure

	noSmithyDocumentSerde
}

// Represents the new provisioned throughput settings to be applied to a global
// secondary index.
type UpdateGlobalSecondaryIndexAction struct {

	// The name of the global secondary index to be updated.
	//
	// This member is required.
	IndexName *string

	// Represents the provisioned throughput settings for the specified global
	// secondary index. For current minimum and maximum provisioned throughput values,
	// see Service, Account, and Table Quotas
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	//
	// This member is required.
	ProvisionedThroughput *ProvisionedThroughput

	noSmithyDocumentSerde
}

// Represents a replica to be modified.
type UpdateReplicationGroupMemberAction struct {

	// The Region where the replica exists.
	//
	// This member is required.
	RegionName *string

	// Replica-specific global secondary index settings.
	GlobalSecondaryIndexes []ReplicaGlobalSecondaryIndex

	// The KMS key of the replica that should be used for KMS encryption. To specify a
	// key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note
	// that you should only provide this parameter if the key is different from the
	// default DynamoDB KMS key alias/aws/dynamodb.
	KMSMasterKeyId *string

	// Replica-specific provisioned throughput. If not specified, uses the source
	// table's provisioned throughput settings.
	ProvisionedThroughputOverride *ProvisionedThroughputOverride

	// Replica-specific table class. If not specified, uses the source table's table
	// class.
	TableClassOverride TableClass

	noSmithyDocumentSerde
}

// Represents an operation to perform - either DeleteItem or PutItem. You can only
// request one of these operations, not both, in a single WriteRequest. If you do
// need to perform both of these operations, you need to provide two separate
// WriteRequest objects.
type WriteRequest struct {

	// A request to perform a DeleteItem operation.
	DeleteRequest *DeleteRequest

	// A request to perform a PutItem operation.
	PutRequest *PutRequest

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAttributeValue() {}
