############################################################################
#
#  Program:         ScaLAPACK
#
#  Module:          SLmake.inc
#
#  Purpose:         Top-level Definitions
#
#  Creation date:   February 15, 2000
#
#  Modified:
#
#  Send bug reports, comments or suggestions to scalapack@cs.utk.edu
#
############################################################################
#
SHELL         = /bin/sh
#
#  The complete path to the top level of ScaLAPACK directory, usually
#  $(HOME)/SCALAPACK
#
home          = $(BASEDIR)
#
#  The platform identifier to suffix to the end of library names
#
PLAT          = LINUX
#
#  BLACS setup.  All version need the debug level (0 or 1),
#  and the directory where the BLACS libraries are
#
BLACSDBGLVL   = 0
BLACSdir      = /usr/lib
#
#  MPI setup; tailor to your system if using MPIBLACS
#
ifeq ($(MPI),lam)
USEMPI        = -DUsingMpiBlacs
ifeq ($(BUILD),static)
SMPLIB        = -lmpi
BLACSFINIT    = /usr/lib/libblacsF77init-lam.a
BLACSCINIT    = /usr/lib/libblacsCinit-lam.a
BLACSLIB      = /usr/lib/libblacs-lam.a
else
SMPLIB        = -lmpi
BLACSFINIT    = -lblacsF77init-lam
BLACSCINIT    = -lblacsCinit-lam
BLACSLIB      = -lblacs-lam
endif
TESTINGdir    = $(home)/TESTING
endif
ifeq ($(MPI),mpich)
USEMPI        = -DUsingMpiBlacs
ifeq ($(BUILD),static)
SMPLIB        = /usr/lib/mpich/lib/libmpich.a
BLACSFINIT    = /usr/lib/libblacsF77init-mpich.a
BLACSCINIT    = /usr/lib/libblacsCinit-mpich.a
BLACSLIB      = /usr/lib/libblacs-mpich.a
else
SMPLIB        = /usr/lib/mpich/lib/libmpich.a
BLACSFINIT    = -lblacsF77init-mpich
BLACSCINIT    = -lblacsCinit-mpich
BLACSLIB      = -lblacs-mpich
endif
TESTINGdir    = $(home)/TESTING
endif
ifeq ($(MPI),pvm)
USEMPI        =
ifeq ($(BUILD),static)
SMPLIB        = /usr/lib/libpvm3.a
BLACSFINIT    =
BLACSCINIT    =
BLACSLIB      = /usr/lib/libblacs-pvm.a
else
SMPLIB        = -lpvm3
BLACSFINIT    =
BLACSCINIT    =
BLACSLIB      = -lblacs-pvm
endif
#TESTINGdir    = $(HOME)/pvm3/bin/$(PLAT)
TESTINGdir    = $(home)/TESTING
endif

CBLACSLIB     = $(BLACSCINIT) $(BLACSLIB) $(BLACSCINIT)
FBLACSLIB     = $(BLACSFINIT) $(BLACSLIB) $(BLACSFINIT)

#
#  The directories to find the various pieces of ScaLapack
#
PBLASdir      = $(home)/PBLAS
SRCdir        = $(home)/SRC
TESTdir       = $(home)/TESTING
PBLASTSTdir   = $(TESTINGdir)
TOOLSdir      = $(home)/TOOLS
REDISTdir     = $(home)/REDIST
REDISTTSTdir  = $(TESTINGdir)
#
#  The fortran and C compilers, loaders, and their flags
#
F77           = g77
#F77           = /usr/local/pgi/linux86/bin/pgf77
CC            = gcc
NOOPT         = -w -fno-globals -fno-f90 -fugly-complex $(FPIC)
F77FLAGS      = -Wall -O6 -funroll-all-loops -ffast-math $(NOOPT)
CCFLAGS       = -Wall $(FPIC) -O6 -funroll-all-loops -ffast-math
SRCFLAG       =
F77LOADER     = $(F77)
ifeq ($(MPI),mpich)
CCLOADER      = $(F77)
SYSLIBS       = -lm
else
CCLOADER      = $(CC)
SYSLIBS       = -lm
endif
F77LOADFLAGS  =
CCLOADFLAGS   =
#
#  C preprocessor defs for compilation 
#  (-DNoChange, -DAdd_, -DUpCase, or -Df77IsF2C)
#
CDEFS         = -Df77IsF2C -DNO_IEEE $(USEMPI)
#
#  The archiver and the flag(s) to use when building archive (library)
#  Also the ranlib routine.  If your system has no ranlib, set RANLIB = echo
#
ARCH          = ar
ARCHFLAGS     = cr
RANLIB        = ranlib
#
#  The name of the libraries to be created/linked to
#
SCALAPACKLIB  = $(home)/scalapack_$(MPI).a
BLASLIB       = -llapack-3 -lblas-3
# BLASLIB       = /usr/local/lib/libf77blas.a /usr/local/lib/libatlas.a
#
ifeq ($(BUILD),static)
PBLIBS        = $(SCALAPACKLIB) $(FBLACSLIB) $(BLASLIB) $(SMPLIB)
PRLIBS        = $(SCALAPACKLIB) $(CBLACSLIB) $(SMPLIB) $(BLASLIB) $(SYSLIBS)
RLIBS         = $(SCALAPACKLIB) $(FBLACSLIB) $(CBLACSLIB) $(BLASLIB) $(SMPLIB)
LIBS          = $(PBLIBS)
else
PBLIBS        = -L $(BASEDIR) -lscalapack-$(MPI) $(FBLACSLIB) $(BLASLIB) $(SMPLIB)
PRLIBS        = -L $(BASEDIR) -lscalapack-$(MPI) $(CBLACSLIB) $(SMPLIB) $(BLASLIB) $(SYSLIBS)
RLIBS         = -L $(BASEDIR) -lscalapack-$(MPI) $(FBLACSLIB) $(CBLACSLIB) $(BLASLIB) $(SMPLIB)
LIBS          = $(PBLIBS)
endif
