/****************************************************************************
**
** Copyright (C) 2014 Klaralvdalens Datakonsult AB (KDAB).
** Contact: https://www.qt.io/licensing/
**
** This file is part of the Qt3D module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** BSD License Usage
** Alternatively, you may use this file under the terms of the BSD license
** as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of The Qt Company Ltd nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/

import Qt3D.Core 2.0
import Qt3D.Render 2.0
import Qt3D.Input 2.0
import Qt3D.Extras 2.10
import QtQuick 2.5

Entity {
    id: sceneRoot

    Camera {
        id: camera
        projectionType: CameraLens.PerspectiveProjection
        fieldOfView: 45
        aspectRatio: 16/9
        nearPlane : 0.1
        farPlane : 1000.0
        position: Qt.vector3d( 0.0, 0.0, 20.0 )
        upVector: Qt.vector3d( 0.0, 1.0, 0.0 )
        viewCenter: Qt.vector3d( 0.0, 0.0, 0.0 )
    }

    OrbitCameraController { camera: camera }

    RenderSettings {
        id : external_forward_renderer
        activeFrameGraph : ForwardRenderer {
            camera: camera
            clearColor: "lightgrey"
        }
    }

    // Event Source will be set by the Qt3DQuickWindow
    InputSettings { id: inputSettings }

    components: [external_forward_renderer, inputSettings]

    PlaneMesh {
        id: mesh
    }

    SpriteGrid {
        id: spriteGrid
        rows: 2
        columns: 6
        texture: textureLoader
    }

    SpriteSheet {
        id:spriteSheet
        texture: textureLoader

        SpriteItem { x:    0; y:   0; width: 250; height: 172 }
        SpriteItem { x:  276; y:   0; width: 250; height: 172 }
        SpriteItem { x:  550; y:   0; width: 250; height: 172 }
        SpriteItem { x:  826; y:   0; width: 250; height: 172 }
        SpriteItem { x: 1100; y:   0; width: 250; height: 172 }
        SpriteItem { x: 1376; y:   0; width: 250; height: 172 }
        SpriteItem { x:    0; y: 198; width: 250; height: 172 }
        SpriteItem { x:  276; y: 198; width: 250; height: 172 }
        SpriteItem { x:  550; y: 198; width: 250; height: 172 }
        SpriteItem { x:  826; y: 198; width: 250; height: 172 }
        SpriteItem { x: 1100; y: 198; width: 250; height: 172 }
        SpriteItem { x: 1376; y: 198; width: 250; height: 172 }
    }

    Transform {
        id: transform1
        scale: 8
        rotation: fromAxisAndAngle(Qt.vector3d(1, 0, 0), 45)
        translation: Qt.vector3d(-6, 0, 0)
    }

    TextureMaterial {
        id: material1
        texture: TextureLoader {
            id: textureLoader
            source: "spritegrid.png"
            mirrored: false
        }
        textureTransform: spriteGrid.textureTransform
    }

    Entity {
        components: [ mesh, material1, transform1 ]
    }


    Transform {
        id: transform2
        scale: 8
        rotation: fromAxisAndAngle(Qt.vector3d(1, 0, 0), 45)
        translation: Qt.vector3d(6, 0, 0)
    }

    TextureMaterial {
        id: material2
        texture: material1.texture
        textureTransform: spriteSheet.textureTransform
    }

    Entity {
        components: [ mesh, material2, transform2 ]
    }


    Transform {
        id: transform3
        scale3D: Qt.vector3d(12, 4, 4)
        rotation: fromAxisAndAngle(Qt.vector3d(1, 0, 0), 90)
        translation: Qt.vector3d(0, -6, 0)
    }

    TextureMaterial {
        id: material3
        texture: material1.texture
    }

    Entity {
        components: [ mesh, material3, transform3 ]
    }


    Timer {
        interval: 1000
        repeat: true
        running: true
        onTriggered: {
            spriteGrid.currentIndex = (spriteGrid.currentIndex + 1) % (spriteGrid.rows * spriteGrid.columns)
            spriteSheet.currentIndex = (spriteSheet.currentIndex + 1) % (spriteSheet.sprites.length)
        }
    }
}
