# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.dijkstra_graph_geodesic_path import DijkstraGraphGeodesicPath


class DijkstraImageGeodesicPath(DijkstraGraphGeodesicPath):
    r"""
    DijkstraImageGeodesicPath - Dijkstra algorithm to compute the
    graph geodesic.
    
    Superclass: DijkstraGraphGeodesicPath
    
    Takes as input a polyline and an image representing a 2D cost
    function and performs a single source shortest path calculation.
    Dijkstra's algorithm is used. The implementation is similar to the
    one described in Introduction to Algorithms (Second Edition) by
    Thomas H. Cormen, Charles E. Leiserson, Ronald L. Rivest, and Cliff
    Stein, published by MIT Press and mc_graw-Hill. Some minor enhancement
    are added though. All vertices are not pushed on the heap at start,
    instead a front set is maintained. The heap is implemented as a
    binary heap. The output of the filter is a set of lines describing
    the shortest path from start_vertex to end_vertex.  See parent class
    DijkstraGraphGeodesicPath for the implementation.
    
    @warning
    The input cost image must have only VTK_PIXEL cells: i.e., a 2D image
    or slice of a 3D volume. A cost function for a gray scale image might
    be generated by the following pipeline:
    ImageData->vtkImageGradientMagnitude->vtkImageShiftScale wherein
    the gradient magnitude image is inverted so that strong edges have
    low cost value.  Costs in moving from a vertex v to a vertex u are
    calculated using a weighted additive scheme: cost = Iw*f(I) +
    Ew*f(u,v) + Cw*f(t,u,v) where Iw is the weight associated with f(I):
    the normalized image cost, Ew is the weight associated with f(u,v):
    the normalized distance between vertices u and v, and Cw is the
    weight associated with f(t,u,v): the normalized curvature calculated
    from the vertex t which precedes vertex u, and vertices u and v.  All
    weights range from 0 to 1.
    
    @par Thanks: The class was contributed by Dean Inglis.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDijkstraImageGeodesicPath, obj, update, **traits)
    
    curvature_weight = traits.Trait(0.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        Curvature cost weight.
        """
    )

    def _curvature_weight_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCurvatureWeight,
                        self.curvature_weight)

    edge_length_weight = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        r"""
        Edge length cost weight.
        """
    )

    def _edge_length_weight_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEdgeLengthWeight,
                        self.edge_length_weight)

    image_weight = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Image cost weight.
        """
    )

    def _image_weight_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetImageWeight,
                        self.image_weight)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_input_as_image_data(self):
        return wrap_vtk(self._vtk_obj.GetInputAsImageData())
    input_as_image_data = traits.Property(_get_input_as_image_data, desc=\
        r"""
        
        """
    )

    _updateable_traits_ = \
    (('repel_path_from_vertices', 'GetRepelPathFromVertices'),
    ('stop_when_end_reached', 'GetStopWhenEndReached'),
    ('use_scalar_weights', 'GetUseScalarWeights'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('curvature_weight',
    'GetCurvatureWeight'), ('edge_length_weight', 'GetEdgeLengthWeight'),
    ('image_weight', 'GetImageWeight'), ('end_vertex', 'GetEndVertex'),
    ('start_vertex', 'GetStartVertex'), ('progress_text',
    'GetProgressText'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'repel_path_from_vertices',
    'stop_when_end_reached', 'use_scalar_weights', 'curvature_weight',
    'edge_length_weight', 'end_vertex', 'image_weight', 'object_name',
    'progress_text', 'start_vertex'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DijkstraImageGeodesicPath, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DijkstraImageGeodesicPath properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['repel_path_from_vertices', 'stop_when_end_reached',
            'use_scalar_weights'], [], ['curvature_weight', 'edge_length_weight',
            'end_vertex', 'image_weight', 'object_name', 'start_vertex']),
            title='Edit DijkstraImageGeodesicPath properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DijkstraImageGeodesicPath properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

