package org.libreoffice.canvas;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;

class ImageUtils {
    static Bitmap getBitmapForDrawable(Drawable drawable) {
        drawable = drawable.mutate();

        int width = !drawable.getBounds().isEmpty() ?
                drawable.getBounds().width() : drawable.getIntrinsicWidth();

        width = width <= 0 ? 1 : width;

        int height = !drawable.getBounds().isEmpty() ?
                drawable.getBounds().height() : drawable.getIntrinsicHeight();

        height = height <= 0 ? 1 : height;

        final Bitmap bitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);

        return bitmap;
    }
}
/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
