#!/bin/sh -e

VERSION=$2
UVERSION=`echo $VERSION | sed 's/\./_/g'`
TAR=../jaxb_$VERSION.orig.tar.xz
DIR=jaxb-$VERSION
TAG=$(echo "jaxb-$UVERSION" | sed -re's/~(alpha|beta)/-\1-/')

svn export https://svn.java.net/svn/jaxb~version2/tags/$TAG $DIR
wget http://repo1.maven.org/maven2/com/sun/xml/bind/jaxb-impl/$VERSION/jaxb-impl-$VERSION.pom
wget http://repo1.maven.org/maven2/com/sun/xml/bind/jaxb-xjc/$VERSION/jaxb-xjc-$VERSION.pom
mv jaxb-impl-$VERSION.pom $DIR/jaxb-impl.pom
mv jaxb-xjc-$VERSION.pom $DIR/jaxb-xjc.pom
XZ_OPT=--best tar -c -J -f $TAR \
    --exclude '*.jar' \
    --exclude '*.class' \
    --exclude '*.ipr' \
    --exclude '*.iml' \
    --exclude '.settings' \
    --exclude '.project' \
    --exclude '.classpath' \
    --exclude '*.dll' \
    --exclude '*.zip' \
    $DIR
rm -rf $DIR ../$TAG

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir && echo "moved $TAR to $origDir"
fi
