/*
 *  dancer-XML parser
 *  Copyright (C) 2000,2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * example application for mikilab user account file parser
 *
 */

#include <stddef.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <dirent.h>
#include "dancer-xml.h"

const char * get_PCDATA_bysimplepath_i (dxml_element * e, const char * loc)
{
  const char * s = dxml_get_PCDATA_bysimplepath ( e, loc);
  if (s)
    return s;
  else
    return "";
}


static void
dump_one_info (dxml_element * e)
{
  printf ("<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td><tr> \n", 
	  get_PCDATA_bysimplepath_i(e, "name"),
	  get_PCDATA_bysimplepath_i(e, "uid"),
	  /*get_PCDATA_bysimplepath_i(e, "ssh"),*/
	  "hidden",
	  get_PCDATA_bysimplepath_i(e, "status")
	  );
  
}

static void
process_file(const char * filename)
{
  FILE*f = fopen (filename, "r");
  dxml_element * tmp ;
  tmp = dxml_read_xml(f);
  
  for (tmp = dxml_get_element_byname(tmp, "data"); tmp ; tmp = tmp->next)
    {
      dump_one_info (tmp -> child);
    }  
  if (tmp)
    dxml_free_xml(tmp);
  
  fclose (f);
}


static void
dirlist (void)
{
  DIR *dp;
  struct dirent *ep;
  
  dp = opendir ("./");
  if (dp != NULL)
    {
      while ((ep = readdir (dp)))
	{
	  if (strstr(ep->d_name, ".xml"))
	    process_file (ep->d_name);
	}
      
      closedir (dp);
    }
  else
    perror ("Couldn't open the directory");
}

int
main (int ac, char ** av)
{
  printf ("Content-Type: text/html;\n\n"
	  "<html><head><link title=\"Mainstyle\" href=\"http://mikilab.doshisha.ac.jp/dia/research/parallel/parallel.css\" type=\"text/css\" rel=\"stylesheet\"> <title>Database</title></head><body>\n"
	  "<table><tr><th>Name</th><th>User ID</th><th>SSH key</th><th>Status</th></tr>\n"
	  );

  chdir("data");
  
  dirlist ();
  
  printf ("</table></body></html>\n");

  return 0;
}
