#!/bin/bash

TARGET=`pwd`
if [ -e $TARGET'/debug' ]; then
    BUILD=$TARGET'/debug'
else
    BUILD=$TARGET
fi
LINKS=`echo ~`'/kde-debug'
HOME=`echo ~`

dest_files=(
    "$LINKS/share/apps/basket/backgrounds/abstract.png"
    "$LINKS/share/apps/basket/backgrounds/alien-artifact.png"
    "$LINKS/share/apps/basket/backgrounds/alien-artifact.png.config"
    "$LINKS/share/apps/basket/backgrounds/basket-title.png"
    "$LINKS/share/apps/basket/backgrounds/green-curves.png"
    "$LINKS/share/apps/basket/backgrounds/light.png"
    "$LINKS/share/apps/basket/backgrounds/painting.png"
    "$LINKS/share/apps/basket/backgrounds/pens.png"
    "$LINKS/share/apps/basket/backgrounds/pins.png"
    "$LINKS/share/apps/basket/backgrounds/rainbow-balls.png"
    "$LINKS/share/apps/basket/backgrounds/rounds-line.png"
    "$LINKS/share/apps/basket/backgrounds/todo.png"
    "$LINKS/share/apps/basket/backgrounds/working.png"
    "$LINKS/share/apps/basket/backgrounds/previews/abstract.png"
    "$LINKS/share/apps/basket/backgrounds/previews/alien-artifact.png"
    "$LINKS/share/apps/basket/backgrounds/previews/basket-title.png"
    "$LINKS/share/apps/basket/backgrounds/previews/green-curves.png"
    "$LINKS/share/apps/basket/backgrounds/previews/light.png"
    "$LINKS/share/apps/basket/backgrounds/previews/painting.png"
    "$LINKS/share/apps/basket/backgrounds/previews/pens.png"
    "$LINKS/share/apps/basket/backgrounds/previews/pins.png"
    "$LINKS/share/apps/basket/backgrounds/previews/rainbow-balls.png"
    "$LINKS/share/apps/basket/backgrounds/previews/rounds-line.png"
    "$LINKS/share/apps/basket/backgrounds/previews/todo.png"
    "$LINKS/share/apps/basket/backgrounds/previews/working.png"
    "$LINKS/share/apps/basket/images/insertion_help.png"
    "$LINKS/share/apps/basket/images/tag_export_help.png"
    "$LINKS/share/apps/basket/basket_part.rc"
    "$LINKS/share/apps/basket/basketui.rc"
    "$LINKS/share/apps/basket/icons/hicolor/16x16/actions/tag_priority_high.png"
    "$LINKS/share/apps/basket/icons/hicolor/16x16/actions/tag_important.png"
    "$LINKS/share/apps/basket/icons/hicolor/16x16/actions/tag_for_later.png"
    "$LINKS/share/apps/basket/icons/hicolor/16x16/actions/tag_preference_excellent.png"
    "$LINKS/share/apps/basket/icons/hicolor/16x16/actions/tag_priority_medium.png"
    "$LINKS/share/apps/basket/icons/hicolor/16x16/actions/tag_progress_000.png"
    "$LINKS/share/apps/basket/icons/hicolor/16x16/actions/tag_progress_100.png"
    "$LINKS/share/apps/basket/icons/hicolor/16x16/actions/tag_preference_bad.png"
    "$LINKS/share/apps/basket/icons/hicolor/16x16/actions/tag_preference_good.png"
    "$LINKS/share/apps/basket/icons/hicolor/16x16/actions/tag_checkbox.png"
    "$LINKS/share/apps/basket/icons/hicolor/16x16/actions/tag_progress_050.png"
    "$LINKS/share/apps/basket/icons/hicolor/16x16/actions/tag_fun.png"
    "$LINKS/share/apps/basket/icons/hicolor/16x16/actions/tag_progress_025.png"
    "$LINKS/share/apps/basket/icons/hicolor/16x16/actions/tag_checkbox_checked.png"
    "$LINKS/share/apps/basket/icons/hicolor/16x16/actions/tag_progress_075.png"
    "$LINKS/share/apps/basket/icons/hicolor/16x16/actions/tag_priority_low.png"
    "$LINKS/share/apps/kontact/ksettingsdialog/kontact_basketplugin.setdlg"
    "$LINKS/share/services/kontact/basket.desktop"
    "$LINKS/share/services/basket_config_general.desktop"
    "$LINKS/share/services/basket_config_baskets.desktop"
    "$LINKS/share/services/basket_config_new_notes.desktop"
    "$LINKS/share/services/basket_config_notes_appearance.desktop"
    "$LINKS/share/services/basket_config_apps.desktop"
    "$LINKS/share/services/basket_part.desktop"
    "$LINKS/share/applnk/Utilities/basket.desktop"
    "$LINKS/lib/kde3/libkontact_basket.so"
    "$LINKS/lib/kde3/libkontact_basket.la"
    "$LINKS/lib/kde3/kcm_basket.so"
    "$LINKS/lib/kde3/kcm_basket.la"
    "$LINKS/lib/kde3/libbasketpart.so"
    "$LINKS/lib/kde3/libbasketpart.la"
    "$LINKS/lib/libbasketcommon.so"
    "$LINKS/lib/libbasketcommon.la"
    "$LINKS/bin/basket"
	"$LINKS/share/icons/hicolor/16x16/actions/likeback_dislike.png"
	"$LINKS/share/icons/hicolor/16x16/actions/likeback_like.png"
	"$LINKS/share/icons/hicolor/16x16/actions/likeback_configure.png"
	"$LINKS/share/icons/hicolor/16x16/actions/tag_priority_high.png"
	"$LINKS/share/icons/hicolor/16x16/actions/tag_important.png"
	"$LINKS/share/icons/hicolor/16x16/actions/tag_for_later.png"
	"$LINKS/share/icons/hicolor/16x16/actions/tag_preference_excellent.png"
	"$LINKS/share/icons/hicolor/16x16/actions/tag_priority_medium.png"
	"$LINKS/share/icons/hicolor/16x16/actions/tag_progress_000.png"
	"$LINKS/share/icons/hicolor/16x16/actions/tag_progress_100.png"
	"$LINKS/share/icons/hicolor/16x16/actions/tag_preference_bad.png"
	"$LINKS/share/icons/hicolor/16x16/actions/tag_preference_good.png"
	"$LINKS/share/icons/hicolor/16x16/actions/tag_checkbox.png"
	"$LINKS/share/icons/hicolor/16x16/actions/tag_progress_050.png"
	"$LINKS/share/icons/hicolor/16x16/actions/tag_fun.png"
	"$LINKS/share/icons/hicolor/16x16/actions/tag_progress_025.png"
	"$LINKS/share/icons/hicolor/16x16/actions/tag_checkbox_checked.png"
	"$LINKS/share/icons/hicolor/16x16/actions/tag_progress_075.png"
	"$LINKS/share/icons/hicolor/16x16/actions/tag_priority_low.png"
	"$LINKS/share/icons/hicolor/16x16/apps/basket.png"
	"$LINKS/share/icons/hicolor/128x128/apps/basket.png"
	"$LINKS/share/icons/hicolor/64x64/apps/basket.png"
	"$LINKS/share/icons/hicolor/48x48/apps/basket.png"
	"$LINKS/share/icons/hicolor/22x22/apps/basket.png"
	"$LINKS/share/icons/hicolor/32x32/apps/basket.png"
	"$LINKS/share/icons/hicolor/scalable/apps/basket.svg"
)

source_files=(
    "$TARGET/backgrounds/abstract.png"
    "$TARGET/backgrounds/alien-artifact.png"
    "$TARGET/backgrounds/alien-artifact.png.config"
    "$TARGET/backgrounds/basket-title.png"
    "$TARGET/backgrounds/green-curves.png"
    "$TARGET/backgrounds/light.png"
    "$TARGET/backgrounds/painting.png"
    "$TARGET/backgrounds/pens.png"
    "$TARGET/backgrounds/pins.png"
    "$TARGET/backgrounds/rainbow-balls.png"
    "$TARGET/backgrounds/rounds-line.png"
    "$TARGET/backgrounds/todo.png"
    "$TARGET/backgrounds/working.png"
    "$TARGET/backgrounds-previews/abstract.png"
    "$TARGET/backgrounds-previews/alien-artifact.png"
    "$TARGET/backgrounds-previews/basket-title.png"
    "$TARGET/backgrounds-previews/green-curves.png"
    "$TARGET/backgrounds-previews/light.png"
    "$TARGET/backgrounds-previews/painting.png"
    "$TARGET/backgrounds-previews/pens.png"
    "$TARGET/backgrounds-previews/pins.png"
    "$TARGET/backgrounds-previews/rainbow-balls.png"
    "$TARGET/backgrounds-previews/rounds-line.png"
    "$TARGET/backgrounds-previews/todo.png"
    "$TARGET/backgrounds-previews/working.png"
    "$TARGET/images/insertion_help.png"
    "$TARGET/images/tag_export_help.png"
    "$TARGET/src/basket_part.rc"
    "$TARGET/src/basketui.rc"
    "$TARGET/tags/16-action-tag_priority_high.png"
    "$TARGET/tags/16-action-tag_important.png"
    "$TARGET/tags/16-action-tag_for_later.png"
    "$TARGET/tags/16-action-tag_preference_excellent.png"
    "$TARGET/tags/16-action-tag_priority_medium.png"
    "$TARGET/tags/16-action-tag_progress_000.png"
    "$TARGET/tags/16-action-tag_progress_100.png"
    "$TARGET/tags/16-action-tag_preference_bad.png"
    "$TARGET/tags/16-action-tag_preference_good.png"
    "$TARGET/tags/16-action-tag_checkbox.png"
    "$TARGET/tags/16-action-tag_progress_050.png"
    "$TARGET/tags/16-action-tag_fun.png"
    "$TARGET/tags/16-action-tag_progress_025.png"
    "$TARGET/tags/16-action-tag_checkbox_checked.png"
    "$TARGET/tags/16-action-tag_progress_075.png"
    "$TARGET/tags/16-action-tag_priority_low.png"
    "$TARGET/kontact_plugin/kontact_basketplugin.setdlg"
    "$TARGET/kontact_plugin/basket.desktop"
    "$TARGET/src/basket_config_general.desktop"
    "$TARGET/src/basket_config_baskets.desktop"
    "$TARGET/src/basket_config_new_notes.desktop"
    "$TARGET/src/basket_config_notes_appearance.desktop"
    "$TARGET/src/basket_config_apps.desktop"
    "$TARGET/src/basket_part.desktop"
    "$TARGET/src/basket.desktop"
    "$BUILD/kontact_plugin/.libs/libkontact_basket.so"
    "$BUILD/kontact_plugin/.libs/libkontact_basket.la"
    "$BUILD/src/.libs/kcm_basket.so"
    "$BUILD/src/.libs/kcm_basket.la"
    "$BUILD/src/.libs/libbasketpart.so"
    "$BUILD/src/.libs/libbasketpart.la"
    "$BUILD/src/.libs/libbasketcommon.so"
    "$BUILD/src/.libs/libbasketcommon.la"
    "$BUILD/src/.libs/basket"
	"$TARGET/src/16-action-likeback_dislike.png"
	"$TARGET/src/16-action-likeback_like.png"
	"$TARGET/src/16-action-likeback_configure.png"
	"$TARGET/tags/16-action-tag_priority_high.png"
	"$TARGET/tags/16-action-tag_important.png"
	"$TARGET/tags/16-action-tag_for_later.png"
	"$TARGET/tags/16-action-tag_preference_excellent.png"
	"$TARGET/tags/16-action-tag_priority_medium.png"
	"$TARGET/tags/16-action-tag_progress_000.png"
	"$TARGET/tags/16-action-tag_progress_100.png"
	"$TARGET/tags/16-action-tag_preference_bad.png"
	"$TARGET/tags/16-action-tag_preference_good.png"
	"$TARGET/tags/16-action-tag_checkbox.png"
	"$TARGET/tags/16-action-tag_progress_050.png"
	"$TARGET/tags/16-action-tag_fun.png"
	"$TARGET/tags/16-action-tag_progress_025.png"
	"$TARGET/tags/16-action-tag_checkbox_checked.png"
	"$TARGET/tags/16-action-tag_progress_075.png"
	"$TARGET/tags/16-action-tag_priority_low.png"
	"$TARGET/src/16-app-basket.png"
	"$TARGET/src/128-app-basket.png"
	"$TARGET/src/64-app-basket.png"
	"$TARGET/src/48-app-basket.png"
	"$TARGET/src/22-app-/basket.png"
	"$TARGET/src/32-app-/basket.png"
	"$TARGET/src/hisc-app-basket.svg"
)

function makedir()
{
  if [ ! -d $1 ]; then
    echo "Making dir: $1"
    mkdir -p $1
  fi
}

function softlink()
{
  if [ -L $2 ]; then
    rm $2
  fi
  makedir `dirname $2`
  echo "Linking: $2->$1"
  ln -s $1 $2
}

index=0
element_count=${#source_files[@]}

while [ "$index" -lt "$element_count" ]; do
  softlink "${source_files[$index]}" "${dest_files[$index]}"
  let "index = $index + 1"
done

softlink "$LINKS/lib" "$LINKS/lib64"

