//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_19.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot19(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[19] = {3.204591312825304e-02,2.887340723468645e-01,8.038347993954951e-01,1.580861457509691e+00,2.625251397291487e+00,
    3.944584383931721e+00,5.548906636814555e+00,7.451196374737413e+00,9.668028267502336e+00,1.222052992938617e+01,1.513578608474423e+01,1.844896140646318e+01,
    2.220663960653552e+01,2.647235572714690e+01,3.133641179615084e+01,3.693498528005443e+01,4.349259161844164e+01,5.143807076938222e+01,6.187022447903700e+01
    };
  constexpr double aw[19] = {3.467841178687803e-01,2.687237600289276e-01,1.610879714954811e-01,7.444398336823849e-02,2.638053352048692e-02,
    7.115236826134048e-03,1.446307121562705e-03,2.187575953393917e-04,2.422341512093562e-05,1.923465686732354e-06,1.066586570440940e-07,3.990652885688871e-09,
    9.627029292605650e-11,1.407633343845225e-12,1.142861675025690e-14,4.517371223604765e-17,7.007843330558407e-20,2.838738753209343e-23,1.078718882074127e-27
    };
  constexpr double x[7296] = {  3.243030629141147e-03, -4.151169348671088e-05,  3.978718493532683e-07, -3.382598251495552e-09,  2.688740854508611e-11,
 -2.045076310944256e-13,  1.506427888866165e-15, -1.082133503758774e-17,  7.612093604788456e-20, -5.256982188414674e-22,  3.569507049057003e-24, -2.384636679637934e-26,
  2.906734228265174e-02, -3.673781480316636e-04,  3.431815502375254e-06, -2.792893953592130e-08,  2.074604832488249e-10, -1.427966863966275e-12,  9.105940019393373e-15,
 -5.305368916119473e-17,  2.717500392305831e-19, -1.091586684536077e-21,  1.676664638221318e-24,  2.818996184094430e-26,  8.007886844950526e-02, -9.865482477286940e-04,
  8.741160796236628e-06, -6.474479290739837e-08,  4.098506402512442e-10, -2.129576238228324e-12,  7.500955363658509e-15,  5.774362534811492e-18, -4.141163678333104e-19,
  4.713180262947513e-21, -3.699451450577175e-23,  2.162690399648940e-25,  1.550156579330419e-01, -1.836954592083356e-03,  1.497526294142798e-05, -9.426898818424877e-08,
  4.222909410755570e-10, -5.793743500810032e-13, -1.257190031930645e-14,  1.644936767723652e-16, -1.192235741799282e-18,  4.786718572813160e-21,  1.033964751441643e-23,
 -3.894877190578180e-25,  2.520154545479273e-01, -2.832897649592943e-03,  2.049022271153751e-05, -9.775316391297245e-08,  1.273555338707471e-10,  2.991367395412806e-12,
 -3.453531947869632e-14,  1.837270327595177e-16,  4.755118042285734e-20, -1.096632152152189e-20,  1.104525823197185e-22, -4.882803102466841e-25,  3.686526559082894e-01,
 -3.873255281601521e-03,  2.371823770387199e-05, -6.535769481886488e-08, -4.005463967566383e-10,  6.084199549187772e-12, -2.924981629226379e-14, -8.810318247222340e-17,
  2.450326513721173e-18, -1.601929941532115e-20, -1.211291899845698e-23,  1.142555932874619e-24,  5.019877818345869e-01, -4.851341661483491e-03,  2.352915462957710e-05,
 -1.046264787876727e-09, -9.126959625056912e-10,  5.757070719120005e-12,  1.092370899990340e-14, -4.032850303547613e-16,  2.096596926019380e-18,  1.100301736092178e-20,
 -2.157278258572704e-22,  7.993769539833455e-25,  6.486294804900971e-01, -5.665554112580688e-03,  1.950468982783452e-05,  7.781128804924523e-08, -1.116945743403505e-09,
  1.200671718535236e-12,  5.564621789265366e-14, -3.381241941601833e-16, -1.842334191667943e-18,  3.143705902473374e-20, -3.385556262622369e-23, -2.029767526323387e-24,
  8.048089373939772e-01, -6.229825545617742e-03,  1.206101021963586e-05,  1.462500108356942e-07, -8.502636330767880e-10, -5.134918290486418e-12,  6.133590637047745e-14,
  1.440373800826711e-16, -4.353139079493131e-18,  2.721440752759866e-21,  2.956451763717795e-22, -1.062292194011589e-24,  9.664662770910182e-01, -6.482850247423624e-03,
  2.385367138989631e-06,  1.809187564758334e-07, -1.899238904875418e-10, -9.041197317054112e-12,  1.584518052123518e-14,  5.466999375131863e-16, -1.358691013858634e-18,
 -3.643010201934127e-20,  1.184066602436355e-22,  2.571830633950455e-24,  1.129348143730965e+00, -6.395089499861097e-03, -7.807629146667618e-06,  1.691813900398329e-07,
  5.699977787056872e-10, -7.695487995024523e-12, -4.446977226786878e-14,  4.019902253327430e-16,  3.562191451620774e-18, -2.146447828864933e-20, -2.881245900975073e-22,
  1.066155823132378e-24,  1.289115109855921e+00, -5.972705165333310e-03, -1.665245215456270e-05,  1.144172832234969e-07,  1.072420441703532e-09, -1.944427896402435e-12,
 -6.746220659579681e-14, -1.358104879678388e-16,  3.832580531627448e-18,  2.418559925402615e-20, -1.718810722269080e-22, -2.431964129599814e-24,  1.441456903713651e+00,
 -5.257820252347519e-03, -2.255945368437937e-05,  3.514741888928029e-08,  1.095495468779442e-09,  4.248630016286641e-12, -3.624527501292048e-14, -4.642489225885311e-16,
 -4.749718363383548e-19,  2.776821733859936e-20,  2.030964991631331e-22, -6.908156591587014e-25,  1.582212698860292e+00, -4.324858723065549e-03, -2.459158830410750e-05,
 -4.196146577735992e-08,  6.759709936581032e-10,  6.861492292611300e-12,  1.544958283914923e-14, -2.758183317060896e-16, -3.114734268216827e-18, -7.391094732135959e-21,
  1.454780502156201e-22,  1.699060178184420e-24,  1.707492938614670e+00, -3.273147877435607e-03, -2.269595540250407e-05, -9.255944811409650e-08,  7.910062155494015e-11,
  4.869348066801981e-12,  4.022751729161946e-14,  1.090775475171207e-16, -1.293279095572516e-18, -1.919071456473063e-20, -1.080136513045111e-22,  1.621443559172258e-25,
  1.813798469191863e+00, -2.216431059128725e-03, -1.772529955153294e-05, -1.042378382300878e-07, -3.687995171769350e-10,  7.252073280120318e-13,  2.503786623253478e-14,
  2.300105834170337e-16,  1.147835342746152e-18, -3.248564524954287e-22, -7.117361357817738e-23, -7.913878229503891e-25,  1.898132289836262e+00, -1.270373424703590e-03,
 -1.123465121174070e-05, -8.115139947247384e-08, -4.793844892121401e-10, -2.066344138913309e-12, -2.440124182520457e-15,  6.911674621271012e-17,  9.426500970921528e-19,
  7.785036156181050e-21,  4.451720392898554e-23,  1.198445523861954e-25,  1.958099542066097e+00, -5.394714584596343e-04, -5.096362137694947e-06, -4.150402492242828e-08,
 -3.038749490631416e-10, -2.014310581245277e-12, -1.189021515198667e-14, -5.905294054941579e-17, -1.998379345680489e-19,  2.373046783710789e-22,  1.266015484887332e-23,
  1.515938865553502e-25,  1.991999692077486e+00, -1.048351857165165e-04, -1.026191921467892e-06, -8.880767188625405e-09, -7.155926721753446e-11, -5.488986597579258e-13,
 -4.051882397572220e-15, -2.894292545936976e-17, -2.005247133919782e-19, -1.347634894492057e-21, -8.767730978576606e-24, -5.497113553847856e-26,  3.083102657724472e-03,
 -3.848406861407079e-05,  3.597329796371558e-07, -2.983254835430011e-09,  2.313560760244300e-11, -1.717306271208789e-13,  1.234872806715471e-15, -8.662637794463102e-18,
  5.953183181069335e-20, -4.018639053487630e-22,  2.668712206597961e-24, -1.744952336634646e-26,  2.765069303654311e-02, -3.412098796603792e-04,  3.115679101217324e-06,
 -2.482666020857883e-08,  1.809711720481186e-10, -1.226303488983421e-12,  7.736377725066619e-15, -4.497141089227050e-17,  2.339082491364900e-19, -1.005161125525878e-21,
  2.525894208900480e-24,  1.182718445248413e-26,  7.626776662230496e-02, -9.196184052818155e-04,  8.002195196065273e-06, -5.851810367338484e-08,  3.690653315778752e-10,
 -1.948963551252044e-12,  7.500689517034030e-15, -5.030210906693237e-18, -2.688847333202389e-19,  3.412690881196183e-21, -2.830576632258167e-23,  1.785040544419141e-25,
  1.479004402022702e-01, -1.721563516540188e-03,  1.388414361937313e-05, -8.761993630237523e-08,  4.080376727215773e-10, -8.299798982178235e-13, -8.473902595659142e-15,
  1.291487612845948e-16, -1.016120936040296e-18,  4.909299346053966e-21, -3.031996536889231e-24, -2.275112601935006e-25,  2.410043328137320e-01, -2.673629116087141e-03,
  1.933124407807217e-05, -9.528014285027501e-08,  1.793105462995296e-10,  2.224088595981468e-12, -2.942317904941341e-14,  1.797416412127772e-16, -2.730465438332236e-19,
 -6.993819784397705e-21,  8.795924807587439e-23, -5.183900097766757e-25,  3.535340174667699e-01, -3.686746501303339e-03,  2.289938300951156e-05, -7.083179317213182e-08,
 -2.860386539803675e-10,  5.360927747814053e-12, -3.070579188209516e-14, -1.892297942244701e-17,  1.875820440619755e-18, -1.563010300837012e-20,  2.840547796987698e-23,
  7.085721729025478e-25,  4.829584633025359e-01, -4.663398073657694e-03,  2.343281629531397e-05, -1.471772311657474e-08, -7.958069850480711e-10,  5.891625554183346e-12,
  6.191108099368326e-16, -3.314459853832993e-16,  2.346872063846217e-18,  3.184585033142900e-21, -1.730586040837731e-22,  1.093479388302293e-24,  6.262848268077378e-01,
 -5.506083181339802e-03,  2.033221693118601e-05,  6.020150076822311e-08, -1.080374121779005e-09,  2.416941600959009e-12,  4.552069305951895e-14, -3.793957137601906e-16,
 -7.547406924798558e-19,  2.849176749250318e-20, -1.083553040009390e-22, -1.338790798394215e-24,  7.800933902457490e-01, -6.126556014822729e-03,  1.373125814675922e-05,
  1.319052777806364e-07, -9.379953828077798e-10, -3.630031340245306e-12,  6.344914542802220e-14,  8.480822189803971e-18, -4.055759208457082e-18,  1.337701642156898e-20,
  2.319947256708030e-22, -1.766543608071013e-24,  9.405867009518225e-01, -6.455148452251242e-03,  4.532273237861543e-06,  1.764591458089723e-07, -3.657354754406824e-10,
 -8.483308664666405e-12,  3.035467522776370e-14,  4.833633236206411e-16, -2.559237972604605e-18, -2.961091193893691e-20,  2.173609216355782e-22,  1.861867192171760e-24,
  1.103655924457871e+00, -6.449286840899619e-03, -5.727988548884088e-06,  1.770161366215138e-07,  4.063902464264928e-10, -8.615603818776735e-12, -3.174958183749384e-14,
  5.015035209481720e-16,  2.596243181321150e-18, -3.173353078458798e-20, -2.178334684561022e-22,  2.091172533662228e-24,  1.264966952859917e+00, -6.100144587057177e-03,
 -1.517806358727077e-05,  1.311758973230905e-07,  1.017107783927785e-09, -3.594542615188805e-12, -6.942766621970790e-14, -7.693598835859338e-19,  4.554350129390628e-18,
  1.524664603590536e-20, -2.722668812744622e-22, -2.047206082477587e-24,  1.420067771419999e+00, -5.436304702125700e-03, -2.202987822046233e-05,  5.330342517016722e-08,
  1.170711528450585e-09,  3.222016242749090e-12, -4.929599744565059e-14, -4.619615854265707e-16,  6.610661601652909e-19,  3.500549565624020e-20,  1.516768643613132e-22,
 -1.661427787508434e-24,  1.564516882955050e+00, -4.523411169257215e-03, -2.502564650249330e-05, -3.003077600400305e-08,  8.162240900174083e-10,  7.128142410631846e-12,
  6.300135563719274e-15, -3.784751259317213e-16, -3.257670508288487e-18, -3.859911049867255e-23,  2.225963309537118e-22,  1.758439170669310e-24,  1.694030217868396e+00,
 -3.459129111795042e-03, -2.379568881308491e-05, -9.046133997753336e-08,  1.863625901955787e-10,  5.866114359517341e-12,  4.259261431804861e-14,  5.582689045422540e-17,
 -2.058955944926989e-18, -2.322960237201632e-20, -9.012690994447277e-23,  6.845608843075885e-25,  1.804641078201938e+00, -2.363335859635369e-03, -1.901096780508147e-05,
 -1.099876839256482e-07, -3.477432910178623e-10,  1.407518035549499e-12,  3.198630317199113e-14,  2.659326336497298e-16,  1.075896212952141e-18, -3.934897526142499e-21,
 -1.109684116050802e-22, -1.015761903296670e-24,  1.892864685965354e+00, -1.364279452141377e-03, -1.225586105761481e-05, -8.915462552859789e-08, -5.211214843459037e-10,
 -2.098003784324556e-12, -3.791044696718902e-17,  1.041186816120859e-16,  1.256072204489929e-18,  9.652505838760256e-21,  4.828303758842399e-23,  4.061830125351865e-26,
  1.955856839277144e+00, -5.823203680730180e-04, -5.624963668212916e-06, -4.670439368754367e-08, -3.471524316376143e-10, -2.320228413885355e-12, -1.363116233134908e-14,
 -6.519907808955903e-17, -1.803865107525003e-19,  8.978847182032156e-22,  2.093252227166056e-23,  2.291328353583295e-25,  1.991563228701844e+00, -1.134913321105201e-04,
 -1.140010991220786e-06, -1.011911208511475e-08, -8.357928158192947e-11, -6.566411278107917e-13, -4.959924192619057e-15, -3.620866532362338e-17, -2.559803070339765e-19,
 -1.751739486389486e-21, -1.157109581140636e-23, -7.333811778221675e-26,  2.934703936197430e-03, -3.574335908679190e-05,  3.260465974617368e-07, -2.639030499645074e-09,
  1.997877604418488e-11, -1.448017254772319e-13,  1.016952953893025e-15, -6.969902274319104e-18,  4.681470071865552e-20, -3.090072667528876e-22,  2.007558046237516e-24,
 -1.285020186838072e-26,  2.633388467280592e-02, -3.174287028857578e-04,  2.834354595302990e-06, -2.211765510936876e-08,  1.582040697646699e-10, -1.054927722461794e-12,
  6.576673116704903e-15, -3.804500066294785e-17,  1.996367681164733e-19, -8.969017515121774e-22,  2.818381174182496e-24,  2.354976702243528e-27,  7.271301864347852e-02,
 -8.583122261021510e-04,  7.334153420853020e-06, -5.291517563734523e-08,  3.318702470595210e-10, -1.771503365562770e-12,  7.256380524822470e-15, -1.187262836015607e-17,
 -1.646150428133276e-19,  2.426616618895739e-21, -2.126253898065631e-23,  1.422210014593424e-25,  1.412298282587451e-01, -1.614586465798247e-03,  1.287129562465424e-05,
 -8.123401482050375e-08,  3.896789467460074e-10, -9.934718471027077e-13, -5.286659589429753e-15,  9.941988697748828e-17, -8.436469118345816e-19,  4.623920836317612e-21,
 -1.042588826624225e-23, -1.159709902712922e-25,  2.306119479723562e-01, -2.523500698095775e-03,  1.820644441791935e-05, -9.209199713222081e-08,  2.171324042544645e-10,
  1.577128691593377e-12, -2.454600360276176e-14,  1.676105766541140e-16, -4.669194701441622e-19, -3.923043334607914e-21,  6.588923582562980e-23, -4.764763446030436e-25,
  3.391479389496641e-01, -3.507021277764298e-03,  2.202535007890162e-05, -7.459076823250125e-08, -1.861995242957643e-10,  4.623902891888754e-12, -3.047797484942072e-14,
  3.237379893340353e-17,  1.340073886361739e-18, -1.398203094769062e-20,  5.139721218372078e-23,  3.517506489115177e-25,  4.646783837268569e-01, -4.476849508030797e-03,
  2.318368898335600e-05, -2.651016924942685e-08, -6.785334653271952e-10,  5.803665189182038e-12, -7.601712692845383e-15, -2.557516105508365e-16,  2.348803367340283e-18,
 -2.746441279886626e-21, -1.231635692246229e-22,  1.139998829734215e-24,  6.045899753109680e-01, -5.340825594301972e-03,  2.095269652439454e-05,  4.335793533489790e-08,
 -1.021980993132570e-09,  3.380147360014006e-12,  3.470711867278337e-14, -3.880750274392266e-16,  1.807041780558757e-19,  2.319355099609213e-20, -1.513262817962065e-22,
 -6.229253734115891e-25,  7.558165243294759e-01, -6.010634611814927e-03,  1.522194571096894e-05,  1.163991075093256e-07, -9.954226653400898e-10, -2.118562822799899e-12,
  6.195387516480326e-14, -1.119669178386651e-16, -3.426999407435063e-18,  2.098555817168456e-20,  1.462969562518424e-22, -2.060183393924044e-24,  9.148518773176785e-01,
 -6.410532322735681e-03,  6.609213762521420e-06,  1.692940544413361e-07, -5.270720350588037e-10, -7.602561904248772e-12,  4.259486665461240e-14,  3.862336421726976e-16,
 -3.451508259247884e-18, -1.955785068979484e-20,  2.780144856239476e-22,  8.664488521065175e-25,  1.077780720982886e+00, -6.486516776945736e-03, -3.570588433444822e-06,
  1.821034116417043e-07,  2.276395157987337e-10, -9.200811563442508e-12, -1.672698325657258e-14,  5.648176026099150e-16,  1.321344465108806e-18, -3.837381889529751e-20,
 -1.091913333344048e-22,  2.773478884826523e-24,  1.240333877488893e+00, -6.215002050075346e-03, -1.350897542686660e-05,  1.467842560584722e-07,  9.286395236024741e-10,
 -5.244168694879296e-12, -6.734228865884095e-14,  1.514866160294272e-16,  4.887475431527962e-18,  2.779412105740500e-21, -3.446781139362981e-22, -1.168079395984713e-24,
  1.397974581077990e+00, -5.609662271722968e-03, -2.127594238696145e-05,  7.248171066872139e-08,  1.222290520399070e-09,  1.887286049358184e-12, -6.173788038412941e-14,
 -4.196338262042901e-16,  2.010201197196905e-18,  3.932051606709266e-20,  5.709262921845126e-23, -2.615872493080327e-24,  1.546020873354255e+00, -4.724824936168784e-03,
 -2.530293746997114e-05, -1.582628679932620e-08,  9.593799400723835e-10,  7.140462137956058e-12, -5.743698564225072e-15, -4.808759419676624e-16, -3.080620407832492e-18,
  1.035458721111071e-20,  2.948743797162432e-22,  1.455974563190358e-24,  1.679806179114373e+00, -3.653776796596186e-03, -2.485928142982132e-05, -8.648503207032554e-08,
  3.139918781639991e-10,  6.898853839514024e-12,  4.310307380494588e-14, -2.406518868569561e-17, -2.951069014645739e-18, -2.603349210505564e-20, -4.480539059856441e-23,
  1.406261046722760e-24,  1.794875069858792e+00, -2.520795173817714e-03, -2.036313221444370e-05, -1.152820638793073e-07, -3.112936501353862e-10,  2.268269366367207e-12,
  3.988649076288367e-14,  2.971470834025649e-16,  8.430241609481089e-19, -9.326702183317604e-21, -1.599606152299385e-22, -1.198168064188805e-24,  1.887204494319285e+00,
 -1.466750691690695e-03, -1.337712615480167e-05, -9.782722215074388e-08, -5.628296326893248e-10, -2.059053348093672e-12,  3.495039012889905e-15,  1.502467868387519e-16,
  1.638400732435547e-18,  1.157908679302066e-20,  4.686553134395825e-23, -1.221817480771494e-25,  1.953433870746685e+00, -6.296599591352421e-04, -6.220333677934954e-06,
 -5.264847616279529e-08, -3.969795719988769e-10, -2.669899312959045e-12, -1.553141550068545e-14, -7.027120694078011e-17, -1.302939701390591e-19,  1.966729603354311e-21,
  3.331752268665371e-23,  3.402220783710254e-25,  1.991090220679568e+00, -1.231209128816502e-04, -1.269919264780841e-06, -1.156827305045349e-08, -9.798965038143678e-11,
 -7.888326718070107e-13, -6.098601761757717e-15, -4.550507047066959e-17, -3.282120983794275e-19, -2.285839315109362e-21, -1.531250322089698e-23, -9.789116972342198e-26,
  2.796754071224482e-03, -3.325643734449155e-05,  2.962047461904572e-07, -2.341275686661007e-09,  1.731183569342897e-11, -1.225772106783061e-13,  8.412007402498977e-16,
 -5.635362752719043e-18,  3.700939177663450e-20, -2.389555008871040e-22,  1.519228277479157e-24, -9.522072641698153e-27,  2.510789729734209e-02, -2.957740315808856e-04,
  2.583460893078164e-06, -1.974695202223765e-08,  1.386012378538668e-10, -9.091778550493161e-13,  5.596152083146404e-15, -3.215138992385515e-17,  1.693859282031689e-19,
 -7.838648462723274e-22,  2.795880175929954e-24, -2.831335852123240e-27,  6.939321860524540e-02, -8.020912902689997e-04,  6.729891983185975e-06, -4.787935266084648e-08,
  2.981520297300605e-10, -1.601859541614987e-12,  6.862229937882911e-15, -1.589507473948211e-17, -9.114701559210362e-20,  1.691539287814286e-21, -1.572282652268821e-23,
  1.104492594651784e-25,  1.349713969352710e-01, -1.515410891221846e-03,  1.193322106165333e-05, -7.516410743941360e-08,  3.687510712313235e-10, -1.089846509512028e-12,
 -2.856456258929733e-15,  7.499756757747798e-17, -6.857011811797094e-19,  4.128601583323336e-21, -1.381391567630535e-23, -4.355795970148815e-26,  2.208023355858380e-01,
 -2.382208301525648e-03,  1.712312666921947e-05, -8.839598228598577e-08,  2.431548614822841e-10,  1.042540074710644e-12, -2.007992392418847e-14,  1.508783549794379e-16,
 -5.655741717725203e-19, -1.685887186436412e-21,  4.652449643977619e-23, -4.005370909141286e-25,  3.254665279841700e-01, -3.334442708291925e-03,  2.111530978198772e-05,
 -7.686948987109394e-08, -1.009396331944270e-10,  3.907704540272509e-12, -2.904384736635498e-14,  6.762442580460713e-17,  8.766819048069080e-19, -1.170030914345691e-20,
  6.079340278080207e-23,  9.140914708701663e-26,  4.471396609241674e-01, -4.292828299693384e-03,  2.280421976112167e-05, -3.645031433395715e-08, -5.648212265266113e-10,
  5.543661870361048e-12, -1.373157475814265e-14, -1.830259350345244e-16,  2.173121695771637e-18, -6.695962504094067e-21, -7.519916269925008e-23,  1.019546789821084e-24,
  5.835648259624757e-01, -5.171395406439351e-03,  2.137724902760971e-05,  2.758864784806386e-08, -9.469219964652003e-10,  4.084107056335131e-12,  2.403891456333788e-14,
 -3.701432705979260e-16,  9.018629743420714e-19,  1.678268010436951e-20, -1.647684093520001e-22, -1.319190530739778e-26,  7.320259975115386e-01, -5.883545345439269e-03,
  1.652203443797916e-05,  1.002128830949201e-07, -1.023239881377865e-09, -6.809486923059017e-13,  5.740410217838641e-14, -2.085915081534090e-16, -2.588061345485900e-18,
  2.502633470014053e-20,  5.642615420160257e-23, -1.967938403637849e-24,  8.893281446395922e-01, -6.349687039329881e-03,  8.585315219848491e-06,  1.597034805188348e-07,
 -6.680915053413986e-10, -6.463563592944338e-12,  5.177292740918696e-14,  2.667221291756507e-16, -3.949086402285335e-18, -7.987830785724866e-21,  2.928151816965604e-22,
 -1.832506274907922e-25,  1.051791433148988e+00, -6.506292702663696e-03, -1.369622427851368e-06,  1.842571484876565e-07,  4.090900110153608e-11, -9.409003038649821e-12,
 -5.324030519037844e-16,  5.843992499414806e-16, -1.084224937596704e-19, -4.020991700181413e-20,  1.864336934906705e-23,  2.945410872826524e-24,  1.215269226665076e+00,
 -6.315784152456886e-03, -1.166215585851128e-05,  1.607173674454698e-07,  8.080289481387637e-10, -6.791815803567837e-12, -6.091548565890282e-14,  3.067457823379665e-16,
  4.730118567456723e-18, -1.168646250245055e-20, -3.694404513596446e-22,  8.765627575474631e-26,  1.375201497982249e+00, -5.776055899297404e-03, -2.028784770491250e-05,
  9.225597128788787e-08,  1.244310576189019e-09,  2.731667151765851e-13, -7.237248725673367e-14, -3.324574538403408e-16,  3.436960599017502e-18,  3.907155429577083e-20,
 -7.456800661883084e-23, -3.301754451055398e-24,  1.526715906433691e+00, -4.927736365033631e-03, -2.539607697339904e-05,  6.540032825932134e-10,  1.099664265361885e-09,
  6.830328264090927e-12, -2.051540044687478e-14, -5.711006355301024e-16, -2.481794815803341e-18,  2.323820542906110e-20,  3.436202088907739e-22,  6.746546503067885e-25,
  1.664786885418494e+00, -3.856706074312202e-03, -2.586222439598856e-05, -8.030157126862658e-08,  4.622002538590152e-10,  7.913695563716164e-12,  4.096458323293340e-14,
 -1.337048631109170e-16, -3.903377153471612e-18, -2.633996835223952e-20,  3.581421161850950e-23,  2.273445695969423e-24,  1.784457203063125e+00, -2.689314642532610e-03,
 -2.177472778125994e-05, -1.198449479420121e-07, -2.556673066538141e-10,  3.328077955291717e-12,  4.852439650387994e-14,  3.174117234729873e-16,  3.791047241066037e-19,
 -1.680800172743706e-20, -2.144905018912801e-22, -1.249025680687244e-24,  1.881115802458733e+00, -1.578619589851859e-03, -1.460642450169108e-05, -1.071558452842693e-07,
 -6.027988316379418e-10, -1.918367269853257e-12,  8.501116449408324e-15,  2.096921825748054e-16,  2.087034155984771e-18,  1.327149793940826e-20,  3.563788434405954e-23,
 -4.137702078592812e-25,  1.950811546326637e+00, -6.820619270397468e-04, -6.892055015323648e-06, -5.944826269480646e-08, -4.542665944369758e-10, -3.066660166474058e-12,
 -1.754472167186707e-14, -7.301882761026231e-17, -3.151744164807297e-20,  3.641020362803588e-21,  5.152989344674915e-23,  4.959579265105110e-25,  1.990576499854393e+00,
 -1.338634502252273e-04, -1.418693175170797e-06, -1.327072883815771e-08, -1.153396461198131e-10, -9.517561134151323e-13, -7.533047870219970e-15, -5.745166185592930e-17,
 -4.226456951586366e-19, -2.993431480883379e-21, -2.030456602197657e-23, -1.305304249023155e-25,  2.668296071597328e-03, -3.099465123623917e-05,  2.696938854447419e-07,
 -2.082853082312962e-09,  1.505005802063780e-11, -1.041555975445659e-13,  6.987766685616807e-16, -4.577744499129372e-18,  2.940697118740799e-20, -1.857967816561590e-22,
  1.156328834891306e-24, -7.098665770528598e-27,  2.396468723575826e-02, -2.760178346123557e-04,  2.359225957899015e-06, -1.766779867913361e-08,  1.216908955252939e-10,
 -7.850858824623631e-13,  4.767707973388032e-15, -2.716126301511142e-17,  1.431412925205561e-19, -6.754254251600966e-22,  2.607477557802606e-24, -5.403456253323307e-27,
  6.628900423764289e-02, -7.504716434418064e-04,  6.182933678624719e-06, -4.335642593496288e-08,  2.677242443956406e-10, -1.442784201935207e-12,  6.384675819215642e-15,
 -1.794982264814761e-17, -4.047575384284370e-20,  1.151671287019465e-21, -1.146235946651844e-23,  8.411366201391735e-26,  1.290951118251930e-01, -1.423454376991425e-03,
  1.106592235806312e-05, -6.944151947159788e-08,  3.464264402809039e-10, -1.135548327091216e-12, -1.042151997576991e-15,  5.532372559744101e-17, -5.473425872535745e-19,
  3.552388588898257e-21, -1.467761572534530e-23,  3.978102791227321e-28,  2.115408495667279e-01, -2.249398735675950e-03,  1.608632484208951e-05, -8.436348334186389e-08,
  2.595179100172052e-10,  6.092278473395885e-13, -1.611546285694785e-14,  1.321351002671520e-16, -5.967884341638448e-19, -1.523739086712775e-22,  3.077323276879638e-23,
 -3.153483980886028e-25,  3.124607287907017e-01, -3.169231724067612e-03,  2.018564398833203e-05, -7.789646845326016e-08, -2.958790014957422e-11,  3.236171802545588e-12,
 -2.681755756263281e-14,  8.941259988116151e-17,  4.996922004582662e-19, -9.243907441144909e-21,  6.080203123283072e-23, -7.701383087859437e-26,  4.303302390794099e-01,
 -4.112289486120754e-03,  2.231618953888331e-05, -4.461997810434514e-08, -4.576190725261729e-10,  5.160223991771966e-12, -1.792262800421760e-14, -1.178390470364357e-16,
  1.888221275166362e-18, -8.864023888496246e-21, -3.472663692226724e-23,  8.114864726583366e-25,  5.632230218604241e-01, -4.999304327637072e-03,  2.162019586893363e-05,
  1.311924138968965e-08, -8.602909430271299e-10,  4.540446920598051e-12,  1.416073333864836e-14, -3.328812384838983e-16,  1.388580289262113e-18,  1.032196782458749e-20,
 -1.551040866839532e-22,  4.209179233438890e-25,  7.087633911709947e-01, -5.746837732014337e-03,  1.762614524761695e-05,  8.380480477278079e-08, -1.023599745831268e-09,
  6.181485349950907e-13,  5.054168139130274e-14, -2.767227430097966e-16, -1.666524940299254e-18,  2.564609361217519e-20, -2.268468654206366e-23, -1.592114877135124e-24,
  8.640786300568291e-01, -6.273529845838556e-03,  1.043357925211868e-05,  1.480496378241974e-07, -7.844069847344731e-10, -5.145860191069561e-12,  5.744466739391304e-14,
  1.379781286847326e-16, -4.030333195791891e-18,  3.284666856991299e-21,  2.643408437333587e-22, -1.069010162989939e-24,  1.025758348804080e+00, -6.508408490372782e-03,
  8.391935744560136e-07,  1.834110971632995e-07, -1.460810821836554e-10, -9.227140800153286e-12,  1.556706419884760e-14,  5.581626262098963e-16, -1.511917960021162e-18,
 -3.694517175581447e-20,  1.418309110599029e-22,  2.567725161866384e-24,  1.189832006122806e+00, -6.401158005722237e-03, -9.660707868617530e-06,  1.724829282611865e-07,
  6.583549923363171e-10, -8.134106837688933e-12, -5.029092812674885e-14,  4.485580650632452e-16,  4.048058003317322e-18, -2.597799787377335e-20, -3.349999863896373e-22,
  1.474175123376346e-24,  1.351780157847915e+00, -5.933592154512536e-03, -1.906145571931569e-05,  1.121113484437181e-07,  1.231720147158009e-09, -1.561778699412881e-12,
 -7.993586472346513e-14, -2.008356714882699e-16,  4.753921221466441e-18,  3.309157251729152e-20, -2.255684985934653e-22, -3.454780061453884e-24,  1.506599109152699e+00,
 -5.130564299301552e-03, -2.527825502556797e-05,  1.930914447438911e-08,  1.230009127715713e-09,  6.137963583224267e-12, -3.747314497754833e-14, -6.344419744192892e-16,
 -1.393731457702881e-18,  3.723221155313839e-20,  3.466724102966892e-22, -6.151508464174044e-25,  1.648940356383633e+00, -4.067320257952131e-03, -2.677608006681721e-05,
 -7.158829599199675e-08,  6.299258105827627e-10,  8.836944964632527e-12,  3.533276436164064e-14, -2.732968155795985e-16, -4.799324740459234e-18, -2.264442709099808e-20,
  1.553038843178525e-22,  3.139932925413234e-24,  1.773342349661906e+00, -2.869329078938549e-03, -2.323500142045594e-05, -1.233368179022748e-07, -1.767355145332175e-10,
  4.600063719980602e-12,  5.747837924537783e-14,  3.181001760024654e-16, -3.933501486227658e-19, -2.644807662270975e-20, -2.659601361308107e-22, -1.032938071584886e-24,
  1.874559242247385e+00, -1.700781261135769e-03, -1.595138775274383e-05, -1.170943421117458e-07, -6.386094187661592e-10, -1.635886898781939e-12,  1.538103452795790e-14,
  2.843539882020732e-16,  2.584969998336243e-18,  1.420811576737291e-20,  7.729680488060980e-24, -8.902487217095091e-25,  1.947968326894860e+00, -7.401802577013545e-04,
 -7.651143765959664e-06, -6.723076763963771e-08, -5.199761573325442e-10, -3.512245323483037e-12, -1.958056349788064e-14, -7.148627737268461e-17,  1.424399922678814e-19,
  6.196624166269098e-21,  7.779394681487396e-23,  7.080523402773557e-25,  1.990017292105712e+00, -1.458828763155196e-04, -1.589676069405932e-06, -1.527884301661407e-08,
 -1.363213425326381e-10, -1.153486776048833e-12, -9.348426133959416e-15, -7.286921760480353e-17, -5.465188117990632e-19, -3.932296268427288e-21, -2.695129912751594e-23,
 -1.734920217287623e-25,  2.548479849682167e-03, -2.893313609018127e-05,  2.460785483276824e-07, -1.857847587973386e-09,  1.312479459231108e-11, -8.882261971488016e-14,
  5.828288898625586e-16, -3.735389968652854e-18,  2.348076622597735e-20, -1.452278499691631e-22,  8.850280939469136e-25, -5.323238624192645e-27,  2.289706596528697e-02,
 -2.579601355476056e-04,  2.158395997120330e-06, -1.584039054450951e-08,  1.070744083118069e-10, -6.792912362168168e-13,  4.067805202989255e-15, -2.295014689225452e-17,
  1.206423866627018e-19, -5.762671696698054e-22,  2.343089891892199e-24, -6.422310234643745e-27,  6.338284949622491e-02, -7.030186012616861e-04,  5.687432353925539e-06,
 -3.929553093425419e-08,  2.403595675439839e-10, -1.295694165716616e-12,  5.869589557705518e-15, -1.866333428985855e-17, -6.436954679381806e-21,  7.606347641716281e-22,
 -8.242727623402808e-24,  6.306033763106634e-26,  1.235732022634909e-01, -1.338167695457032e-03,  1.026512855531004e-05, -6.408125057807755e-08,  3.235810894496771e-10,
 -1.143836267813763e-12,  2.801233090205411e-16,  3.974218406309256e-17, -4.299422324709066e-19,  2.973964230888228e-21, -1.406712402109542e-23,  2.473529682803107e-26,
  2.027943249079764e-01, -2.124686199684428e-03,  1.509921412366619e-05, -8.013351577476040e-08,  2.681232928423488e-10,  2.646989257033073e-13, -1.268232213678694e-14,
  1.131619970494862e-16, -5.832389557312625e-19,  8.253297199737410e-22,  1.869692006378966e-23, -2.351352393929924e-25,  3.001008469092742e-01, -3.011488954427918e-03,
  1.925007092029696e-05, -7.788617752108116e-08,  2.891020375521883e-11,  2.624109031813119e-12, -2.413687260444605e-14,  1.005390002221128e-16,  2.095703886374521e-19,
 -6.911791068742061e-21,  5.512797168256902e-23, -1.701333830819906e-25,  4.142345834670950e-01, -3.936018514530468e-03,  2.174014563539805e-05, -5.114062137757444e-08,
 -3.589492760565039e-10,  4.697012024294709e-12, -2.042569718520398e-14, -6.272397725094542e-17,  1.552096344815563e-18, -9.607373459678708e-21, -4.140016609719006e-24,
  5.788492619723640e-25,  5.435724036258508e-01, -4.825940030138738e-03,  2.169808691230331e-05,  9.644869555942349e-11, -7.668111491904335e-10,  4.773779069189902e-12,
  5.509704735690287e-15, -2.836570258206986e-16,  1.653760550664896e-18,  4.573545245900299e-21, -1.305369280595619e-22,  6.657627146939609e-25,  6.860640364314832e-01,
 -5.602083004241924e-03,  1.853415135995279e-05,  6.758928697758818e-08, -9.997619359660737e-10,  1.732987489893317e-12,  4.218363852266027e-14, -3.155828220184932e-16,
 -7.751461573289180e-19,  2.348569588837100e-20, -8.150720786973295e-23, -1.068625719559367e-24,  8.391623888091394e-01, -6.183175517478667e-03,  1.213172117639062e-05,
  1.347517497345847e-07, -8.732991314928477e-10, -3.735221491818607e-12,  5.953419856862672e-14,  1.283601875464374e-17, -3.734911100310482e-18,  1.272310509582592e-20,
  2.034015667423387e-22, -1.642029330366504e-24,  9.997520067945984e-01, -6.492944810609390e-03,  3.020093047532013e-06,  1.796229568084972e-07, -3.256552001504124e-10,
 -8.672640262522089e-12,  3.032735728783248e-14,  4.898043430557053e-16, -2.714519558495268e-18, -2.922896110214944e-20,  2.379370238933125e-22,  1.741484767562668e-24,
  1.164086147474503e+00, -6.469998183234791e-03, -7.533279313693165e-06,  1.816540933508399e-07,  4.846920203104209e-10, -9.176688850164043e-12, -3.607595513740093e-14,
  5.606962931883600e-16,  2.890761410901596e-18, -3.770281417868354e-20, -2.424576684867526e-22,  2.675252387578890e-24,  1.327749795388470e+00, -6.080370486971243e-03,
 -1.759924727711125e-05,  1.314631605822671e-07,  1.180937732494149e-09, -3.529498827688375e-12, -8.326452653502288e-14, -3.168257113041931e-17,  5.747088726576022e-18,
  2.113985697167978e-20, -3.678916062744485e-22, -2.887929188000305e-24,  1.485674351557202e+00, -5.331519956152975e-03, -2.492458833110324e-05,  3.991638593848411e-08,
  1.342315482451727e-09,  5.021728222384200e-12, -5.564177343058285e-14, -6.550001420296961e-16,  1.854400734059680e-19,  5.008445048161701e-20,  2.836946372624132e-22,
 -2.291389292354143e-24,  1.632237477320785e+00, -4.284780079595563e-03, -2.756869299234120e-05, -6.005242108518607e-08,  8.144320283486757e-10,  9.575045776841121e-12,
  2.541798195534046e-14, -4.384362303198382e-16, -5.467463184628043e-18, -1.346055053979290e-20,  3.083530464109077e-22,  3.746922679696225e-24,  1.761483841708923e+00,
 -3.061169835678438e-03, -2.472872282720381e-05, -1.253506334132119e-07, -7.022933614222210e-11,  6.084048902574194e-12,  6.605071429937028e-14,  2.881453610712543e-16,
 -1.546576706171139e-18, -3.784016720898466e-20, -2.988683886995779e-22, -3.741439655116683e-25,  1.867491747505834e+00, -1.834188935437175e-03, -1.741883326348606e-05,
 -1.275508965717767e-07, -6.669404790600841e-10, -1.161379226323070e-12,  2.457783441917373e-14,  3.752288051652338e-16,  3.090869098432580e-18,  1.354147232956728e-20,
 -4.629898195339543e-23, -1.609986856413799e-24,  1.944879871103048e+00, -8.047634260211896e-04, -8.510233309936708e-06, -7.613854688323280e-08, -5.950789100110200e-10,
 -4.005453986235910e-12, -2.148017330752823e-14, -6.269293671959862e-17,  4.297281791190778e-19,  1.000818308902370e-20,  1.148027338580839e-22,  9.852108809857705e-25,
  1.989407109828143e+00, -1.593725848350480e-04, -1.786911808384912e-06, -1.765746374949183e-08, -1.618107644525105e-10, -1.404447901284357e-12, -1.165646053041630e-14,
 -9.284671942116973e-17, -7.094644114754311e-19, -5.178398683878048e-21, -3.575867344194301e-23, -2.291084095663244e-25,  2.436548233610418e-03, -2.705024468686223e-05,
  2.249881028750518e-07, -1.661336577681732e-09,  1.148016843037532e-11, -7.600950839187353e-14,  4.880175647695523e-16, -3.061257048408776e-18,  1.883715980417980e-20,
 -1.140971185601777e-22,  6.810234574257750e-25, -4.014819368189443e-27,  2.189859568676824e-02, -2.414251811916252e-04,  1.978158725368617e-06, -1.423079306746771e-08,
  9.441498143520666e-11, -5.889574538789228e-13,  3.476255851938953e-15, -1.940399064965706e-17,  1.015148140278039e-19, -4.882814826082163e-22,  2.055289039235220e-24,
 -6.553008011560026e-27,  6.065887731155675e-02, -6.593418707234673e-04,  5.238129650380931e-06, -3.564961276626664e-08,  2.158120364859580e-10, -1.161095017448837e-12,
  5.347825201233319e-15, -1.848971162922601e-17,  1.563245925829839e-20,  4.812788488723568e-22, -5.844463792134977e-24,  4.665455550063657e-26,  1.183800253315439e-01,
 -1.259036287474831e-03,  9.526464553394493e-06, -5.908625006442671e-08,  3.008541000376208e-10, -1.125219504674291e-12,  1.215624821209917e-15,  2.759082869968709e-17,
 -3.327066164521698e-19,  2.437169040890094e-21, -1.268960687089144e-23,  3.621196747053279e-26,  1.945311807488134e-01, -2.007665665823151e-03,  1.416347575473649e-05,
 -7.581668925177493e-08,  2.706193996328987e-10, -3.731229616086260e-15, -9.769692392023879e-15,  9.509912620765850e-17, -5.423646963676832e-19,  1.387405909219779e-21,
  9.905628314246019e-24, -1.666881623045455e-25,  2.883569889852880e-01, -2.861215271055524e-03,  1.831984476932641e-05, -7.703426333072143e-08,  7.583055242357204e-11,
  2.079147921416862e-12, -2.126235493498323e-14,  1.036740701493662e-16, -1.504417137609391e-21, -4.870905941939795e-21,  4.664133008254904e-23, -2.081886418513757e-25,
  3.988343364070785e-01, -3.764642769633442e-03,  2.109501140071448e-05, -5.615942323347858e-08, -2.700258118394118e-10,  4.191012853490434e-12, -2.153858336635306e-14,
 -1.857685258088303e-17,  1.208786739280575e-18, -9.329250434588311e-21,  1.647381159385948e-23,  3.633049147685346e-25,  5.246155353801450e-01, -4.652551988077185e-03,
  2.162879727757175e-05, -1.140413160714105e-08, -6.706251482603511e-10,  4.816800787885972e-12, -1.673896703109967e-15, -2.290505080229459e-16,  1.731813153297066e-18,
 -2.775354438702057e-23, -9.894507429042961e-23,  7.465365174798511e-25,  6.639570076182020e-01, -5.450834466399661e-03,  1.925055930428598e-05,  5.192233645595935e-08,
 -9.557051142916834e-10,  2.637312691745922e-12,  3.312218759970544e-14, -3.275712174961357e-16,  1.800311738620348e-21,  1.944708239310149e-20, -1.164614671971904e-22,
 -5.261675511040795e-25,  8.146336932137149e-01, -6.079896374966706e-03,  1.366269144471322e-05,  1.202588459502069e-07, -9.337540507976278e-10, -2.315117510174354e-12,
  5.829957216435453e-14, -9.792943142241862e-17, -3.148685346273893e-18,  1.932678321670733e-20,  1.252754282205749e-22, -1.849572616219364e-24,  9.738420583050494e-01,
 -6.460263645604945e-03,  5.138722080057368e-06,  1.730688725999955e-07, -4.907731680178309e-10, -7.790928350426902e-12,  4.268146282634540e-14,  3.880725528346743e-16,
 -3.579738761888095e-18, -1.848413140603768e-20,  2.914948928182036e-22,  6.732674878061709e-25,  1.138099595363442e+00, -6.521427412029667e-03, -5.313093757749618e-06,
  1.878993616331675e-07,  2.938201493745824e-10, -9.844979888299198e-12, -1.929737679932533e-14,  6.298583716142564e-16,  1.389656302711162e-18, -4.479161899322077e-20,
 -1.067057836923132e-22,  3.396820912910965e-24,  1.303157162202744e+00, -6.214539088623048e-03, -1.591100041292445e-05,  1.496849477738128e-07,  1.090402410471519e-09,
 -5.517115491968094e-12, -8.148413002768125e-14,  1.613311795773059e-16,  6.215571933735666e-18,  4.217282841810990e-21, -4.687049913638687e-22, -1.582406559313576e-24,
  1.463953036845904e+00, -5.528628435668265e-03, -2.431366706453776e-05,  6.211815182555359e-08,  1.427921283924110e-09,  3.468655010599020e-12, -7.361332555997093e-14,
 -6.182559675963995e-16,  2.163658822319557e-18,  5.889130084442623e-20,  1.438329693874291e-22, -4.043147218901452e-24,  1.614653026105069e+00, -4.507975867008020e-03,
 -2.820472194643220e-05, -4.546089069776820e-08,  1.010935146141303e-09,  1.001763785310933e-11,  1.063835770007168e-14, -6.184410197517511e-16, -5.689695754906596e-18,
  2.226256936104703e-21,  4.759687748538826e-22,  3.738106822123073e-24,  1.748833962098147e+00, -3.265025730591614e-03, -2.623537075773073e-05, -1.254120992397827e-07,
  6.792278120920215e-11,  7.759148799203691e-12,  7.320458120825949e-14,  2.145381457553799e-16, -3.125083195066506e-18, -4.979682355493635e-20, -2.896178920353050e-22,
  9.112117733927411e-25,  1.859866338416095e+00, -1.979844990892744e-03, -1.901412274506605e-05, -1.383719365449707e-07, -6.833587492142651e-10, -4.338237971691571e-13,
  3.653880786504756e-14,  4.814245215997620e-16,  3.525497596816107e-18,  9.998818324698022e-21, -1.381273160178638e-22, -2.611086608048167e-24,  1.941518630366514e+00,
 -8.766680773184425e-04, -9.483759333284153e-06, -8.632925651565826e-08, -6.804758529693755e-10, -4.540122273294589e-12, -2.298205546794249e-14, -4.220019231441808e-17,
  8.839940692606240e-19,  1.556323507224136e-20,  1.654270844918871e-22,  1.324899000765857e-24,  1.988739621852796e+00, -1.745616881881181e-04, -2.015313910524540e-06,
 -2.048728003205958e-08, -1.929218763767716e-10, -1.718147508248108e-12, -1.460412220429514e-14, -1.188292617497237e-16, -9.242384348871965e-19, -6.829895258780770e-21,
 -4.732613139393355e-23, -2.991262737199315e-25,  2.331825064028129e-03, -2.532707295361890e-05,  2.061059784409977e-07, -1.489206993756197e-09,  1.007049612847062e-11,
 -6.526116959991301e-14,  4.101594964455958e-16, -2.519257138009079e-18,  1.518025676804709e-20, -9.008273731714493e-23,  5.267480232373668e-25, -3.045086920213747e-27,
  2.096349907242812e-02, -2.262581752364484e-04,  1.816078529280446e-06, -1.281003184388604e-08,  8.342795571747494e-11, -5.116956655352450e-13,  2.975890047170161e-15,
 -1.642145976210858e-17,  8.534765898572461e-20, -4.117590574594229e-22,  1.773383434381901e-24, -6.206597764228955e-27,  5.810269113349849e-02, -6.190910344860290e-04,
  4.830308041101226e-06, -3.237559663634484e-08,  1.938320340264150e-10, -1.038888737687643e-12,  4.839421683367101e-15, -1.775360147266900e-17,  2.920882180650040e-20,
  2.846107708938643e-22, -4.080221337107943e-24,  3.410925393853610e-26,  1.134919263469912e-01, -1.185580577550782e-03,  8.845574703936883e-06, -5.445079238520621e-08,
  2.786981497990754e-10, -1.087899411038397e-12,  1.851625526506370e-15,  1.825327669415387e-17, -2.537067760256676e-19,  1.962926297516426e-21, -1.099750188894003e-23,
  3.970095984244178e-26,  1.867214754406357e-01, -1.897923536479358e-03,  1.327961360640651e-05, -7.149924485847083e-08,  2.684058026833538e-10, -2.081631824713652e-13,
 -7.341920339471564e-15,  7.860576916680768e-17, -4.868962712075336e-19,  1.654025392462762e-21,  3.822899885151120e-24, -1.120928206686840e-25,  2.771994238779608e-01,
 -2.718330546567539e-03,  1.740399846008550e-05, -7.551505200823740e-08,  1.125450082289382e-10,  1.603530850451769e-12, -1.838405396403795e-14,  1.011622420743349e-16,
 -1.455105126613942e-19, -3.191063136855205e-21,  3.733890736881231e-23, -2.100661801234865e-25,  3.841089218731022e-01, -3.598645590471381e-03,  2.039785063099545e-05,
 -5.983746261576912e-08, -1.913956552813608e-10,  3.671910933388721e-12, -2.156661747774294e-14,  1.488575612564710e-17,  8.881392109594855e-19, -8.405779827597260e-21,
  2.841323985034978e-23,  1.867727033759873e-25,  5.063502735725671e-01, -4.480244121227221e-03,  2.143073401464433e-05, -2.136769677788496e-08, -5.751780883928113e-10,
  4.705901889804183e-12, -7.316683029487004e-15, -1.743481977092710e-16,  1.667463066864520e-18, -3.332999210129322e-21, -6.660505637199033e-23,  7.077939182141370e-25,
  6.424652634280891e-01, -5.294593397734157e-03,  1.978375168221008e-05,  3.709310559081029e-08, -8.957498084379229e-10,  3.322801561306521e-12,  2.404961890701543e-14,
 -3.172476260079235e-16,  6.137983829756546e-19,  1.447076633624434e-20, -1.289499253163464e-22, -5.954997481997502e-26,  7.905414878637789e-01, -5.965079430400771e-03,
  1.501487246521967e-05,  1.050232563903225e-07, -9.663426089339168e-10, -9.595441872415815e-13,  5.425750839035848e-14, -1.867467489790526e-16, -2.382242878203483e-18,
  2.272466035058016e-20,  4.551043950409766e-23, -1.728712925110581e-24,  9.480961729170171e-01, -6.410991516624037e-03,  7.163482119269493e-06,  1.640290644950256e-07,
 -6.355372461138895e-10, -6.649658525100790e-12,  5.186001938159568e-14,  2.651629672126071e-16, -4.031092173688093e-18, -6.553562080231233e-21,  2.972538689457501e-22,
 -3.914088582441762e-25,  1.111943249494995e+00, -6.554848171439687e-03, -3.036657323266706e-06,  1.910061908065538e-07,  9.373726362017094e-11, -1.009297158041590e-11,
 -1.285342095121270e-15,  6.480010829851684e-16, -2.629309287691214e-19, -4.600142687443618e-20,  4.668384986793924e-23,  3.461085851631259e-24,  1.278056212697557e+00,
 -6.334354692057008e-03, -1.401408272215493e-05,  1.661443332935544e-07,  9.609860800410574e-10, -7.396043730816404e-12, -7.418589556512675e-14,  3.589342489691845e-16,
  6.017778909789199e-18, -1.540857590698586e-20, -4.991156092129881e-22,  2.608322879985680e-25,  1.441454779862248e+00, -5.719763086165557e-03, -2.342920611758012e-05,
  8.541816576142897e-08,  1.478273844106517e-09,  1.504014512450327e-12, -8.963068855926327e-14, -5.143625323988763e-16,  4.340301020027409e-18,  6.064114784493668e-20,
 -6.626406785644407e-23, -5.396982457883827e-24,  1.596166800408756e+00, -4.735505504761441e-03, -2.864656325651951e-05, -2.767548929186730e-08,  1.212332973592217e-09,
  1.004480151440923e-11, -9.186917985640932e-15, -7.952438796452055e-16, -5.228996775302851e-18,  2.434300449678732e-20,  6.225995727830696e-22,  2.735735317984656e-24,
  1.735344604348328e+00, -3.480897579086970e-03, -2.772836006394443e-05, -1.229865950400390e-07,  2.410957153086702e-10,  9.575109398256227e-12,  7.752677812285191e-14,
  8.372647617526380e-17, -5.111792236738045e-18, -6.003744180718514e-20, -2.076298772311603e-22,  2.940007195842556e-24,  1.851631953361093e+00, -2.138786025543512e-03,
 -2.074030732392370e-05, -1.493226253796988e-07, -6.821069024466751e-10,  6.179029597389284e-13,  5.164322473783382e-14,  5.986878228180964e-16,  3.755119868569905e-18,
  1.821791292249356e-21, -2.798810354526823e-22, -3.865813582253003e-24,  1.937853386235890e+00, -9.568741431557989e-04, -1.058813059411303e-05, -9.797359546255696e-08,
 -7.768708091263467e-10, -5.102108048710732e-12, -2.367360580908977e-14, -3.550329777154005e-18,  1.578418486503597e-18,  2.345530564399870e-20,  2.318937259623010e-22,
  1.696646592095231e-24,  1.988007495356018e+00, -1.917228048456362e-04, -2.280880678557390e-06, -2.386917185559142e-08, -2.310776065858520e-10, -2.112156034545654e-12,
 -1.838512456822510e-14, -1.527314191436815e-16, -1.207576430693062e-18, -9.009972716846474e-21, -6.228985331832231e-23, -3.830816981962727e-25,  2.233705028660977e-03,
 -2.374706372413912e-05,  1.891608590515030e-07, -1.338009027612006e-09,  8.858268822692045e-12, -5.621177762929053e-14,  3.459610671802000e-16, -2.081558194300857e-18,
  1.228635194290278e-20, -7.146440479108578e-23,  4.094235638150254e-25, -2.322552446912853e-27,  2.008658110726606e-02, -2.123224894466155e-04,  1.670041667760802e-06,
 -1.155332624889775e-08,  7.387255074262387e-11, -4.454965180910966e-13,  2.552191043393939e-15, -1.391434227971411e-17,  7.173677645515120e-20, -3.461270359964546e-22,
  1.512413690876976e-24, -5.632781478287166e-27,  5.570122377906851e-02, -5.819514154248090e-04,  4.459743074892933e-06, -2.943436268741312e-08,  1.741760374603026e-10,
 -9.285937978798446e-13,  4.356738232710524e-15, -1.668372961928011e-17,  3.685121777851652e-20,  1.484349657314235e-22, -2.797373730403838e-24,  2.465142447569163e-26,
  1.088870998325048e-01, -1.117355449178661e-03,  8.218210462187840e-06, -5.016311330137802e-08,  2.574214751608488e-10, -1.038182357106633e-12,  2.259094489348342e-15,
  1.118382137693576e-17, -1.905389807714015e-19,  1.557873357597518e-21, -9.263777242603568e-24,  3.855013533576697e-26,  1.793369237465075e-01, -1.795045960022720e-03,
  1.244722319518718e-05, -6.724691462427579e-08,  2.626498935118373e-10, -3.596624983877585e-13, -5.349978253444730e-15,  6.399847294357173e-17, -4.256668454099091e-19,
  1.721369669842685e-21, -1.550768114345061e-25, -7.078904019886715e-26,  2.665988727634426e-01, -2.582690382785364e-03,  1.650960543876891e-05, -7.348078741038966e-08,
  1.404297546168529e-10,  1.195681617659087e-12, -1.563201832511392e-14,  9.493827786655723e-17, -2.356932778559855e-19, -1.877845875573016e-21,  2.846197122040751e-23,
 -1.910175820664791e-25,  3.700360911076956e-01, -3.438381643728948e-03,  1.966375997916694e-05, -6.234021422997075e-08, -1.230842231907757e-10,  3.162253821899234e-12,
 -2.079577774526233e-14,  3.869734140902807e-17,  6.075828956590150e-19, -7.146661228530973e-21,  3.359211769386212e-23,  5.621021922047429e-26,  4.887703533615657e-01,
 -4.309973263816780e-03,  2.112217526895423e-05, -2.982869574942274e-08, -4.831808473371730e-10,  4.477622275333511e-12, -1.147276840707729e-14, -1.233641084684039e-16,
  1.506769699443055e-18, -5.403161410295200e-21, -3.771183258520239e-23,  5.974082054394340e-25,  6.216059118696525e-01, -5.134781319561127e-03,  2.014516345893887e-05,
  2.332114315749442e-08, -8.242280026490680e-10,  3.796062471857060e-12,  1.551288930700224e-14, -2.902647588649458e-16,  1.042289955869865e-18,  9.370377723484184e-21,
 -1.235956916780015e-22,  2.799373089648011e-25,  7.669290174381816e-01, -5.840183187821361e-03,  1.618197332658484e-05,  8.947707633556518e-08, -9.729765097769489e-10,
  2.720397996850133e-13,  4.808600867064748e-14, -2.496813883707833e-16, -1.548916269823991e-18,  2.311466992290021e-20, -2.343078722461755e-23, -1.376542996281048e-24,
  9.225790319685679e-01, -6.345992787367641e-03,  9.066655861312533e-06,  1.528664087681801e-07, -7.555585852724567e-10, -5.330636829390772e-12,  5.745926891158865e-14,
  1.346376694203114e-16, -4.059652339671330e-18,  4.721049491849136e-21,  2.602825417938528e-22, -1.239791194987736e-24,  1.085689802554824e+00, -6.569962958047533e-03,
 -7.422342745844768e-07,  1.908955679381583e-07, -1.069723203232763e-10, -9.908552236990917e-12,  1.649619709438555e-14,  6.137417685933163e-16, -1.849783202822403e-18,
 -4.121966770783041e-20,  1.880374093236236e-22,  2.864321053813975e-24,  1.252507549002921e+00, -6.438242889583995e-03, -1.193328054704235e-05,  1.802438058083142e-07,
  7.961844405833381e-10, -9.034792131203194e-12, -6.155033057806611e-14,  5.388324360713431e-16,  5.111847011014273e-18, -3.455371770875455e-20, -4.436359711813931e-22,
  2.244385670531157e-24,  1.418207921686792e+00, -5.902693068988230e-03, -2.226167243389154e-05,  1.091897223631317e-07,  1.485765761818015e-09, -8.022661916647160e-13,
 -1.017666034713687e-13, -3.415337565151277e-16,  6.416384955732697e-18,  5.303068674328953e-20, -3.174600360267613e-22, -5.829979919474588e-24,  1.576764815560597e+00,
 -4.965661528390752e-03, -2.885571587776841e-05, -6.690872012842697e-09,  1.409126890060170e-09,  9.539192325980348e-12, -3.362911703782067e-14, -9.435404710813100e-16,
 -3.880370535204699e-18,  5.108668845518019e-20,  6.982200799797564e-22,  4.897678191151827e-25,  1.720968125889487e+00, -3.708547024636611e-03, -2.917440564994478e-05,
 -1.174955127329916e-07,  4.512900316812216e-10,  1.144335261087470e-11,  7.724636796972439e-14, -1.157380311255980e-16, -7.384669983402325e-18, -6.500152723035314e-20,
 -2.089276845836874e-23,  5.635690655114705e-24,  1.842733355718252e+00, -2.312060097207938e-03, -2.259701897299651e-05, -1.600641848296156e-07, -6.559265216522877e-10,
  2.072052648544409e-12,  7.008118833898888e-14,  7.173838061914903e-16,  3.574573230903387e-18, -1.317324018348369e-20, -4.796586385406699e-22, -5.203194973038530e-24,
  1.933848724785180e+00, -1.046501184832020e-03, -1.184186054799093e-05, -1.112506565421241e-07, -8.845696342149143e-10, -5.664911984502471e-12, -2.292530355971465e-14,
  6.241177505598663e-17,  2.608702275208529e-18,  3.432569848495871e-20,  3.139373697199772e-22,  2.010937453175608e-24,  1.987202202816753e+00, -2.111817974197481e-04,
 -2.590970043501331e-06, -2.792986930583793e-08, -2.781034563613808e-10, -2.609401123442005e-12, -2.325498776127012e-14, -1.970790563348189e-16, -1.581090136357328e-18,
 -1.186551287355363e-20, -8.115676085579048e-23, -4.747326525979833e-25,  2.141644951325855e-03, -2.229567444209147e-05,  1.739194538078258e-07, -1.204838524143417e-09,
  7.812562868136327e-12, -4.856595706411708e-14,  2.928163865907938e-16, -1.726587130203526e-18,  9.985364032683887e-21, -5.696073904682270e-23,  3.196935301828399e-25,
 -1.781703072981119e-27,  1.926316126411041e-02, -1.994972786024122e-04,  1.538209919379328e-06, -1.043944476386605e-08,  6.554488174410925e-11, -3.886708597986884e-13,
  2.192934786832328e-15, -1.180693224275169e-17,  6.030713509318900e-20, -2.903974183769415e-22,  1.278828848283657e-24, -4.980356170122324e-27,  5.344260206324521e-02,
 -5.476403196833637e-04,  4.122656725113339e-06, -2.679059628471449e-08,  1.566126469577041e-10, -8.295003440150921e-13,  3.906764124494074e-15, -1.543860277689882e-17,
  4.042158384543313e-20,  5.600312808639374e-23, -1.875547047016837e-24,  1.759478182587020e-26,  1.045454538005996e-01, -1.053949134696036e-03,  7.640290168718724e-06,
 -4.620743830325606e-08,  2.372220256636717e-10, -9.808459689238783e-13,  2.494820314153438e-15,  5.915657031692243e-18, -1.407249619964174e-19,  1.220309952962478e-21,
 -7.640734129217159e-24,  3.495475252247614e-26,  1.723508847952859e-01, -1.698625174689269e-03,  1.166521623357875e-05, -6.310845639442985e-08,  2.543100848096551e-10,
 -4.680406239420696e-13, -3.739444627590543e-15,  5.136193912595960e-17, -3.644716158137290e-19,  1.662409426726407e-21, -2.576001535504194e-24, -4.096844907798280e-26,
  2.565267365392191e-01, -2.454100730753721e-03,  1.564204279753655e-05, -7.106209867645168e-08,  1.608023802047438e-10,  8.515051650019069e-13, -1.308802638866305e-14,
  8.651821468216402e-17, -2.847559267033236e-19, -8.993794618771466e-22,  2.067257795408425e-23, -1.621314308807613e-25,  3.565924056894564e-01, -3.284092740664150e-03,
  1.890586166442668e-05, -6.383031391081844e-08, -6.473198807061468e-11,  2.678126114253565e-12, -1.947686462250063e-14,  5.428591671952322e-17,  3.748197911258223e-19,
 -5.782104402953826e-21,  3.400169860157361e-23, -3.096628626542046e-26,  4.718659714323519e-01, -4.142552360903873e-03,  2.072074935015878e-05, -3.685920902881088e-08,
 -3.966342941570205e-10,  4.166085061936589e-12, -1.428296212631879e-14, -7.850181404607624e-17,  1.291072301313161e-18, -6.426369954567219e-21, -1.447918939128534e-23,
  4.563785954901982e-25,  6.013905728665561e-01, -4.972718899025437e-03,  2.034845483716004e-05,  1.075840206710753e-08, -7.452213013300075e-10,  4.074890037380086e-12,
  7.896492729187085e-15, -2.524398962846003e-16,  1.294247660898875e-18,  4.741739445499269e-21, -1.063777711943740e-22,  4.804601122830848e-25,  7.438336239384490e-01,
 -5.706696342446308e-03,  1.716266844327576e-05,  7.401321473033706e-08, -9.565870650497557e-10,  1.337369809549029e-12,  4.052417443705834e-14, -2.862241843248110e-16,
 -7.470574501716062e-19,  2.109863623725143e-20, -7.397475308442843e-23, -9.120036410211597e-25,  8.973514449625504e-01, -6.266335075264566e-03,  1.082524650218049e-05,
  1.400005167377989e-07, -8.481506869504669e-10, -3.920829790211144e-12,  5.944960283087735e-14,  9.339778796371300e-18, -3.717083427389522e-18,  1.386587302060059e-20,
  1.932891161200518e-22, -1.743210309109257e-24,  1.059412522314060e+00, -6.566781834238127e-03,  1.531788871136890e-06,  1.876258589745238e-07, -2.998324907952466e-10,
 -9.314428524354135e-12,  3.264087757538663e-14,  5.324873521430270e-16, -3.170550889330637e-18, -3.147111881229473e-20,  2.914188110018689e-22,  1.774482970190926e-24,
  1.226577630489905e+00, -6.524855096688821e-03, -9.700129340255905e-06,  1.914623748465244e-07,  6.020288145261052e-10, -1.031373439034444e-11, -4.438306038428931e-14,
  6.793088980322809e-16,  3.577122697788330e-18, -4.980114795581176e-20, -3.067722281579193e-22,  3.879944304333464e-24,  1.394249828893477e+00, -6.075143309481275e-03,
 -2.080972944195645e-05,  1.326980959667086e-07,  1.444648890790158e-09, -3.334554282535537e-12, -1.081883517136409e-13, -1.086089665136445e-16,  8.036329777422486e-18,
  3.535700854332046e-20, -5.598651830149942e-22, -4.955873554648738e-24,  1.556440529293595e+00, -5.196430965628294e-03, -2.879460144268608e-05,  1.732836534170203e-08,
  1.589635195873925e-09,  8.402924615448670e-12, -6.147176566104395e-14, -1.032908272810134e-15, -1.541687485005311e-18,  7.851432571001585e-20,  6.482308467485362e-22,
 -2.924246158499912e-24,  1.705658414684694e+00, -3.947441262749123e-03, -3.053315328574843e-05, -1.083448164333946e-07,  6.982865587721559e-10,  1.322951948875180e-11,
  7.034749752305738e-14, -3.891125895618453e-16, -9.672088239503176e-18, -6.000790218619051e-20,  2.920322514504682e-22,  8.567338826551904e-24,  1.833111151214759e+00,
 -2.500693963802595e-03, -2.457907535399002e-05, -1.701290398435014e-07, -5.959745338926083e-10,  4.007385717937122e-12,  9.166895176044712e-14,  8.200105482451373e-16,
  2.696648570962066e-18, -3.727776659928056e-20, -7.329153168699559e-22, -6.199534136846678e-24,  1.929464443959784e+00, -1.146825504867223e-03, -1.326562072407979e-05,
 -1.263392718232487e-07, -1.003174470585498e-09, -6.183483038831096e-12, -1.980500677048938e-14,  1.682617047038722e-16,  4.092243351452871e-18,  4.869803426961097e-20,
  4.051234144408623e-22,  2.065769667531995e-24,  1.986313785155291e+00, -2.333300086913055e-04, -2.954652226314352e-06, -3.282933762626417e-08, -3.363509584158607e-10,
 -3.239874749462412e-12, -2.955045705508385e-14, -2.551774171407381e-16, -2.071950208220210e-18, -1.555501744657060e-20, -1.039052300165983e-22, -5.545805800439949e-25,
  2.055156302817023e-03, -2.096009746225072e-05,  1.601805374787407e-07, -1.087242049745100e-09,  6.907782635707921e-12, -4.208420014014949e-14,  2.486538650297303e-16,
 -1.437542340887899e-18,  8.147244872549578e-21, -4.561287441530025e-23,  2.506538044187487e-25, -1.375580263846257e-27,  1.848901452368803e-02, -1.876754371319000e-04,
  1.418981333108956e-06, -9.450163005546646e-09,  5.827207805495968e-11, -3.397988007602404e-13,  1.887854610667359e-15, -1.003491735927374e-17,  5.072252681734723e-20,
 -2.434348246483186e-22,  1.073992454813313e-24, -4.337025824134073e-27,  5.131602572454975e-02, -5.159036443255098e-04,  3.815673020533073e-06, -2.441256389478770e-08,
  1.409260102498882e-10, -7.407778302880928e-13,  3.492800244326371e-15, -1.412592062375173e-17,  4.125859284368943e-20, -5.190810292845457e-24, -1.222222091308424e-24,
  1.235984370145240e-26,  1.004484792937698e-01, -9.949817154994577e-04,  7.107937536258134e-06, -4.256552034019574e-08,  2.182148148120420e-10, -9.194529255511121e-13,
  2.603614738613186e-15,  2.059300022111063e-18, -1.019364985156385e-19,  9.441096475557053e-22, -6.203439881658513e-24,  3.027673073077127e-26,  1.657383279936401e-01,
 -1.608264219153120e-03,  1.093200510323924e-05, -5.911879181794008e-08,  2.441617150633856e-10, -5.417931050713621e-13, -2.455756832444103e-15,  4.063339210778329e-17,
 -3.068524513567389e-19,  1.529958984924440e-21, -3.897265927529121e-24, -2.044247940682693e-26,  2.469552689012153e-01, -2.332330443443601e-03,  1.480524355669280e-05,
 -6.836928175465157e-08,  1.748821517074504e-10,  5.654084278921695e-13, -1.079689476287333e-14,  7.703417310742010e-17, -3.038845352604209e-19, -2.059152090235358e-22,
  1.422961006193905e-23, -1.307624780370923e-25,  3.437536577148342e-01, -3.135923401116988e-03,  1.813537038519545e-05, -6.446238455863084e-08, -1.571457047636276e-11,
  2.230093742054131e-12, -1.781838182528497e-14,  6.320839857892686e-17,  1.906542477533609e-19, -4.466684501064998e-21,  3.139673736674372e-23, -8.226782853082549e-26,
  4.556243485631613e-01, -3.978657284598749e-03,  2.024304938864614e-05, -4.255807522277211e-08, -3.168953370631309e-10,  3.801369041034763e-12, -1.593797404075502e-14,
 -4.096414400607724e-17,  1.053749553359108e-18, -6.646421405181284e-21,  2.439703019266780e-24,  3.142890532688365e-25,  5.818258122576437e-01, -4.809611308074142e-03,
  2.040873083931303e-05, -5.051766108179709e-10, -6.623761233062432e-10,  4.184395487634986e-12,  1.428055412676983e-15, -2.090706104378287e-16,  1.393748435854287e-18,
  9.402548443340016e-22, -8.313553638897542e-23,  5.579762609790841e-25,  7.212867020345122e-01, -5.566100189846730e-03,  1.796004095690706e-05,  5.897187970093186e-08,
 -9.207740864190199e-10,  2.211756930837773e-12,  3.228491682255245e-14, -2.986183181936120e-16, -4.915342658563679e-20,  1.747790217534845e-20, -1.036370638883707e-22,
 -4.430015865611021e-25,  8.724696157314339e-01, -6.173249231953457e-03,  1.242149327926035e-05,  1.258801487589825e-07, -9.123455209864027e-10, -2.503831346476217e-12,
  5.813065286458396e-14, -1.002823593638892e-16, -3.097863823940834e-18,  1.999884224889621e-20,  1.124114779080627e-22, -1.874352759713960e-24,  1.033184029740517e+00,
 -6.545616893587944e-03,  3.748518938869831e-06,  1.813856446887083e-07, -4.771429590292792e-10, -8.364559478112342e-12,  4.597660879813797e-14,  4.152823242636316e-16,
 -4.078307149825101e-18, -1.863151531569011e-20,  3.410308787053133e-22,  4.708585821226826e-25,  1.200337769251062e+00, -6.593118205494327e-03, -7.351762432107764e-06,
  1.993934406212998e-07,  3.867024037544629e-10, -1.113947777507624e-11, -2.404423264343669e-14,  7.630774578359778e-16,  1.607586410571764e-18, -5.833661158023585e-20,
 -1.136830379735547e-22,  4.743839619963903e-24,  1.369626931944238e+00, -6.234864679968886e-03, -1.908132532718918e-05,  1.551373742426636e-07,  1.351900854240086e-09,
 -5.937496364732248e-12, -1.074709052045045e-13,  1.642025938755555e-16,  8.858513435445162e-18,  9.167380159228247e-21, -7.332960297659024e-22, -2.721417820492474e-24,
  1.535196035307247e+00, -5.425511432308733e-03, -2.842879683929317e-05,  4.401693879478617e-08,  1.740580727982470e-09,  6.577753426259699e-12, -9.062507343503950e-14,
 -1.032334808167528e-15,  1.709949301856018e-18,  1.007019925928349e-19,  4.317999104086005e-22, -6.936745194307686e-24,  1.689372180354256e+00, -4.196696422458924e-03,
 -3.175723863284590e-05, -9.496813343881122e-08,  9.786889730561795e-10,  1.475024695699824e-11,  5.481506153381596e-14, -7.301455500888516e-16, -1.152425898729279e-17,
 -4.003349380514311e-20,  7.232544018409581e-22,  1.081946960053554e-23,  1.822701960549759e+00, -2.705647958366655e-03, -2.667478358957382e-05, -1.788959503962812e-07,
 -4.919221339081337e-10,  6.491259536989521e-12,  1.155921331102864e-13,  8.786329797415890e-16,  7.603142014787292e-19, -7.212757386327373e-20, -1.008717618633152e-21,
 -6.062378756929170e-24,  1.924654892413087e+00, -1.259297176736055e-03, -1.488215642503258e-05, -1.434033564137750e-07, -1.131131944424541e-09, -6.585733697508363e-12,
 -1.297349796735881e-14,  3.305634304523341e-16,  6.158067693455639e-18,  6.661032874465668e-20,  4.861850692354988e-22,  1.463528722478034e-24,  1.985330559673021e+00,
 -2.586397097617471e-04, -3.383164085509321e-06, -3.877043771611738e-08, -4.088603300735429e-10, -4.042864802615156e-12, -3.771384203539601e-14, -3.312902715155378e-16,
 -2.712750684437488e-18, -2.021207284695385e-20, -1.291054920494937e-22, -5.746662282152477e-25,  1.973798741996971e-03, -1.972902379117713e-05,  1.477700185981550e-07,
 -9.831399291064810e-10,  6.122661274498029e-12, -3.657151207435300e-14,  2.118189276918725e-16, -1.201280977602461e-18,  6.671952779223330e-21, -3.670108386024610e-23,
  1.971524842732726e-25, -1.070862659194895e-27,  1.776031997920735e-02, -1.767618452475764e-04,  1.310956950319745e-06, -8.569808135850026e-09,  5.190734254441896e-11,
 -2.976864199094811e-13,  1.628340150662270e-15, -8.544086311634333e-18,  4.268777746928688e-20, -2.041149485261506e-22,  8.962291910362362e-25, -3.757208616583815e-27,
  4.931165922826346e-02, -4.865128284014687e-04,  3.535776630006699e-06, -2.227184937208622e-08,  1.269174572748367e-10, -6.615482277568536e-13,  3.115668741762080e-15,
 -1.281708261274275e-17,  4.031144262499421e-20, -4.443221965142493e-23, -7.681808894753832e-25,  8.463187169855756e-27,  9.657912643258548e-02, -9.401033811949715e-04,
  6.617504111582737e-06, -3.921778729883551e-08,  2.004535165756689e-10, -8.566130938224342e-13,  2.620390335111735e-15, -7.042329605569938e-19, -7.210727668659956e-20,
  7.211526741383482e-22, -4.980805991439002e-24,  2.528445925847669e-26,  1.594757828188864e-01, -1.523580310837011e-03,  1.024565217980458e-05, -5.530172607245651e-08,
  2.328231053167519e-10, -5.881382493654613e-13, -1.447434964496853e-15,  3.166379488135263e-17, -2.547560448643892e-19,  1.360454483130578e-21, -4.481296843152039e-24,
 -7.144136845782424e-27,  2.378577031358785e-01, -2.217121881059042e-03,  1.400193038178431e-05, -6.549406758512727e-08,  1.837680844013130e-10,  3.310643984818391e-13,
 -8.776471940730412e-15,  6.729039640591700e-17, -3.023573364803608e-19,  2.570975773391216e-22,  9.135364906089220e-24, -1.013727727473425e-25,  3.314952291435530e-01,
 -2.993935665040751e-03,  1.736171143880219e-05, -6.437962552945691e-08,  2.475721278569272e-11,  1.824239905880989e-12, -1.598562300539553e-14,  6.697126311502161e-17,
  5.150313736394642e-20, -3.292076570366964e-21,  2.715543237668098e-23, -1.068827317310700e-25,  4.400302595592709e-01, -3.818836231245037e-03,  1.970437120848954e-05,
 -4.704128893303119e-08, -2.447672179176899e-10,  3.408684283303418e-12, -1.664858126482395e-14, -1.102894709385662e-17,  8.192144077326017e-19, -6.310763118508112e-21,
  1.342885240901216e-23,  1.888649423363166e-25,  5.629136223620819e-01, -4.646539513275394e-03,  2.034184312563856e-05, -1.043372861722868e-08, -5.787935530292288e-10,
  4.153470410711491e-12, -3.800730323497148e-15, -1.645226782565529e-16,  1.373677308566890e-18, -1.893044000841434e-21, -5.864410866224436e-23,  5.427682103877529e-25,
  6.993137949757543e-01, -5.419836041230870e-03,  1.858089757239746e-05,  4.463263607278785e-08, -8.694663923870405e-10,  2.886633417338576e-12,  2.399028578789462e-14,
 -2.909546225722805e-16,  5.018739634030450e-19,  1.306637801039508e-20, -1.140472884373905e-22, -4.658655000719113e-26,  8.479845748426889e-01, -6.068086515429225e-03,
  1.384305983499554e-05,  1.109566623490441e-07, -9.487532013384626e-10, -1.152900125306629e-12,  5.404839793553035e-14, -1.871865141562807e-16, -2.316569623819034e-18,
  2.288008908795650e-20,  3.299147260971319e-23, -1.692111762047048e-24,  1.007075124305994e+00, -6.507064320107778e-03,  5.874024695189167e-06,  1.724766624872495e-07,
 -6.325364027101417e-10, -7.136858212517137e-12,  5.569549201951358e-14,  2.766953894921088e-16, -4.501935748139555e-18, -4.949985275947305e-21,  3.341428257813618e-22,
 -7.477142800515702e-25,  1.173862948089647e+00, -6.642273336052743e-03, -4.929351285834803e-06,  2.037743529597530e-07,  1.598946186402216e-10, -1.145629399840775e-11,
 -2.277455538650165e-15,  7.804526097225667e-16, -5.236117105303867e-19, -5.867232831198616e-20,  9.599256785442319e-23,  4.620691353858430e-24,  1.344394468556082e+00,
 -6.379710896969515e-03, -1.709426139598552e-05,  1.756797878185031e-07,  1.207896410101803e-09, -8.429495925406484e-12, -9.889646540921103e-14,  4.471126640473311e-16,
  8.639759709257262e-18, -2.166423711392020e-20, -7.848545424358713e-22,  4.827486854176801e-25,  1.513043154654822e+00, -5.650346373781450e-03, -2.772956579647247e-05,
  7.279082325357744e-08,  1.848090996478737e-09,  4.065523225025542e-12, -1.181994199122808e-13, -9.169438121155784e-16,  5.562253241766704e-18,  1.107507574233791e-19,
  4.476618048757033e-23, -1.046658542678728e-23,  1.672070467183439e+00, -4.455023751364838e-03, -3.279295622113703e-05, -7.688530713343465e-08,  1.284973342969654e-09,
  1.577769919671604e-11,  2.903675654379090e-14, -1.115447311290987e-15, -1.232729113012112e-17, -1.322020773457975e-21,  1.213943429549848e-21,  1.101733749743245e-23,
  1.811438801481351e+00, -2.927756147898498e-03, -2.886396412540939e-05, -1.855689903815358e-07, -3.323591183789797e-10,  9.560750585492474e-12,  1.400857073541060e-13,
  8.531351985324776e-16, -2.622550180918533e-18, -1.173002399197176e-19, -1.232053119066111e-21, -3.585979105480668e-24,  1.919368242878430e+00, -1.385555560006168e-03,
 -1.671597712531156e-05, -1.625685250590472e-07, -1.265085558095736e-09, -6.761408160955513e-12, -5.710407189141489e-16,  5.698439735895162e-16,  8.917753815123342e-18,
  8.689843742804554e-20,  5.140487706358504e-22, -4.999388715927323e-25,  1.984238758128609e+00, -2.876836945380486e-04, -3.890496585704640e-06, -4.601157954959022e-08,
 -4.995739971552356e-10, -5.069829022005129e-12, -4.832205644063662e-14, -4.307853716175505e-16, -3.539230915547727e-18, -2.585653313511973e-20, -1.520767484122400e-22,
 -4.283880722303138e-25,  1.897174528501179e-03, -1.859244284435794e-05,  1.365368422204949e-07, -8.907635960270005e-10,  5.439462766340229e-12, -3.186853104626900e-14,
  1.809838080801192e-16, -1.007484069154783e-18,  5.481969738760719e-21, -2.968571000099002e-23,  1.552595664061593e-25, -8.450285404231172e-28,  1.707361595675813e-02,
 -1.666718607192712e-04,  1.212912546896957e-06, -7.784875773960702e-09,  4.632580760735584e-11, -2.613292604423223e-13,  1.407172688420814e-15, -7.289043063014591e-18,
  3.594644969114843e-20, -1.714237619251498e-22,  7.417732002176425e-25, -3.285382837787663e-27,  4.742053512327075e-02, -4.592621223354642e-04,  3.280274725064384e-06,
 -2.034307435708981e-08,  1.144059304255621e-10, -5.909346245755908e-13,  2.774571145337887e-15, -1.155796814016030e-17,  3.823996897984355e-20, -6.864174622956308e-23,
 -4.639555241963978e-25,  5.482696671199208e-27,  9.292168770715670e-02, -8.889925586394107e-04,  6.165579876507749e-06, -3.614418324081796e-08,  1.839473005956766e-10,
 -7.941984220321668e-13,  2.572008657680698e-15, -2.632645694410471e-18, -4.947723887999418e-20,  5.427004596464098e-22, -3.978094886019151e-24,  2.030069831421096e-26,
  1.535412772909770e-01, -1.444207153166992e-03,  9.603988984817554e-06, -5.167226052925228e-08,  2.207801960355449e-10, -6.131148461286163e-13, -6.678660287889902e-16,
  2.426017750753224e-17, -2.090573409321774e-19,  1.177548982755738e-21, -4.607854461612719e-24,  5.781550517009331e-28,  2.292083400891327e-01, -2.108199736365306e-03,
  1.323382644084289e-05, -6.251163138332026e-08,  1.884300280735084e-10,  1.419561871807770e-13, -7.025950924927973e-15,  5.782531895915316e-17, -2.875284473788833e-19,
  5.410149218746514e-22,  5.241909959069577e-24, -7.648866232876005e-26,  3.197923940106887e-01, -2.858122821005126e-03,  1.659267084714914e-05, -6.371183740600137e-08,
  5.755787655229799e-11,  1.463171289296346e-12, -1.410373061782390e-14,  6.692336613351719e-17, -4.862263318776269e-20, -2.302952223660990e-21,  2.225116939947047e-23,
 -1.138246539188854e-25,  4.250665220979968e-01, -3.663520780289890e-03,  1.911855733201528e-05, -5.043393903416435e-08, -1.805997720398849e-10,  3.008169037852561e-12,
 -1.662371383075270e-14,  1.166891197012987e-17,  6.034073115230358e-19, -5.639020261018130e-21,  1.942183024932355e-23,  8.774464128293347e-26,  5.446519268528315e-01,
 -4.484456745431407e-03,  2.016379537082860e-05, -1.903630419857817e-08, -4.969841087369786e-10,  4.011862461538972e-12, -7.805165333594037e-15, -1.220624710368394e-16,
  1.268895036026446e-18, -3.779920776800122e-21, -3.624778304204655e-23,  4.679742188823616e-25,  6.779348094014859e-01, -5.269278411651105e-03,  1.903501946643411e-05,
  3.121158649309919e-08, -8.066248317657149e-10,  3.366857468543209e-12,  1.613283893044285e-14, -2.682471865940867e-16,  8.905110274600702e-19,  8.555731032306968e-21,
 -1.094217594897209e-22,  2.365689271047313e-25,  8.239417843783581e-01, -5.952275481762637e-03,  1.508292165171602e-05,  9.566070330456952e-08, -9.593041678881963e-10,
  7.375673141524024e-14,  4.789418060431077e-14, -2.480228143291501e-16, -1.486159408092267e-18,  2.281359446373705e-20, -3.349580658798251e-23, -1.306894329789202e-24,
  9.811537030596992e-01, -6.451975656937068e-03,  7.878552571272714e-06,  1.612891496955289e-07, -7.613636048716104e-10, -5.723550115324336e-12,  6.141723515877692e-14,
  1.322793651800948e-16, -4.450206618519280e-18,  7.463763173774072e-21,  2.799640010850228e-22, -1.649430387280162e-24,  1.147230510437214e+00, -6.671900882259462e-03,
 -2.476259775685730e-06,  2.045040612031537e-07, -6.802572382779942e-11, -1.125252981184863e-11,  1.903062585982676e-14,  7.310268091792203e-16, -2.519860148091764e-18,
 -5.101544587404451e-20,  2.791836986877525e-22,  3.572983928349729e-24,  1.318615914362269e+00, -6.507717437806621e-03, -1.487611413382885e-05,  1.935332572818158e-07,
  1.016743010871438e-09, -1.062247497850769e-11, -8.266660307737898e-14,  7.051498673169920e-16,  7.309147638968794e-18, -5.161648857415969e-20, -6.879174160710882e-22,
  3.877909084513340e-24,  1.490004344711445e+00, -5.868181123381104e-03, -2.667649808837281e-05,  1.028483105412950e-07,  1.899073522850306e-09,  9.444303657752623e-13,
 -1.407855463892260e-13, -6.757581823098908e-16,  9.464062248662928e-18,  1.026535900933048e-19, -4.621129397465541e-22, -1.216235223795472e-23,  1.653720366885106e+00,
 -4.720684210993895e-03, -3.358171747289648e-05, -5.377485595803575e-08,  1.604737049108874e-09,  1.605552952514512e-11, -7.653408928258737e-15, -1.500397707289624e-15,
 -1.138973939086295e-17,  5.624545355462626e-20,  1.640096744787396e-21,  7.660138292544413e-24,  1.799251743297444e+00, -3.167649815527706e-03, -3.111577500278624e-05,
 -1.891664465442041e-07, -1.056554528152461e-10,  1.319572979463141e-11,  1.620945720373472e-13,  6.919136148746421e-16, -7.757176106649295e-18, -1.682185092349995e-19,
 -1.268457850975696e-21,  2.666457566662695e-24,  1.913545710483483e+00, -1.527441022239272e-03, -1.879269627811449e-05, -1.838864204672506e-07, -1.398978933581669e-09,
 -6.548368645335662e-12,  1.987778995322847e-14,  9.091304178476656e-16,  1.240145279521963e-17,  1.059402422927215e-19,  4.058754713289852e-22, -4.941033736848445e-24,
  1.983022075987010e+00, -3.211602440292238e-04, -4.494156628291403e-06, -5.488329086762123e-08, -6.136148388007479e-10, -6.388002986684253e-12, -6.211811109032229e-14,
 -5.601386239033043e-16, -4.583090624775209e-18, -3.219833326280990e-20, -1.611560928320246e-22,  1.080522055062431e-25,  1.824923675330217e-03, -1.754147217841516e-05,
  1.263495733639230e-07, -8.086044006998020e-10,  4.843341692658596e-12, -2.784455785098570e-14,  1.550776575024693e-16, -8.480309549315885e-19,  4.516587948650535e-21,
 -2.416740331291238e-23,  1.218173541284493e-25, -6.855095996453563e-28,  1.642576074408716e-02, -1.573300193957445e-04,  1.123774597596772e-06, -7.083707704956935e-09,
  4.142106058725607e-11, -2.298817564107190e-13,  1.218294968587422e-15, -6.232046510202025e-18,  3.027540786391019e-20, -1.445396188067239e-22,  6.046569421399648e-25,
 -2.981786400816482e-27,  4.563446773247914e-02, -4.339661489417534e-04,  3.046762210313087e-06, -1.860361854396831e-08,  1.032276260453437e-10, -5.280925191703788e-13,
  2.467685026881446e-15, -1.037698216599973e-17,  3.548606327608813e-20, -8.312740763590111e-23, -2.783795675918161e-25,  2.996311378437275e-27,  8.946168886416878e-02,
 -8.413539922854211e-04,  5.748995235935659e-06, -3.332477234035830e-08,  1.686737915031027e-10, -7.335166968538182e-13,  2.478856603802644e-15, -3.932373426233835e-18,
 -3.260235321684350e-20,  3.999705287247796e-22, -3.195135497568277e-24,  1.524916587421555e-26,  1.479142689553859e-01, -1.369796394080161e-03,  9.004709879806678e-06,
 -4.823852881974054e-08,  2.084088880798425e-10, -6.217102615681150e-13, -7.611877686469722e-17,  1.821316839298565e-17, -1.699652245498182e-19,  9.949867324399609e-22,
 -4.497255975191293e-24,  3.739382419041308e-27,  2.209826040526128e-01, -2.005278271269853e-03,  1.250184162005716e-05, -5.948266774918420e-08,  1.897087792186260e-10,
 -8.257743679305858e-15, -5.532474549709039e-15,  4.897028762302847e-17, -2.650331083735224e-19,  6.894079128208626e-22,  2.315016511598536e-24, -5.766273372448930e-26,
  3.086205682483222e-01, -2.728421859000456e-03,  1.583456220449185e-05, -6.257456221503459e-08,  8.358697703464258e-11,  1.146921479673181e-12, -1.226295488422393e-14,
  6.420293380176300e-17, -1.167130114322172e-19, -1.512748574722756e-21,  1.727842539840099e-23, -1.112781810964300e-25,  4.107144394162855e-01, -3.513037841561799e-03,
  1.849792805138348e-05, -5.286375766856975e-08, -1.243891169712176e-10,  2.615120524687283e-12, -1.605607081992484e-14,  2.788587414414038e-17,  4.150928941731698e-19,
 -4.809188517562278e-21,  2.151053109315694e-23,  1.087022706315127e-26,  5.270350909458558e-01, -4.324189278278070e-03,  1.989026112614543e-05, -2.635741106638665e-08,
 -4.188737906350175e-10,  3.787979053004072e-12, -1.067667683441361e-14, -8.387637094182243e-17,  1.111413715834117e-18, -4.847796187130058e-21, -1.792260827521170e-23,
  3.616415639502592e-25,  6.571643253071696e-01, -5.115714259852812e-03,  1.933440596072223e-05,  1.886283117431995e-08, -7.360064442799005e-10,  3.667389603114995e-12,
  9.061283121666908e-15, -2.356435921281247e-16,  1.122766965115349e-18,  4.442938918103465e-21, -9.505318999872352e-23,  3.966516894056084e-25,  8.003809116825996e-01,
 -5.827280819736013e-03,  1.613900121238788e-05,  8.038364345284614e-08, -9.469215409422469e-10,  1.135254436700853e-12,  4.040475383151373e-14, -2.828023282963671e-16,
 -7.016215599819201e-19,  2.045862541008917e-20, -8.085895878865697e-23, -8.426980994028748e-25,  9.554838120765337e-01, -6.381420622461886e-03,  9.737416097204369e-06,
  1.482726257696625e-07, -8.608763035550342e-10, -4.220860726010957e-12,  6.318229145445344e-14, -3.819628170067623e-18, -3.999044767337961e-18,  1.703952285733000e-20,
  1.953847073216117e-22, -2.121933701337974e-24,  1.120518780632813e+00, -6.681930177329539e-03, -3.606922000224791e-08,  2.016468353123998e-07, -2.869049895910501e-10,
 -1.056089439334917e-11,  3.811140005598087e-14,  6.234423750142781e-16, -4.121637371744305e-18, -3.716334375806896e-20,  4.012333149886945e-22,  1.906661872905350e-24,
  1.292362103614951e+00, -6.617177011764687e-03, -1.246344829920528e-05,  2.080009169588142e-07,  7.861814518703516e-10, -1.234501080264921e-11, -5.996292363332571e-14,
  9.043877387964626e-16,  5.004785768869665e-18, -7.485575893197273e-20, -4.546364846956909e-22,  6.530197565229522e-24,  1.466113342318721e+00, -6.076139627675707e-03,
 -2.525999466094317e-05,  1.331952361619133e-07,  1.882831786062380e-09, -2.623994219553051e-12, -1.549428011502842e-13, -3.183906245396535e-16,  1.269867849158597e-17,
  7.359741922241383e-20, -9.815847832234904e-22, -1.090612762676193e-23,  1.634296883895210e+00, -4.991458389647495e-03, -3.406243741677849e-05, -2.555515472946565e-08,
  1.920404702817594e-09,  1.532886672859586e-11, -5.436919864707154e-14, -1.819262861716455e-15, -8.120179470790089e-18,  1.266171435930499e-19,  1.821454441604118e-21,
 -1.619720634282176e-25,  1.786068902624906e+00, -3.425663282099248e-03, -3.338650479563808e-05, -1.885282383669216e-07,  1.985611412619567e-10,  1.728449551887653e-11,
  1.770148614526890e-13,  3.373934855840881e-16, -1.467232817571068e-17, -2.137137049804126e-19, -9.256368934251194e-22,  1.373544877218421e-23,  1.907120737823892e+00,
 -1.686999401626390e-03, -2.113784756987077e-05, -2.072823939066650e-07, -1.522866648939569e-09, -5.717366913470341e-12,  5.148192814637963e-14,  1.369585020262467e-15,
  1.643626742838293e-17,  1.156902315841092e-19,  2.035284021397233e-23, -1.338004506924610e-23,  1.981661108248376e+00, -3.599250620168890e-04, -5.216156930983691e-06,
 -6.580985560970053e-08, -7.576439937168390e-10, -8.084731663823736e-12, -8.003820484242914e-14, -7.265607481153801e-16, -5.854318882542636e-18, -3.822738943433774e-20,
 -1.303570168890283e-22,  1.486196520829275e-24,  1.756719731506140e-03, -1.656821226262973e-05,  1.170935376243932e-07, -7.353716310081139e-10,  4.321826951713294e-12,
 -2.439207219377455e-14,  1.332318015279680e-16, -7.165370748473457e-19,  3.727308423671167e-21, -1.986508950669694e-23,  9.399414026924799e-26, -5.900842164068578e-28,
  1.581389815593616e-02, -1.486689134419644e-04,  1.042599793574593e-06, -6.456220579418753e-09,  3.710222794168085e-11, -2.026318162981479e-13,  1.056610607231787e-15,
 -5.342074490586190e-18,  2.547606451638865e-20, -1.229434447442174e-22,  4.754091759659421e-25, -2.948784674715073e-27,  4.394597606392692e-02, -4.104577293106832e-04,
  2.833090257877344e-06, -1.703334998544512e-08,  9.323513624092066e-11, -4.722292633100871e-13,  2.192563360294968e-15, -9.291243187477422e-18,  3.231834594030016e-20,
 -9.233908352418857e-23, -2.002562209975996e-25,  5.085449398677268e-28,  8.618578746309083e-02, -7.969168343373981e-04,  5.364816894466188e-06, -3.074016131399227e-08,
  1.545889086013974e-10, -6.754508524347339e-13,  2.356140215201425e-15, -4.768713623474766e-18, -2.035655454750498e-20,  2.839975724480710e-22, -2.644317891148864e-24,
  9.632911011687991e-27,  1.425755713922430e-01, -1.300018422034619e-03,  8.445444584970697e-06, -4.500339676735163e-08,  1.959946814516506e-10, -6.180002178199558e-13,
  3.628447512908011e-16,  1.331300113615487e-17, -1.373437485247394e-19,  8.183601023042326e-22, -4.342788150061652e-24,  2.533814133513210e-27,  2.131570725260254e-01,
 -1.908067162750763e-03,  1.180623406354925e-05, -5.645541361332502e-08,  1.883220413855560e-10, -1.255180227577522e-13, -4.276210351897693e-15,  4.089948290314874e-17,
 -2.391222239140361e-19,  7.351981904550972e-22,  5.719589948111137e-26, -4.633534119075792e-26,  2.979555124094842e-01, -2.604724562262646e-03,  1.509239862761499e-05,
 -6.106905101933193e-08,  1.037255316523966e-10,  8.737149273340236e-13, -1.052485120258570e-14,  5.972067306452454e-17, -1.598983564494904e-19, -9.181009318888762e-22,
  1.248782551413861e-23, -1.067376579920544e-25,  3.969541945589373e-01, -3.367621870981739e-03,  1.785328054885541e-05, -5.445621088508322e-08, -7.586981826509054e-11,
  2.240491421277069e-12, -1.511414819808769e-14,  3.856463802120336e-17,  2.573970099277253e-19, -3.957420421474705e-21,  2.065472596390628e-23, -4.737431333238496e-26,
  5.100544214726609e-01, -4.166440615073773e-03,  1.953621326501008e-05, -3.246796576145098e-08, -3.458467734637159e-10,  3.507409749239323e-12, -1.255435443669953e-14,
 -5.121275868346038e-17,  9.275098463217405e-19, -5.281034190777443e-21, -4.608853471667282e-24,  2.423831966097448e-25,  6.370119771447554e-01, -4.960328149659112e-03,
  1.949255611805812e-05,  7.683157673265040e-09, -6.609968672611294e-10,  3.809866503928415e-12,  2.985280567454626e-15, -1.978541563032875e-16,  1.218689548382374e-18,
  1.011291423462444e-21, -7.619062416971971e-23,  4.434404383767541e-25,  7.773357606518505e-01, -5.694565903436664e-03,  1.701361295591930e-05,  6.546449786680682e-08,
 -9.151710176446217e-10,  2.008066454328133e-12,  3.227785340319315e-14, -2.941587536169399e-16, -3.104522802845704e-20,  1.661582285328899e-20, -1.081083289172999e-22,
 -4.083112365939023e-25,  9.301248586015298e-01, -6.296644247640226e-03,  1.143152388642193e-05,  1.339053681319772e-07, -9.302105783179708e-10, -2.719613527319055e-12,
  6.138566747513337e-14, -1.206517501453230e-16, -3.267900169389512e-18,  2.294324349795333e-20,  9.939200834219022e-23, -2.179995251668016e-24,  1.093805677081207e+00,
 -6.672633422505691e-03,  2.349356256198993e-06,  1.954219619597252e-07, -4.876440304715770e-10, -9.452769992361564e-12,  5.354303871398594e-14,  4.733728074973720e-16,
 -5.155390969482477e-18, -1.998354687135086e-20,  4.441926874323238e-22,  5.097602964733657e-26,  1.265710065032704e+00, -6.706705941258637e-03, -9.900340629979689e-06,
  2.185353291641605e-07,  5.270238381634439e-10, -1.346475037669109e-11, -3.282465891999500e-14,  1.018506366703626e-15,  2.056336452458681e-18, -8.683007121155214e-20,
 -1.356945803061355e-22,  7.676156034648261e-24,  1.441415462812524e+00, -6.271319396121102e-03, -2.348329252065791e-05,  1.626964838131631e-07,  1.792690162683101e-09,
 -6.401527198491515e-12, -1.578295875964251e-13,  1.219043194146168e-16,  1.453542950603140e-17,  2.583926679951260e-20, -1.373465302286931e-21, -6.409577868700858e-24,
  1.613784876613262e+00, -5.264639434996627e-03, -3.417490149223504e-05,  7.535252957625174e-09,  2.209675284258918e-09,  1.338808182409730e-11, -1.081618927668234e-13,
 -1.992317475412542e-15, -2.281122162965889e-18,  1.961132703349183e-19,  1.568057656844084e-21, -1.182765219065968e-23,  1.771817850062826e+00, -3.701722883426066e-03,
 -3.561762003344574e-05, -1.823527492694868e-07,  5.871946405256157e-10,  2.158583066161240e-11,  1.786891817633642e-13, -2.609332826084733e-16, -2.284838993912138e-17,
 -2.343790462677061e-19,  4.229541474291593e-24,  2.903494184602669e-23,  1.900018185589643e+00, -1.866474141818507e-03, -2.377494919065528e-05, -2.324817497463385e-07,
 -1.621428696803271e-09, -3.958364938396052e-12,  9.781329414526912e-14,  1.960977237334645e-15,  2.044121624209141e-17,  1.010568291391581e-19, -8.537876543534541e-22,
 -2.736232567313690e-23,  1.980132639905345e+00, -4.050322725207363e-04, -6.084302878300314e-06, -7.933740071952456e-08, -9.403105561485323e-10, -1.027224587135166e-11,
 -1.032177602826539e-13, -9.367547251058377e-16, -7.302095367882078e-18, -4.138931097085592e-20, -5.345259457888219e-24,  4.586237624575643e-24,  1.692266102895187e-03,
 -1.566562224311224e-05,  1.086684193703328e-07, -6.699579842293609e-10,  3.864402976463758e-12, -2.142242355673777e-14,  1.147359714511903e-16, -6.080297753908727e-19,
  3.073710422592053e-21, -1.661168727631237e-23,  6.886809266600323e-26, -5.636521789309599e-28,  1.523542727825893e-02, -1.406282211698699e-04,  9.685575515483352e-07,
 -5.893677453041900e-09,  3.329152153644281e-11, -1.789799420292579e-13,  9.178051066318520e-16, -4.594243397792119e-18,  2.136049272483454e-20, -1.065978647515680e-22,
  3.391883488289952e-25, -3.317437681420515e-27,  4.234821493502981e-02, -3.885859477337321e-04,  2.637337984495536e-06, -1.561437177510747e-08,  8.429628437225779e-11,
 -4.226158638892630e-13,  1.946376422293348e-15, -8.311794731600428e-18,  2.884782106307504e-20, -1.007383883073276e-22, -2.417161985209362e-25, -2.516543537317052e-27,
  8.308167897719421e-02, -7.554327856960446e-04,  5.010339521715754e-06, -2.837178511442216e-08,  1.416342068285785e-10, -6.205706488472377e-13,  2.214892197968083e-15,
 -5.276238900749108e-18, -1.195173166265268e-20,  1.847762260172986e-22, -2.367301568147110e-24,  2.687843783549075e-27,  1.375072785873927e-01, -1.234562653538530e-03,
  7.923813291220104e-06, -4.196577060779760e-08,  1.837494982066969e-10, -6.052893830834094e-13,  6.782696142000157e-16,  9.355991114096274e-18, -1.109948873917593e-19,
  6.454721086338182e-22, -4.345341590078094e-24, -3.466844436366335e-27,  2.057094850293776e-01, -1.816276151645022e-03,  1.114674813866608e-05, -5.346754589377466e-08,
  1.848737852796103e-10, -2.152451363603777e-13, -3.234192157476283e-15,  3.366759496482736e-17, -2.130915333462795e-19,  6.980834920675525e-22, -1.895976864115071e-24,
 -4.400681966338774e-26,  2.877734927631955e-01, -2.486887232686766e-03,  1.437006138892631e-05, -5.928281475109674e-08,  1.188062064433394e-10,  6.405791325229476e-13,
 -8.928641257565895e-15,  5.416235788787451e-17, -1.850852607688070e-19, -5.120237468360899e-22,  7.815953919684141e-24, -1.068013210948881e-25,  3.837651960886978e-01,
 -3.227426881919011e-03,  1.719393843774285e-05, -5.533097594939724e-08, -3.459564879745757e-11,  1.891514274326929e-12, -1.393933317773015e-14,  4.467635979697303e-17,
  1.291647980849685e-19, -3.187552676952227e-21,  1.748824654205761e-23, -9.559115797961495e-26,  4.936986449462473e-01, -4.011798218913592e-03,  1.911565705464299e-05,
 -3.745712891894071e-08, -2.788111893108924e-10,  3.192075167711241e-12, -1.360151168697848e-14, -2.459119936103451e-17,  7.363156626573271e-19, -5.288232300755414e-21,
  3.351440238066718e-24,  1.192366656759054e-25,  6.174828831970077e-01, -4.804192893034330e-03,  1.952382047740981e-05, -2.281124813120666e-09, -5.845089590100954e-10,
  3.819454572337964e-12, -2.007163836790654e-15, -1.588239664591906e-16,  1.204880107409074e-18, -1.654027986319438e-21, -5.742491233988664e-23,  3.958560019261560e-25,
  7.548343430732662e-01, -5.555560318577155e-03,  1.771278453646521e-05,  5.118234690631729e-08, -8.679285016623700e-10,  2.684307456888637e-12,  2.411130331843608e-14,
 -2.864447063487295e-16,  4.859377601519920e-19,  1.203813074281118e-20, -1.183867717785838e-22, -8.078103725802133e-26,  9.051310007973302e-01, -6.199021236440252e-03,
  1.294754880825065e-05,  1.186655564304012e-07, -9.702016736927845e-10, -1.297927200257953e-12,  5.667196588898753e-14, -2.114266114605205e-16, -2.393027399373976e-18,
  2.505580535196572e-20,  8.045294757768228e-24, -1.934033105594383e-24,  1.067167379558774e+00, -6.644604851066671e-03,  4.641604800234230e-06,  1.861811982036061e-07,
 -6.628742110714331e-10, -8.027868292656592e-12,  6.440403214522839e-14,  3.002923464539593e-16, -5.559125526347365e-18, -2.680881038260387e-21,  4.089609402800680e-22,
 -1.589395380767604e-24,  1.238741619605285e+00, -6.775296315973010e-03, -7.236321043950102e-06,  2.247803398892581e-07,  2.521869734613778e-10, -1.390579775482313e-11,
 -3.858812411566903e-15,  1.033906602482921e-15, -1.086228809863165e-18, -8.557066666368159e-20,  1.937030355492150e-22,  6.998923351708602e-24,  1.415967491372110e+00,
 -6.450899751163827e-03, -2.136372267574111e-05,  1.901515856189606e-07,  1.627330863422449e-09, -1.009544854171052e-11, -1.478428013857546e-13,  5.908775669027165e-16,
  1.442580558306426e-17, -3.284440594732067e-20, -1.510789801473270e-21,  4.130442928751268e-25,  1.592180967204168e+00, -5.537056584043245e-03, -3.386402236221635e-05,
  4.487207979211911e-08,  2.446946026154264e-09,  1.012145608478413e-11, -1.638280697856292e-13, -1.941492596814389e-15,  5.747871340809496e-18,  2.446244202590610e-19,
  7.644981826388696e-22, -2.451871308303385e-23,  1.756427488424736e+00, -3.995222753114373e-03, -3.773449149037269e-05, -1.692749612399705e-07,  1.060745005189212e-09,
  2.569634968065757e-11,  1.598946438616689e-13, -1.124262783853402e-15, -3.093112255600635e-17, -2.038512321147181e-19,  1.637377179633169e-21,  4.472269818385163e-23,
  1.892153591824616e+00, -2.068278977751748e-03, -2.672253240147183e-05, -2.589103601866161e-07, -1.672278101365668e-09, -8.749803217822269e-13,  1.623630509372234e-13,
  2.664039475119359e-15,  2.312533759951908e-17,  3.736006423899991e-20, -2.476144078492313e-21, -4.723501213357161e-23,  1.978408749504030e+00, -4.577871897927867e-04,
 -7.133862723193388e-06, -9.616993542524356e-08, -1.172794568937776e-09, -1.309199296062871e-11, -1.329398079387417e-13, -1.193819540408445e-15, -8.733450459582894e-18,
 -3.598531602797804e-20,  3.223699581783741e-22,  1.106111829482192e-23,  1.631292834016429e-03, -1.482741337177347e-05,  1.009862367407287e-07, -6.114111040479151e-10,
  3.462167288949071e-12, -1.886247847911853e-14,  9.900176558283305e-17, -5.187565490157434e-19,  2.519243754535933e-21, -1.435958915841176e-23,  4.349490494221600e-26,
 -5.955442694335170e-28,  1.468797582972285e-02, -1.331538664668919e-04,  9.009150419687693e-07, -5.388495473442346e-09,  2.992216063294921e-11, -1.584225052429287e-13,
  7.981758433115925e-16, -3.969786609287953e-18,  1.773021116492857e-20, -9.615107800870796e-23,  1.777095470618220e-25, -4.053299968037352e-27,  4.083491340274454e-02,
 -3.682144313854135e-04,  2.457787049734147e-06, -1.433078898370054e-08,  7.629277091006273e-11, -3.785947032417812e-13,  1.726009935184101e-15, -7.448834413613151e-18,
  2.501104458819703e-20, -1.136678677709601e-22, -4.312041868404247e-25, -6.117829016641833e-27,  8.013801017833043e-02, -7.166743154586532e-04,  4.683074624316268e-06,
 -2.620209182455251e-08,  1.297422018289401e-10, -5.692237736884210e-13,  2.062673494463155e-15, -5.570448451974393e-18, -6.997276124002055e-21,  9.007230011383507e-23,
 -2.427892354031780e-24, -5.489238205228166e-27,  1.326926889418831e-01, -1.173137438214200e-03,  7.437467596333932e-06, -3.912165836293660e-08,  1.718257270798576e-10,
 -5.862483955223746e-13,  8.937632707839368e-16,  6.141941313740801e-18, -9.094806416098362e-20,  4.658433955355800e-22, -4.709444373929032e-24, -1.342793950852538e-26,
  1.986187353870697e-01, -1.729618676105705e-03,  1.052273059133681e-05, -5.054791499357522e-08,  1.798651486128774e-10, -2.823013723922092e-13, -2.383313082277098e-15,
  2.723227099280957e-17, -1.898030195288572e-19,  5.822422458996043e-22, -3.938871455652731e-24, -4.971342562934879e-26,  2.780514061338298e-01, -2.374739100848096e-03,
  1.367045945482721e-05, -5.729056234901543e-08,  1.295942313898985e-10,  4.438059224147280e-13, -7.497407985231706e-15,  4.799576103410444e-17, -1.990374046167485e-19,
 -2.950194469449089e-22,  2.984145847404310e-24, -1.134796849694623e-25,  3.711263767815683e-01, -3.092537912130313e-03,  1.652783624322189e-05, -5.559960852705752e-08,
 -7.496519962099222e-15,  1.572347172596413e-12, -1.264686931431938e-14,  4.709959179439600e-17,  2.587049621724047e-20, -2.585277101986275e-21,  1.231173463304615e-23,
 -1.384449950253979e-25,  4.779543550287412e-01, -3.860742005561325e-03,  1.864145442101902e-05, -4.142530074074427e-08, -2.182768037292157e-10,  2.859863993095042e-12,
 -1.398858249002486e-14, -4.041144349573867e-18,  5.492887725256358e-19, -5.085154116078011e-21,  5.930658140156120e-24, -2.750054547590109e-29,  5.985781025595721e-01,
 -4.648265028267881e-03,  1.944284253687044e-05, -1.102620724057696e-08, -5.089395714124041e-10,  3.722204577142206e-12, -5.926371906823360e-15, -1.216314961546714e-16,
  1.107920254755187e-18, -3.632705418430096e-21, -4.234236653461232e-23,  2.823472765220322e-25,  7.328990685456944e-01, -5.411633095161375e-03,  1.824551768789301e-05,
  3.775373067850798e-08, -8.090946351921096e-10,  3.168858132388747e-12,  1.636716624734392e-14, -2.648775144548839e-16,  8.338301914306525e-19,  7.297123369959177e-21,
 -1.172879266094925e-22,  1.087608713399233e-25,  8.805507206482112e-01, -6.090010297433367e-03,  1.427777302405442e-05,  1.030064037443669e-07, -9.830796504015891e-10,
 -1.666087228945892e-14,  4.981505728928329e-14, -2.736691214698066e-16, -1.504725846397092e-18,  2.378803433457235e-20, -6.845971256694426e-23, -1.527146737281567e-24,
  1.040677105673706e+00, -6.598727260941768e-03,  6.807123844262254e-06,  1.743772318225833e-07, -8.073974146412826e-10, -6.401355218525186e-12,  7.032882106778665e-14,
  1.238530242926971e-16, -5.381568655146212e-18,  1.189928459387990e-20,  3.116897343473830e-22, -2.734430029395851e-24,  1.211541805501014e+00, -6.822349954202805e-03,
 -4.523914496380779e-06,  2.265951082438634e-07, -2.454233359490156e-11, -1.365772305683953e-11,  2.415482876102151e-14,  9.519242445689190e-16, -3.958088944992403e-18,
 -7.223231895165318e-20,  4.567066395804679e-22,  4.744872309200834e-24,  1.389837127449659e+00, -6.612256188393444e-03, -1.893294977910751e-05,  2.143873662310035e-07,
  1.391543175053988e-09, -1.339448343716699e-11, -1.250955295926264e-13,  1.022087540266975e-15,  1.217981766372607e-17, -9.074389347322038e-20, -1.331536818921726e-21,
  7.604317762241421e-24,  1.569495284840914e+00, -5.805135427006638e-03, -3.308471180611301e-05,  8.541101414850235e-08,  2.605795641862163e-09,  5.566317524390023e-12,
 -2.142620100996882e-13, -1.613058171891759e-15,  1.481589194676331e-17,  2.505318299148326e-19, -5.352137162437167e-22, -3.350757432739276e-23,  1.739830441104494e+00,
 -4.304895009052470e-03, -3.964635878646159e-05, -1.479959194506987e-07,  1.609892034387847e-09,  2.903799222874643e-11,  1.135683672540759e-13, -2.214777137883952e-15,
 -3.658551416920142e-17, -9.574285721340646e-20,  3.827194502341454e-21,  5.265995839606211e-23,  1.883432596193130e+00, -2.294941616270553e-03, -2.998981414872484e-05,
 -2.855682107843400e-07, -1.644333928707754e-09,  4.000922734123654e-12,  2.473567222720702e-13,  3.401992433213261e-15,  2.212627687069693e-17, -1.098794319837501e-19,
 -5.048894068930744e-21, -6.944306320854466e-23,  1.976455671946392e+00, -5.198143334791515e-04, -8.409724932680263e-06, -1.172146684851158e-07, -1.469415445722707e-09,
 -1.671633311337476e-11, -1.704499679227658e-13, -1.490397392205332e-15, -9.651608569792315e-18, -1.018350207884468e-20,  1.060436333906229e-21,  2.386834395922392e-23,
  1.573553785772530e-03, -1.404795735743747e-05,  9.396962738706140e-08, -5.589101063589519e-10,  3.107546695536962e-12, -1.665209565314479e-14,  8.552958346668448e-17,
 -4.461279156937357e-19,  2.027220478001536e-21, -1.315115441382930e-23,  1.696112656454632e-26, -5.857536810945671e-28,  1.416937665979655e-02, -1.261972893093214e-04,
  8.390243357755776e-07, -4.934084362315012e-09,  2.693658717448897e-11, -1.405391790414796e-13,  6.944522855024679e-16, -3.456791367323508e-18,  1.435205716610201e-20,
 -9.278035038402021e-23, -1.127911564048194e-26, -4.297009641155073e-27,  3.940031968575449e-02, -3.492198224118885e-04,  2.292898916148538e-06, -1.316849842018921e-08,
  6.911867615619158e-11, -3.395867473735754e-13,  1.528005289837943e-15, -6.717864306506704e-18,  2.053549915224368e-20, -1.371516303883225e-22, -7.575746965890576e-25,
 -7.995120167040243e-27,  7.734429945347705e-02, -6.804329770029879e-04,  4.380737652915346e-06, -2.421465612704415e-08,  1.188400136806030e-10, -5.216142707218280e-13,
  1.903916624206694e-15, -5.761823192341182e-18, -5.579932567472404e-21, -1.386852407432354e-23, -2.805564293718353e-24, -1.023803486569628e-26,  1.281162302406338e-01,
 -1.115469683705871e-03,  6.984119963021225e-06, -3.646502826563357e-08,  1.603275535611169e-10, -5.630490887308776e-13,  1.027247310174940e-15,  3.462250889915665e-18,
 -7.773539275137386e-20,  2.630899861364806e-22, -5.471941077826963e-24, -1.900137177750889e-26,  1.918648512091298e-01, -1.647814656026011e-03,  9.933226958819825e-06,
 -4.771810153570894e-08,  1.737054196571128e-10, -3.310189985544098e-13, -1.702932283881834e-15,  2.145914989317685e-17, -1.722211970573459e-19,  3.793835192786677e-22,
 -6.216105933026668e-24, -5.070849101205127e-26,  2.687668735752385e-01, -2.268089509288867e-03,  1.299567621274319e-05, -5.515537846765749e-08,  1.367760672677236e-10,
  2.792657535629836e-13, -6.244184899378486e-15,  4.146980790490976e-17, -2.087260382361957e-19, -2.766883708559300e-22, -2.055554545789790e-24, -1.109062486392442e-25,
  3.590164479585463e-01, -2.962981720380246e-03,  1.586162577685456e-05, -5.536419544058094e-08,  2.851115010384116e-11,  1.284658414972666e-12, -1.132987656697776e-14,
  4.652087915709444e-17, -5.988852920267155e-20, -2.223494790723085e-21,  5.633271569858176e-24, -1.570107633204867e-25,  4.628064237178957e-01, -3.713653927490690e-03,
  1.812522463764421e-05, -4.447839736068168e-08, -1.644363958106128e-10,  2.524598867085891e-12, -1.388285665673653e-14,  1.065100702301232e-17,  3.702200794664046e-19,
 -4.877125154544832e-21,  3.861995350536898e-24, -8.192170342205540e-26,  5.802951018919288e-01, -4.493384375402924e-03,  1.926409847918423e-05, -1.858250315256762e-08,
 -4.361735180723317e-10,  3.542977742574584e-12, -8.857566737737205e-15, -8.857534657270505e-17,  9.493060916253022e-19, -5.115294077582645e-21, -3.263716209901227e-23,
  1.681679329669220e-25,  7.115470295493183e-01, -5.264071905288460e-03,  1.862304319907148e-05,  2.533411200595906e-08, -7.423735992373458e-10,  3.475897035893524e-12,
  9.357252401197808e-15, -2.348859147461385e-16,  1.013530849419942e-18,  2.733338746419133e-21, -1.101802301805949e-22,  2.109689866140415e-25,  8.564265752929957e-01,
 -5.971110820115172e-03,  1.541966631253555e-05,  8.733672913499018e-08, -9.721027770239698e-10,  1.082275874010899e-12,  4.160245616242118e-14, -3.087702390846886e-16,
 -7.125961585984252e-19,  1.984368921179655e-20, -1.251844339445800e-22, -1.034581598654581e-24,  1.014404041168161e+00, -6.536128904939200e-03,  8.818215040368788e-06,
  1.605271999793966e-07, -9.183633005688930e-10, -4.690832870832532e-12,  7.146589092540160e-14, -3.934490009201176e-17, -4.759634662195873e-18,  2.176640364080692e-20,
  1.781816847003482e-22, -3.209444353984157e-24,  1.184197207797428e+00, -6.847691891749238e-03, -1.816017251631628e-06,  2.240574684757832e-07, -2.898243475394645e-10,
 -1.277474059044431e-11,  4.867181098265095e-14,  7.875418708934049e-16, -6.187239605425207e-18, -5.066608900265974e-20,  5.991975192426096e-22,  1.688018845627148e-24,
  1.363101975177028e+00, -6.753072061346645e-03, -1.623605359949655e-05,  2.343562956319669e-07,  1.096162200882959e-09, -1.601268027644668e-11, -9.158058025980250e-14,
  1.350057814105964e-15,  8.051435595098794e-18, -1.355405029454408e-19, -8.691083954030556e-22,  1.296299681754130e-23,  1.545752888387014e+00, -6.064998042746910e-03,
 -3.180689393755419e-05,  1.277006698111317e-07,  2.662352165464117e-09, -5.627075627904054e-14, -2.514807404913656e-13, -1.001724059720086e-15,  2.308531035137607e-17,
  1.987876070533001e-19, -2.054064229218446e-21, -3.373905415592187e-23,  1.721965949101241e+00, -4.628686807398519e-03, -4.124817880368720e-05, -1.174669693090712e-07,
  2.212192154395065e-09,  3.088515770123506e-11,  3.488280255296604e-14, -3.406638917553156e-15, -3.672855659423035e-17,  1.022375739017804e-19,  5.994450846515800e-21,
  4.189402705178139e-23,  1.873750668953824e+00, -2.549006318967870e-03, -3.357071146577515e-05, -3.108810881294326e-07, -1.496841726040859e-09,  1.115535945538944e-11,
  3.516162909502351e-13,  4.001464841694072e-15,  1.375097423108725e-17, -3.780046789876024e-19, -8.451966219849459e-21, -8.203240378362061e-23,  1.974232351035714e+00,
 -5.931450439049438e-04, -9.969157880378878e-06, -1.436370131720862e-07, -1.848210880561769e-09, -2.134279507939397e-11, -2.164881986662650e-13, -1.794530062152002e-15,
 -8.948228247190183e-18,  5.928777531334631e-20,  2.587539548267922e-21,  4.793187777575544e-23,  1.518824154027699e-03, -1.332220737789329e-05,  8.755039018800264e-08,
 -5.117462847788947e-10,  2.794056105911091e-12, -1.474238817129772e-14,  7.387567963054798e-17, -3.887480501998985e-19,  1.560332778118928e-21, -1.291952654539195e-23,
 -2.594506423466762e-27, -1.911482911755244e-28,  1.367764697074544e-02, -1.197148118166761e-04,  7.823113255479725e-07, -4.524711684980883e-09,  2.428488721442838e-11,
 -1.249850071498436e-13,  6.035870753971259e-16, -3.051398448764081e-18,  1.096255520544389e-20, -9.647074549721770e-23, -1.498715393146121e-25, -9.785301147787810e-28,
  3.803915184985113e-02, -3.314904222658469e-04,  2.141294483397378e-06, -1.211500364109216e-08,  6.267878995556705e-11, -3.051023539707459e-13,  1.348317284964954e-15,
 -6.146210638438427e-18,  1.497711153033148e-20, -1.732621011749644e-22, -9.892377222350426e-25,  3.731090738152490e-28,  7.469086364328109e-02, -6.465178317875974e-04,
  4.101234046650341e-06, -2.239424671343242e-08,  1.088514913187662e-10, -4.778776775318280e-13,  1.739851575862017e-15, -5.970820341394768e-18, -8.191932296490766e-21,
 -1.329504440184214e-22, -3.038941999584749e-24,  5.419795850202533e-27,  1.237633865316390e-01, -1.061304283252215e-03,  6.561563873769743e-06, -3.398850773194076e-08,
  1.493195423205965e-10, -5.375057247215328e-13,  1.090478878430071e-15,  1.082559290785265e-18, -7.237429694281190e-20,  3.159078417205455e-23, -5.908171354898122e-24,
  8.786053079715300e-27,  1.854289636631786e-01, -1.570592577961892e-03,  9.377060326494746e-06, -4.499380525362076e-08,  1.667218337937102e-10, -3.652910484364833e-13,
 -1.177543596949710e-15,  1.611462927060648e-17, -1.635124460903057e-19,  9.418673471725921e-23, -7.704236957683638e-24, -2.506274017222530e-27,  2.598983075660676e-01,
 -2.166733981175414e-03,  1.234710115930191e-05, -5.293004019946734e-08,  1.409528889615757e-10,  1.425744213048617e-13, -5.178202441557806e-15,  3.460642589754239e-17,
 -2.212377148587728e-19, -4.434943905093628e-22, -5.760967025635712e-24, -3.671633734905698e-26,  3.474141128150844e-01, -2.838736581639966e-03,  1.520079371781361e-05,
 -5.471680780344341e-08,  5.158922893546170e-11,  1.028083103181686e-12, -1.006592109143971e-14,  4.335428682393258e-17, -1.374405139145184e-19, -2.122913841031584e-21,
  1.948098589542074e-26, -6.827229081399596e-26,  4.482383730122199e-01, -3.570828099793756e-03,  1.757730589990156e-05, -4.672342370598239e-08, -1.172459140396806e-10,
  2.196166415960761e-12, -1.344499401277209e-14,  1.971148394202247e-17,  1.965561607356299e-19, -4.791678814836297e-21,  8.941474427207340e-25, -1.130503463963222e-26,
  5.626282172058977e-01, -4.340276880576260e-03,  1.900153457428470e-05, -2.500673701400352e-08, -3.676236812437453e-10,  3.303888695558745e-12, -1.094178745710972e-14,
 -6.138210387593063e-17,  7.433599419883367e-19, -6.277998745716693e-21, -2.513150653538281e-23,  2.242700647520700e-25,  6.907903579927445e-01, -5.114068096131165e-03,
  1.885811234551453e-05,  1.402231049306474e-08, -6.711234216886004e-10,  3.625275357096838e-12,  3.243353886640239e-15, -2.017085209747384e-16,  1.035227457508394e-18,
 -1.442125970061113e-21, -9.697221038180298e-23,  4.412236095365212e-25,  8.327951135723609e-01, -5.843823755810128e-03,  1.637526710081634e-05,  7.200752069192984e-08,
 -9.411836092911091e-10,  1.975034789378660e-12,  3.273768595766186e-14, -3.211882478257661e-16, -9.769330392669090e-20,  1.410998583443973e-20, -1.562905626037403e-22,
 -3.107775100254556e-25,  9.884124557632710e-01, -6.458134201525577e-03,  1.065358273776721e-05,  1.451753709276863e-07, -9.952030968777538e-10, -3.005315819237508e-12,
  6.835793024030085e-14, -1.780148645322401e-16, -3.881465609755965e-18,  2.611926504941076e-20,  4.262533903440182e-23, -2.765779576554879e-24,  1.156794275991662e+00,
 -6.851563073238509e-03,  8.366429664366912e-07,  2.174468634056949e-07, -5.319739476560253e-10, -1.136589346978165e-11,  6.771045738388502e-14,  5.650852149578062e-16,
 -7.569797250686461e-18, -2.606722758044301e-20,  6.114671482832510e-22, -9.316070953479909e-25,  1.335848109092134e+00, -6.871438281249108e-03, -1.332946543769547e-05,
  2.492267574008949e-07,  7.571217387501667e-10, -1.773260054237866e-11, -5.094654367458541e-14,  1.524097132092595e-15,  2.692323209475329e-18, -1.579929978049027e-19,
 -2.367670054317184e-22,  1.527665030943721e-23,  1.520994710660446e+00, -6.312601659353876e-03, -3.002002175425751e-05,  1.699534142394640e-07,  2.599056651062948e-09,
 -6.338935370691855e-12, -2.682401954653465e-13, -1.671197184278209e-16,  2.842636371466230e-17,  8.945975769908554e-20, -3.327574754943151e-21, -2.210863688595582e-23,
  1.702783215061405e+00, -4.963661865634956e-03, -4.242497467594180e-05, -7.711954260089466e-08,  2.829875259823486e-09,  3.045003957384358e-11, -7.605575198471805e-14,
 -4.473679760817531e-15, -2.836592928281343e-17,  3.699039819696188e-19,  7.117144228279660e-21,  4.655797960405615e-24,  1.862993336886550e+00, -2.832881316709393e-03,
 -3.743602772522041e-05, -3.325483873713172e-07, -1.180076739456236e-09,  2.097328606674201e-11,  4.672663452782439e-13,  4.151564001735752e-15, -6.792384887163151e-18,
 -7.854159982684209e-19, -1.176103894206606e-20, -5.976654770689154e-23,  1.971688593020608e+00, -6.803299591455613e-04, -1.188527898362610e-05, -1.769231679952687e-07,
 -2.331249837023889e-09, -2.717103101188467e-11, -2.702536471034112e-13, -2.021999743929052e-15, -4.346075170039732e-18,  2.158682990915445e-19,  5.550457520754747e-21,
  9.049226885140333e-23,  1.466898282181756e-03, -1.264562989533377e-05,  8.166823635171946e-08, -4.693074401898409e-10,  2.516084157837888e-12, -1.309477960336760e-14,
  6.361969090666422e-17, -3.462774699422039e-19,  1.094202609102871e-21, -1.285537796242994e-23,  1.694979754337474e-26,  1.358981672654483e-27,  1.321096990779509e-02,
 -1.136670868889390e-04,  7.302661162012145e-07, -4.155392390782016e-09,  2.192331849930722e-11, -1.114877962756401e-13,  5.225290682589439e-16, -2.757245401941001e-18,
  7.396706140573461e-21, -1.003468365359910e-22,  5.549030178095826e-26,  1.284868229606665e-26,  3.674655360351504e-02, -3.149249905620082e-04,  2.001735773582509e-06,
 -1.115925878670812e-08,  5.688665388400560e-11, -2.747597367207432e-13,  1.181943241513535e-15, -5.773913233343337e-18,  8.100427642643876e-21, -2.043783463428747e-22,
 -2.931744334045331e-25,  3.840519817629157e-26,  7.216875095765346e-02, -6.147539875696390e-04,  3.842644622385858e-06, -2.072687195411124e-08,  9.969778549300192e-11,
 -4.381622922896910e-13,  1.568118554338290e-15, -6.331690286934897e-18, -1.497395188989711e-20, -2.338597424720054e-22, -1.469592783709435e-24,  8.012434351726935e-26,
  1.196206275672428e-01, -1.010403413455802e-03,  6.167686326276466e-06, -3.168396839096824e-08,  1.388322441234272e-10, -5.112327331367977e-13,  1.088223873710533e-15,
 -1.258636521737370e-18, -7.516834401005251e-20, -1.700010295163595e-22, -3.261551371151907e-24,  1.353758583967894e-25,  1.792932700648072e-01, -1.497691014163345e-03,
  8.852894287071565e-06, -4.238609520425335e-08,  1.591669002686919e-10, -3.887277990280685e-13, -7.994922107453791e-16,  1.087907539085379e-17, -1.653320670999467e-19,
 -1.735399054016536e-22, -4.259154031038081e-24,  1.954239126509765e-25,  2.514249569351503e-01, -2.070459300224911e-03,  1.172554524573000e-05, -5.065841958909972e-08,
  1.426358932102698e-10,  2.910896474555291e-14, -4.311056488532800e-15,  2.722710649632269e-17, -2.412048403401509e-19, -6.434286491897766e-22, -2.152327464141793e-24,
  2.530285577484610e-25,  3.362982424761869e-01, -2.719741126984282e-03,  1.454978171078009e-05, -5.373960991854263e-08,  6.983052908572164e-11,  8.005003744148817e-13,
 -8.925075167241924e-15,  3.773216187238094e-17, -2.138599531935388e-19, -2.098100641736564e-21,  4.043147337595535e-24,  3.242735643505011e-25,  4.342327057636326e-01,
 -3.432481042577594e-03,  1.700676242492993e-05, -4.826530557420376e-08, -7.650168068685136e-11,  1.880661289485842e-12, -1.283087919293353e-14,  2.325249999500661e-17,
  2.542851506579326e-20, -4.665039625996349e-21,  8.945885775127156e-24,  4.772159673612394e-25,  5.455690990581821e-01, -4.189559994502201e-03,  1.866829471892521e-05,
 -3.037490054912971e-08, -3.042981686226635e-10,  3.023134214599654e-12, -1.236268022136323e-14, -4.137930764943708e-17,  5.026224453208175e-19, -6.967631620396032e-21,
 -5.103347743085524e-24,  8.166328026007074e-25,  6.706366306783145e-01, -4.962707143400782e-03,  1.896435351803956e-05,  3.866755350720405e-09, -5.982779357322322e-10,
  3.639011544380727e-12, -1.953578674372913e-15, -1.701128421458838e-16,  9.197145934779177e-19, -4.751264331716269e-21, -6.240629027247467e-23,  1.288299220155040e-24,
  8.096869382686291e-01, -5.709617995732428e-03,  1.715043717178333e-05,  5.730421996882426e-08, -8.945543160123986e-10,  2.652892652929575e-12,  2.376835048876794e-14,
 -3.174005051615038e-16,  2.975487908174700e-19,  7.940644123710818e-21, -1.414210147879309e-22,  1.181462618877033e-24,  9.627610221466038e-01, -6.366211815413288e-03,
  1.229844771309718e-05,  1.288584735717670e-07, -1.039376072601241e-09, -1.437698748870066e-12,  6.177705540035543e-14, -2.870623799123803e-16, -2.936065392586674e-18,
  2.582714984067651e-20, -4.306291410465344e-23, -8.030737076408152e-25,  1.129417709645296e+00, -6.834593854817880e-03,  3.387733840191075e-06,  2.072099094081236e-07,
 -7.419042311674303e-10, -9.579047065406342e-12,  8.003355878062460e-14,  3.124517921783049e-16, -8.081498258585809e-18, -2.790442159035588e-21,  5.486981594328737e-22,
 -1.402265092151285e-24,  1.308168280497014e+00, -6.965932495943304e-03, -1.027793945775922e-05,  2.584516717103828e-07,  3.937270896637869e-10, -1.843877359169188e-11,
 -7.926087999729750e-15,  1.518743975157740e-15, -3.002580350726750e-18, -1.538946594343614e-19,  4.426618383752702e-22,  1.546575626356178e-23,  1.495277882605740e+00,
 -6.543909034092020e-03, -2.773638791979433e-05,  2.101745928688361e-07,  2.408061650423503e-09, -1.272804602879136e-11, -2.598928621674010e-13,  7.668088430805803e-16,
  2.907043554039624e-17, -5.703553786690105e-20, -3.828091623645081e-21,  1.051902426204018e-24,  1.682245053535105e+00, -5.305948253633001e-03, -4.305908582451017e-05,
 -2.711296678806145e-08,  3.410005612737968e-09,  2.703323542780782e-11, -2.116353807379088e-13, -5.113928120751074e-15, -1.002137416244296e-17,  6.424573074161889e-19,
  6.082891309385251e-21, -5.362957026853889e-23,  1.851037155601970e+00, -3.148616810741169e-03, -4.152397350827210e-05, -3.474258604484300e-07, -6.393013244390660e-10,
  3.352856336647665e-11,  5.755448844227309e-13,  3.387025262640126e-15, -4.398605236192193e-17, -1.287115133501352e-18, -1.263421649198648e-20,  3.555018122886424e-23,
  1.968762709907230e+00, -7.845822889358542e-04, -1.425128445851985e-05, -2.189423646273313e-07, -2.944161720631248e-09, -3.434330139131543e-11, -3.272926968185334e-13,
 -1.985047846645091e-15,  8.543003578370788e-18,  5.357129288169397e-19,  1.094469979796332e-20,  1.595993856163354e-22,  1.417587727610288e-03, -1.201414576793333e-05,
  7.626970847581660e-08, -4.310655291025720e-10,  2.268690597166171e-12, -1.168071873715048e-14,  5.434641111818307e-17, -3.183681008173547e-19,  6.661223381819815e-22,
 -1.005352956414578e-23,  1.511095609350906e-25,  5.213505374242216e-27,  1.276767820882931e-02, -1.080186188145505e-04,  6.824346006494410e-07, -3.821801774394445e-09,
  1.981284035065036e-11, -9.985007353346609e-14,  4.481085462943328e-16, -2.576351008539762e-18,  4.033237659124085e-21, -7.847448215582406e-23,  1.289983355820306e-24,
  4.756107266441677e-26,  3.551805461611628e-02, -2.994316835176911e-04,  1.873109288904337e-06, -1.029154715618525e-08,  5.166215285948341e-11, -2.483106170443351e-13,
  1.022805810167357e-15, -5.630085494550671e-18,  1.141499517611812e-21, -1.590855729965008e-22,  3.259914724756301e-24,  1.351758905558864e-25,  6.976967950130192e-02,
 -5.849812556718508e-04,  3.603210415696383e-06, -1.919982988018711e-08,  9.129621418726142e-11, -4.027170090626398e-13,  1.382828626290857e-15, -6.947451206563550e-18,
 -2.320089327537704e-20, -1.761994389265344e-22,  5.743033060845236e-24,  2.717726011736958e-25,  1.156753412116307e-01, -9.625457588918974e-04,  5.800473739392192e-06,
 -2.954304762920474e-08,  1.288644777332488e-10, -4.858162603331403e-13,  1.018295362580494e-15, -3.771153558060187e-18, -8.152512736646107e-20, -1.037973576331373e-22,
  8.917885182204791e-24,  4.587640208311920e-25,  1.734409913066331e-01, -1.428859696209033e-03,  8.359281486561052e-06, -3.990257105407826e-08,  1.512220230826165e-10,
 -4.048644961197372e-13, -5.699909162318225e-16,  5.479101027984038e-18, -1.715296408108801e-19, -5.222849348730059e-23,  1.394065940234147e-23,  6.938428626746502e-25,
  2.433269332042954e-01, -1.979047736491864e-03,  1.113133892828015e-05, -4.837696624533514e-08,  1.422405716384596e-10, -6.610156467475799e-14, -3.660185129593246e-15,
  1.915278940201619e-17, -2.617184481071451e-19, -3.330719447101782e-22,  2.291318522155984e-23,  9.757298824711984e-25,  3.256480185912496e-01, -2.605902237799075e-03,
  1.391210169936087e-05, -5.250553526978170e-08,  8.377980927864978e-11,  5.981355126499366e-13, -7.975290469379129e-15,  2.975257475569194e-17, -2.809577557692418e-19,
 -1.412029735207904e-21,  3.748663260682304e-23,  1.320377059290051e-24,  4.207711958855062e-01, -3.298761735301992e-03,  1.642142224006793e-05, -4.920493706025684e-08,
 -4.191529936442739e-11,  1.580473595530863e-12, -1.219285069189737e-14,  2.150661786329284e-17, -1.282948473408238e-19, -3.575167727285611e-21,  5.505632817794465e-23,
  1.788105213842995e-24,  5.291071323769254e-01, -4.041749912484904e-03,  1.827652533264933e-05, -3.477645490587692e-08, -2.468879647686148e-10,  2.714112874865971e-12,
 -1.333360324896277e-14, -2.925595319498818e-17,  2.602107673515115e-19, -6.057383896949210e-21,  6.277414889616266e-23,  2.493290234256574e-24,  6.510893031578869e-01,
 -4.810963935656009e-03,  1.895570911046900e-05, -5.127559049794625e-09, -5.263359150850400e-10,  3.538121423063604e-12, -6.333072382293685e-15, -1.437604793078489e-16,
  7.219615022882878e-19, -5.589543101373726e-21,  3.647088316876548e-23,  3.492251235963266e-24,  7.871268904441757e-01, -5.569902995723664e-03,  1.775405370076799e-05,
  4.344380839524597e-08, -8.365053734954026e-10,  3.117990839507139e-12,  1.505042989432751e-14, -3.042513893250710e-16,  5.009510109454017e-19,  4.102748611883959e-21,
 -2.744115589551464e-23,  4.357067728111549e-24,  9.375023419326546e-01, -6.261923413501331e-03,  1.374427345498179e-05,  1.120760689274270e-07, -1.054005880883991e-09,
 -6.127256251052687e-14,  5.256125710779450e-14, -3.664795622572433e-16, -2.036131022815715e-18,  2.450239289494682e-20,  9.550099932354287e-24,  3.704884101375244e-24,
  1.102148982702531e+00, -6.797761575870098e-03,  5.797052699822896e-06,  1.939136070091088e-07, -9.137193549564324e-10, -7.582424297621020e-12,  8.517626757164753e-14,
  5.638825608994408e-17, -7.795818711229437e-18,  1.864493984682111e-20,  5.498578008808315e-22,  2.300327196694812e-24,  1.280159860050597e+00, -7.035671260915457e-03,
 -7.150885771812595e-06,  2.618049647604697e-07,  2.641658406315761e-11, -1.813452298154033e-11,  3.245281038017169e-14,  1.338772915436835e-15, -8.058895758132374e-18,
 -1.224129114430443e-19,  1.140606277903412e-21,  1.679381109176727e-23,  1.468675334000000e+00, -6.755078268858562e-03, -2.499259275967744e-05,  2.463373482548975e-07,
  2.093396969444984e-09, -1.860565037935330e-11, -2.259149853036031e-13,  1.635264227727931e-15,  2.435119190732607e-17, -2.004516589680841e-19, -3.114070613442893e-21,
  3.236122515849445e-23,  1.660331615623401e+00, -5.650755786918958e-03, -4.304026686392763e-05,  3.144742073467855e-08,  3.888188536992652e-09,  2.022238478473690e-11,
 -3.555351243649675e-13, -5.023270752491563e-15,  1.675840990487201e-17,  8.212971710724040e-19,  2.468840984542237e-21, -1.065022072638718e-22,  1.837751728438244e+00,
 -3.497602944182597e-03, -4.572981685662692e-05, -3.515107996514584e-07,  1.760664885350141e-10,  4.827445387338651e-11,  6.430463898457431e-13,  1.146525283800046e-15,
 -9.858980823895717e-17, -1.709927008924474e-18, -7.031420809278229e-21,  2.379242051058986e-22,  1.965378517594826e+00, -9.099576754078623e-04, -1.718533115631139e-05,
 -2.719887511824415e-07, -3.713832632914226e-09, -4.281320113740573e-11, -3.754578729810514e-13, -1.303302042400014e-15,  3.764233848328796e-17,  1.140793051643171e-18,
  2.001781901878429e-20,  2.565082574924198e-22,  1.370719547224817e-03, -1.142407947083567e-05,  7.130722852338527e-08, -3.965675181277134e-10,  2.047408524764967e-12,
 -1.048124757182075e-14,  4.568753914256044e-17, -3.011236724189174e-19,  4.843665842675189e-22,  2.388079353081820e-24,  5.209781360624007e-25,  1.205354449470792e-26,
  1.234623964291268e-02, -1.027373474984927e-04,  6.384109373437501e-07, -3.520212300499832e-09,  1.791760773548453e-11, -8.994867414087283e-14,  3.774521778932753e-16,
 -2.477497509312744e-18,  2.786466162760869e-21,  3.130780263455744e-23,  4.650620049645383e-24,  1.093159046303846e-25,  3.434953482432739e-02, -2.849271203973027e-04,
  1.754410578632908e-06, -9.503402250878003e-09,  4.692864809820739e-11, -2.256549151125046e-13,  8.650734055774912e-16, -5.645764534314979e-18, -3.990868654573514e-22,
  1.359300448079247e-22,  1.275419080315074e-23,  3.079731876601105e-25,  6.748598092324579e-02, -5.570529323594928e-04,  3.381316757065099e-06, -1.780178966949370e-08,
  8.355754551905808e-11, -3.719509625365253e-13,  1.177429292372762e-15, -7.718433441839674e-18, -2.172154856075067e-20,  3.833184083457431e-22,  2.474158647940683e-23,
  6.149177055136672e-25,  1.119157690052815e-01, -9.175257141385718e-04,  5.458011709357996e-06, -2.755765994631198e-08,  1.193824648189752e-10, -4.629389285841015e-13,
  8.763802982056490e-16, -6.322624264656828e-18, -7.261700713269817e-20,  8.095446882510448e-22,  4.098226752824101e-23,  1.037775529977423e-24,  1.678563256822692e-01,
 -1.363860255346142e-03,  7.894698445631183e-06, -3.754849924142720e-08,  1.429971685087499e-10, -4.173197175618411e-13, -4.925251739933808e-16,  1.409248379004260e-19,
 -1.539250343377088e-19,  1.351101226854087e-21,  6.273320867065130e-23,  1.583978583138722e-24,  2.355852214816174e-01, -1.892280560657546e-03,  1.056441179762492e-05,
 -4.611630098366803e-08,  1.400786271881839e-10, -1.484593658646724e-13, -3.241116852053963e-15,  1.086638549399713e-17, -2.438393341693821e-19,  1.782452485354804e-21,
  9.228212492606853e-23,  2.264207631514709e-24,  3.154430461331849e-01, -2.497102058859415e-03,  1.329043994848962e-05, -5.107949192597086e-08,  9.389052696943592e-11,
  4.156761439937493e-13, -7.272876367498596e-15,  2.037870377746079e-17, -2.866133260747765e-19,  1.720336475082642e-21,  1.321771435380212e-22,  3.104973626820604e-24,
  4.078351390677882e-01, -3.169761295321885e-03,  1.582793127295784e-05, -4.963841049479715e-08, -1.318616733296477e-11,  1.294508222960721e-12, -1.166339350171144e-14,
  1.595687059686969e-17, -1.928219637343248e-19,  8.285053685934165e-22,  1.825639978453024e-22,  4.173432544940889e-24,  5.132298246119290e-01, -3.897270122018641e-03,
  1.783724089706496e-05, -3.831005525191241e-08, -1.958680341031737e-10,  2.385039311257611e-12, -1.406405300595055e-14, -2.367228912362069e-17,  1.210195161779867e-19,
 -5.368323568609092e-22,  2.359754667828949e-22,  5.601734466490442e-24,  6.321481539682933e-01, -4.659702231296503e-03,  1.884595493195961e-05, -1.299241643778502e-08,
 -4.574067059157961e-10,  3.340267457734758e-12, -1.006113351618510e-14, -1.232342291133063e-16,  5.934596561367826e-19,  4.868507848703015e-24,  2.728419626256338e-22,
  7.541124719979870e-24,  7.651343302235710e-01, -5.426007940164520e-03,  1.819718850071255e-05,  3.057536458783157e-08, -7.712135480587095e-10,  3.378923830663831e-12,
  6.779089628239117e-15, -2.856109115214925e-16,  6.880321553228592e-19,  8.293878516493254e-21,  2.771685548480262e-22,  9.854803785304411e-24,  9.126826701133358e-01,
 -6.146875929810603e-03,  1.498817346763986e-05,  9.526710029515175e-08, -1.043482357383464e-09,  1.070525548867417e-12,  4.152319738538700e-14, -4.170114746705830e-16,
 -1.089606893516395e-18,  3.019796679762189e-20,  3.317586339337487e-22,  1.144186788231988e-23,  1.075065061522807e+00, -6.742336635833602e-03,  8.031654576700003e-06,
  1.781920184333663e-07, -1.044940129300409e-09, -5.546657899215566e-12,  8.339555695975358e-14, -1.777657446462211e-16, -6.684094740745779e-18,  4.496172312785976e-20,
  8.325686535488812e-22,  1.141053989329040e-23,  1.251922632235047e+00, -7.080331752029856e-03, -4.018488452057562e-06,  2.593805969668384e-07, -3.256154824524919e-10,
 -1.693868882189888e-11,  6.573707632539413e-14,  1.020704242150792e-15, -1.145454939795127e-17, -6.062151597849142e-20,  1.993847014781952e-21,  2.295478767704866e-23,
  1.441274625348144e+00, -6.942655525382077e-03, -2.184876631783924e-05,  2.765772612601701e-07,  1.671197048943637e-09, -2.339755462638701e-11, -1.704554131545232e-13,
  2.278387680597421e-15,  1.532745889277776e-17, -2.864793049080381e-19, -9.383221453832561e-22,  6.641028466289206e-23,  1.637043867722889e+00, -5.992483364182252e-03,
 -4.227791398924728e-05,  9.638402448623985e-08,  4.196345859173073e-09,  1.009008581909628e-11, -4.841537376261112e-13, -4.004518766326824e-15,  4.690564425903193e-17,
  8.197663745576870e-19, -2.593179619824947e-21, -1.125474079607668e-22,  1.823003096017233e+00, -3.880187256713113e-03, -4.989645393809914e-05, -3.401275325443353e-07,
  1.296398027069687e-09,  6.367807425282462e-11,  6.214818589281175e-13, -3.022255241448820e-15, -1.619477861116419e-16, -1.699651665159061e-18,  9.690060640522806e-21,
  5.303063517393981e-22,  1.961441534472235e+00, -1.061574253921222e-03, -2.083559357778856e-05, -3.387591963509055e-07, -4.662275961432045e-09, -5.208193153577436e-11,
 -3.876738286129235e-13,  7.368137998822210e-16,  9.612396677955323e-17,  2.197737065861685e-18,  3.353847771923328e-20,  3.522012002952454e-22,  1.326134771537310e-03,
 -1.087211554692731e-05,  6.673823713351113e-08, -3.654292373280863e-10,  1.848075637342822e-12, -9.483921142974261e-15,  3.752138727347931e-17, -2.790451221614685e-19,
  1.095144533401547e-21,  3.623161348593140e-23,  1.228861117453851e-24,  1.984584851505827e-26,  1.194524399577198e-02, -9.779429024134209e-05,  5.978306443634638e-07,
 -3.247453543509929e-09,  1.620366579895668e-11, -8.170960318955746e-14,  3.098168749225415e-16, -2.323685716256582e-18,  8.618927889267467e-21,  3.351906758358246e-22,
  1.106459709974300e-23,  1.797310842873131e-25,  3.323719223072061e-02, -2.713355704171919e-04,  1.644729476952535e-06, -8.787574287530805e-09,  4.261038967915196e-11,
 -2.067828080075340e-13,  7.084222714282683e-16, -5.451628520462944e-18,  1.749711368511100e-20,  9.777938540814165e-22,  3.079916544662381e-23,  5.052901413846391e-25,
  6.531054867872856e-02, -5.308347123147477e-04,  3.175476087566331e-06, -1.652292037839152e-08,  7.638328154782696e-11, -3.463435746768193e-13,  9.553603066608409e-16,
 -7.941561814733669e-18,  1.751367795259944e-20,  2.034746128188304e-21,  6.073377470498442e-23,  1.007343083822304e-24,  1.083309448780253e-01, -8.751526126696055e-04,
  5.138478493938504e-06, -2.572053237848626e-08,  1.103184839894645e-10, -4.442521090517864e-13,  6.740287052535170e-16, -7.762144974379934e-18, -1.102276916779643e-21,
  3.565775117713250e-21,  1.017347270303781e-22,  1.700695689143322e-24,  1.625244002193829e-01, -1.302466739044899e-03,  7.457566652684782e-06, -3.532796585045277e-08,
  1.345302768422384e-10, -4.295835837080210e-13, -5.458907501700740e-16, -3.367017490153783e-18, -4.046202190846549e-20,  5.567569557666792e-21,  1.556375954586106e-22,
  2.604001244150339e-24,  2.281816784475192e-01, -1.809941000001464e-03,  1.002435230708133e-05, -4.390293422783302e-08,  1.363520212921350e-10, -2.233866984165678e-13,
 -3.030109816936595e-15,  5.024731365740306e-18, -8.507758972785771e-20,  7.919966461176673e-21,  2.255340875813382e-22,  3.742954243657832e-24,  3.056634397059866e-01,
 -2.393204245557426e-03,  1.268674364922701e-05, -4.952004263476466e-08,  1.004998212382049e-10,  2.470389829029697e-13, -6.812356511235185e-15,  1.352342045437762e-17,
 -9.083993142832122e-20,  1.036984998426754e-20,  3.155082721505272e-22,  5.160929009094118e-24,  3.954055656747673e-01, -3.045522205933065e-03,  1.523180997099521e-05,
 -4.965733663205070e-08,  9.937701251567100e-12,  1.019338821709139e-12, -1.128612339241303e-14,  1.208314208355316e-17,  2.043036426595885e-20,  1.265062108369673e-20,
  4.290217201100257e-22,  6.941834915441825e-24,  4.979231578288859e-01, -3.756460848575814e-03,  1.736023102632779e-05, -4.108089400653056e-08, -1.515938442801561e-10,
  2.040046195805053e-12, -1.465945812114871e-14, -1.773842645560684e-17,  3.411333827542647e-19,  1.494348139656278e-20,  5.649763633160076e-22,  9.242730405017027e-24,
  6.138097238338057e-01, -4.509677656150316e-03,  1.864829385836097e-05, -1.979073435966765e-08, -3.932841020813951e-10,  3.059632642193041e-12, -1.322659281269518e-14,
 -1.013984938155694e-16,  8.832666910507370e-19,  1.900492681583901e-20,  7.123382237195893e-22,  1.229644895181192e-23,  7.437234878881150e-01, -5.279167404649242e-03,
  1.849230778776326e-05,  1.878274577434170e-08, -7.026414742885027e-10,  3.448520175969711e-12, -8.441512421885014e-16, -2.557122480144485e-16,  1.308397252685333e-18,
  2.999688761441937e-20,  8.551277171260303e-22,  1.623162290663962e-23,  8.883418193361236e-01, -6.022679589422637e-03,  1.603207531806824e-05,  7.879278605603779e-08,
 -1.013067740209153e-09,  1.924149877968304e-12,  2.954692902819073e-14, -4.307756467062798e-16,  3.825726110713482e-19,  5.626497416287345e-20,  1.037976955171567e-21,
  2.042995396053673e-23,  1.048237352551327e+00, -6.669822140537143e-03,  1.006633039004616e-05,  1.606921533646593e-07, -1.136379165599892e-09, -3.627309927578750e-12,
  7.571951771574383e-14, -3.581390169872216e-16, -4.312915568577303e-18,  9.184542910008732e-20,  1.599732231848159e-21,  2.333775192479382e-23,  1.223556564112268e+00,
 -7.100143103141683e-03, -9.480575239834848e-07,  2.515552320871872e-07, -6.465178522167887e-10, -1.506087618190188e-11,  8.897908984188310e-14,  6.367792823120047e-16,
 -1.193178314492776e-17,  4.223538674303518e-20,  3.223319582313145e-21,  3.295910652929087e-23,  1.413176036024870e+00, -7.103752278861366e-03, -1.838550525913793e-05,
  2.993730954459635e-07,  1.167749584800909e-09, -2.667715874148159e-11, -1.013600782551000e-13,  2.602880949622239e-15,  5.126390824816819e-18, -2.565511659147092e-19,
  2.635745706660690e-21,  9.369061490213835e-23,  1.612406439064006e+00, -6.324927777356062e-03, -4.071393817691400e-05,  1.644739043429789e-07,  4.273857376065314e-09,
 -2.679184985569189e-12, -5.710251564087698e-13, -2.060289641800752e-15,  7.348013446276046e-17,  6.316466860964807e-19, -6.314049267565829e-21, -4.450031713971291e-23,
  1.806658785867162e+00, -4.295230521693328e-03, -5.380898293593830e-05, -3.084262556268954e-07,  2.709007949795919e-09,  7.693992162990249e-11,  4.559307919841353e-13,
 -9.057981556687922e-15, -2.097599116914376e-16, -7.619617134574691e-19,  3.900766798623054e-20,  7.744235894389144e-22,  1.956834223513785e+00, -1.245869968165780e-03,
 -2.538425757745857e-05, -4.221799463625039e-07, -5.793142448487087e-09, -6.070782030101085e-11, -3.100596474817258e-13,  5.368697541966233e-15,  2.032313757770521e-16,
  3.858367588323797e-18,  4.936551215542482e-20,  3.299508414775171e-22,  1.283687039561734e-03, -1.035526168719116e-05,  6.252439360319128e-08, -3.373310927771110e-10,
  1.666796429910016e-12, -8.671618626455110e-15,  3.047279378017821e-17, -2.118524664777776e-19,  3.506572606587809e-21,  1.039936690414799e-22,  2.165363832423285e-24,
  2.041723652162562e-26,  1.156339138028460e-02, -9.316323714020620e-05,  5.603640753705693e-07, -3.000885810894589e-09,  1.463878045141469e-11, -7.500898879144834e-14,
  2.511314849621672e-16, -1.753165610870166e-18,  3.066542230869087e-20,  9.462727398495728e-22,  1.954486001583532e-23,  1.848966640364541e-25,  3.217751372028776e-02,
 -2.585882567008094e-04,  1.543235560660349e-06, -8.138019771692590e-09,  3.863289013192448e-11, -1.915070059809113e-13,  5.708651746698145e-16, -4.045130223482070e-18,
  8.053200900016523e-20,  2.683406675921557e-21,  5.463728288066556e-23,  5.198532656351867e-25,  6.323679035177707e-02, -5.062037462553758e-04,  2.984309085160844e-06,
 -1.535503047106704e-08,  6.966836779309007e-11, -3.259332851039340e-13,  7.557214127495928e-16, -5.649316958465825e-18,  1.457741651521512e-19,  5.408352870397998e-21,
  1.082608373633944e-22,  1.036906964737245e-24,  1.049106368015585e-01, -8.352500335584077e-04,  4.840132122411005e-06, -2.402571018160356e-08,  1.015782012467504e-10,
 -4.305370285542967e-13,  4.819768627659358e-16, -4.804598682803467e-18,  2.195649715197422e-19,  9.229834998570443e-21,  1.820151091404427e-22,  1.752859536588098e-24,
  1.574312201969612e-01, -1.244466013700941e-03,  7.046260050242198e-06, -3.324495848319806e-08,  1.258001597116270e-10, -4.437286643148905e-13, -6.182413091293201e-16,
 -1.816215640705880e-20,  3.012144244955395e-19,  1.423651999466584e-20,  2.786923005360877e-22,  2.690015017531436e-24,  2.210990193408761e-01, -1.731816799628038e-03,
  9.510446782086280e-06, -4.176094867100796e-08,  1.311682384349498e-10, -2.943946690179725e-13, -2.870307095587884e-15,  8.943581999669095e-18,  4.044119776592663e-19,
  2.045745782801024e-20,  4.027008529116096e-22,  3.879044536291357e-24,  2.962898861139723e-01, -2.294059604040336e-03,  1.210228573986534e-05, -4.788127437455063e-08,
  1.038364265137691e-10,  8.820129088323630e-14, -6.398221044533913e-15,  1.949213445635722e-17,  5.675875190874564e-19,  2.784432873750177e-20,  5.602335247213760e-22,
  5.367770599698194e-24,  3.834634175921028e-01, -2.926047120890599e-03,  1.463750137361112e-05, -4.934983327170176e-08,  2.764586086844186e-11,  7.531602974913520e-13,
 -1.084294614480843e-14,  2.396392526598865e-17,  8.627351239296988e-19,  3.634573250105543e-20,  7.586016930341670e-22,  7.240988831684582e-24,  4.831719017019468e-01,
 -3.619589140848843e-03,  1.685399140743711e-05, -4.319924267562534e-08, -1.143423028423611e-10,  1.684166147666410e-12, -1.488651991632757e-14,  6.983121601060594e-18,
  1.389691398466554e-18,  4.624075425368956e-20,  1.003798407545421e-21,  9.654604259603669e-24,  5.960677367788559e-01, -4.361543699746998e-03,  1.837501078338072e-05,
 -2.561188385782005e-08, -3.354758105471054e-10,  2.712174466225575e-12, -1.552158161327312e-14, -5.557599867099340e-17,  2.218352877347015e-18,  5.906371463959649e-20,
  1.295943716689215e-21,  1.286640755478061e-23,  7.229038597560367e-01, -5.130513266119920e-03,  1.865251319956479e-05,  8.088810758981294e-09, -6.344239616066224e-10,
  3.348342260528963e-12, -7.200058895227410e-15, -1.884938076792191e-16,  3.186524339602950e-18,  7.950874528598201e-20,  1.628771165600160e-21,  1.715921091883064e-23,
  8.645132175639751e-01, -5.890913332709504e-03,  1.688171790607122e-05,  6.292604643403393e-08, -9.684541973368542e-10,  2.492122667716134e-12,  1.802897092934716e-14,
 -3.762456265213199e-16,  3.387585281170659e-18,  1.173044308602248e-19,  2.029980425520383e-21,  2.234557316815340e-23,  1.021730895026606e+00, -6.581892259119871e-03,
  1.188345974878624e-05,  1.420248091889059e-07, -1.191630797272879e-09, -1.942422289924187e-12,  6.435697398835764e-14, -4.287358269942419e-16,  4.152959327969740e-19,
  1.786435704015454e-19,  2.768505700833147e-21,  2.685190497044805e-23,  1.195159663514741e+00, -7.095850876715119e-03,  1.998989969913018e-06,  2.389225482004127e-07,
 -9.251497247395578e-10, -1.275219828489361e-11,  1.018865142288046e-13,  3.071320844050982e-16, -7.723793706682293e-18,  2.018287407896293e-19,  4.763983220629204e-21,
  3.350856135505686e-23,  1.384490005204829e+00, -7.236190068446250e-03, -1.469889093546022e-05,  3.136815822568576e-07,  6.158462198854845e-10, -2.822429775739492e-11,
 -2.737828685928595e-14,  2.647790840502862e-15, -1.186624830149107e-18, -6.573926664652188e-20,  6.904902472810564e-21,  9.304674855837521e-23,  1.586469434564045e+00,
 -6.641591033324025e-03, -3.833418282202191e-05,  2.316677537755499e-07,  4.080010708430344e-09, -1.679113341671132e-11, -5.927360613755474e-13,  6.042398801072624e-16,
  9.149420781106603e-17,  3.723646073931357e-19, -5.823857525167230e-21,  6.708601736996330e-23,  1.788594678381498e+00, -4.739649668269093e-03, -5.719759597659794e-05,
 -2.522772909665563e-07,  4.332703329350213e-09,  8.406738399903517e-11,  1.067505569329912e-13, -1.584025782214434e-14, -2.007565656376322e-16,  1.488277296333050e-18,
  7.283864961996990e-20,  6.771873559885890e-22,  1.951410160690264e+00, -1.470878990086764e-03, -3.104776011718137e-05, -5.249216806072481e-07, -7.065142665903366e-09,
 -6.546788528256245e-11, -4.494570599759048e-14,  1.449969050844830e-14,  3.804693832977485e-16,  6.037621712052110e-18,  5.635365176659521e-20, -1.256799313726656e-22,
  1.243241368933776e-03, -9.870817993798397e-06,  5.863083354351136e-08, -3.120118105774889e-10,  1.500279562858203e-12, -7.994677560144972e-15,  2.680301071502412e-17,
 -2.148878296822686e-20,  8.989833950771347e-21,  2.041766931186062e-22,  2.676849127683150e-24, -2.870252688695886e-27,  1.119948166317227e-02, -8.882049726714618e-05,
  5.257102836012351e-07, -2.778353522606106e-09,  1.319562351998480e-11, -6.942277902505583e-14,  2.220607759211787e-16, -6.201591564938970e-20,  8.043800708460288e-20,
  1.851006556062803e-21,  2.418243923020379e-23, -2.566094819377823e-26,  3.116724843009187e-02, -2.466227754381916e-04,  1.449164007762402e-06, -7.549822213534550e-09,
  3.493252528204488e-11, -1.787688474531134e-13,  5.114427008330935e-16,  5.384818963447602e-19,  2.210717784334809e-19,  5.214893767195106e-21,  6.770556256719538e-23,
 -7.044215613254621e-26,  6.125858343708102e-02, -4.830478544763209e-04,  2.806524840545864e-06, -1.429154213564361e-08,  6.332186563794781e-11, -3.089552162654024e-13,
  6.985410195158117e-16,  3.044570321726194e-18,  4.276022212231760e-19,  1.042983191209689e-20,  1.344044146441390e-22, -1.361316292918452e-25,  1.016452909754963e-01,
 -7.976552318838867e-04,  4.561292908020153e-06, -2.246874339142500e-08,  9.307783846947577e-11, -4.194293037944888e-13,  5.065696758357307e-16,  9.075194321432944e-18,
  6.984230486596340e-19,  1.768041795692434e-20,  2.263563448065833e-22, -2.222496498947133e-25,  1.525636170976689e-01, -1.189658153265821e-03,  6.659101952946946e-06,
 -3.130393241553929e-08,  1.167851032279882e-10, -4.569276314035177e-13, -3.902107375738337e-16,  2.017544127555506e-17,  1.038250934656864e-18,  2.718259829397935e-20,
  3.469670509131219e-22, -3.297279997820345e-25,  2.143207952074650e-01, -1.657702544380466e-03,  9.021701441577672e-06, -3.971298156397253e-08,  1.246226302090078e-10,
 -3.580154204773521e-13, -2.304086936439279e-15,  3.707009717691980e-17,  1.465275162027753e-18,  3.916307903144537e-20,  5.014773239249584e-22, -4.605845348343341e-25,
  2.873036852758132e-01, -2.199511294805779e-03,  1.153771055611214e-05, -4.621388666949347e-08,  1.041242222237029e-10, -5.566292688922887e-14, -5.414219577004922e-15,
  5.842410049869173e-17,  2.021084085249263e-18,  5.385490877021778e-20,  6.974252183860825e-22, -6.142280160868557e-25,  3.719896905545401e-01, -2.811307327861356e-03,
  1.404840945880331e-05, -4.880083113611463e-08,  4.018317181059154e-11,  5.055336686773313e-13, -9.543734807275231e-15,  7.891117174052868e-17,  2.781877430205006e-18,
  7.156063195199516e-20,  9.446917396051235e-22, -7.764291355106971e-25,  4.689598851683121e-01, -3.486859439755724e-03,  1.632567275130546e-05, -4.477848550119287e-08,
 -8.418233864072474e-11,  1.336095244796190e-12, -1.375855337572863e-14,  8.656968382082117e-17,  3.863343443670978e-18,  9.291633176345403e-20,  1.254380370430469e-21,
 -8.965120449528971e-25,  5.789134920936786e-01, -4.215860244261053e-03,  1.803718593541626e-05, -3.056614494420673e-08, -2.850323684801988e-10,  2.331352188131466e-12,
 -1.568708768402200e-14,  6.041630473506188e-17,  5.393237200874140e-18,  1.196632932410847e-19,  1.635701817396462e-21, -8.589853472753545e-25,  7.026806246570984e-01,
 -4.981072440378179e-03,  1.869084940048040e-05, -1.537175343550624e-09, -5.695401142933136e-10,  3.126857559267901e-12, -1.052257864954526e-14, -2.683995010014742e-17,
  7.376787232201637e-18,  1.564829761763780e-19,  2.093333972063301e-21, -5.161747063762835e-25,  8.412240873789764e-01, -5.753098634702115e-03,  1.754557068012745e-05,
  4.784972303471840e-08, -9.150560661394941e-10,  2.815155521825115e-12,  9.768522158683000e-15, -1.828813336358410e-16,  9.276051177593544e-18,  2.140928603212924e-19,
  2.649049883892210e-21, -5.921700013749127e-26,  9.956037944153423e-01, -6.480333940980289e-03,  1.347233984246380e-05,  1.227278798454278e-07, -1.215970008457341e-09,
 -5.336486679376497e-13,  5.366989751949141e-14, -2.891039916109746e-16,  9.084653202638282e-18,  3.080485430657938e-19,  3.500764832928790e-21, -1.256052803831691e-24,
  1.166826022251163e+00, -7.068660822710772e-03,  4.769267086717945e-06,  2.222151817268499e-07, -1.155155203176556e-09, -1.022356107950195e-11,  1.083954447851805e-13,
  2.155174268290607e-16,  3.267083286495183e-18,  4.144907385273828e-19,  5.585172630404986e-21, -6.180932420229415e-24,  1.355334082259774e+00, -7.338599977895326e-03,
 -1.089426572568817e-05,  3.190086548209447e-07,  5.077075617372005e-11, -2.799610430062723e-11,  4.629562714983207e-14,  2.632571436699760e-15,  2.292256281316858e-18,
  2.787529548936989e-19,  9.823736943695245e-21,  2.405694286351870e-23,  1.559308857068061e+00, -6.936065171748679e-03, -3.517604425082875e-05,  2.935002647288941e-07,
  3.605058899952695e-09, -3.047197990105479e-11, -5.330920965894427e-13,  3.708878694400956e-15,  1.016407173558289e-16,  2.212638478424407e-19, -1.400945953704594e-21,
  1.097438967229519e-22,  1.768703577494388e+00, -5.208033362808522e-03, -5.975349023584191e-05, -1.695270714095907e-07,  6.000281190461896e-09,  8.065202939948347e-11,
 -4.143576927700837e-13, -2.079570669975060e-14, -8.899876312088420e-17,  4.828245664592992e-18,  8.857821070718976e-20, -9.044037756707929e-23,  1.944987142794385e+00,
 -1.746478127224924e-03, -3.806802997133001e-05, -6.483319247731421e-07, -8.344384751273672e-09, -6.008311794058767e-11,  5.671208926551262e-13,  3.055788152902738e-14,
  6.341056700376561e-16,  7.836781317364404e-18,  2.251847544360158e-20, -1.663386136005046e-21,  1.204673037771700e-03, -9.416351739467860e-06,  5.502555643644138e-08,
 -2.892510605057283e-10,  1.346969445420477e-12, -7.318609845136808e-15,  3.147535254921067e-17,  4.033106831173814e-19,  1.809598097136689e-20,  2.924861707983997e-22,
  1.240905888790828e-24, -7.141967627495499e-26,  1.085240481416474e-02, -8.474469037788851e-05,  4.935919529731442e-07, -2.578036128412894e-09,  1.186211009500452e-11,
 -6.375524684268725e-14,  2.676573059212939e-16,  3.754528790869537e-18,  1.629375357551000e-19,  2.648886456463855e-21,  1.121090174860935e-23, -6.455243553417463e-25,
  3.020338322738031e-02, -2.353826204990333e-04,  1.361803890361895e-06, -7.018815993759198e-09,  3.148604976642623e-11, -1.653222974375085e-13,  6.573650922040083e-16,
  1.111038146404574e-17,  4.532310966420358e-19,  7.449380515050957e-21,  3.139772568365259e-23, -1.808711967430796e-24,  5.937023396365631e-02, -4.612648896474786e-04,
  2.640904430793113e-06, -1.332685262038723e-08,  5.732691135181768e-11, -2.892381085065183e-13,  1.038912770902139e-15,  2.371598017636433e-17,  8.912903814790326e-19,
  1.486757487963709e-20,  6.238699835506171e-23, -3.592529892552890e-24,  9.852597801752633e-02, -7.622187037298362e-04,  4.300329139320980e-06, -2.104580613257500e-08,
  8.484718157588197e-11, -4.010481036328870e-13,  1.181235524175675e-15,  4.326060480271340e-17,  1.483550019926644e-18,  2.515942702694425e-20,  1.052928177429804e-22,
 -6.048383484752645e-24,  1.479091949441608e-01, -1.137856857414993e-03,  6.294363627919859e-06, -2.950871590419284e-08,  1.076222382578495e-10, -4.547622410864036e-13,
  8.053204830801018e-16,  7.158990173396318e-17,  2.244790195304271e-18,  3.865865194683173e-20,  1.620500586903476e-22, -9.252691658177871e-24,  2.078313611821167e-01,
 -1.587401820109836e-03,  8.556864645513320e-06, -3.777884022992659e-08,  1.170268193748929e-10, -3.941223638372290e-13, -3.711684579007112e-16,  1.101802122557376e-16,
  3.204898141974519e-18,  5.577493372973600e-20,  2.357935703851307e-22, -1.331402131918887e-23,  2.786867710285751e-01, -2.109399682224673e-03,  1.099308212427729e-05,
 -4.456315284872404e-08,  1.018901137253673e-10, -1.566869811275579e-13, -2.544474952061843e-15,  1.592178454724276e-16,  4.418981024702228e-18,  7.700820812748112e-20,
  3.312392570467535e-22, -1.838203403608089e-23,  3.609655432784004e-01, -2.701250870127697e-03,  1.346695296905767e-05, -4.808849482274247e-08,  4.824533657040163e-11,
  3.156913789090259e-13, -5.650548596339141e-15,  2.160638934734241e-16,  5.980956868240148e-18,  1.030182291963660e-19,  4.548055763132721e-22, -2.465760080859642e-23,
  4.552702252194733e-01, -3.358424403082880e-03,  1.578107607752519e-05, -4.592845043822276e-08, -6.047959901014077e-11,  1.052374977489686e-12, -9.034348145455155e-15,
  2.729111275826759e-16,  8.037302606626901e-18,  1.348558359564745e-19,  6.138491031980842e-22, -3.240388576799901e-23,  5.623362181221724e-01, -4.073104045313834e-03,
  1.764450405512816e-05, -3.477312109422394e-08, -2.419139107786242e-10,  1.999084471456250e-12, -1.084462519282683e-14,  3.139424640607222e-16,  1.078538182702509e-17,
  1.746245515654186e-19,  8.139256783189412e-22, -4.196630309793113e-23,  6.830550591122514e-01, -4.831769679896279e-03,  1.861974733787543e-05, -1.016294477244480e-08,
 -5.094272440465998e-10,  2.897741462902039e-12, -7.010797239846537e-15,  3.147715123615998e-16,  1.440261362325033e-17,  2.271742615573200e-19,  1.054001125380062e-21,
 -5.385548918753405e-23,  8.184957129070646e-01, -5.610681821864101e-03,  1.803381814801303e-05,  3.367094972238291e-08, -8.566170974510642e-10,  3.029530785789248e-12,
  1.010364408094251e-14,  2.568172580308494e-16,  1.874900383381535e-17,  3.037426303864781e-19,  1.331930305014505e-21, -6.914293222385063e-23,  9.699068759653796e-01,
 -6.366995395083914e-03,  1.482820998113818e-05,  1.032549407707635e-07, -1.214201186230226e-09,  7.013299593005505e-13,  5.149855985277935e-14,  2.048000829308984e-16,
  2.249949109988662e-17,  4.259568144780681e-19,  1.743413359165928e-21, -9.097501392436244e-23,  1.138644112690916e+00, -7.020169169287181e-03,  7.318671213046403e-06,
  2.022407320542807e-07, -1.332997669938022e-09, -7.522554671708690e-12,  1.184335911677274e-13,  5.998262403937092e-16,  2.189786616632381e-17,  6.040230593020870e-19,
  3.013508678730589e-21, -1.271465741915490e-22,  1.325829582793199e+00, -7.410469914959402e-03, -7.079500600795129e-06,  3.154273364158569e-07, -4.919776119001315e-10,
 -2.598018637691733e-11,  1.230836898610322e-13,  2.941868407611977e-15,  1.925987705058786e-17,  6.474748625822566e-19,  7.238250972285977e-21, -1.650940140974103e-22,
  1.531025403526846e+00, -7.202455568320173e-03, -3.133020611306176e-05,  3.456525512687847e-07,  2.878018903128328e-09, -4.164529251427397e-11, -3.825405561059182e-13,
  7.085897970061362e-15,  1.095011434024459e-16,  2.293278118141351e-19,  4.918270157151111e-22, -7.202501125555879e-23,  1.746904964237358e+00, -5.692448425522384e-03,
 -6.116085791628430e-05, -6.136004248165484e-08,  7.465816827098477e-09,  6.358272016025179e-11, -1.005658219796893e-12, -2.020919590558291e-14,  1.441367145764201e-16,
  7.898570550148356e-18,  5.412965510348555e-20, -1.565018499774885e-21,  1.937339551955650e+00, -2.084496870196232e-03, -4.668543182063118e-05, -7.903803248983068e-07,
 -9.327667740001891e-09, -3.364935848826470e-11,  1.749409486794611e-12,  5.534541719469984e-14,  9.072371389544316e-16,  6.410630130588883e-18, -1.193028076162833e-19,
 -5.166561194593367e-21,  1.167866559571335e-03, -8.989675796536293e-06,  5.167916904744353e-08, -2.688243397929962e-10,  1.209446164018617e-12, -6.352368422433010e-15,
  5.248154568922312e-17,  1.152406990827971e-18,  2.847102903983301e-20,  2.466072704604643e-22, -4.435504563401905e-24, -1.945233031040631e-25,  1.052113202356843e-02,
 -8.091656841021795e-05,  4.637534598026938e-07, -2.398046692203892e-09,  1.066318301113064e-11, -5.539124445434169e-14,  4.603285265783694e-16,  1.050827719108429e-17,
  2.568965046980250e-19,  2.233861713940716e-21, -4.010699716433009e-23, -1.758787046307857e-24,  2.928311994476288e-02, -2.248167734029299e-04,  1.280494790220460e-06,
 -6.540495082479182e-09,  2.837210793414217e-11, -1.439218193668736e-13,  1.212414100335957e-15,  2.994365859402589e-17,  7.174660620854869e-19,  6.285138030720559e-21,
 -1.124542172122232e-22, -4.931161559396026e-24,  5.756643748182097e-02, -4.407621796685331e-04,  2.486299844565934e-06, -1.245425520326910e-08,  5.186406424359397e-11,
 -2.526103259329294e-13,  2.183903646255824e-15,  6.087859662796941e-17,  1.418689906081731e-18,  1.255389672231531e-20, -2.235084096808242e-22, -9.803136643665257e-24,
  9.554434078079703e-02, -7.288037879874793e-04,  4.055666474321541e-06, -1.975035935598026e-08,  7.723916299426594e-11, -3.519481918291848e-13,  3.195328788474796e-15,
  1.053584370242077e-16,  2.376249835087902e-18,  2.127016783196546e-20, -3.763808430454516e-22, -1.652195509146416e-23,  1.434562750992282e-01, -1.088889773887329e-03,
  5.950296280764625e-06, -2.785762761752304e-08,  9.893013030471479e-11, -4.019566682921669e-13,  4.027840457455545e-15,  1.659002538045493e-16,  3.617194842354224e-18,
  3.274091797739025e-20, -5.753684524982261e-22, -2.530416226368657e-23,  2.016158366961192e-01, -1.520729052054247e-03,  8.114494869401351e-06, -3.596867315616156e-08,
  1.093730735803728e-10, -3.525353344693103e-13,  4.456150675228374e-15,  2.451846207902615e-16,  5.186803414174284e-18,  4.735352733327511e-20, -8.261705164192409e-22,
 -3.645652360979357e-23,  2.704217136093964e-01, -2.023566593368624e-03,  1.046799648607701e-05, -4.295946237183464e-08,  9.860043941093709e-11, -1.456731435612945e-13,
  4.316790608030324e-15,  3.454685537942903e-16,  7.159337293032323e-18,  6.559150497311464e-20, -1.136362213950609e-21, -5.040742665240407e-23,  3.503723754328525e-01,
 -2.595809927468416e-03,  1.289471372614285e-05, -4.727093648342662e-08,  5.381963257548542e-11,  2.777907015784954e-13,  3.645791129405937e-15,  4.675248093606877e-16,
  9.654029893461570e-18,  8.809022207651445e-20, -1.516477645460285e-21, -6.775391981049377e-23,  4.420855130690187e-01, -3.234395272238161e-03,  1.522479352234175e-05,
 -4.673634536582312e-08, -4.081179469249594e-11,  9.608821510291537e-13,  2.951131321515396e-15,  6.088641424789261e-16,  1.285634820694755e-17,  1.158116708267063e-19,
 -1.982518229178614e-21, -8.933401057737397e-23,  5.463233822658751e-01, -3.933679958585385e-03,  1.720528647518189e-05, -3.833426540442804e-08, -2.035962327542059e-10,
  1.889221485376599e-12,  3.741055309477887e-15,  7.611969881753589e-16,  1.703772330574135e-17,  1.505528348060864e-19, -2.561610291231487e-21, -1.163471263032457e-22,
  6.640249341015293e-01, -4.683433722556151e-03,  1.845078053926897e-05, -1.785525197393958e-08, -4.521392687701716e-10,  2.895031610910093e-12,  9.508652792484909e-15,
  9.085366560619722e-16,  2.254101974458139e-17,  1.963355524939786e-19, -3.303559695235683e-21, -1.505946176784890e-22,  7.963437629614230e-01, -5.465023362909829e-03,
  1.835768637506694e-05,  2.046677248430150e-08, -7.926251253817879e-10,  3.436394541049172e-12,  2.736747364970598e-14,  1.034157791208129e-15,  2.961344460775444e-17,
  2.628651513219895e-19, -4.297168557687965e-21, -1.951072178665798e-22,  9.446835288416656e-01, -6.243742222218394e-03,  1.595139561716346e-05,  8.401068647780096e-08,
 -1.186868852649571e-09,  2.101877390870565e-12,  6.965644893694028e-14,  1.173258963146320e-15,  3.773704258761507e-17,  3.720328982560086e-19, -5.647711506307062e-21,
 -2.561461940234815e-22,  1.110695379408946e+00, -6.952285215675600e-03,  9.613147204109290e-06,  1.798709958563189e-07, -1.453167826897272e-09, -4.378832072880277e-12,
  1.483940763038610e-13,  1.657431400586662e-15,  4.394373878274809e-17,  5.541103483445431e-19, -7.131634639153739e-21, -3.489897834928412e-22,  1.296098164107936e+00,
 -7.452137527503533e-03, -3.358149256738215e-06,  3.035889175398706e-07, -9.749118968097038e-10, -2.194497470166096e-11,  2.178799896293042e-13,  3.967727313488240e-15,
  4.524641351989043e-17,  7.037432805944376e-19, -6.839439296472897e-21, -4.952420249272251e-22,  1.501741585612437e+00, -7.435789251171396e-03, -2.693498574822226e-05,
  3.846134524888081e-07,  1.971452507681150e-09, -4.804196090016593e-11, -1.338799025000623e-13,  1.071273375297046e-14,  1.162729389185746e-16,  6.328934712974701e-20,
 -1.235775933522235e-20, -5.590551988496300e-22,  1.723154915901199e+00, -6.182562647937428e-03, -6.114323884161786e-05,  6.677535044509361e-08,  8.454129416015256e-09,
  3.345162231585751e-11, -1.462143148602909e-12, -1.079391290892607e-14,  4.463324197597452e-16,  8.191591673228349e-18, -5.125835749528745e-20, -3.163688337787160e-21,
  1.928190901557300e+00, -2.498489168219189e-03, -5.707868404452777e-05, -9.421374567849342e-07, -9.437573955982422e-09,  3.038078973397496e-11,  3.730643927615508e-12,
  8.661530029381799e-14,  9.837247773994960e-16, -4.424537174606266e-18, -4.623362562155889e-19, -1.057925948473553e-20,  1.132714744773122e-03, -8.588826191778111e-06,
  4.856544755399797e-08, -2.504082316174575e-10,  1.098168970935819e-12, -4.596134082623721e-15,  9.848496528354488e-17,  2.151992990709764e-18,  3.170570166769224e-20,
 -1.442466895652233e-22, -1.610557139507887e-23, -3.290685507831551e-25,  1.020470754299635e-02, -7.731882631460561e-05,  4.359662666411980e-07, -2.235580532870396e-09,
  9.694732313956433e-12, -3.982457778880916e-14,  8.785419636875378e-16,  1.953162044084750e-17,  2.862891054611403e-19, -1.300302883728996e-21, -1.456316379620526e-22,
 -2.975771896821951e-24,  2.840385431153806e-02, -2.148792485084119e-04,  1.204643600740530e-06, -6.107653838016390e-09,  2.586670796274287e-11, -1.020021277754365e-13,
  2.397310796719105e-15,  5.516559395482122e-17,  8.006574794739274e-19, -3.624551733121745e-21, -4.083686843893907e-22, -8.345971288574613e-24,  5.584224247411394e-02,
 -4.214558403335046e-04,  2.341672050147476e-06, -1.166132359768395e-08,  4.750205288902617e-11, -1.742788138212196e-13,  4.574197584468234e-15,  1.108098564953355e-16,
  1.586220296436761e-18, -7.146396288917314e-21, -8.119361450148940e-22, -1.659969617446631e-23,  9.269254426061099e-02, -6.972859666450408e-04,  3.825861462823273e-06,
 -1.856551241288021e-08,  7.125293731219073e-11, -2.307029213070830e-13,  7.295019387062572e-15,  1.891053478821930e-16,  2.662830357875756e-18, -1.192363881557329e-20,
 -1.368428071718643e-21, -2.799408910514061e-23,  1.391938408018534e-01, -1.042598228782420e-03,  5.625258672349965e-06, -2.633197968465593e-08,  9.230539012939740e-11,
 -2.355960244600650e-13,  1.042482540735101e-14,  2.935567405571258e-16,  4.062745281626234e-18, -1.806129108434484e-20, -2.095340076933636e-21, -4.290692377155863e-23,
  1.956600601428201e-01, -1.457510325015450e-03,  7.693163984323119e-06, -3.426660996239087e-08,  1.040504303741006e-10, -1.431896327166952e-13,  1.383527770477229e-14,
  4.284420394953983e-16,  5.837192263309654e-18, -2.574009906011627e-20, -3.017072660411610e-21, -6.187374466733965e-23,  2.624917078995263e-01, -1.941858022900673e-03,
  9.961880830192481e-06, -4.139575540100917e-08,  9.764805714360060e-11,  1.016439069367076e-13,  1.746133031044665e-14,  5.985718621668339e-16,  8.066941152934088e-18,
 -3.525535909407081e-20, -4.167377815384501e-21, -8.564546853095914e-23,  3.401918798438751e-01, -2.494906105779126e-03,  1.233284165914800e-05, -4.635551068662564e-08,
  6.150159396204616e-11,  5.596377267508452e-13,  2.141658770942738e-14,  8.087592803227735e-16,  1.087890207101626e-17, -4.705891792440860e-20, -5.593479594353556e-21,
 -1.152783330641570e-22,  4.293879630388541e-01, -3.114849851577546e-03,  1.466070403835182e-05, -4.722506958272346e-08, -1.925103925877209e-11,  1.285869109299125e-12,
  2.622626720509892e-14,  1.062796233156749e-15,  1.447090809082718e-17, -6.177009285287197e-20, -7.363379522230036e-21, -1.522779506319708e-22,  5.308609593053880e-01,
 -3.797930145713107e-03,  1.672701533078102e-05, -4.127624131416335e-08, -1.628513597312482e-10,  2.300401791410822e-12,  3.329565120272146e-14,  1.361783169575451e-15,
  1.914406216564290e-17, -8.003632505049548e-20, -9.579550281758913e-21, -1.988416329654987e-22,  6.455848870421658e-01, -4.536802982060001e-03,  1.819509035335914e-05,
 -2.460368833961694e-08, -3.894515015420423e-10,  3.515276786195308e-12,  4.584179559576353e-14,  1.702454258198027e-15,  2.532681261864108e-17, -1.018787430420041e-19,
 -1.240567669194658e-20, -2.583050219680534e-22,  7.747786508463537e-01, -5.317389548640688e-03,  1.852961100572968e-05,  8.382149222779897e-09, -7.143988508250671e-10,
  4.554866555394195e-12,  7.066660272731434e-14,  2.080595203579802e-15,  3.351306344232269e-17, -1.245385867776671e-19, -1.611809580592932e-20, -3.361072489236441e-22,
  9.199697163727856e-01, -6.112417521760265e-03,  1.684730264773565e-05,  6.546168010450213e-08, -1.124702683546189e-09,  4.314510857709418e-12,  1.209717368182684e-13,
  2.526017889382574e-15,  4.382010212186254e-17, -1.370160399331590e-19, -2.118475873319732e-20, -4.423808223887855e-22,  1.083053153999429e+00, -6.867146799829527e-03,
  1.162988228943049e-05,  1.561320511809053e-07, -1.500481214668432e-09, -8.594307069944972e-14,  2.168983615922642e-13,  3.293038465596796e-15,  5.434673545247672e-17,
 -1.159258190659818e-19, -2.822982127213439e-20, -6.000197946134292e-22,  1.266258540592863e+00, -7.464726939588105e-03,  1.778737474232254e-07,  2.848042351205906e-07,
 -1.351587127527722e-09, -1.519874742556712e-11,  3.523985302145117e-13,  5.718718331266429e-15,  5.936801758435660e-17, -1.191164088839478e-19, -3.701519340953733e-20,
 -8.615852694445595e-22,  1.471597359444940e+00, -7.632345077356674e-03, -2.216234124067756e-05,  4.084049316238937e-07,  1.004943577410050e-09, -4.723785958671646e-11,
  2.174957730602988e-13,  1.431522829938420e-14,  1.020213801156936e-16, -1.110444845324145e-18, -5.093874952804866e-20, -1.182130811850158e-21,  1.697454745765145e+00,
 -6.666165740142822e-03, -5.951463987664429e-05,  2.054166193046884e-07,  8.757189912359019e-09, -3.401410200942574e-12, -1.524579544697426e-12,  7.519562236489961e-15,
  6.679179067135610e-16,  3.063101310496629e-18, -2.097955641986327e-19, -3.780655618027804e-21,  1.917208565449188e+00, -3.002826131011676e-03, -6.925213096833086e-05,
 -1.082527706625067e-06, -7.720943029157969e-09,  1.522771562632233e-10,  6.541482282257003e-12,  1.109799391513553e-13,  3.666708287743659e-16, -3.354350579418443e-17,
 -1.014458009320180e-18, -1.320640261617298e-20,  1.099117869812096e-03, -8.212029546537003e-06,  4.566341625779156e-08, -2.334220463404050e-10,  1.035317034338934e-12,
 -1.404746557463223e-15,  1.711075644268103e-16,  2.929651311079460e-18,  1.126665193629432e-20, -1.092242967426643e-21, -3.116525459127100e-23, -3.054434104505827e-25,
  9.902241447440011e-03, -7.393581917470782e-05,  4.100479720772266e-07, -2.085487564073138e-09,  9.158387689659918e-12, -1.123173552182181e-14,  1.537092463099742e-15,
  2.655281274261657e-17,  1.016130920562717e-19, -9.872816960973067e-21, -2.818346745400559e-22, -2.763100983703976e-24,  2.756315719083243e-02, -2.055283632656287e-04,
  1.133779317964312e-06, -5.706406289665383e-09,  2.454111697615153e-11, -2.328753689713172e-14,  4.254230977028016e-15,  7.479791578973862e-17,  2.835553228096015e-19,
 -2.766559184309467e-20, -7.904715888152334e-22, -7.755013123255873e-24,  5.419301755220164e-02, -4.032695074195211e-04,  2.206203780616173e-06, -1.092205803852388e-08,
  4.539330148702002e-11, -2.202861647754593e-14,  8.295545119824703e-15,  1.496957630312580e-16,  5.601614087921334e-19, -5.495501712536160e-20, -1.572228214239593e-21,
 -1.544103922296103e-23,  8.996323018684399e-02, -6.675511179932839e-04,  3.609799462622782e-06, -1.745090093696618e-08,  6.886508033919976e-11,  1.670966154570819e-14,
  1.362857972915064e-14,  2.543726439108016e-16,  9.376074719470617e-19, -9.252421374602386e-20, -2.651312188450548e-21, -2.607870939680282e-23,  1.351114858975551e-01,
 -9.988352422472980e-04,  5.318033017266072e-06, -2.487614998712900e-08,  9.083217907715186e-11,  1.266519562442952e-13,  2.022923789063104e-14,  3.931357093990450e-16,
  1.427529005643836e-18, -1.415331365366779e-19, -4.063037848682983e-21, -4.004780466159103e-23,  1.899505450466623e-01, -1.397581587411739e-03,  7.291929457463422e-06,
 -3.260223392129389e-08,  1.055807914268018e-10,  3.520953578566309e-13,  2.810931487243555e-14,  5.715612245882886e-16,  2.051055782386655e-18, -2.036425295218699e-19,
 -5.857113902350138e-21, -5.788954082312943e-23,  2.548805577476169e-01, -1.864123079484313e-03,  9.474663595514640e-06, -3.978815848306235e-08,  1.053701974487326e-10,
  7.484940392799868e-13,  3.737079880498613e-14,  7.965456771129728e-16,  2.845571308178876e-18, -2.812056087856027e-19, -8.102875887935341e-21, -8.036808872584462e-23,
  3.304060828850627e-01, -2.398450635516749e-03,  1.178296217152666e-05, -4.524564600302401e-08,  7.985881733241847e-11,  1.381353324178734e-12,  4.831331893008901e-14,
  1.076242488709998e-15,  3.875804661181800e-18, -3.775612709416938e-19, -1.089779218139155e-20, -1.085680338002815e-22,  4.171595413218491e-01, -2.999834028287871e-03,
  1.409314436595627e-05, -4.728213778254565e-08,  1.542429946604322e-11,  2.320302440294771e-12,  6.164901277038771e-14,  1.419755522287063e-15,  5.251307997843837e-18,
 -4.974763729288388e-19, -1.438184888602799e-20, -1.440526490346877e-22,  5.159336764881568e-01, -3.666135730314424e-03,  1.621776389795367e-05, -4.345623516304267e-08,
 -1.054284181657418e-10,  3.620535714582438e-12,  7.893857187952320e-14,  1.836456025834477e-15,  7.151175866418445e-18, -6.477887845369727e-19, -1.876319497779927e-20,
 -1.891318642167724e-22,  6.277267847694896e-01, -4.392523348599168e-03,  1.786502054710062e-05, -3.019491687445365e-08, -3.038381474953639e-10,  5.271702111030872e-12,
  1.034886763553225e-13,  2.335207795077540e-15,  9.847325836727095e-18, -8.382518163665993e-19, -2.436669074374865e-20, -2.473484618451878e-22,  7.538059391542196e-01,
 -5.168937004977414e-03,  1.856497836821423e-05, -2.205419596438667e-09, -6.010326241533646e-10,  7.061793050002056e-12,  1.422013623601101e-13,  2.926560796441036e-15,
  1.367229764212265e-17, -1.082342693629041e-18, -3.173089797910605e-20, -3.244728697559921e-22,  8.957941564261372e-01, -5.974795145566614e-03,  1.752830222466040e-05,
  4.834128099871276e-08, -1.002875114152305e-09,  8.213643408303835e-12,  2.091940692282519e-13,  3.645887168401621e-15,  1.868872049318950e-17, -1.397305055599779e-18,
 -4.180369756837279e-20, -4.309784955904588e-22,  1.055781937116708e+00, -6.767019657451856e-03,  1.336037405091820e-05,  1.324281852615314e-07, -1.441709237096057e-09,
  6.409619152860273e-12,  3.309574770477701e-13,  4.693269104007573e-15,  2.313432115789713e-17, -1.805887822775144e-18, -5.627008147267291e-20, -5.897966704587238e-22,
  1.236423578577003e+00, -7.450020809147261e-03,  3.457387273870671e-06,  2.612647075049916e-07, -1.556967066654571e-09, -4.621108554601114e-12,  5.359886973712741e-13,
  7.186226222766865e-15,  1.876698894384521e-17, -2.407550454513580e-18, -7.750587891985490e-20, -8.607050030114121e-22,  1.440744714859802e+00, -7.789836283407679e-03,
 -1.719487876840617e-05,  4.173518718519666e-07,  1.465423876082318e-10, -3.689279718926462e-11,  6.545872329513120e-13,  1.643788959611140e-14,  1.177110268912685e-17,
 -4.293035475366652e-18, -1.091046556643812e-19, -1.284958615851840e-21,  1.669856800550202e+00, -7.130058457653600e-03, -5.621733318635765e-05,  3.431150925553962e-07,
  8.352995101512568e-09, -3.501343429606057e-11, -1.011604576870953e-12,  2.872423441055358e-14,  5.890731210525510e-16, -8.397071268671899e-18, -3.520849697809557e-19,
 -2.231802332865498e-21,  1.904004371298420e+00, -3.610612440918782e-03, -8.285263273720524e-05, -1.172105224830885e-06, -2.852729716969442e-09,  3.464656840826740e-10,
  9.569725990531694e-12,  9.453299608370533e-14, -1.692830793890130e-15, -8.336367284812527e-17, -1.370939114436350e-18,  1.668573161161199e-21,  1.066983022953411e-03,
 -7.857645414502363e-06,  4.296161453855953e-08, -2.168305400435958e-10,  1.054955582895087e-12,  3.681445971030557e-15,  2.504320323866216e-16,  2.399611292489683e-18,
 -5.285012330987735e-20, -2.501363146727789e-21, -3.541309048755125e-23,  2.336063485424337e-25,  9.612903953498113e-03, -7.075305050494129e-05,  3.859011020659998e-07,
 -1.938491687660207e-09,  9.363082411202179e-12,  3.453641646415799e-14,  2.256003884292455e-15,  2.175331134599774e-17, -4.780585720557920e-19, -2.261710397258725e-20,
 -3.203256671998009e-22,  2.109966348119783e-24,  2.675875994684503e-02, -1.967253568329021e-04,  1.067662949600878e-06, -5.311210427108925e-09,  2.526657614445221e-11,
  1.038188275738547e-13,  6.279153661421260e-15,  6.130423990427060e-17, -1.341448844377377e-18, -6.341730289639071e-20, -8.988674981353452e-22,  5.903199452588350e-24,
  5.261442619070699e-02, -3.861317450579364e-04,  2.079521264073742e-06, -1.018703875917471e-08,  4.728420793960760e-11,  2.270975874243775e-13,  1.234761569082577e-14,
  1.227739226977618e-16, -2.669618933609276e-18, -1.260870444865315e-19, -1.789174555870193e-21,  1.169661798684247e-23,  8.734948287569007e-02, -6.394914812651398e-04,
  3.407074956903297e-06, -1.632617880319568e-08,  7.304868976860933e-11,  4.287979566523202e-13,  2.051355609821017e-14,  2.088298597425237e-16, -4.504141423825256e-18,
 -2.125308077930636e-19, -3.020321959464880e-21,  1.962119136068362e-23,  1.311993782415159e-01, -9.574599443494392e-04,  5.028418440064890e-06, -2.337242826415769e-08,
  9.911424157854900e-11,  7.435064949292357e-13,  3.087030532453944e-14,  3.231834664674847e-16, -6.903714753693195e-18, -3.255483111746962e-19, -4.634923295486491e-21,
  2.986362528221961e-23,  1.844744533803343e-01, -1.340781540474376e-03,  6.911204488716167e-06, -3.081448024910810e-08,  1.206685838605760e-10,  1.217683420055577e-12,
  4.358330161156310e-14,  4.707077589360884e-16, -9.947296538228391e-18, -4.691150091800982e-19, -6.693300527649221e-21,  4.267887258379269e-23,  2.475726785543528e-01,
 -1.790205449404650e-03,  9.007993950328073e-06, -3.792611947605803e-08,  1.311204905255798e-10,  1.911584151022363e-12,  5.894749825448370e-14,  6.575493875143148e-16,
 -1.373854564189491e-17, -6.488225689724661e-19, -9.280114938168372e-21,  5.840927058102782e-23,  3.209974030807398e-01, -2.306334447349494e-03,  1.124882482308093e-05,
 -4.367358185592753e-08,  1.215295248321260e-10,  2.900738687373501e-12,  7.749591054187115e-14,  8.911784702588019e-16, -1.841225800975244e-17, -8.725751493078741e-19,
 -1.251510548893709e-20,  7.751439291851239e-23,  4.053821133892812e-01, -2.889350103785586e-03,  1.352906845814253e-05, -4.657010565056957e-08,  7.985870424507291e-11,
  4.275122402109257e-12,  1.002104751549121e-13,  1.180263760168328e-15, -2.414454821469075e-17, -1.151709393100133e-18, -1.657111358138330e-20,  1.006195725832201e-22,
  5.015252828356388e-01, -3.538501935401880e-03,  1.568893911747821e-05, -4.444324960699198e-08, -9.885168746558448e-12,  6.130893223881395e-12,  1.289450334039430e-13,
  1.534192209675925e-15, -3.117208253944978e-17, -1.502836646141466e-18, -2.170589065529193e-20,  1.285991554916925e-22,  6.104401320212131e-01, -4.251126182946259e-03,
  1.747749090789804e-05, -3.405546071821026e-08, -1.682308644401908e-10,  8.540601008063030e-12,  1.673040411914339e-13,  1.962141628353163e-15, -3.983839214666541e-17,
 -1.950943697409116e-18, -2.832182788856422e-20,  1.627265475655708e-22,  7.334268482199509e-01, -5.020674440337389e-03,  1.848615272083839e-05, -1.047842577299714e-08,
 -4.189621396469047e-10,  1.146202520339717e-11,  2.225287751872638e-13,  2.472955186820615e-15, -5.073369127676686e-17, -2.534726238414894e-18, -3.708619528175541e-20,
  2.049439029448404e-22,  8.721787364185828e-01, -5.832506696459955e-03,  1.801852244952416e-05,  3.391746076026126e-08, -7.800194359244093e-10,  1.446807525535536e-11,
  3.096050062852421e-13,  3.085979948015692e-15, -6.518959097703472e-17, -3.316094340683550e-18, -4.918828787094129e-20,  2.582409637046988e-22,  1.028937152048351e+00,
 -6.654159485803261e-03,  1.481686020083105e-05,  1.108631992383241e-07, -1.223325487711410e-09,  1.593648222381283e-11,  4.596100858233086e-13,  3.917068334095833e-15,
 -8.720310896683252e-17, -4.400418862833901e-18, -6.688426787605707e-20,  3.262686775619166e-22,  1.206698068653666e+00, -7.410246642864686e-03,  6.442496189952218e-06,
  2.363811712379067e-07, -1.504525947138619e-09,  1.062194783963700e-11,  7.279426877055652e-13,  5.739718472307699e-15, -1.308584737746265e-16, -6.024511375111525e-18,
 -9.425375168439877e-20,  4.069099395700131e-22,  1.409341960675461e+00, -7.907372322854111e-03, -1.219374770670707e-05,  4.148023943084245e-07, -3.974352070032089e-10,
 -1.579238712698095e-11,  1.090318789996084e-12,  1.340541416226662e-14, -2.322418387779337e-16, -9.453489030108960e-18, -1.358295484072383e-19,  5.436802210783648e-22,
  1.640466294545523e+00, -7.561115876945041e-03, -5.132461679209633e-05,  4.701489483976158e-07,  7.484545280272892e-09, -4.789060828527690e-11, -9.043691091086167e-15,
  3.989305248183487e-14,  1.989911741650050e-17, -2.325480155394694e-17, -3.535010040444914e-19,  2.926851900190860e-21,  1.888146905169698e+00, -4.329858907368643e-03,
 -9.692055854176273e-05, -1.149084765255973e-06,  6.542983718545255e-09,  5.986449593268029e-10,  1.093569036778563e-11, -1.742486067314788e-14, -5.557891299156733e-15,
 -1.245727058055513e-16, -3.154458091301935e-19,  5.281537133534546e-20,  1.036223763277175e-03, -7.524065603269804e-06,  4.046446300750319e-08, -1.990174052466983e-10,
  1.192756767744144e-12,  1.021484206887995e-14,  2.786674343714877e-16, -9.663657315495117e-19, -1.629114000169804e-19, -3.369881847246346e-21,  1.937174535029836e-24,
  1.589740021292447e-24,  9.335922533515171e-03, -6.775627005695369e-05,  3.635708494252533e-07, -1.780049169262889e-09,  1.063216320470339e-11,  9.342783783917374e-14,
  2.512786453478775e-15, -8.688853697155776e-18, -1.473334154268936e-18, -3.047683433515078e-20,  1.732437032086768e-23,  1.437459701558320e-23,  2.598854745513729e-02,
 -1.884319053841866e-04,  1.006450380337398e-06, -4.881679127442951e-09,  2.895412915816603e-11,  2.679298009778421e-13,  7.007321208769544e-15, -2.409239904638229e-17,
 -4.132779351272642e-18, -8.549309096057363e-20,  4.749261021828614e-23,  4.030705596903014e-23,  5.110241608576979e-02, -3.699712368072137e-04,  1.962020772743793e-06,
 -9.377117644140842e-09,  5.499868307807532e-11,  5.503934337191364e-13,  1.381896696978776e-14, -4.711283234678979e-17, -8.221239311094509e-18, -1.700907447361106e-19,
  9.113699474406518e-23,  8.014113142154908e-23,  8.484481849950345e-02, -6.129978350434640e-04,  3.218547654956201e-06, -1.506044557692194e-08,  8.690453860579330e-11,
  9.671711046315969e-13,  2.304418452511897e-14, -7.770836417304974e-17, -1.386608125768966e-17, -2.869574603166225e-19,  1.460479580527514e-22,  1.350836670915314e-22,
  1.274482567497644e-01, -9.183261097163867e-04,  4.758092377485446e-06, -2.162490734766918e-08,  1.219469310840022e-10,  1.556019978370283e-12,  3.483662681679996e-14,
 -1.159498447546211e-16, -2.125211136778996e-17, -4.400458124504218e-19,  2.087429654040516e-22,  2.068991772654991e-22,  1.792196138549797e-01, -1.286935938773215e-03,
  6.554012892306771e-06, -2.862850376395263e-08,  1.562914485050265e-10,  2.368574812633653e-12,  4.943824250283753e-14, -1.621939591948276e-16, -3.063735146814681e-17,
 -6.349723187870173e-19,  2.738388882212482e-22,  2.980769268352820e-22,  2.405531571173989e-01, -1.719922855337587e-03,  8.566993025040801e-06, -3.544040450330791e-08,
  1.846338955239087e-10,  3.473652472468132e-12,  6.723510645138425e-14, -2.174133477533742e-16, -4.237739960771576e-17, -8.796476783921441e-19,  3.329766349600572e-22,
  4.120940068352405e-22,  3.119487806476915e-01, -2.218402023129717e-03,  1.073866992749235e-05, -4.115705394331245e-08,  1.996855523803904e-10,  4.961303939014191e-12,
  8.886015923692871e-14, -2.838289289635702e-16, -5.696353431986492e-17, -1.185282821864715e-18,  3.729198859369893e-22,  5.538353179043725e-22,  3.940376791022589e-01,
 -2.783323804886204e-03,  1.298116425927388e-05, -4.446853976928739e-08,  1.914592130333539e-10,  6.946924991560517e-12,  1.153890213986801e-13, -3.661321433143749e-16,
 -7.508434614302244e-17, -1.568033732545508e-18,  3.720284434406515e-22,  7.302845163899949e-22,  4.876189303752662e-01, -3.415115913949593e-03,  1.515929571559471e-05,
 -4.344044298900747e-08,  1.463440358448530e-10,  9.572844390923397e-12,  1.487292985738594e-13, -4.738658309668028e-16, -9.773102765260631e-17, -2.051779882389245e-18,
  2.933097481148957e-22,  9.517108972676535e-22,  5.937126333260425e-01, -4.112972198378956e-03,  1.705906154510976e-05, -3.514730939980371e-08,  4.613779951639032e-11,
  1.299902439240504e-11,  1.924327100974422e-13, -6.260415001873325e-16, -1.263925916067421e-16, -2.673005474910293e-18,  6.976027601547511e-23,  1.233825495721949e-21,
  7.136389971268845e-01, -4.873382733736970e-03,  1.832874997682329e-05, -1.503865099653089e-08, -1.320468345976854e-10,  1.735641050243557e-11,  2.534800422236054e-13,
 -8.596645601196704e-16, -1.634633059713902e-16, -3.489771733010874e-18, -4.286750853445468e-22,  1.601980093315312e-21,  8.491393166407833e-01, -5.686917906253980e-03,
  1.836157353894092e-05,  2.417936571554068e-08, -4.110864263387207e-10,  2.257688454469565e-11,  3.464058002504177e-13, -1.242042084640672e-15, -2.132431067005655e-16,
 -4.599145718133971e-18, -1.472050138836565e-21,  2.100057629669233e-21,  1.002565576746279e+00, -6.530607642847150e-03,  1.604232261096589e-05,  9.446873124483167e-08,
 -7.877195302354557e-10,  2.780440593628557e-11,  5.030529757065869e-13, -1.861970297764404e-15, -2.849428340027957e-16, -6.174520068347712e-18, -3.625435744868156e-21,
  2.811174494725991e-21,  1.177177578585640e+00, -7.347747068656553e-03,  9.144843784023911e-06,  2.150008246206874e-07, -1.107748416470869e-09,  2.932324545809078e-11,
  7.926725651075413e-13, -2.562369454355579e-15, -4.037615904692097e-16, -8.575148351566573e-18, -7.628933586320045e-21,  3.911695511028896e-21,  1.377548724457457e+00,
 -7.985134102055104e-03, -7.259787392455880e-06,  4.074465579007480e-07, -4.270066032912043e-10,  1.369019253421900e-11,  1.303606804637170e-12, -4.010419596008971e-16,
 -6.532723405301845e-16, -1.310896481987616e-17, -7.876147762798663e-21,  5.885526418585082e-21,  1.609439148747091e+00, -7.947180882210449e-03, -4.499494167932569e-05,
  5.825976620256821e-07,  6.611802111472757e-09, -3.549376052237316e-11,  9.737650717092225e-13,  2.481097888557624e-14, -1.016979537479927e-15, -3.212428457628004e-17,
 -1.286956660141717e-20,  1.347416946464156e-20,  1.869193236090877e+00, -5.157599641658598e-03, -1.096415905017324e-04, -9.349340288599599e-07,  2.097959155990260e-08,
  8.310541841586216e-10,  7.298773750028723e-12, -2.636725877625599e-13, -9.520045113245060e-15, -7.003977582419041e-17,  3.520685244050192e-18,  1.162989341631558e-19,
  1.006760288299884e-03, -7.209560510999525e-06,  3.819862396582676e-08, -1.779567379384439e-10,  1.458236346807823e-12,  1.588144092855447e-14,  1.614295336903799e-16,
 -7.939786941072912e-18, -2.616014492740024e-19, -1.422051865691941e-21,  1.056210635972610e-22,  2.932283881211046e-24,  9.070583598922271e-03, -6.493009121882873e-05,
  3.433027389728196e-07, -1.591900658394692e-09,  1.305237709951340e-11,  1.445142018443651e-13,  1.453920259083746e-15, -7.175677089955109e-17, -2.366032121573102e-18,
 -1.286944432791515e-20,  9.550544703274714e-22,  2.652494960352358e-23,  2.525056375933879e-02, -1.806062831519004e-04,  9.508549081125421e-07, -4.366940486939100e-09,
  3.585090396519868e-11,  4.103352138221014e-13,  4.044907354672776e-15, -2.010127201919374e-16, -6.637847962190719e-18, -3.614991493435887e-20,  2.678122858949806e-21,
  7.443932936162605e-23,  4.965323317433482e-02, -3.547092636039313e-04,  1.855194197815656e-06, -8.392109864044125e-09,  6.903932561327290e-11,  8.310560857352894e-13,
  7.948376843040133e-15, -3.990961099226086e-16, -1.320784542262248e-17, -7.207037276700169e-20,  5.325158905185856e-21,  1.481945188007047e-22,  8.244321487410258e-02,
 -5.879470595797047e-04,  3.046896361299887e-06, -1.348693708084496e-08,  1.113038962070434e-10,  1.434810744865685e-12,  1.319095552830243e-14, -6.714773858119779e-16,
 -2.228518320318712e-17, -1.219361901636831e-19,  8.976792030211957e-21,  2.502316975052404e-22,  1.238494885995331e-01, -8.812635481321486e-04,  4.511467772950695e-06,
 -1.938203564015417e-08,  1.607077093944829e-10,  2.262223957910627e-12,  1.982099571989261e-14, -1.026256374956956e-15, -3.417522062220748e-17, -1.876841783269961e-19,
  1.375104571676696e-20,  3.841400635899129e-22,  1.741746238099674e-01, -1.235831490150164e-03,  6.227237317584510e-06, -2.568820241969538e-08,  2.145007068006591e-10,
  3.369502349884518e-12,  2.792566897869754e-14, -1.475056890509927e-15, -4.930776898717656e-17, -2.720972877646293e-19,  1.981464973023206e-20,  5.550191032672351e-22,
  2.338079226645118e-01, -1.653032003317145e-03,  8.161996543586819e-06, -3.184799580069104e-08,  2.688377397650828e-10,  4.832859251408423e-12,  3.766333007220354e-14,
 -2.034479107587741e-15, -6.828121876185144e-17, -3.791471531363229e-19,  2.740084156871829e-20,  7.700530491257152e-22,  3.032439508716578e-01, -2.134405624012225e-03,
  1.026758751529835e-05, -3.705930398557716e-08,  3.183672391929387e-10,  6.754649291542496e-12,  4.932618780123720e-14, -2.728499639925794e-15, -9.193231625966007e-17,
 -5.145466612484745e-19,  3.683773096480417e-20,  1.039434875914095e-21,  3.831087915278808e-01, -2.681545406337206e-03,  1.247097152820871e-05, -4.015224028653293e-08,
  3.556423088090766e-10,  9.271491167422794e-12,  6.346561221227481e-14, -3.592565242707524e-15, -1.214497965888720e-16, -6.866621482257993e-19,  4.859477516836534e-20,
  1.377897703781864e-21,  4.741977908830614e-01, -3.295871124357348e-03,  1.465897623386285e-05, -3.938506446075735e-08,  3.703130156964857e-10,  1.256392714373813e-11,
  8.115291272740270e-14, -4.680867283263206e-15, -1.585679170583993e-16, -9.080650831553067e-19,  6.336204975049717e-20,  1.807363250257598e-21,  5.775310640619794e-01,
 -3.978152905457879e-03,  1.665107673422882e-05, -3.209362571791504e-08,  3.481527609005304e-10,  1.686419644703907e-11,  1.045488233794064e-13, -6.079894784042151e-15,
 -2.059174117592194e-16, -1.198259809372510e-18,  8.219275356713139e-20,  2.361782000432260e-21,  6.944375699286235e-01, -4.727482065590243e-03,  1.814808444943741e-05,
 -1.406411188610331e-08,  2.704317106906383e-10,  2.244778933104331e-11,  1.382194206846166e-13, -7.934960292429126e-15, -2.677201032946257e-16, -1.588626327468662e-18,
  1.067774557033102e-19,  3.096618943990659e-21,  8.266871587614667e-01, -5.538939394039915e-03,  1.862855568134862e-05,  2.163837794082678e-08,  1.161525957557973e-10,
  2.955406077760435e-11,  1.923748934822708e-13, -1.050417496343491e-14, -3.513453025403250e-16, -2.131527808231628e-18,  1.400229017109391e-19,  4.109158908921134e-21,
  9.767067613571363e-01, -6.397902470325833e-03,  1.712070339888040e-05,  8.693105585378814e-08, -1.212995212618356e-10,  3.802234982746805e-11,  2.913271000656313e-13,
 -1.426619032957033e-14, -4.714707423761019e-16, -2.916848335097210e-18,  1.874558280256078e-19,  5.587102212394087e-21,  1.147948889432772e+00, -7.264518539859541e-03,
  1.164107366664066e-05,  2.029479557029239e-07, -3.455859255397630e-10,  4.574891323982222e-11,  4.955608035861900e-13, -2.006331235219549e-14, -6.642135470259126e-16,
 -4.103929543593332e-18,  2.615844719446620e-19,  7.942505287371656e-21,  1.345522874515206e+00, -8.023739469686982e-03, -2.397004123440600e-06,  4.044529782371731e-07,
  1.447338398673114e-10,  4.205641822381002e-11,  9.318874440494086e-13, -2.828447468975051e-14, -1.049290083360619e-15, -6.156037442810441e-18,  4.036666741199328e-19,
  1.227263387830856e-20,  1.576977262823485e+00, -8.277422161483474e-03, -3.738789276908399e-05,  6.841338598055349e-07,  6.168453994924769e-09, -8.503455136140312e-12,
  1.046153372483518e-12, -2.494510165814494e-14, -2.004958140271741e-15, -1.699809282729660e-17,  8.539801010811324e-19,  2.468969672739984e-20,  1.846747298309468e+00,
 -6.072592759099016e-03, -1.182758239128948e-04, -4.599220856863207e-07,  3.857092801395729e-08,  8.821010512686866e-10, -4.475225921276757e-12, -5.713041184040059e-13,
 -8.263003571767245e-15,  1.716724426200655e-16,  8.178403982870358e-18,  6.053040940509039e-20,  };
  constexpr double w[7296] = {  1.607270146226080e-01, -1.152456439036995e-03,  8.991298534576949e-06, -7.361109565036572e-08,  6.152057376864908e-10,
 -5.165254148293829e-12,  4.321202167669540e-14, -3.589517490668044e-16,  2.956791632223359e-18, -2.414912603376052e-20,  1.956119406249434e-22, -1.572143335166722e-24,
  1.577318807318815e-01, -2.085563258609347e-03,  3.056301733849760e-05, -4.215899612888634e-07,  5.470306042846908e-09, -6.762766519594566e-11,  8.041633682197977e-13,
 -9.256966568359651e-15,  1.036299391513728e-16, -1.132093982699304e-18,  1.210093575994196e-20, -1.268168690407992e-22,  1.519708905633569e-01, -3.827499971744535e-03,
  8.637069890380148e-05, -1.686947338253130e-06,  2.984589231718181e-08, -4.902674047522417e-10,  7.589590803196775e-12, -1.118402534956900e-13,  1.580159754638042e-15,
 -2.152146118055854e-17,  2.837434380960519e-19, -3.632784285494912e-21,  1.438653680802987e-01, -6.153452887948516e-03,  1.964243049510313e-04, -5.161812996246581e-06,
  1.190715458168952e-07, -2.491483027836018e-09,  4.824539920309291e-11, -8.762645874752348e-13,  1.507129940973148e-14, -2.472272592947130e-16,  3.889167869772932e-18,
 -5.891546403488702e-20,  1.339636677874188e-01, -8.778970475594379e-03,  3.795161360214282e-04, -1.295555973785791e-05,  3.774748091196457e-07, -9.773013683376666e-09,
  2.304264076729193e-10, -5.029276222092160e-12,  1.028002432566271e-13, -1.984945111108827e-15,  3.644638939662697e-17, -6.395521304256515e-19,  1.228639457360857e-01,
 -1.140730476683102e-02,  6.446232132836482e-04, -2.776343986577388e-05,  9.961997073684854e-07, -3.119681752464960e-08,  8.770855013004064e-10, -2.255947169067777e-11,
  5.380046121730389e-13, -1.201533757643117e-14,  2.532248848109897e-16, -5.064987662149784e-18,  1.111412743052057e-01, -1.377208543637009e-02,  9.852511688272954e-04,
 -5.218990528690469e-05,  2.256711600141231e-06, -8.384575499236400e-08,  2.761786325030343e-09, -8.235494727106591e-11,  2.256559958869454e-12, -5.744836752752706e-14,
  1.370549649976571e-15, -3.083548400082680e-17,  9.929185991031150e-02, -1.566721523587216e-02,  1.378342076041481e-03, -8.776363685799907e-05,  4.485101520260886e-06,
 -1.943309478109529e-07,  7.383117752773336e-09, -2.515831196188027e-10,  7.814051337456355e-12, -2.239020585758034e-13,  5.974077959373512e-15, -1.494496713410452e-16,
  8.770061551459284e-02, -1.696065335429554e-02,  1.787623546106522e-03, -1.339863034699769e-04,  7.949308093289340e-06, -3.953640802780530e-07,  1.707890585089063e-08,
 -6.563112046539183e-10,  2.282427190278800e-11, -7.276174242475967e-13,  2.147596450975756e-14, -5.911698323038791e-16,  7.663173866246614e-02, -1.759335920773469e-02,
  2.169904089937162e-03, -1.877931172639863e-04,  1.272155054596289e-05, -7.156259744064692e-07,  3.468060314324728e-08, -1.484490444857748e-09,  5.714260109975351e-11,
 -2.004933344063546e-12,  6.479702688637031e-14, -1.943748090330825e-15,  6.623724310576178e-02, -1.756769654231957e-02,  2.482255616173010e-03, -2.436614745778283e-04,
  1.855499669787914e-05, -1.164162562237141e-06,  6.249135652625406e-08, -2.944748702463670e-09,  1.241004977884537e-10, -4.743386126728867e-12,  1.662424692389764e-13,
 -5.384707656095476e-15,  5.657636724095636e-02, -1.693059523292383e-02,  2.688261402060060e-03, -2.943707839994038e-04,  2.483014672411541e-05, -1.714555435736291e-06,
  1.007075823751663e-07, -5.165614399901396e-09,  2.358381473607793e-10, -9.723202506880351e-12,  3.661087813133481e-13, -1.269194450859113e-14,  4.763909791021846e-02,
 -1.575611419737516e-02,  2.762230043597488e-03, -3.322073531023994e-04,  3.060712719199196e-05, -2.296490825804618e-06,  1.458693174016731e-07, -8.055679441148994e-09,
  3.943819549947395e-10, -1.737066865571366e-11,  6.963442660017379e-13, -2.561589413618140e-14,  3.936876260484579e-02, -1.413052301357858e-02,  2.691088530653845e-03,
 -3.503017016396228e-04,  3.478384506293318e-05, -2.801176382864653e-06,  1.902238525540991e-07, -1.119050088100572e-08,  5.816258028798508e-10, -2.711180813729487e-11,
  1.146860979130390e-12, -4.439242438677612e-14,  3.168076717933893e-02, -1.214137334459445e-02,  2.474283937617730e-03, -3.437966771020638e-04,  3.632331598543561e-05,
 -3.102332491911917e-06,  2.227411182476629e-07, -1.381325423824384e-08,  7.547505692701159e-10, -3.689006846792517e-11,  1.632305235021165e-12, -6.593414908448380e-14,
  2.447640058783464e-02, -9.870742938231444e-03,  2.122332115314784e-03, -3.106373463820002e-04,  3.449103961839139e-05, -3.088216619485382e-06,  2.318846935952076e-07,
 -1.500447049886922e-08,  8.535625456507036e-10, -4.334676424524317e-11,  1.988949010677309e-12, -8.315330894878482e-14,  1.765190903806954e-02, -7.392080819281607e-03,
  1.654687742318114e-03, -2.518939438755182e-04,  2.904126777053228e-05, -2.695170296819508e-06,  2.093866929531694e-07, -1.399435663106089e-08,  8.209456708151103e-10,
 -4.292504609449798e-11,  2.024963109983500e-12, -8.691243312853747e-14,  1.110398864954148e-02, -4.769910430163591e-03,  1.097499394958441e-03, -1.716368646746594e-04,
  2.030716843160291e-05, -1.931724503779522e-06,  1.536437078708234e-07, -1.050077873134585e-08,  6.292206846278836e-10, -3.357063752982982e-11,  1.614320368496617e-12,
 -7.055752039331405e-14,  4.739198989648546e-03, -2.064347781238087e-03,  4.822355051500111e-04, -7.654790174636288e-05,  9.187419935694691e-06, -8.859960717551002e-07,
  7.139387920907324e-08, -4.940274353065432e-09,  2.995368433694807e-10, -1.616109982062208e-11,  7.854595555964233e-13, -3.467839103192619e-14,  1.562556815289404e-01,
 -1.083899548703443e-03,  8.163789702006766e-06, -6.454113068122548e-08,  5.215094714617259e-10, -4.238834128241538e-12,  3.436535211885859e-14, -2.768596011476746e-16,
  2.213079464189028e-18, -1.754787891047172e-20,  1.380410836814104e-22, -1.077760985229982e-24,  1.498485682887832e-01, -1.859903907699535e-03,  2.598762415709010e-05,
 -3.439186980701195e-07,  4.291545330401228e-09, -5.109792853677220e-11,  5.858754638227182e-13, -6.509379276953907e-15,  7.039384599306081e-17, -7.434178768325941e-19,
  7.686990056128483e-21, -7.797599179164052e-23,  1.379251672009744e-01, -3.210075575647623e-03,  6.869833816356051e-05, -1.278929396109274e-06,  2.163514664605179e-08,
 -3.406263587716935e-10,  5.063479042620522e-12, -7.175918904475894e-14,  9.763088091320306e-16, -1.281878720865786e-17,  1.630853918587800e-19, -2.016638145804248e-21,
  1.220432468840762e-01, -4.800854100699836e-03,  1.444521837402232e-04, -3.599850800202539e-06,  7.908370857382411e-08, -1.580784188577904e-09,  2.931184965071498e-11,
 -5.107865133597203e-13,  8.442733369754117e-15, -1.332820952155916e-16,  2.020306001415660e-18, -2.952336698952298e-20,  1.040629852159830e-01, -6.275151119623413e-03,
  2.546937460596038e-04, -8.221116493069663e-06,  2.275841061494748e-07, -5.618071086416357e-09,  1.266454814888486e-10, -2.648743906570416e-12,  5.197965239142844e-14,
 -9.651830498618778e-16,  1.706753046353817e-17, -2.888165385413256e-19,  8.576690965905290e-02, -7.352926343310114e-03,  3.896995236954191e-04, -1.585629048721732e-05,
  5.401808752037930e-07, -1.612057013796005e-08,  4.331822912298964e-10, -1.067520854388450e-11,  2.444301663755946e-13, -5.250634113696922e-15,  1.066067186453515e-16,
 -2.057278011330926e-18,  6.857441839442717e-02, -7.888784814006563e-03,  5.301085934152838e-04, -2.655490674403816e-05,  1.091097940311464e-06, -3.866385948549648e-08,
  1.218290542114007e-09, -3.483982610238267e-11,  9.174738390922741e-13, -2.249073385666368e-14,  5.175203917028737e-16, -1.124752315126786e-17,  5.340568956295957e-02,
 -7.876133017036654e-03,  6.531759163505678e-04, -3.943549576685431e-05,  1.919382872429131e-06, -7.948251441259150e-08,  2.894463271034075e-09, -9.477131302083256e-11,
  2.834428397758457e-12, -7.835345547726812e-14,  2.020280644882886e-15, -4.891582280556219e-17,  4.068778419285085e-02, -7.410968696115698e-03,  7.400495451163654e-04,
 -5.280833906764968e-05,  2.994409075266387e-06, -1.427913631676556e-07,  5.930007049613443e-09, -2.195845597851802e-10,  7.373401852350775e-12, -2.273719658171199e-13,
  6.502100610918051e-15, -1.736737546555066e-16,  3.045504337741553e-02, -6.639444468390829e-03,  7.806046720414812e-04, -6.464632767880900e-05,  4.204321028701456e-06,
 -2.276881008123226e-07,  1.064831047497796e-08, -4.407810471124486e-10,  1.643860710291156e-11, -5.597426461152683e-13,  1.758253433217598e-14, -5.133533011747979e-16,
  2.248577923525522e-02, -5.710789753242513e-03,  7.744030346802944e-04, -7.316616364383561e-05,  5.376964674622939e-06, -3.263291280591076e-07,  1.697937519495453e-08,
 -7.769693331490655e-10,  3.184894689274545e-11, -1.185821173454808e-12,  4.053844518615032e-14, -1.282428609616240e-15,  1.643012775611951e-02, -4.747118956143830e-03,
  7.284755971928183e-04, -7.725730486927972e-05,  6.324436307829957e-06, -4.246283729761638e-07,  2.429243955631033e-08, -1.215477572120654e-09,  5.420722979834793e-11,
 -2.185844106856886e-12,  8.059142543951735e-14, -2.738752307806741e-15,  1.190549044947729e-02, -3.831421102093418e-03,  6.536890508920753e-04, -7.662158071150771e-05,
  6.890707077140504e-06, -5.054013957392236e-07,  3.142293969394694e-08, -1.700699148538103e-09,  8.169045201377441e-11, -3.533835612064761e-12,  1.392645793999240e-13,
 -5.040886440578280e-15,  8.554766007468963e-03, -3.008862673309465e-03,  5.613391026699233e-04, -7.164734926640477e-05,  6.983454410581804e-06, -5.526256523512433e-07,
  3.691371659738461e-08, -2.137997785950102e-09,  1.094986081517026e-10, -5.033555669068031e-12,  2.101345555215463e-13, -8.032921373154870e-15,  6.073630686450368e-03,
 -2.294922677612440e-03,  4.608707373616571e-04, -6.314002577101421e-05,  6.582296345566374e-06, -5.551208000975114e-07,  3.938318577993250e-08, -2.414921717554435e-09,
  1.305488830753370e-10, -6.316688793208195e-12,  2.768358019909655e-13, -1.108144061367717e-14,  4.216870695338566e-03, -1.685151364318866e-03,  3.588690409811883e-04,
 -5.204057024328268e-05,  5.727333095827654e-06, -5.085245118510907e-07,  3.788162499983798e-08, -2.432842227237115e-09,  1.374164206042740e-10, -6.931579343974308e-12,
  3.160262251456483e-13, -1.313262277957350e-14,  2.792953259404540e-03, -1.163552878203367e-03,  2.590150939054562e-04, -3.921728771058074e-05,  4.498092298007905e-06,
 -4.153956052694427e-07,  3.212151800800479e-08, -2.137346992045110e-09,  1.248561316433265e-10, -6.502376037170679e-12,  3.055843913572793e-13, -1.306876027706245e-14,
  1.653419367733669e-03, -7.085099283614471e-04,  1.625850057888775e-04, -2.535991876460065e-05,  2.992887862970853e-06, -2.840127453667595e-07,  2.253756226579684e-08,
 -1.536949564264484e-09,  9.190334979994435e-11, -4.893506249871386e-12,  2.348670711605794e-13, -1.024677323549644e-14,  6.818275187574004e-04, -2.967179570120045e-04,
  6.924176864689092e-05, -1.097972848151797e-05,  1.316473129805153e-06, -1.268305228825664e-07,  1.021034923496197e-08, -7.058823122430419e-10,  4.276088570731132e-11,
 -2.305131220373391e-12,  1.119410550725907e-13, -4.938309431563783e-15,  1.520459909598992e-01, -1.021551519194088e-03,  7.436701701136784e-06, -5.683287902720532e-08,
  4.443915685917384e-10, -3.499635793349294e-12,  2.751686702319517e-14, -2.151691133765346e-16,  1.670309397240542e-18, -1.286762541527694e-20,  9.837647616795893e-23,
 -7.466941834888940e-25,  1.428001682748579e-01, -1.667416707034556e-03,  2.224117928788444e-05, -2.827233466000929e-07,  3.396651405895006e-09, -3.899228690838053e-11,
  4.315131280345137e-13, -4.631748930398541e-15,  4.842900231952734e-17, -4.948514045418850e-19,  4.953816344965698e-21, -4.867794935847283e-23,  1.260945151443198e-01,
 -2.716470727109383e-03,  5.522300943870720e-05, -9.812891738208779e-07,  1.589169152379862e-08, -2.400689555818884e-10,  3.430296103864312e-12, -4.679691397255188e-14,
  6.136427586666578e-16, -7.773614188029569e-18,  9.550874235612082e-20, -1.141495122079257e-21,  1.049049628349725e-01, -3.798695255290370e-03,  1.079144277343181e-04,
 -2.553579480648658e-06,  5.348521465677955e-08, -1.022328001018528e-09,  1.816889305072389e-11, -3.040200829081985e-13,  4.832873482849865e-15, -7.347549995695584e-17,
  1.073878013246015e-18, -1.514747617820441e-20,  8.249002324375415e-02, -4.577891148938633e-03,  1.746538748063018e-04, -5.335720266549019e-06,  1.404607700239703e-07,
 -3.308543729452993e-09,  7.135673398292645e-11, -1.430963388589796e-12,  2.697526553909399e-14, -4.819241043446822e-16,  8.210832070627235e-18, -1.340417822569220e-19,
  6.156451883835452e-02, -4.870783188855384e-03,  2.422278258746145e-04, -9.315523423312293e-06,  3.014431818002886e-07, -8.576297596773742e-09,  2.203448727714112e-10,
 -5.204275442439933e-12,  1.144387300490244e-13, -2.365000456294596e-15,  4.626827961551501e-17, -8.615653054308326e-19,  4.383559076777980e-02, -4.675654378218895e-03,
  2.950420565630020e-04, -1.397524150105230e-05,  5.456171306884627e-07, -1.843957034438945e-08,  5.557945032402720e-10, -1.524187818707331e-11,  3.857281350699645e-13,
 -9.103855237477894e-15,  2.020231907301746e-16, -4.240716192080887e-18,  2.995883541816433e-02, -4.121680455546964e-03,  3.218940026732674e-04, -1.841464627622356e-05,
  8.531115790818830e-07, -3.374714349662433e-08,  1.177412448534958e-09, -3.702621990692555e-11,  1.065860830772539e-12, -2.841280685709363e-14,  7.076499498333876e-16,
 -1.657593830350378e-17,  1.978757743462640e-02, -3.386417104019230e-03,  3.198810267006554e-04, -2.170422403778192e-05,  1.174979738743038e-06, -5.367005582965935e-08,
  2.140903133608271e-09, -7.632820300207021e-11,  2.472815950148051e-12, -7.370521260133945e-14,  2.040641597785820e-15, -5.285186463119704e-17,  1.272457391530884e-02,
 -2.627121879912651e-03,  2.938383081391397e-04, -2.324691784938863e-05,  1.449349829451549e-06, -7.546481873817128e-08,  3.401731671432090e-09, -1.360206514549935e-10,
  4.909598329941414e-12, -1.620747679874350e-13,  4.943429578364940e-15, -1.403496611221813e-16,  8.027951812365037e-03, -1.946955419456714e-03,  2.528028834197073e-04,
 -2.294469114996382e-05,  1.624469531655342e-06, -9.521742956167927e-08,  4.795314385208967e-09, -2.128004247100812e-10,  8.473940066817696e-12, -3.069765763769749e-13,
  1.022493487505957e-14, -3.155795223846484e-16,  5.006448014252239e-03, -1.392848105947786e-03,  2.060973095350848e-04, -2.112583428287111e-05,  1.675322201266218e-06,
 -1.091880324784442e-07,  6.074635274306925e-09, -2.960677625521215e-10,  1.288068911000839e-11, -5.073670384512128e-13,  1.829556770313698e-14, -6.087911584908597e-16,
  3.106814821654421e-03, -9.705368333507937e-04,  1.607998382904277e-04, -1.833369924755992e-05,  1.606543179579734e-06, -1.149977217832697e-07,  6.988083740755834e-09,
 -3.701473962703942e-10,  1.742131988324312e-11, -7.392657930489777e-13,  2.860765319640386e-14, -1.017790377744209e-15,  1.927837769180713e-03, -6.631176305495724e-04,
  1.209646332372728e-04, -1.511305220856165e-05,  1.443695890137270e-06, -1.120999771056408e-07,  7.355492856684132e-09, -4.189132606571625e-10,  2.111672905970349e-11,
 -9.562481395300602e-13,  3.935670578686520e-14, -1.484413294612977e-15,  1.197781820796060e-03, -4.455466036590855e-04,  8.804388515905845e-05, -1.187701923452410e-05,
  1.220173439277504e-06, -1.014918689062441e-07,  7.107129054884762e-09, -4.304707668272170e-10,  2.300203329049111e-11, -1.100801584054926e-12,  4.774444509526681e-14,
 -1.892449966469582e-15,  7.410384622584696e-04, -2.931529654571579e-04,  6.177050131121091e-05, -8.866134299299891e-06,  9.662998354047861e-07, -8.500913951880735e-08,
  6.277632007940952e-09, -3.998543858929778e-10,  2.240997033601803e-11, -1.122098099301795e-12,  5.080270989021731e-14, -2.097226605875531e-15,  4.472791183704145e-04,
 -1.852645158888507e-04,  4.098793805823991e-05, -6.168890323771763e-06,  7.035160288889508e-07, -6.461733277209741e-08,  4.971044787137593e-09, -3.291611015580804e-10,
  1.913973739764845e-11, -9.924184773427442e-13,  4.644597818694338e-14, -1.978524268035692e-15,  2.476777709761983e-04, -1.058438431261374e-04,  2.421687764740052e-05,
 -3.766420349892691e-06,  4.432654929854566e-07, -4.195255469125840e-08,  3.320695869188459e-09, -2.259102445111995e-10,  1.347757665266260e-11, -7.160643494568659e-13,
  3.429651827446021e-14, -1.493328419344824e-15,  9.832328334001268e-05, -4.274477629244031e-05,  9.963656006164151e-06, -1.578177252145854e-06,  1.890175621453791e-07,
 -1.819093728446828e-08,  1.462947706188610e-09, -1.010399282065536e-10,  6.114980538389890e-12, -3.293413233548996e-13,  1.597923706824218e-14, -7.043285711962559e-16,
  1.480746167263912e-01, -9.646701053418351e-04,  6.795169868174760e-06, -5.024861863546623e-08,  3.805443896661671e-10, -2.905890351929009e-12,  2.217585537554572e-14,
 -1.684313060914870e-16,  1.270658082818876e-18, -9.517360539717851e-21,  7.076528960005905e-23, -5.225364841134676e-25,  1.364661038671850e-01, -1.502189923495283e-03,
  1.915055213461315e-05, -2.340941387036510e-07,  2.710703867330507e-09, -3.003231050884264e-11,  3.210924250383865e-13, -3.332635264606123e-15,  3.371978967387810e-17,
 -3.336418801626787e-19,  3.236151900311115e-21, -3.082747218866746e-23,  1.160432778126874e-01, -2.317803895628292e-03,  4.482805788025125e-05, -7.613686924302269e-07,
  1.181790727086359e-08, -1.714811408434243e-10,  2.357562143364328e-12, -3.098867033794900e-14,  3.919785004462527e-16, -4.794768438278345e-18,  5.693387814535098e-20,
 -6.581619810688317e-22,  9.126140797433419e-02, -3.044816874560190e-03,  8.180084930745592e-05, -1.840304780092815e-06,  3.679060076806982e-08, -6.731266662073220e-10,
  1.147614158266499e-11, -1.845473037741535e-13,  2.823595033737021e-15, -4.137090722812458e-17,  5.833905012703511e-19, -7.947773965996798e-21,  6.661539929340604e-02,
 -3.403055002617463e-03,  1.221938327679373e-04, -3.536718744501404e-06,  8.861359416035735e-08, -1.993263735455405e-09,  4.115941396784287e-11, -7.919286029871742e-13,
  1.434894447025409e-14, -2.467733113361132e-16,  4.052855045340565e-18, -6.385605558690770e-20,  4.534970269582283e-02, -3.309501262239180e-03,  1.545310483202797e-04,
 -5.620305416746530e-06,  1.728427199737432e-07, -4.690368490925352e-09,  1.152675367299417e-10, -2.610220807909466e-12,  5.513969277485223e-14, -1.096589753379158e-15,
  2.067654045975130e-17, -3.715899941051094e-19,  2.896925222008339e-02, -2.861671565191388e-03,  1.695524185568919e-04, -7.594345955389503e-06,  2.817486241612730e-07,
 -9.081926398802480e-09,  2.618685956656724e-10, -6.886846825579703e-12,  1.674906096037365e-13, -3.805914102164262e-15,  8.144527265538017e-17, -1.651124145378738e-18,
  1.749359363946419e-02, -2.241210979878438e-03,  1.646980160821329e-04, -8.922639647599172e-06,  3.932925770906468e-07, -1.485605544375695e-08,  4.964054730934132e-10,
 -1.498786578394795e-11,  4.151305537853323e-13, -1.066765968289802e-14,  2.565497302817295e-16, -5.811612013455101e-18,  1.007323795031322e-02, -1.616066440116213e-03,
  1.441923017709548e-04, -9.292436911633153e-06,  4.798302554719125e-07, -2.097684030737730e-08,  8.031297742409285e-10, -2.754886431229838e-11,  8.605047811730101e-13,
 -2.477474193484462e-14,  6.636648427642429e-16, -1.665635301498746e-17,  5.585821165152047e-03, -1.089267586928242e-03,  1.156781956620911e-04, -8.729034908485659e-06,
  5.209980275359247e-07, -2.604967184616059e-08,  1.130537681089778e-09, -4.362119281751919e-11,  1.522328624924327e-12, -4.867604223300665e-14,  1.440311285896596e-15,
 -3.972919694625217e-17,  3.015289346092485e-03, -6.963273652536034e-04,  8.638117929223329e-05, -7.517044754971967e-06,  5.118561088932193e-07, -2.893203496143036e-08,
  1.408343263081303e-09, -6.053049103112968e-11,  2.338734100612804e-12, -8.233751836712844e-14,  2.669235396234061e-15, -8.029071323198547e-17,  1.602646494269379e-03,
 -4.281368039764908e-04,  6.094116974882282e-05, -6.025228081373411e-06,  4.620175372402199e-07, -2.918070263466203e-08,  1.576352741191166e-09, -7.473034590283160e-11,
  3.167384883174205e-12, -1.217189452792195e-13,  4.287648890823013e-15, -1.395438315825947e-16,  8.482337637665190e-04, -2.565577474519537e-04,  4.118469049285672e-05,
 -4.558302632980265e-06,  3.884867817488216e-07, -2.709357516669704e-08,  1.606643299703450e-09, -8.316605222465850e-11,  3.830282983424447e-12, -1.592382411129723e-13,
  6.043675298931809e-15, -2.111063698584879e-16,  4.515929877218251e-04, -1.515845304789457e-04,  2.698351363292780e-05, -3.293961239124332e-06,  3.078716813117876e-07,
 -2.342075115021471e-08,  1.507436163962927e-09, -8.430828850219803e-11,  4.177715212613579e-12, -1.861485674494570e-13,  7.545073163247124e-15, -2.804904795449610e-16,
  2.435427053379412e-04, -8.903556320150055e-05,  1.728495164156780e-05, -2.292522778911902e-06,  2.317785243516870e-07, -1.899027320734012e-08,  1.311059765286478e-09,
 -7.835264838086095e-11,  4.134140926371255e-12, -1.954969994660606e-13,  8.383910552802216e-15, -3.287849655517079e-16,  1.330808072618806e-04, -5.205675721292765e-05,
  1.084072048381378e-05, -1.538483807051386e-06,  1.658840546332784e-07, -1.444608766006784e-08,  1.056622491848633e-09, -6.669573931690886e-11,  3.706185978192895e-12,
 -1.840810255754708e-13,  8.270770509153897e-15, -3.389758248217387e-16,  7.259108576254314e-05, -2.987422881672282e-05,  6.564265121052124e-06, -9.814117732981377e-07,
  1.112162268553291e-07, -1.015398160408535e-08,  7.767262886662750e-10, -5.115578437642578e-11,  2.959465048025056e-12, -1.527144993242529e-13,  7.114614228519652e-15,
 -3.017656554704925e-16,  3.734766075684759e-05, -1.591201372898743e-05,  3.628744709638803e-06, -5.625702134574915e-07,  6.600526364171051e-08, -6.228769067107260e-09,
  4.916591797206270e-10, -3.335968066725425e-11,  1.985204702366002e-12, -1.052219757181364e-13,  5.028234955735675e-15, -2.184649282023363e-16,  1.421457915444785e-05,
 -6.172765151155537e-06,  1.437095513666337e-06, -2.273506843628858e-07,  2.719759250629427e-08, -2.614498259039448e-09,  2.100316769290111e-10, -1.449069547119383e-11,
  8.760893103410127e-13, -4.713818008870610e-14,  2.284921774827198e-15, -1.006225033279320e-16,  1.443209806608778e-01, -9.126214087349637e-04,  6.226890298420725e-06,
 -4.459745821488814e-08,  3.273892560532905e-10, -2.425966152502491e-12,  1.798117517352910e-14, -1.327478713407521e-16,  9.739003244888719e-19, -7.097231593585120e-21,
  5.135552063506946e-23, -3.691701525196355e-25,  1.307469458230494e-01, -1.359527791513734e-03,  1.658310330975728e-05, -1.951390088529962e-07,  2.180147535973510e-09,
 -2.333419352144907e-11,  2.412433027333112e-13, -2.423224440925867e-15,  2.374561470785411e-17, -2.276916400138472e-19,  2.141445902649767e-21, -1.979017364916473e-23,
  1.074356650533576e-01, -1.992752704845916e-03,  3.672218460222243e-05, -5.969163078708465e-07,  8.890518573973363e-09, -1.240395224964669e-10,  1.642370377702368e-12,
 -2.081855477762918e-14,  2.542335707749756e-16, -3.005231478237779e-18,  3.451337634571005e-20, -3.861776973382618e-22,  8.026398220620322e-02, -2.469671625928201e-03,
  6.284890748748267e-05, -1.345979911583122e-06,  2.571125198807323e-08, -4.507276210098243e-10,  7.378431880060169e-12, -1.141227220340471e-13,  1.681858434803043e-15,
 -2.376538106321340e-17,  3.235541022014730e-19, -4.259907130707244e-21,  5.471992083824655e-02, -2.573878973722916e-03,  8.709985454853607e-05, -2.390852364476633e-06,
  5.706747995916104e-08, -1.226852469975232e-09,  2.427304538347176e-11, -4.483890579608984e-13,  7.813569086116452e-15, -1.294294050571828e-16,  2.050069848803697e-18,
 -3.118861225827236e-20,  3.421511864625831e-02, -2.302277397153693e-03,  1.010113523403171e-04, -3.476650914244904e-06,  1.016737334524348e-07, -2.633069417317922e-09,
  6.192546291274928e-11, -1.345049164636125e-12,  2.730631981089951e-14, -5.227667200451086e-16,  9.502717574653538e-18, -1.648625717892553e-19,  1.975067021660777e-02,
 -1.805017446543970e-03,  1.004241458491448e-04, -4.254091595597400e-06,  1.500038515535595e-07, -4.612614441050837e-09,  1.272501369065479e-10, -3.209654930430234e-12,
  7.502261218245678e-14, -1.641376917777417e-15,  3.387321695108281e-17, -6.631983430208388e-19,  1.061159834080179e-02, -1.263926233216108e-03,  8.734071641016173e-05,
 -4.479228197993792e-06,  1.877914350893780e-07, -6.771862193780274e-09,  2.166590749282579e-10, -6.279100533343899e-12,  1.672971356710808e-13, -4.143163983480457e-15,
  9.618693562559176e-17, -2.106610098613423e-18,  5.359257718129121e-03, -8.042384037802087e-04,  6.769275829886896e-05, -4.139451326387725e-06,  2.037161362292341e-07,
 -8.517690253011763e-09,  3.127994340696026e-10, -1.031685408309352e-11,  3.105155456439474e-13, -8.630563012767292e-15,  2.235656496456710e-16, -5.434148202942047e-18,
  2.574012661470523e-03, -4.728630104544559e-04,  4.759344893132985e-05, -3.420441450219732e-06,  1.951943906889353e-07, -9.361392428047133e-09,  3.907539270116118e-10,
 -1.453470373801096e-11,  4.899955394894940e-13, -1.516210515428338e-14,  4.348769054666147e-16, -1.164499638783134e-17,  1.191512639665822e-03, -2.612623441770596e-04,
  3.089611675888983e-05, -2.573092416610993e-06,  1.682375985348139e-07, -9.156857365935815e-09,  4.302528570235925e-10, -1.788791514496097e-11,  6.698125823690919e-13,
 -2.289222016656896e-14,  7.215304203387745e-16, -2.113133769980755e-17,  5.395135518090775e-04, -1.379947236031422e-04,  1.885001564208383e-05, -1.793889490408699e-06,
  1.327639686899690e-07, -8.112452263512762e-09,  4.248695128605481e-10, -1.956380458773733e-11,  8.067422489229573e-13, -3.020803167227336e-14,  1.038261406451903e-15,
 -3.301256500057762e-17,  2.427408179053219e-04, -7.089366238384532e-05,  1.100036486737551e-05, -1.179408625934364e-06,  9.757642818958024e-08, -6.618767298126188e-09,
  3.824044941229408e-10, -1.931604745163626e-11,  8.693269715488553e-13, -3.536191755967465e-14,  1.314721981356062e-15, -4.503605090417403e-17,  1.102176678680655e-04,
 -3.601875402030506e-05,  6.243348474778443e-06, -7.432253494407511e-07,  6.784701156704172e-08, -5.048443864210897e-09,  3.182556747238865e-10, -1.745509310316244e-11,
  8.491679803737321e-13, -3.718473855290655e-14,  1.482620615862170e-15, -5.426740971744970e-17,  5.117811063835428e-05, -1.835462276369438e-05,  3.494508636622946e-06,
 -4.549522407185995e-07,  4.519848196105757e-08, -3.642783645920622e-09,  2.476284489238325e-10, -1.458479854380518e-11,  7.590374973869277e-13, -3.543103236432456e-14,
  1.500946969864123e-15, -5.818394881351799e-17,  2.447395298639227e-05, -9.453982989096087e-06,  1.943287246910977e-06, -2.723554674562653e-07,  2.902031716578674e-08,
 -2.499165336483165e-09,  1.808803214881531e-10, -1.130467701699183e-11,  6.223284131433775e-13, -3.063798746592122e-14,  1.365105803580960e-15, -5.550882132460277e-17,
  1.195607407379430e-05, -4.885059888926570e-06,  1.065236576489743e-06, -1.580900894185226e-07,  1.778983838838759e-08, -1.613446923167116e-09,  1.226478601801198e-10,
 -8.029919209598217e-12,  4.619506357523115e-13, -2.371159414668916e-14,  1.099140834159604e-15, -4.639954578930503e-17,  5.673105187822357e-06, -2.408873749588347e-06,
  5.473501330382717e-07, -8.455578589782968e-08,  9.887104678454911e-09, -9.300119040668205e-10,  7.318415305022718e-11, -4.951187079364555e-12,  2.938269055207545e-13,
 -1.553287971978097e-14,  7.404181799099048e-16, -3.209335993297675e-17,  2.060636290691579e-06, -8.937640174777972e-07,  2.078033614181586e-07, -3.283157959873379e-08,
  3.922572599869595e-09, -3.766113388738196e-10,  3.021860161556980e-11, -2.082490234801141e-12,  1.257665759478795e-13, -6.759753501667984e-15,  3.273314806603352e-16,
 -1.440082840877319e-17,  1.407668569042659e-01, -8.648614556232671e-04,  5.721621676400642e-06, -3.972514054191524e-08,  2.829015905076801e-10, -2.035722264855759e-12,
  1.466478485873060e-14, -1.053042799444463e-16,  7.517763677903972e-19, -5.333855192242582e-21,  3.758342439514451e-23, -2.631930428265091e-25,  1.255601266022016e-01,
 -1.235670170069040e-03,  1.443628829622574e-05, -1.636971537863305e-07,  1.766279827614172e-09, -1.827971593683303e-11,  1.829074849648647e-13, -1.779545702559304e-15,
  1.690181651438491e-17, -1.571785529478971e-19,  1.434434857221361e-21, -1.286951201022059e-23,  1.000100253348252e-01, -1.725384536639312e-03,  3.033724564444027e-05,
 -4.725555293520339e-07,  6.761039663738650e-09, -9.078956106697043e-11,  1.158806444671590e-12, -1.417763526575016e-14,  1.672865111861955e-16, -1.912397321707884e-18,
  2.125736758975977e-20, -2.303809952440572e-22,  7.129762626811234e-02, -2.025121519344087e-03,  4.889638938598431e-05, -9.980811712834151e-07,  1.823706710610818e-08,
 -3.066184167002865e-10,  4.823740639868340e-12, -7.181958020743431e-14,  1.020261273493893e-15, -1.391346392289188e-17,  1.830040581476700e-19, -2.329956336262888e-21,
  4.565598858927233e-02, -1.977997174856326e-03,  6.317036109790996e-05, -1.646227438190570e-06,  3.746863093015416e-08, -7.705037258266278e-10,  1.461715515545903e-11,
 -2.594214707836875e-13,  4.350437760473259e-15, -6.944970481319153e-17,  1.061467239467205e-18, -1.560013852114571e-20,  2.639232238775512e-02, -1.636945259268621e-03,
  6.754481723707602e-05, -2.201639384018852e-06,  6.126892653168719e-08, -1.515134605594384e-09,  3.411905327459536e-11, -7.111663526657596e-13,  1.388091085410842e-14,
 -2.559120397781036e-16,  4.486223585242887e-18, -7.515699084961612e-20,  1.386362768971810e-02, -1.171086794488557e-03,  6.119549523144092e-05, -2.452406828494195e-06,
  8.221243001679553e-08, -2.412265010619570e-09,  6.368558802215619e-11, -1.540947768915890e-12,  3.462211060081887e-14, -7.294076599686699e-16,  1.451772331261702e-17,
 -2.745260299643378e-19,  6.673461211844360e-03, -7.378398741842212e-04,  4.792317685278025e-05, -2.325968985919049e-06,  9.273696855802580e-08, -3.192037011806937e-09,
  9.777152587726562e-11, -2.719488809100460e-12,  6.968770924748058e-14, -1.662969097915617e-15,  3.726215473205917e-17, -7.888412682232272e-19,  2.974775717287576e-03,
 -4.166927789534354e-04,  3.304899350649560e-05, -1.916099867839457e-06,  8.981260193950283e-08, -3.589422110407696e-09,  1.263670778776556e-10, -4.005503760269292e-12,
  1.161087720360933e-13, -3.113938176048419e-15,  7.796388857095248e-17, -1.834453692660295e-18,  1.243760637277619e-03, -2.146993930357627e-04,  2.044545659943191e-05,
 -1.397554931788012e-06,  7.616828402973767e-08, -3.500370403843587e-09,  1.403956989855667e-10, -5.030023775794220e-12,  1.636716914696626e-13, -4.897325057208736e-15,
  1.360506949123720e-16, -3.534042621628877e-18,  4.952367442959311e-04, -1.028117645239591e-04,  1.156535772575746e-05, -9.201579673973694e-07,  5.768010224124118e-08,
 -3.018839750056622e-09,  1.367458812603389e-10, -5.492986100930486e-12,  1.991167857895693e-13, -6.599397525273659e-15,  2.020290944044206e-16, -5.755238148827424e-18,
  1.911399274621685e-04, -4.666984555229461e-05,  6.103255892128255e-06, -5.579187692066543e-07,  3.977978809863282e-08, -2.347755879136689e-09,  1.190269834597504e-10,
 -5.316042454582010e-12,  2.129992916711903e-13, -7.761757063305423e-15,  2.599921865756178e-16, -8.067368475673368e-18,  7.293287560975487e-05, -2.050883082438142e-05,
  3.068483461766757e-06, -3.180038416986497e-07,  2.549050743215789e-08, -1.678753386960997e-09,  9.434558242585677e-11, -4.643369688853755e-12,  2.039247838837828e-13,
 -8.105663917632765e-15,  2.948453130266125e-16, -9.893269808435317e-18,  2.809223003626129e-05, -8.915252465221407e-06,  1.501331064099831e-06, -1.739282772733657e-07,
  1.547852271343447e-08, -1.124633292743289e-09,  6.933095759067389e-11, -3.723531832803534e-12,  1.775988626141791e-13, -7.633272086605288e-15,  2.990342438326942e-16,
 -1.076462424693684e-17,  1.114282041158133e-05, -3.912418209445878e-06,  7.291036426473734e-07, -9.301220338821151e-08,  9.065605321626438e-09, -7.176523214056715e-10,
  4.796919701552735e-11, -2.780863247869704e-12,  1.425806587255814e-13, -6.562484050116910e-15,  2.743323254659341e-16, -1.050190566755538e-17,  4.619266772917670e-06,
 -1.759557666487564e-06,  3.564922846816804e-07, -4.927645066657954e-08,  5.182377909253829e-09, -4.408374649917282e-10,  3.153894599649204e-11, -1.949758848754164e-12,
  1.062386336898259e-13, -5.179839072731223e-15,  2.286915186330010e-16, -9.219341568753519e-18,  2.001598458084922e-06, -8.112363881084451e-07,  1.753986956594894e-07,
 -2.581761953816181e-08,  2.882682712206386e-09, -2.595260461241119e-10,  1.959157110940484e-11, -1.274309199440420e-12,  7.285742045890609e-14, -3.717944299407968e-15,
  1.713951019765767e-16, -7.197753216982307e-18,  8.687803000546256e-07, -3.675025431632682e-07,  8.316677474414415e-08, -1.279713017626496e-08,  1.490733678113062e-09,
 -1.397216710650975e-10,  1.095766183408332e-11, -7.389470212429483e-13,  4.371915764855134e-14, -2.304501913672644e-15,  1.095497194331974e-16, -4.736108148204478e-18,
  2.996155836755043e-07, -1.297814255013321e-07,  3.013100264940724e-08, -4.753687033602346e-09,  5.671613510839917e-10, -5.438111215186505e-11,  4.357835090360223e-12,
 -2.999461568287163e-13,  1.809300687116731e-14, -9.713635956784752e-16,  4.698545371891229e-17, -2.064939426733829e-18,  1.373960426231990e-01, -8.209213145693019e-04,
  5.270794283740663e-06, -3.550626354053654e-08,  2.454811958123785e-10, -1.716598828629724e-12,  1.202613861659727e-14, -8.405078755957723e-17,  5.842459786334189e-19,
 -4.038444241261935e-21,  2.772436921142699e-23, -1.892707668475866e-25,  1.208366290243721e-01, -1.127583214407826e-03,  1.263014952168017e-05, -1.381388247216987e-07,
  1.440842328493425e-09, -1.443160491190106e-11,  1.398745466660196e-13, -1.319167120146974e-15,  1.215308318402640e-17, -1.096877828313061e-19,  9.720238931789377e-22,
 -8.472102391401773e-24,  9.356039479452835e-02, -1.503659045384323e-03,  2.526026852916880e-05, -3.775189897264569e-07,  5.194083306363500e-09, -6.719518609443717e-11,
  8.274916509976927e-13, -9.779843372545796e-15,  1.115848408445848e-16, -1.234575954819093e-18,  1.329163024686359e-20, -1.396192478954213e-22,  6.391006446082188e-02,
 -1.677326155571215e-03,  3.848646070434147e-05, -7.496797025495460e-07,  1.311678156397453e-08, -2.117076137478010e-10,  3.203590086906984e-12, -4.595116543995610e-14,
  6.297109907829421e-16, -8.293481266502331e-18,  1.054555714510093e-19, -1.299141606984974e-21,  3.864259854824948e-02, -1.542520271100903e-03,  4.655970483216976e-05,
 -1.153162790962464e-06,  2.505077260077576e-08, -4.931737352148355e-10,  8.977963703084392e-12, -1.531923427551727e-13,  2.473857678706003e-15, -3.808213526535201e-17,
  5.619435578788305e-19, -7.982239282866107e-21,  2.077875186741564e-02, -1.187644501488900e-03,  4.613455103555679e-05, -1.425232134787003e-06,  3.776920825496654e-08,
 -8.924534611986678e-10,  1.925397299989233e-11, -3.853223345742756e-13,  7.234253083927733e-15, -1.284915102077743e-16,  2.173080474483299e-18, -3.516586684565644e-20,
  9.999361510394775e-03, -7.800683322146175e-04,  3.830065187714709e-05, -1.452617349680909e-06,  4.631376973056794e-08, -1.297148037394787e-09,  3.278249851342965e-11,
 -7.611125900881742e-13,  1.644154239362623e-14, -3.336107319036110e-16,  6.404911528336146e-18, -1.169893252672549e-19,  4.342219106629386e-03, -4.450123973696827e-04,
  2.715934995544087e-05, -1.247384575621761e-06,  4.729385967509771e-08, -1.553773742316942e-09,  4.556075529072994e-11, -1.216177187328575e-12,  2.997176781669348e-14,
 -6.891040619984620e-16,  1.490114658808863e-17, -3.048855784120263e-19,  1.719609282860506e-03, -2.243926124032808e-04,  1.675403265309838e-05, -9.203444417174027e-07,
  4.106546731129304e-08, -1.568032201621493e-09,  5.289870880147983e-11, -1.610769194899309e-12,  4.495103917507375e-14, -1.162790839305497e-15,  2.812742281970511e-17,
 -6.404059832390991e-19,  6.293626319431617e-04, -1.018324923544695e-04,  9.160623091565178e-06, -5.948531079990783e-07,  3.093105885047191e-08, -1.360854161091309e-09,
  5.240484083376947e-11, -1.807035535518934e-12,  5.671129606208910e-14, -1.639708308897522e-15,  4.409062078843988e-17, -1.110260015548599e-18,  2.163984665060428e-04,
 -4.241295678401553e-05,  4.529042261587135e-06, -3.436608654290327e-07,  2.062332553665483e-08, -1.036572467523158e-09,  4.521214854798649e-11, -1.752783288472289e-12,
  6.144437989053368e-14, -1.972930997740577e-15,  5.860770935655678e-17, -1.622509077553319e-18,  7.130091421329353e-05, -1.656862162996627e-05,  2.069403101206035e-06,
 -1.813412835662326e-07,  1.243422275041448e-08, -7.076662427737052e-10,  3.467926165968952e-11, -1.500253580863680e-12,  5.833206851389462e-14, -2.066142502768856e-15,
  6.737217839157530e-17, -2.037882221867771e-18,  2.304086644695093e-05, -6.219664151699353e-06,  8.950266739785229e-07, -8.946204598714845e-08,  6.934199023696153e-09,
 -4.425949715203553e-10,  2.415568541353245e-11, -1.156617099584976e-12,  4.949767553694330e-14, -1.919968448937588e-15,  6.824413523747471e-17, -2.240360913101828e-18,
  7.494291772257988e-06, -2.303375752811757e-06,  3.759336262283933e-07, -4.229192742727161e-08,  3.661998615024458e-09, -2.593467146315112e-10,  1.560929623105757e-11,
 -8.196617222782208e-13,  3.827549338452446e-14, -1.612568777961085e-15,  6.199208489460626e-17, -2.192190289222389e-18,  2.520205141235008e-06, -8.643726703852475e-07,
  1.573411736719662e-07, -1.963083236627261e-08,  1.873876064844196e-09, -1.454703623756551e-10,  9.546994664516561e-12, -5.440151702500958e-13,  2.744490552213313e-14,
 -1.244070807328795e-15,  5.126286601991740e-17, -1.935975220701674e-18,  8.969468566274846e-07, -3.363636980306737e-07,  6.706460689917414e-08, -9.129283120480907e-09,
  9.463763898980364e-10, -7.941994253174587e-11,  5.610108597917258e-12, -3.426961770615149e-13,  1.846380741634584e-14, -8.907344081431727e-16,  3.893467555501250e-17,
 -1.554864014118808e-18,  3.412008566047612e-07, -1.370367142255361e-07,  2.934830235137629e-08, -4.280503793678093e-09,  4.738152429363739e-10, -4.230998322069828e-11,
  3.169482582533695e-12, -2.046661716914761e-13,  1.162194679960051e-14, -5.892650475135149e-16,  2.700012411181313e-17, -1.127394320580989e-18,  1.342548388036689e-07,
 -5.655052445587257e-08,  1.273961230175420e-08, -1.951666636417779e-09,  2.263965454186120e-10, -2.113516833173612e-11,  1.651297837964209e-12, -1.109622285922054e-13,
  6.542917703111629e-15, -3.437895172197453e-16,  1.629354666650302e-17, -7.024026577081640e-19,  4.370622633759161e-08, -1.890436185162319e-08,  4.382024206850967e-09,
 -6.902589156970144e-10,  8.223002915065459e-11, -7.872990372436916e-12,  6.300224635201459e-13, -4.330591773604165e-14,  2.608899856629398e-15, -1.398923627062150e-16,
  6.758692869974272e-18, -2.966985903897447e-19,  1.341940825458239e-01, -7.803950012327964e-04,  4.867201060794597e-06, -3.183830193847271e-08,  2.138552402847635e-10,
 -1.454226999883251e-12,  9.914039366453224e-15, -6.748229498611343e-17,  4.569704231163885e-19, -3.079393314045210e-21,  2.060630135945174e-23, -1.372482849973362e-25,
  1.165184057912868e-01, -1.032801583022660e-03,  1.110183795157444e-05, -1.172238199117723e-07,  1.183000806202077e-09, -1.147730774727971e-11,  1.078383784863188e-13,
 -9.866166391287103e-16,  8.822916558619554e-18, -7.733918877340025e-20,  6.659491775442763e-22, -5.642509889262133e-24,  8.792309963553839e-02, -1.318380578646797e-03,
  2.118758115425861e-05, -3.041721744619134e-07,  4.028520388985808e-09, -5.025559804803109e-11,  5.976320115836589e-13, -6.828538214729430e-15,  7.539597749748724e-17,
 -8.079231572853223e-19,  8.430599939723238e-21, -8.588955405059261e-23,  5.776421185968585e-02, -1.402148002741644e-03,  3.062221640684180e-05, -5.699066905643594e-07,
  9.557968772220112e-09, -1.482333205693931e-10,  2.159399462882823e-12, -2.986326604995059e-14,  3.950741703929489e-16, -5.028582495073604e-18,  6.185384433220208e-20,
 -7.377646784115448e-22,  3.313855124708388e-02, -1.219260837919990e-03,  3.483542378229653e-05, -8.208632386792500e-07,  1.703593952378819e-08, -3.213568768898933e-10,
  5.618127710380839e-12, -9.223040018752513e-14,  1.435173189173167e-15, -2.131669044067694e-17,  3.038549375194563e-19, -4.173784561568933e-21,  1.667090927926508e-02,
 -8.779158947293987e-04,  3.214092024016683e-05, -9.418572035478027e-07,  2.378620343585484e-08, -5.374089431171323e-10,  1.111460274841932e-11, -2.136811312955263e-13,
  3.860768527382723e-15, -6.609318970131741e-17,  1.078808563570143e-18, -1.686957357787017e-20,  7.396995337016514e-03, -5.325174109476638e-04,  2.458021943502855e-05,
 -8.826950588400294e-07,  2.677829227719743e-08, -7.161995610323426e-10,  1.733334903432151e-11, -3.862685394254014e-13,  8.024766966503403e-15, -1.568609218320703e-16,
  2.905501023308158e-18, -5.127138134829641e-20,  2.917389465780802e-03, -2.767743442632982e-04,  1.587039423228978e-05, -6.897613349140831e-07,  2.487064306277756e-08,
 -7.799508031257781e-10,  2.189535158004999e-11, -5.609221630612559e-13,  1.329437837136404e-14, -2.944948237999465e-16,  6.145339672853450e-18, -1.215150741514191e-19,
  1.033268050706262e-03, -1.253680970579218e-04,  8.804922061274788e-06, -4.580410640863611e-07,  1.944762832614273e-08, -7.092313951113955e-10,  2.292036391975836e-11,
 -6.702573008721704e-13,  1.800170420807092e-14, -4.490118875344204e-16,  1.049043842140925e-17, -2.310414175924081e-19,  3.330146629998456e-04, -5.038426347813489e-05,
  4.275524091487746e-06, -2.634658815283416e-07,  1.305888638419506e-08, -5.496199828763880e-10,  2.030642087465954e-11, -6.734686252742296e-13,  2.037238656156110e-14,
 -5.688290885953848e-16,  1.479574357657670e-17, -3.609645487855207e-19,  9.933304157396403e-05, -1.832845694868503e-05,  1.854259941610555e-06, -1.339770466116131e-07,
  7.686681343428920e-09, -3.705834643844115e-10,  1.554701225623457e-11, -5.811068207167119e-13,  1.968098551496581e-14, -6.116630193932902e-16,  1.761598442264522e-17,
 -4.735372816963694e-19,  2.801047603327086e-05, -6.175596184615082e-06,  7.349208787802230e-07, -6.161303153156456e-08,  4.055762940018372e-09, -2.222422358658911e-10,
  1.051234214370657e-11, -4.399202146481227e-13,  1.657806397783014e-14, -5.701013914357559e-16,  1.807642171400404e-17, -5.324512205659553e-19,  7.663222158799865e-06,
 -1.979576686790775e-06,  2.732794315714969e-07, -2.628671356098962e-08,  1.966284822188910e-09, -1.214177748258884e-10,  6.424843329750355e-12, -2.988365154954158e-13,
  1.244440255885513e-14, -4.704339571705283e-16,  1.631897876561549e-17, -5.235271352894403e-19,  2.097103738518299e-06, -6.224064460116060e-07,  9.820143536465771e-08,
 -1.070376859028818e-08,  8.999484835953647e-10, -6.200973568418716e-11,  3.637584267344229e-12, -1.864694306726835e-13,  8.512600025678142e-15, -3.510713773116596e-16,
  1.322716066870997e-17, -4.589349035589050e-19,  5.936925318348223e-07, -1.984137985048316e-07,  3.519887983133707e-08, -4.286299117477986e-09,  3.999652170741682e-10,
 -3.039718624186274e-11,  1.955643030852064e-12, -1.093786605754545e-13,  5.422125968695727e-15, -2.417603220151375e-16,  9.808074501892322e-18, -3.650151877449386e-19,
  1.796421349241396e-07, -6.620138023138738e-08,  1.296657778271516e-08, -1.735478537105785e-09,  1.770673340043998e-10, -1.463951928828823e-11,  1.019751181214207e-12,
 -6.147949254023033e-14,  3.271773324755912e-15, -1.560151538548611e-16,  6.745323244384490e-18, -2.666154384000634e-19,  5.933860152880015e-08, -2.358984919595237e-08,
  4.998546518827607e-09, -7.216310033825677e-10,  7.911064752497587e-11, -7.000407289868459e-12,  5.199490381402736e-13, -3.330676988143292e-14,  1.877092434130612e-15,
 -9.449937488881482e-17,  4.301031078625654e-18, -1.784605386114740e-19,  2.095733771107416e-08, -8.785506468599478e-09,  1.969141453107361e-09, -3.001830740911749e-10,
  3.465897024684352e-11, -3.221273590030045e-12,  2.506288058230045e-13, -1.677514662055520e-14,  9.854706293564894e-16, -5.159825535542154e-17,  2.437312173386346e-18,
 -1.047407575083685e-19,  6.398450379525489e-09, -2.763120812607981e-09,  6.393759133090980e-10, -1.005421808184391e-10,  1.195769058949408e-11, -1.143053151627476e-12,
  9.133180077416761e-14, -6.268751244023350e-15,  3.771257632374446e-16, -2.019498590235648e-17,  9.744449810995371e-19, -4.272475220257537e-20,  1.311480373551117e-01,
 -7.429295921205620e-04,  4.504751941143944e-06, -2.863698046755437e-08,  1.870051448891546e-10, -1.237408725543390e-12,  8.213661517599626e-15, -5.448497974785126e-17,
  3.596024003444988e-19, -2.364137717894042e-21,  1.542481706074202e-23, -1.003337963160134e-25,  1.125563522245334e-01, -9.493084228570218e-04,  9.801576325661043e-06,
 -1.000004048458485e-07,  9.772528140349035e-10, -9.191186321437685e-12,  8.378124441201455e-14, -7.441381154188726e-16,  6.463922364613656e-18, -5.506707678839511e-20,
  4.610371835010046e-22, -3.799785472401056e-24,  8.296691378056698e-02, -1.162456065564244e-03,  1.789344219702437e-05, -2.470378572026016e-07,  3.152655864296152e-09,
 -3.795890514049024e-11,  4.362623664150952e-13, -4.822873663349783e-15,  5.156964077370291e-17, -5.355865620103663e-19,  5.420466155033247e-21, -5.359331146808993e-23,
  5.260565704339305e-02, -1.182134359375687e-03,  2.461146914355486e-05, -4.381412471425042e-07,  7.050559148437655e-09, -1.051648498995185e-10,  1.476075847736907e-12,
 -1.969678017942000e-14,  2.517376702198676e-16, -3.098715515828374e-18,  3.689513341002453e-20, -4.263302097569741e-22,  2.876244193001172e-02, -9.757899824296099e-04,
  2.642995792729714e-05, -5.931722575367034e-07,  1.177206472938782e-08, -2.129549543530370e-10,  3.578120688336041e-12, -5.655478282508173e-14,  8.485477361619509e-16,
 -1.216811320795511e-17,  1.676441077830939e-19, -2.227970113116810e-21,  1.361008362130228e-02, -6.602596988546037e-04,  2.280935781769699e-05, -6.345785088027867e-07,
  1.528470014532208e-08, -3.304279252413184e-10,  6.555372284859788e-12, -1.211402809230742e-13,  2.107469496858113e-15, -3.478984392497751e-17,  5.482939957728142e-19,
 -8.288132321484664e-21,  5.602136978561274e-03, -3.719194445304215e-04,  1.615019683274396e-05, -5.494465760249208e-07,  1.586867691708734e-08, -4.054808936500014e-10,
  9.401539830801128e-12, -2.011726562640460e-13,  4.020731398680752e-15, -7.573521474174514e-17,  1.353774369571061e-18, -2.308417144070234e-20,  2.019988906147693e-03,
 -1.771783361684110e-04,  9.545805996323949e-06, -3.926573768034179e-07,  1.346665152605858e-08, -4.031869857610039e-10,  1.083758287595724e-11, -2.664867097676435e-13,
  6.074718643640452e-15, -1.296569823156300e-16,  2.611009977996941e-18, -4.989522449632950e-20,  6.441208371114570e-04, -7.253629693986626e-05,  4.789142325234905e-06,
 -2.358439190793396e-07,  9.525931848994005e-09, -3.317219435109794e-10,  1.026737984145912e-11, -2.882837868534964e-13,  7.450133171893699e-15, -1.791399727695530e-16,
  4.041407727333126e-18, -8.607768560646602e-20,  1.839592067308977e-04, -2.596498440729698e-05,  2.075825853646410e-06, -1.212769645167526e-07,  5.725750845035218e-09,
 -2.303797578296357e-10,  8.161423695602592e-12, -2.601913861095726e-13,  7.582329147727410e-15, -2.043406496351518e-16,  5.138759185603104e-18, -1.213976261767480e-19,
  4.785185966648117e-05, -8.289114681245619e-06,  7.930232164071210e-07, -5.448171683410359e-08,  2.984728844235249e-09, -1.378747431067344e-10,  5.558001623203211e-12,
 -2.001062751036468e-13,  6.541954807411850e-15, -1.966276685792496e-16,  5.485810632294826e-18, -1.430748603682933e-19,  1.158748508918237e-05, -2.416362181914960e-06,
  2.733492258375390e-07, -2.188258882815239e-08,  1.380562616777563e-09, -7.272941273420978e-11,  3.316088951194009e-12, -1.340709851898805e-13,  4.891033334452786e-15,
 -1.631176757932351e-16,  5.023907581278076e-18, -1.439587397473499e-19,  2.685904068919686e-06, -6.618156324415977e-07,  8.741821380139803e-08, -8.073990111920831e-09,
  5.816959054258558e-10, -3.468864909567645e-11,  1.776768344204582e-12, -8.015886810839981e-14,  3.243618376564333e-15, -1.193436603357108e-16,  4.035323456896393e-18,
 -1.263594767374238e-19,  6.167767830158892e-07, -1.762190760122679e-07,  2.680629766117528e-08, -2.824308801632644e-09,  2.300936077123439e-10, -1.539580565380885e-11,
  8.787215073963572e-13, -4.390275405537740e-14,  1.956439928140917e-15, -7.887322999257396e-17,  2.908609588677534e-18, -9.889564419194156e-20,  1.460629322177481e-07,
 -4.743779217326916e-08,  8.181599095586010e-09, -9.702819076390674e-10,  8.833125683655286e-11, -6.560212864182612e-12,  4.130639838284140e-13, -2.264089109013167e-14,
  1.101284361882430e-15, -4.823608808940787e-17,  1.924308069570295e-18, -7.049029534540128e-20,  3.721321931235464e-08, -1.344867825716653e-08,  2.582646660331713e-09,
 -3.392608812763778e-10,  3.401229268282155e-11, -2.766285188677743e-12,  1.897544662583380e-13, -1.127649089623056e-14,  5.920473273721265e-16, -2.787543054202320e-17,
  1.190865935419511e-18, -4.654359716282514e-20,  1.055124321778057e-08, -4.146531714767661e-09,  8.681891696293076e-10, -1.239146156562896e-10,  1.343896834860261e-11,
 -1.177239893188995e-12,  8.661340508824648e-14, -5.499115011968281e-15,  3.073380311084944e-16, -1.535134701151985e-17,  6.935489627918015e-19, -2.857762840808074e-20,
  3.308635040878117e-09, -1.379539050118313e-09,  3.074385790776401e-10, -4.660868594427712e-11,  5.353274104927607e-12, -4.950891514660187e-13,  3.834097905881685e-14,
 -2.555008114002890e-15,  1.494765101052505e-16, -7.795958043468662e-18,  3.668981417291847e-19, -1.571237541466531e-20,  9.404055168811095e-10, -4.053896588070886e-10,
  9.362561250842387e-11, -1.469490057449557e-11,  1.744519596091233e-12, -1.664711276882866e-13,  1.327920982175237e-14, -9.100002679984157e-16,  5.466229828662165e-17,
 -2.922911293668702e-18,  1.408404082608816e-19, -6.167012190325969e-21,  1.282462880220063e-01, -7.082171000131048e-04,  4.178277311126686e-06, -2.583266920046376e-08,
  1.641110785902553e-10, -1.057362067508609e-12,  6.837190769515400e-15, -4.422848551327037e-17,  2.846131299725030e-19, -1.827029528280314e-21,  1.162243641000051e-23,
 -7.394496199251427e-26,  1.089087014226621e-01, -8.754433132683118e-04,  8.689657053653211e-06, -8.573238483830800e-08,  8.119623444324451e-10, -7.408805462045177e-12,
  6.556679334357484e-14, -5.657547259598705e-16,  4.776817011953363e-18, -3.957546687672022e-20,  3.223587233765794e-22, -2.585964449439260e-24,  7.858574865971570e-02,
 -1.030363039332390e-03,  1.520831492212370e-05, -2.021426752390184e-07,  2.488135687052806e-09, -2.893904436191906e-11,  3.217001400034151e-13, -3.443505730948982e-15,
  3.568349454441894e-17, -3.594277475001820e-19,  3.530363523068466e-21, -3.389649974034119e-23,  4.824011573346772e-02, -1.004503847992387e-03,  1.996697837913232e-05,
 -3.404062369560749e-07,  5.261149491029716e-09, -7.554059573901946e-11,  1.022410742338879e-12, -1.317421096246942e-14,  1.627789945714337e-16, -1.939047914546861e-18,
  2.236227114563267e-20, -2.504823151944073e-22,  2.524120912046817e-02, -7.899164289766120e-04,  2.031522408699477e-05, -4.347141077981945e-07,  8.257742841405390e-09,
 -1.433769425523704e-10,  2.317107158088157e-12, -3.528587183689782e-14,  5.108217494875100e-16, -7.076391283561031e-18,  9.428463716060239e-20, -1.212963448231491e-21,
  1.129103731668083e-02, -5.045390956675692e-04,  1.646850374360268e-05, -4.353731841667577e-07,  1.000965768767622e-08, -2.072033828291111e-10,  3.945805421951620e-12,
 -7.013030444740564e-14,  1.175384678798787e-15, -1.871953424426698e-17,  2.849877747512756e-19, -4.166124357180290e-21,  4.336475283180730e-03, -2.653202542251231e-04,
  1.084765871311501e-05, -3.498476203421681e-07,  9.624835829445195e-09, -2.350884925205079e-10,  5.224511132207080e-12, -1.073895276603530e-13,  2.065636699238229e-15,
 -3.750606690017021e-17,  6.471715552348742e-19, -1.066627030440116e-20,  1.438631713999745e-03, -1.165287038022281e-04,  5.900302352899605e-06, -2.297593347633086e-07,
  7.497081411423924e-09, -2.143443179636930e-10,  5.517878524381320e-12, -1.302525985743943e-13,  2.856186653669024e-15, -5.874447820000689e-17,  1.141725205565055e-18,
 -2.108641829984139e-20,  4.157660030236634e-04, -4.338173728731192e-05,  2.691458689690409e-06, -1.254422977368541e-07,  4.819319527356967e-09, -1.602315329943047e-10,
  4.749381883372949e-12, -1.280226823209673e-13,  3.183066802359136e-15, -7.377261931241910e-17,  1.606828334460056e-18, -3.309109787918998e-20,  1.059066190234874e-04,
 -1.391386040742699e-05,  1.046851622799325e-06, -5.794188783893354e-08,  2.604078001711278e-09, -1.001130555010533e-10,  3.399001762177535e-12, -1.041166805360104e-13,
  2.921594471618670e-15, -7.596122476591495e-17,  1.846089444582728e-18, -4.221211406887960e-20,  2.416254259456481e-05, -3.918668002549847e-06,  3.539188052137337e-07,
 -2.308879470832707e-08,  1.206484544512295e-09, -5.334717010725489e-11,  2.064583331382765e-12, -7.153969312881148e-14,  2.255838517019034e-15, -6.552225982256591e-17,
  1.769576753486383e-18, -4.474641246328091e-20,  5.045893631429819e-06, -9.921243953691709e-07,  1.064482850371461e-07, -8.122237299865827e-09,  4.903533593439000e-10,
 -2.480025701901836e-11,  1.088583943637554e-12, -4.247088881639958e-14,  1.498239102517471e-15, -4.840687745415532e-17,  1.446746543845004e-18, -4.029025786935293e-20,
  9.927533991411897e-07, -2.325539312768132e-07,  2.931424910551073e-08, -2.593941961832025e-09,  1.796483470802789e-10, -1.032794520175060e-11,  5.112461574197542e-13,
 -2.233892132490241e-14,  8.771675293601102e-16, -3.137164419902155e-17,  1.032694122891575e-18, -3.152694051798365e-20,  1.910062792957228e-07, -5.236175135887488e-08,
  7.658372122625770e-09, -7.780782874607858e-10,  6.129114264783601e-11, -3.974763677030536e-12,  2.203371349687023e-13, -1.071186959582987e-14,  4.652660174558227e-16,
 -1.830958273565022e-17,  6.599946649746108e-19, -2.196314193507233e-20,  3.763002148904810e-08, -1.184177108560496e-08,  1.980392408294913e-09, -2.281942690926386e-10,
  2.022488885146674e-11, -1.465052089918353e-12,  9.012310702858467e-14, -4.833316348903995e-15,  2.303409009352893e-16, -9.896841997394606e-18,  3.877380599032815e-19,
 -1.396343487242587e-20,  7.996600472813667e-09, -2.827553860383171e-09,  5.312347695609946e-10, -6.835617322229059e-11,  6.721819210549300e-12, -5.369222054763927e-13,
  3.621454858953231e-14, -2.118414501020425e-15,  1.095892365305871e-16, -5.088615544813825e-18,  2.145690272919755e-19, -8.283853410481703e-21,  1.922906686834419e-09,
 -7.459027683731125e-10,  1.540935214595972e-10, -2.171393394154090e-11,  2.326820990057171e-12, -2.015461369158256e-13,  1.467300423261786e-14, -9.224445099019785e-16,
  5.107916662201590e-17, -2.529294991773392e-18,  1.133396280410596e-19, -4.634460704843003e-21,  5.290101895058015e-10, -2.192248372402335e-10,  4.854100802098508e-11,
 -7.313347890766453e-12,  8.350529944494086e-13, -7.680216203303821e-14,  5.916883722374883e-15, -3.923714380981380e-16,  2.284963976140363e-17, -1.186571936252545e-18,
  5.561558683602017e-20, -2.372596839499990e-21,  1.388173840763079e-10, -5.972390961586224e-11,  1.376404009481095e-11, -2.155817266838526e-12,  2.554175654065602e-13,
 -2.432666691471719e-14,  1.936973081288305e-15, -1.325067053521139e-16,  7.946292162472134e-18, -4.242343301735138e-19,  2.041090038522519e-20, -8.924530323778895e-22,
  1.254783697462774e-01, -6.759877627158248e-04,  3.883369858059059e-06, -2.336755746447049e-08,  1.445095249690582e-10, -9.071588161735200e-13,  5.717016646880262e-15,
 -3.608950245987139e-17,  2.264799474467564e-19, -1.421163601880174e-21,  8.808813786286227e-24, -5.497085678500160e-26,  1.055397446360555e-01, -8.098310889897809e-04,
  7.734189959755556e-06, -7.384598835444838e-08,  6.783231238828257e-10, -6.009255712495305e-12,  5.166802621624935e-14, -4.334098511530479e-16,  3.559204178626899e-18,
 -2.869507607921204e-20,  2.275319011536628e-22, -1.777673583569972e-24,  7.469316739345101e-02, -9.177640111935776e-04,  1.300363863729408e-05, -1.665738592014574e-07,
  1.979372409849112e-09, -2.225727657341706e-11,  2.395016107520359e-13, -2.484078481088502e-15,  2.496381888400115e-17, -2.440334435119847e-19,  2.327729234018348e-21,
 -2.171653219540587e-23,  4.451758021959284e-02, -8.597832298652111e-04,  1.634131687353517e-05, -2.670967149493446e-07,  3.968626224496786e-09, -5.489948644200706e-11,
  7.170801231330185e-13, -8.928989541084977e-15,  1.067332402235797e-16, -1.231206819524206e-18,  1.376155767017967e-20, -1.495089144763571e-22,  2.237645520752960e-02,
 -6.462146523493473e-04,  1.580571282796319e-05, -3.228144929665926e-07,  5.874915796460789e-09, -9.798702576293179e-11,  1.524295533405566e-12, -2.238058240795040e-14,
  3.128137468902339e-16, -4.188783322637406e-18,  5.400418536367820e-20, -6.728988042872698e-22,  9.506755512720417e-03, -3.912509015468824e-04,  1.208320939811426e-05,
 -3.038243138254922e-07,  6.673111331816330e-09, -1.323697151343977e-10,  2.421248109836567e-12, -4.141475485625149e-14,  6.690748833729144e-16, -1.028576826313445e-17,
  1.513362099331138e-19, -2.140421224258523e-21,  3.425443363717414e-03, -1.930313678773752e-04,  7.437879875046856e-06, -2.275539976355966e-07,  5.967281887417266e-09,
 -1.394030990321598e-10,  2.970954878136947e-12, -5.868931455495208e-14,  1.086892088566745e-15, -1.903046150635879e-17,  3.170881035349379e-19, -5.052719705474433e-21,
  1.051961547107717e-03, -7.860006276643376e-05,  3.741760609168049e-06, -1.379822546380691e-07,  4.285175382367602e-09, -1.170308475243655e-10,  2.886142628096169e-12,
 -6.541988883690598e-14,  1.380226346214998e-15, -2.736007159942698e-17,  5.132811576059088e-19, -9.162948096189597e-21,  2.773424876299986e-04, -2.676906539845610e-05,
  1.560221987966544e-06, -6.881630657716009e-08,  2.514670980641978e-09, -7.982410143675639e-11,  2.265788723000990e-12, -5.863335697263546e-14,  1.402480679387907e-15,
 -3.132830956809092e-17,  6.587281606500337e-19, -1.311545514791794e-20,  6.342763620304598e-05, -7.739572218785420e-06,  5.475107621882338e-07, -2.869153983501443e-08,
  1.226919475754207e-09, -4.505051208635494e-11,  1.465330868833675e-12, -4.311113121146554e-14,  1.164459213387589e-15, -2.919857229658315e-17,  6.855257757146713e-19,
 -1.516638182687998e-20,  1.277072669071842e-05, -1.933881807330151e-06,  1.646273501467461e-07, -1.018645067781837e-08,  5.072110855115838e-10, -2.144955880667240e-11,
  7.963225032133728e-13, -2.653751724778442e-14,  8.065555733415187e-16, -2.262396107963174e-17,  5.910867606132469e-19, -1.448203639108078e-20,  2.311443706284415e-06,
 -4.271760559416488e-07,  4.337704297245529e-08, -3.149251425657650e-09,  1.816693282915875e-10, -8.809638008904547e-12,  3.718260890317206e-13, -1.398341785897144e-14,
  4.765172597878377e-16, -1.490061505163344e-17,  4.317445425361374e-19, -1.167490360212050e-20,  3.871124672984132e-07, -8.591519119363421e-08,  1.030815580302883e-08,
 -8.719947010295215e-10,  5.794435497827452e-11, -3.206025567966622e-12,  1.531392392839046e-13, -6.471594334145784e-15,  2.462611932873433e-16, -8.550508817773212e-18,
  2.736949225632319e-19, -8.137056379622284e-21,  6.238372004817601e-08, -1.635213266437648e-08,  2.292962162825556e-09, -2.240939082241364e-10,  1.703118556907992e-11,
 -1.068380894289777e-12,  5.741902771426399e-14, -2.711792718659724e-15,  1.146278623503582e-16, -4.397041857795320e-18,  1.547195879256033e-19, -5.032818434716945e-21,
  1.017849252965914e-08, -3.093701909789322e-09,  5.002911164964330e-10, -5.587272591744475e-11,  4.810468212507537e-12, -3.391944728767045e-13,  2.034796893580058e-14,
 -1.065936555045789e-15,  4.969347422466697e-17, -2.091448374233597e-18,  8.035979959482829e-20, -2.841448640456010e-21,  1.788001544110130e-09, -6.169902877680936e-10,
  1.131388028347008e-10, -1.422958612117873e-11,  1.369817999356864e-12, -1.072705856093447e-13,  7.102701786703449e-15, -4.083647492520137e-16,  2.078643644421173e-17,
 -9.506538451633680e-19,  3.951836152215574e-20, -1.505398059864517e-21,  3.601319846227985e-10, -1.376516940617681e-10,  2.801122822720340e-11, -3.891036259779725e-12,
  4.113965797519766e-13, -3.519055895397859e-14,  2.532111136330298e-15, -1.574512620505237e-16,  8.629686914579184e-18, -4.232279303561233e-19,  1.879472138559695e-20,
 -7.620379788700413e-22,  8.579556395363835e-11, -3.530729606392246e-11,  7.760817503406911e-12, -1.161093346170990e-12,  1.317013650981172e-13, -1.203790655263018e-14,
  9.220186730389703e-16, -6.080930972711024e-17,  3.523087476558679e-18, -1.820723000109386e-19,  8.495250015611084e-21, -3.608717390616275e-22,  2.059054963302667e-11,
 -8.839335783397352e-12,  2.032305032320953e-12, -3.175775710977901e-13,  3.754270886185380e-14, -3.568125057666642e-15,  2.835362952604720e-16, -1.935947265977680e-17,
  1.158860880196024e-18, -6.176204545056626e-20,  2.966624905387145e-21, -1.295106684266282e-22,  1.228348304114881e-01, -6.460044721136171e-04,  3.616256602175738e-06,
 -2.119342490647030e-08,  1.276606219925499e-10, -7.813024924223038e-13,  4.800741014249153e-15, -2.959719421884306e-17,  1.811177311225295e-19, -1.112832881253434e-21,
  6.707114464476664e-24, -4.130243665195793e-26,  1.024188039853647e-01, -7.513263887851485e-04,  6.909398514422335e-06, -6.389083033053297e-08,  5.696180434114558e-10,
 -4.902874008852592e-12,  4.098346699912245e-14, -3.344292965860179e-16,  2.672782593684526e-18, -2.098248635987805e-20,  1.620482818981367e-22, -1.233841906018968e-24,
  7.121822784925316e-02, -8.212239711985333e-04,  1.118103300936453e-05, -1.381748771739378e-07,  1.586507651291325e-09, -1.726113753846766e-11,  1.799285582567941e-13,
 -1.809543265469562e-15,  1.764758864777116e-17, -1.675303278965170e-19,  1.552813032746134e-21, -1.408482870593184e-23,  4.132103012334074e-02, -7.408716385113972e-04,
  1.348372307759015e-05, -2.115260906239512e-07,  3.024318489532845e-09, -4.034120874167515e-11,  5.089106026163634e-13, -6.128105892535683e-15,  7.091590852168053e-17,
 -7.926734879580575e-19,  8.592206413221662e-21, -9.059241254173177e-23,  2.002202877269608e-02, -5.338030756640768e-04,  1.243716122250599e-05, -2.427004443623801e-07,
  4.235551647936183e-09, -6.791842117464201e-11,  1.017777939909270e-12, -1.441807359574744e-14,  1.946930190462423e-16, -2.521593906712294e-18,  3.147540761715821e-20,
 -3.800488576460630e-22,  8.114313461704598e-03, -3.075361910013738e-04,  8.999818363520856e-06, -2.154311255276833e-07,  4.524078334463200e-09, -8.606026399079097e-11,
  1.513086328015779e-12, -2.492282104563689e-14,  3.883393212612009e-16, -5.765663688121199e-18,  8.202406610214497e-20, -1.122902976874213e-21,  2.757070574283185e-03,
 -1.430170553371379e-04,  5.199261715355357e-06, -1.510031972604220e-07,  3.777054538145627e-09, -8.444477646461445e-11,  1.726810137715223e-12, -3.279964545369255e-14,
  5.850938083977971e-16, -9.882756302266230e-18,  1.590663964825803e-19, -2.451412638801530e-21,  7.883812139365395e-04, -5.427975784854822e-05,  2.430792653581746e-06,
 -8.492426400247784e-08,  2.511251442600987e-09, -6.553938717310869e-11,  1.548912383905142e-12, -3.372314939185216e-14,  6.847361938281389e-16, -1.308503661856506e-17,
  2.369954367597072e-19, -4.090040261081737e-21,  1.908265986929761e-04, -1.701106071519207e-05,  9.313900755498767e-07, -3.887754757046131e-08,  1.351367369836096e-09,
 -4.095941815216466e-11,  1.113437702944104e-12, -2.766228331803382e-14,  6.365673759333391e-16, -1.370488767795149e-17,  2.781824979517322e-19, -5.354536599813542e-21,
  3.944329338792757e-05, -4.460788523096223e-06,  2.964899013964235e-07, -1.470358937842989e-08,  5.980501878808642e-10, -2.096725897439019e-11,  6.531842079505065e-13,
 -1.845269197166714e-14,  4.796392108433191e-16, -1.159576943825853e-17,  2.629309784423119e-19, -5.626621082457859e-21,  7.054039426664175e-06, -9.947784476530082e-07,
  7.970697391865350e-08, -4.673014179805231e-09,  2.215376428415257e-10, -8.953688750883576e-12,  3.186650581226875e-13, -1.020685425744321e-14,  2.988269833117592e-16,
 -8.090139840220871e-18,  2.043592070269117e-19, -4.848627133712673e-21,  1.112825494269614e-06, -1.927042167661339e-07,  1.848158645662619e-08, -1.274693012292876e-09,
  7.016774402177838e-11, -3.258577918938652e-12,  1.321042391611684e-13, -4.784077211109358e-15,  1.573358752069006e-16, -4.757305761293575e-18,  1.335195026204813e-19,
 -3.502887533322137e-21,  1.592625933230260e-07, -3.337210736259579e-08,  3.801311720353891e-09, -3.067624708317066e-10,  1.952287243236582e-11, -1.037912282743869e-12,
  4.776859519410384e-14, -1.949697536479613e-15,  7.180623074800584e-17, -2.417557630295519e-18,  7.516160964370375e-20, -2.173771786061665e-21,  2.151657403626749e-08,
 -5.373252872848114e-09,  7.202696862431248e-10, -6.754596036160938e-11,  4.942084678525609e-12, -2.993032339838377e-13,  1.556761065118478e-14, -7.130724225024847e-16,
  2.928889307440626e-17, -1.093570955274456e-18,  3.751208629557642e-20, -1.191236825886980e-21,  2.897863495101588e-09, -8.477947714434269e-10,  1.321789304216973e-10,
 -1.427053536119166e-11,  1.190785459961029e-12, -8.156165112774986e-14,  4.762369837279986e-15, -2.432631053028955e-16,  1.107603312517292e-17, -4.559326846261365e-19,
  1.715660975174309e-20, -5.948494927654655e-22,  4.173219207983980e-10, -1.401330182067014e-10,  2.501486482925273e-11, -3.067977027657865e-12,  2.885146304766760e-13,
 -2.210786198782704e-14,  1.434499946225288e-15, -8.093260107873217e-17,  4.047487625439900e-18, -1.820712498096330e-19,  7.451985495145251e-21, -2.797659741546751e-22,
  6.951723998495482e-11, -2.613071262522573e-11,  5.227916658013845e-12, -7.146425233455861e-13,  7.443381580582124e-14, -6.278629616407436e-15,  4.459248505282028e-16,
 -2.739317318253430e-17,  1.484408199265470e-18, -7.202945696221462e-20,  3.166927985933301e-21, -1.272096676423835e-22,  1.413954891339652e-11, -5.772703565718430e-12,
  1.258389682747561e-12, -1.867780184878800e-13,  2.102836458162237e-14, -1.908663739827696e-15,  1.452369967599530e-16, -9.520259726880922e-18,  5.484176647590538e-19,
 -2.819006001990456e-20,  1.308684540945384e-21, -5.532927715189624e-23,  3.070630455947208e-12, -1.314952416452631e-12,  3.015293619589301e-13, -4.699703964806452e-14,
  5.542123608427122e-15, -5.255016301071090e-16,  4.166567284064908e-17, -2.838891068740069e-18,  1.695971923221117e-19, -9.021625227666597e-21,  4.325558194297867e-22,
 -1.885130410415822e-23,  1.203071094339071e-01, -6.180581282630703e-04,  3.373694799177496e-06, -1.926987362615376e-08,  1.131228576650582e-10, -6.754096941117315e-13,
  4.047487188214540e-15, -2.439400259098979e-17,  1.454757632228529e-19, -8.777744195314719e-22,  5.116753455118213e-24, -3.154885376219271e-26,  9.951940243022739e-02,
 -6.989701447044161e-04,  6.194320800687469e-06, -5.551097744209716e-08,  4.806852516484162e-10, -4.022629989484024e-12,  3.271163652812025e-14, -2.598340039364168e-16,
  2.022107842287027e-18, -1.546724484361583e-20,  1.163982300963553e-22, -8.643638002342539e-25,  6.810230365075176e-02, -7.380013648202253e-04,  9.664562431480996e-06,
 -1.153340560754672e-07,  1.280671330177469e-09, -1.349221731156097e-11,  1.363397249969166e-13, -1.330444250524632e-15,  1.259989615658596e-17, -1.162277261439125e-19,
  1.047466858941370e-21, -9.242433136733676e-24,  3.855829274911161e-02, -6.423897707654394e-04,  1.121112001472965e-05, -1.689820106617506e-07,  2.326955755685048e-09,
 -2.995414139763211e-11,  3.652353562169425e-13, -4.256120110083903e-15,  4.771351334184459e-17, -5.171095479401441e-19,  5.439100328046080e-21, -5.568583045036999e-23,
  1.806886624711568e-02, -4.448985840523502e-04,  9.890495048388195e-06, -1.845969719551801e-07,  3.092061442270658e-09, -4.770814986373175e-11,  6.892074068809360e-13,
 -9.426643081768589e-15,  1.230578597696583e-16, -1.542473985353891e-18,  1.865160431723812e-20, -2.183530840401240e-22,  7.013372631536972e-03, -2.447668647925796e-04,
  6.797955459237645e-06, -1.550567027377930e-07,  3.116007606077530e-09, -5.688735544615828e-11,  9.620304132261526e-13, -1.526916239809633e-14,  2.296026916207497e-16,
 -3.294002554427964e-18,  4.533331210292689e-20, -6.009828912136261e-22,  2.258012165593794e-03, -1.077588918353402e-04,  3.700611133197378e-06, -1.021077341829898e-07,
  2.437887640862804e-09, -5.219586110014227e-11,  1.024725105687122e-12, -1.872493676437266e-14,  3.218926431578148e-16, -5.247342071221847e-18,  8.161653392792191e-20,
 -1.216917686909247e-21,  6.045483818638979e-04, -3.831464892765533e-05,  1.615287274663079e-06, -5.349225401577483e-08,  1.506880814351253e-09, -3.759807952734661e-11,
  8.518643367209201e-13, -1.782109735825993e-14,  3.483529214122925e-16, -6.419101076349345e-18,  1.122713766488623e-19, -1.873494085012168e-21,  1.351772131384777e-04,
 -1.111247318001148e-05,  5.716294825570568e-07, -2.258435191184100e-08,  7.468745087985819e-10, -2.161876114548020e-11,  5.629049649125057e-13, -1.342787676295434e-14,
  2.973096264687789e-16, -6.169642108805791e-18,  1.208972739408673e-19, -2.249722809182834e-21,  2.542017818784667e-05, -2.659069042353130e-06,  1.659659264728193e-07,
 -7.786573578163780e-09,  3.011754702360111e-10, -1.008014314969659e-11,  3.007088069135859e-13, -8.155808382617572e-15,  2.039693128429981e-16, -4.753516169647890e-18,
  1.040756457319899e-19, -2.153813447371708e-21,  4.065109680806183e-06, -5.324929143942004e-07,  4.010978122753350e-08, -2.226156185061262e-09,  1.004133063967654e-10,
 -3.876239597563140e-12,  1.321804519861920e-13, -4.067112756567791e-15,  1.146439124443345e-16, -2.994170357880665e-18,  7.309036180810154e-20, -1.678499753722103e-21,
  5.624280370020410e-07, -9.097563458580954e-08,  8.225126701983306e-09, -5.381425543927732e-10,  2.823325361175424e-11, -1.254304318304941e-12,  4.879521165663214e-14,
 -1.700099506377707e-15,  5.391344784670773e-17, -1.575009230298989e-18,  4.278438095926988e-20, -1.088150686598442e-21,  6.911445326738960e-08, -1.362514223174319e-08,
  1.469743607147394e-09, -1.129195757668062e-10,  6.870754431986614e-12, -3.504420464902002e-13,  1.551866623915522e-14, -6.109682148866425e-16,  2.175198043599375e-17,
 -7.093102102329093e-19,  2.139576998362066e-20, -6.013279185958028e-22,  7.845007777444605e-09, -1.859425337716905e-09,  2.375701734015577e-10, -2.132520302141542e-11,
  1.498866909012747e-12, -8.746744498055515e-14,  4.395167497105215e-15, -1.949375924647922e-16,  7.768675523915471e-18, -2.819370553640641e-19,  9.415399638096790e-21,
 -2.915279414484261e-22,  8.704351270749478e-10, -2.442092538664819e-10,  3.659425174516558e-11, -3.809116031794284e-12,  3.073186571613549e-13, -2.040335476171108e-14,
  1.157325885426056e-15, -5.754033664276881e-17,  2.554459874028358e-18, -1.026863587239556e-19,  3.778805278267793e-21, -1.282967447724555e-22,  1.020084202142334e-10,
 -3.322618378232920e-11,  5.757384607942367e-12, -6.868344558039026e-13,  6.295435297396539e-14, -4.710558611505964e-15,  2.989665498949992e-16, -1.652329969541474e-17,
  8.105882258088301e-19, -3.581227580686867e-20,  1.441199565709862e-21, -5.325568485156380e-23,  1.387557393169255e-11, -5.117589930561538e-12,  1.004475198976744e-12,
 -1.348592062278400e-13,  1.381277897977660e-14, -1.147115999608149e-15,  8.029858402118939e-17, -4.866568552016878e-18,  2.604114994401163e-19, -1.248822088291857e-20,
  5.430484787533490e-22, -2.158935124023619e-23,  2.372887852313094e-12, -9.599740252607540e-13,  2.072935046206504e-13, -3.049172028773453e-14,  3.404022447067705e-15,
 -3.065423925754017e-16,  2.315483681183401e-17, -1.507400158017174e-18,  8.627825303949559e-20, -4.408337900528403e-21,  2.035011911654485e-22, -8.558480950292174e-24,
  4.606834891134539e-13, -1.967336692855524e-13,  4.497866775050170e-14, -6.990261584459083e-15,  8.220623266270866e-16, -7.774477407220717e-17,  6.149011894076110e-18,
 -4.179874934032963e-19,  2.491580339882443e-20, -1.322613622754639e-21,  6.328912167148449e-23, -2.753040718380448e-24,  1.178874336547357e-01, -5.919637478346228e-04,
  3.152886823644076e-06, -1.756291865869324e-08,  1.005333347921421e-10, -5.859681968558872e-13,  3.425144304855346e-15, -2.020745638770173e-17,  1.172455021736801e-19,
 -6.987010209308314e-22,  3.885319530936656e-24, -2.489893615981725e-26,  9.681858900645615e-02, -6.519552078607648e-04,  5.571811637806496e-06, -4.842332659707658e-08,
  4.075298583052154e-10, -3.318027119869287e-12,  2.626448054648215e-14, -2.032064646804115e-16,  1.540682842412485e-18, -1.149047718627766e-20,  8.428051685954817e-23,
 -6.110922143012493e-25,  6.529663192361650e-02, -6.658919702750663e-04,  8.395136504964023e-06, -9.683617551428865e-08,  1.040751123908503e-09, -1.062512756365423e-11,
  1.041563718464185e-13, -9.868409449456411e-16,  9.081296511212364e-18, -8.144739979394255e-20,  7.141262312881177e-22, -6.132689540925209e-24,  3.615610614306117e-02,
 -5.602216404918837e-04,  9.388392969584306e-06, -1.361047349388303e-07,  1.806700318673403e-09, -2.246182758939363e-11,  2.649148050757020e-13, -2.989513501065154e-15,
  3.248797394626609e-17, -3.415992090421998e-19,  3.488619712738319e-21, -3.470037465276736e-23,  1.643458905444327e-02, -3.738613301937509e-04,  7.943365843982192e-06,
 -1.419409123869121e-07,  2.284027926631489e-09, -3.393613723193399e-11,  4.729706712214690e-13, -6.250152046203233e-15,  7.892775363158387e-17, -9.580313750493334e-19,
  1.122857501799926e-20, -1.275174742824329e-22,  6.132380148714404e-03, -1.970573727813698e-04,  5.202565662209271e-06, -1.131797854551609e-07,  2.178384949479487e-09,
 -3.819705043899659e-11,  6.217534142631793e-13, -9.515123058010782e-15,  1.381590492282872e-16, -1.916333273985413e-18,  2.552614661034540e-20, -3.278508716616858e-22,
  1.879267686563990e-03, -8.246353191687453e-05,  2.678793576938037e-06, -7.027598160476191e-08,  1.602785537039048e-09, -3.288443966586332e-11,  6.201870621522665e-13,
 -1.090838937200762e-14,  1.808009665025182e-16, -2.845774678255211e-18,  4.279137198233336e-20, -6.175136948775458e-22,  4.735804304248708e-04, -2.760079833191345e-05,
  1.096409910951088e-06, -3.443647612274172e-08,  9.246535695650549e-10, -2.206768855699691e-11,  4.795519180331235e-13, -9.643506612034960e-15,  1.815362548641025e-16,
 -3.226690044278810e-18,  5.451323264674166e-20, -8.798036294502061e-22,  9.840577455689027e-05, -7.448992254972457e-06,  3.601186758792040e-07, -1.347015999947609e-08,
  4.239350060346246e-10, -1.172183401211993e-11,  2.924078645429293e-13, -6.698756729136898e-15,  1.427281582810645e-16, -2.855193246186474e-18,  5.401773074758473e-20,
 -9.718487290430746e-22,  1.694582398301596e-05, -1.636289492860071e-06,  9.587307058864375e-08, -4.254613957747178e-09,  1.564776809770772e-10, -4.999333108561298e-12,
  1.428060541142333e-13, -3.718172802700567e-15,  8.946003652412681e-17, -2.009536467298375e-18,  4.247816205926430e-20, -8.499888237886092e-22,  2.439705113300601e-06,
 -2.960956252003587e-07,  2.094532534542094e-08, -1.099741400842037e-09,  4.717083638705195e-11, -1.738412298438340e-12,  5.677349510425096e-14, -1.677439683335451e-15,
  4.550650266348374e-17, -1.146078868068288e-18,  2.702523943076514e-20, -6.004703455225816e-22,  2.979939890674175e-07, -4.488729743389872e-08,  3.819037983857100e-09,
 -2.367188112360387e-10,  1.182397106589492e-11, -5.020531557030931e-13,  1.872574572871681e-14, -6.271998989177114e-16,  1.916431006867662e-17, -5.405249351088316e-19,
  1.420135440612856e-20, -3.499098455231586e-22,  3.162017339522173e-08, -5.843711756957777e-09,  5.955151533927915e-10, -4.347613276579746e-11,  2.525092080924762e-12,
 -1.233850539000899e-13,  5.250401619265803e-15, -1.991468516603259e-16,  6.846181277155213e-18, -2.159949903077877e-19,  6.314866486668245e-21, -1.723006973621273e-22,
  3.025696900434137e-09, -6.780082782242155e-10,  8.232295659972323e-11, -7.055999919958196e-12,  4.754110036755754e-13, -2.668188190843345e-14,  1.293064961048247e-15,
 -5.544518492232525e-17,  2.140717349763712e-18, -7.540965637733240e-20,  2.448559037877269e-21, -7.382954111260264e-23,  2.764263108880420e-10, -7.408071319306389e-11,
  1.063482671950140e-11, -1.064319377028819e-12,  8.282266836371460e-14, -5.318293785230687e-15,  2.924691016302940e-16, -1.412756646183790e-17,  6.104901888571917e-19,
 -2.392796772423787e-20,  8.598417743665670e-22, -2.854723004286375e-23,  2.619963104432091e-11, -8.248688077039399e-12,  1.383164347308312e-12, -1.600626643168229e-13,
  1.426480290475602e-14, -1.039987055619186e-15,  6.443299763492827e-17, -3.482092642204373e-18,  1.672840045809497e-19, -7.247452392504992e-21,  2.863588601594954e-22,
 -1.040126734258337e-23,  2.873822163909818e-12, -1.037298148282780e-12,  1.992610210640514e-13, -2.621779119304312e-14,  2.635478427242760e-15, -2.151006632690427e-16,
  1.481630892849372e-17, -8.845938935102315e-19,  4.667834517067709e-20, -2.209501988837367e-21,  9.491593841022379e-23, -3.730733042101567e-24,  4.064667893567892e-13,
 -1.627232224505962e-13,  3.475993329364226e-14, -5.060812769106549e-15,  5.595888583840879e-16, -4.994513193115581e-17,  3.741442963756488e-18, -2.416952084348669e-19,
  1.373438631609207e-20, -6.970407550086081e-22,  3.197532460378785e-23, -1.336870141019700e-24,  6.958592267080752e-14, -2.962295123611200e-14,  6.749899093802584e-15,
 -1.045617741669485e-15,  1.225870939604242e-16, -1.155969337936341e-17,  9.117745967259597e-19, -6.181873234690390e-20,  3.675947126751827e-21, -1.946808325564886e-22,
  9.295421129789297e-24, -4.035104743292634e-25,  1.155687275367021e-01, -5.675571908529703e-04,  2.951410220775538e-06, -1.604385886033189e-08,  8.959227117440476e-11,
 -5.101526998453465e-13,  2.908281993316404e-15, -1.683011679458511e-17,  9.463814139685245e-20, -5.638693591550871e-22,  2.884060712372432e-24, -2.108610602766526e-26,
  9.429638709958527e-02, -6.095990164156609e-04,  5.027770573541748e-06, -4.240132329206762e-08,  3.470391700207211e-10, -2.750746044427524e-12,  2.120709029715775e-14,
 -1.599216175990400e-16,  1.181747971960324e-18, -8.600829853988605e-21,  6.147299003821499e-23, -4.361777964756944e-25,  6.276040609034025e-02, -6.031112424929322e-04,
  7.326417559504332e-06, -8.175719482593887e-08,  8.511668390605458e-10, -8.426639697319259e-12,  8.018890297769697e-14, -7.381272505499050e-16,  6.604436932388906e-18,
 -5.762140826684008e-20,  4.918430880101548e-22, -4.112389588730043e-24,  3.405574133271703e-02, -4.911881323358675e-04,  7.914800599933781e-06, -1.104724566002408e-07,
  1.414825302908437e-09, -1.700134138061502e-11,  1.940903227423760e-13, -2.122451497893304e-15,  2.237357338519067e-17, -2.283667392030150e-19,  2.265814014860693e-21,
 -2.190672371900809e-23,  1.505626384715219e-02, -3.165541634447765e-04,  6.438790502494912e-06, -1.102642401970270e-07,  1.705993039468371e-09, -2.442850957863231e-11,
  3.287010242908458e-13, -4.199496322489731e-15,  5.133320764892809e-17, -6.037297753818102e-19,  6.862442986616761e-21, -7.563913345842584e-23,  5.419556124784664e-03,
 -1.603301643582665e-04,  4.030721902668641e-06, -8.370873610879711e-08,  1.544419454987870e-09, -2.602980633940462e-11,  4.081110029106491e-13, -6.025892528255078e-15,
  8.453695210907425e-17, -1.134278886067394e-18,  1.463109159679989e-20, -1.821455963941579e-22,  1.587488893060676e-03, -6.401567456240695e-05,  1.970007285098086e-06,
 -4.917739105957228e-08,  1.072217654661856e-09, -2.109543751874504e-11,  3.824292962352224e-13, -6.478255933491869e-15,  1.035787372783796e-16, -1.574871947527782e-18,
  2.290364506951178e-20, -3.200167203465586e-22,  3.784180808226593e-04, -2.026085643648964e-05,  7.591747486139700e-07, -2.262875005332719e-08,  5.795071887940666e-10,
 -1.323619500023296e-11,  2.760115515354203e-13, -5.337661548486455e-15,  9.680375482720979e-17, -1.660261835540562e-18,  2.710230951242519e-20, -4.231655910250953e-22,
  7.349004762268682e-05, -5.114922832045954e-06,  2.325189538457360e-07, -8.236965107039987e-09,  2.467960203377632e-10, -6.520626252697033e-12,  1.558825980852935e-13,
 -3.430400521844257e-15,  7.035056057720873e-17, -1.356896936151957e-18,  2.478887189735167e-20, -4.312412106235851e-22,  1.166268801706860e-05, -1.037508358568366e-06,
  5.705884601627801e-08, -2.394976160417238e-09,  8.375734694508204e-11, -2.554515298263335e-12,  6.987268439630993e-14, -1.746441734287159e-15,  4.042480383830912e-17,
 -8.752146899935537e-19,  1.786051040501500e-20, -3.455364776145715e-22,  1.522019068573974e-06, -1.707202996898408e-07,  1.133184626507689e-08, -5.625540756936306e-10,
  2.293599617480112e-11, -8.066878357922743e-13,  2.522291466669283e-14, -7.153919953066251e-16,  1.867231838090714e-17, -4.533349015687976e-19,  1.032303119706603e-20,
 -2.218440245476923e-22,  1.652619744377175e-07, -2.311112963836660e-08,  1.847507787525334e-09, -1.083665450339934e-10,  5.148637311664740e-12, -2.087727515662891e-13,
  7.460368726632260e-15, -2.400483239030551e-16,  7.062612474801503e-18, -1.921978932717648e-19,  4.880958727699912e-21, -1.164364338021322e-22,  1.523814157401419e-08,
 -2.630561619968310e-09,  2.526748528949695e-10, -1.749765119469912e-11,  9.686124763359676e-13, -4.528338769795535e-14,  1.849451429895186e-15, -6.750881017828486e-17,
  2.238610054982764e-18, -6.826563226473766e-20,  1.932590668442899e-21, -5.114524050330533e-23,  1.234829490394390e-09, -2.605516448279206e-10,  2.997654767300613e-11,
 -2.447491041688920e-12,  1.577553229631961e-13, -8.499752891058862e-15,  3.966150345793851e-16, -1.641632990121528e-17,  6.131975647821521e-19, -2.093881054222748e-20,
  6.602146302223969e-22, -1.936252648407224e-23,  9.298303482948084e-11, -2.370350572211318e-11,  3.249090977133540e-12, -3.117503588868857e-13,  2.334125988076880e-14,
 -1.446436845461233e-15,  7.696458334819320e-17, -3.605375074213989e-18,  1.513934334563457e-19, -5.776414028681517e-21,  2.023932136976647e-22, -6.561722490421731e-24,
  7.093594651985531e-12, -2.150394004767819e-12,  3.477791431107679e-13, -3.892658584499175e-14,  3.364371169093067e-15, -2.384377356627745e-16,  1.439037009935682e-17,
 -7.589722240651113e-19,  3.564355319690185e-20, -1.511816548739789e-21,  5.855925584783685e-23, -2.087797674761023e-24,  6.199562381233438e-13, -2.183458550537554e-13,
  4.093781210464408e-14, -5.265875691289986e-15,  5.183764411460850e-16, -4.149774800831681e-17,  2.807635852405037e-18, -1.648626794257669e-19,  8.565967999569348e-21,
 -3.996637528961332e-22,  1.693922512783002e-23, -6.574946537538392e-25,  7.126363338580199e-14, -2.818571371629510e-14,  5.946678530758940e-15, -8.557211691306185e-16,
  9.359429126713220e-17, -8.269564826144757e-18,  6.136968698930511e-19, -3.930042665782510e-20,  2.215217524051548e-21, -1.115791653002625e-22,  5.082489171524560e-24,
 -2.111028466032110e-25,  1.059182208336889e-14, -4.492771586295991e-15,  1.019825999683726e-15, -1.574001972678217e-16,  1.838938510626677e-17, -1.728414206035209e-18,
  1.359105337603338e-19, -9.188176181666024e-21,  5.448734463335917e-22, -2.878290644612416e-23,  1.370970745763152e-24, -5.937751319070635e-26,  1.133445354147314e-01,
 -5.446923967787060e-04,  2.767159932812509e-06, -1.468836885247525e-08,  8.005072591120259e-11, -4.456846445615728e-13,  2.476533340665811e-15, -1.410600273208362e-17,
  7.619639501562249e-20, -4.665988542250858e-22,  1.985337190137031e-24, -2.028133093660231e-26,  9.193534083053861e-02, -5.713217294171511e-04,  4.550540558235673e-06,
 -3.726261097154065e-08,  2.967721779513160e-10, -2.291506355773066e-12,  1.721533832610243e-14, -1.266203305392169e-16,  9.121142172026221e-19, -6.486781652283084e-21,
  4.511170173749628e-23, -3.147818033448802e-25,  6.045928103081438e-02, -5.482048923434761e-04,  6.421802157004133e-06, -6.938884201626843e-08,  7.003210669606901e-10,
 -6.728024368787864e-12,  6.219343373025937e-14, -5.565054757533660e-16,  4.844585831394638e-18, -4.113554623801224e-20,  3.420899813513674e-22, -2.784984149138492e-24,
  3.220974088417776e-02, -4.328118654006668e-04,  6.714501396109221e-06, -9.032121429079826e-08,  1.116954450827371e-09, -1.298242915839539e-11,  1.435637124313291e-13,
 -1.522268254815107e-15,  1.557567200152649e-17, -1.544098846784826e-19,  1.489385299163034e-21, -1.400190340280832e-23,  1.388529718679666e-02, -2.699070251887063e-04,
  5.264558844582407e-06, -8.648516642571792e-08,  1.287667144285847e-09, -1.778343267292136e-11,  2.311881334848084e-13, -2.857487795207457e-15,  3.383154848345788e-17,
 -3.857481973275283e-19,  4.254821742084274e-21, -4.553840425458191e-23,  4.836910080035479e-03, -1.317186982044263e-04,  3.158881039414681e-06, -6.268293037564992e-08,
  1.109536510257803e-09, -1.798820543118641e-11,  2.718426940665606e-13, -3.875101398136990e-15,  5.255655260652552e-17, -6.825232747002813e-19,  8.529866291215931e-21,
 -1.029765344137475e-22,  1.359582023974353e-03, -5.035359394996410e-05,  1.470350240291362e-06, -3.495403918574885e-08,  7.291336339097025e-10, -1.376597305593492e-11,
  2.400355212191236e-13, -3.918330412428804e-15,  6.046657067497337e-17, -8.885340670188302e-19,  1.250347826602595e-20, -1.692205640805651e-22,  3.080003372736388e-04,
 -1.513402209375436e-05,  5.355673314116521e-07, -1.515966441461594e-08,  3.705195587567155e-10, -8.103888202916444e-12,  1.622441837802520e-13, -3.018702631621314e-15,
  5.276638806095267e-17, -8.735681335598753e-19,  1.378351211347974e-20, -2.082652137752117e-22,  5.620783842352836e-05, -3.591753090900401e-06,  1.536432726535042e-07,
 -5.156856232173972e-09,  1.471605997290009e-10, -3.716783252997143e-12,  8.518076323837042e-14, -1.801206333286409e-15,  3.556388769480625e-17, -6.615182660878572e-19,
  1.167202226963918e-20, -1.963730709535521e-22,  8.271277890512887e-06, -6.765783742279708e-07,  3.492917593874885e-08, -1.386793009217866e-09,  4.612331268700123e-11,
 -1.343030835079945e-12,  3.517995477949416e-14, -8.441915852421264e-16,  1.879979993100036e-17, -3.923128345547957e-19,  7.728995217221957e-21, -1.445660749584192e-22,
  9.851172473359312e-07, -1.018714845081950e-07,  6.341124717959715e-09, -2.975217707963217e-10,  1.152722309706925e-11, -3.868318071165326e-13,  1.157754505714746e-14,
 -3.151526077789635e-16,  7.912398552701276e-18, -1.851442098777289e-19,  4.070309201075389e-21, -8.458172450614257e-23,  9.576813199795802e-08, -1.239609083524366e-08,
  9.298076520333066e-10, -5.155983840052024e-11,  2.328308808576617e-12, -9.010046512454854e-14,  3.082802788112130e-15, -9.523705248717960e-17,  2.696569629737410e-18,
 -7.076536169022861e-20,  1.736154153411505e-21, -4.007738862236254e-23,  7.726519333903300e-09, -1.241436000810738e-09,  1.121551031977365e-10, -7.355150669406187e-12,
  3.875436816030547e-13, -1.731408477915020e-14,  6.779712494898277e-16, -2.379205889686569e-17,  7.602980533320146e-19, -2.238954242483747e-20,  6.132310812735325e-22,
 -1.572777942281971e-23,  5.332315304399845e-10, -1.055090634680878e-10,  1.146925164240811e-11, -8.899820323249910e-13,  5.477077337733307e-14, -2.828111584077354e-15,
  1.268640718285488e-16, -5.061530835176497e-18,  1.826625186635188e-19, -6.038554376361160e-21,  1.846680484679457e-22, -5.261698232492067e-24,  3.317866673155178e-11,
 -8.010046896725103e-12,  1.044782371429875e-12, -9.583806139093345e-14,  6.886875384562350e-15, -4.109546350837145e-16,  2.111558539450733e-17, -9.575026504103628e-19,
  3.900365570288268e-20, -1.446416130434252e-21,  4.934127843970059e-23, -1.559912936900315e-24,  2.031048255736315e-12, -5.903260606524040e-13,  9.175424467169362e-14,
 -9.902842232557393e-15,  8.277934870271977e-16, -5.689157651831808e-17,  3.337388326858349e-18, -1.714391370610469e-19,  7.856026225960377e-21, -3.256602606469188e-22,
  1.234642361837904e-23, -4.314264266241415e-25,  1.398636922187055e-13, -4.790247042563738e-14,  8.739175276427690e-15, -1.095998535751652e-15,  1.054007669880584e-16,
 -8.257980855783795e-18,  5.477111066104667e-19, -3.157409665431812e-20,  1.612702144800740e-21, -7.405535786620960e-23,  3.092467776532585e-24, -1.183831479389186e-25,
  1.282829971254640e-14, -5.002991959477146e-15,  1.040605204199614e-15, -1.477504096589730e-16,  1.596077920508484e-17, -1.394121634422481e-18,  1.023664615427495e-19,
 -6.491208095380338e-21,  3.625569528431046e-22, -1.810727531649184e-23,  8.182945397716543e-25, -3.373872055744333e-26,  1.626332550155538e-15, -6.869993199734581e-16,
  1.552652405634028e-16, -2.386366343194602e-17,  2.777077845633915e-18, -2.600544717468914e-19,  2.037822977232564e-20, -1.373198887248827e-21,  8.118524528606158e-23,
 -4.276347009969925e-24,  2.031404020638093e-25, -8.775865501709192e-27,  1.112089539424754e-01, -5.232390423303946e-04,  2.598300329865731e-06, -1.347576690739911e-08,
  7.170076855788196e-11, -3.907269517131031e-13,  2.113275074865578e-15, -1.192292000420899e-17,  6.060960289238185e-20, -4.054662987042783e-22,  1.056180177564110e-24,
 -2.231455421203120e-26,  8.972014014840671e-02, -5.366286312396357e-04,  4.130436522457393e-06, -3.285959707334298e-08,  2.548027303431159e-10, -1.917788426737142e-12,
  1.404582407119770e-14, -1.008462233386666e-16,  7.079835081652491e-19, -4.932214715546149e-21,  3.323109948846962e-23, -2.302268510325845e-25,  5.836419281740123e-02,
 -4.999803769490850e-04,  5.652175330640314e-06, -5.918408801064236e-08,  5.795099040663536e-10, -5.406129294681341e-12,  4.857655703705807e-14, -4.227539261498794e-16,
  3.583128740212683e-18, -2.961708250931441e-20,  2.402383499061502e-22, -1.903144436407165e-24,  3.057946537537765e-02, -3.831460459775534e-04,  5.729875167974203e-06,
 -7.435346533124433e-08,  8.885793430460788e-10, -9.996813721360440e-12,  1.071579316259129e-13, -1.102393188309340e-15,  1.095590145036723e-17, -1.055320684743064e-19,
  9.904112337603891e-22, -9.054395680457777e-24,  1.288379029366684e-02, -2.316167958039992e-04,  4.339522999021546e-06, -6.845152787911611e-08,  9.815846383677024e-10,
 -1.308444579286211e-11,  1.644606489223407e-13, -1.967774052868557e-15,  2.258019317592772e-17, -2.497306581373247e-19,  2.674612183755324e-21, -2.780735125049760e-23,
  4.356206188005909e-03, -1.091798458475267e-04,  2.502384268509721e-06, -4.748771731669867e-08,  8.071196710300778e-10, -1.259652154811360e-11,  1.836141171917144e-13,
 -2.528514105044110e-15,  3.317328322748356e-17, -4.171834880924360e-19,  5.054189223596789e-21, -5.919686066428293e-23,  1.179291498784256e-03, -4.008932269645168e-05,
  1.112733749961632e-06, -2.521116648359041e-08,  5.035520013362508e-10, -9.129466560711511e-12,  1.532147292805667e-13, -2.411557079151852e-15,  3.593755833075918e-17,
 -5.106273566489812e-19,  6.955985677118999e-21, -9.122537225423480e-23,  2.550088037322508e-04, -1.148743931333582e-05,  3.844869875249470e-07, -1.034205046825168e-08,
  2.414093213497385e-10, -5.059163538059079e-12,  9.729823634520144e-14, -1.742601215285621e-15,  2.937147618919791e-17, -4.695649341442346e-19,  7.163942715117146e-21,
 -1.047864688003412e-22,  4.395707397344293e-05, -2.575112811001139e-06,  1.037533017276170e-07, -3.300983276729079e-09,  8.976493754725620e-11, -2.168208451562671e-12,
  4.765570996829357e-14, -9.686459508709683e-16,  1.841914510357038e-17, -3.305020038251092e-19,  5.633475718030920e-21, -9.167977716926210e-23,  6.033786948530727e-06,
 -4.529443076485444e-07,  2.195835606015646e-08, -8.247923238098228e-10,  2.609409399008077e-11, -7.255690650828087e-13,  1.820447299017543e-14, -4.194586735971235e-16,
  8.988200972594084e-18, -1.808026100072543e-19,  3.439016557137587e-21, -6.219229306588073e-23,  6.602364891697360e-07, -6.279107503139703e-08,  3.663960544887120e-09,
 -1.624367906039699e-10,  5.979742616396758e-12, -1.914432621146007e-13,  5.483922268153549e-15, -1.432518644386860e-16,  3.459106063139796e-18, -7.799798724405614e-20,
  1.655232996039265e-21, -3.325357695109543e-23,  5.788380408355196e-08, -6.913917861206035e-09,  4.860502547118458e-10, -2.546026363295366e-11,  1.092084087227651e-12,
 -4.031032084125595e-14,  1.319944127658210e-15, -3.913237794632390e-17,  1.065822377951526e-18, -2.696037557548992e-20,  6.387209870093962e-22, -1.426117137243401e-23,
  4.116454543106289e-09, -6.133564794105731e-10,  5.201623036643101e-11, -3.225776613775232e-12,  1.615861662912790e-13, -6.891603781942341e-15,  2.584808243604030e-16,
 -8.713020793026021e-18,  2.680961939794979e-19, -7.617990446883251e-21,  2.017076942032482e-22, -5.009725102072694e-24,  2.435398262868404e-10, -4.499905803705712e-11,
  4.608977941258579e-12, -3.391675191497055e-13,  1.989256438392977e-14, -9.827938283984233e-16,  4.232023858638398e-17, -1.625326328822248e-18,  5.659807893762583e-20,
 -1.809245799724874e-21,  5.360276416901809e-23, -1.482192527755182e-24,  1.257264028383182e-11, -2.861288085517889e-12,  3.539121476573270e-13, -3.094882201452680e-14,
  2.129291930135226e-15, -1.220851674861306e-16,  6.045591036434620e-18, -2.648936619318211e-19,  1.045010832150219e-20, -3.760691190045276e-22,  1.247173223612595e-23,
 -3.839567314102448e-25,  6.168002941843344e-13, -1.710932500600167e-13,  2.546100658142746e-14, -2.641204438421106e-15,  2.129337293538679e-16, -1.415576109942636e-17,
  8.053162075179397e-19, -4.020844111226932e-20,  1.794394947483535e-21, -7.256963855328260e-23,  2.688412842694818e-24, -9.193193386800255e-26,  3.313855615749000e-14,
 -1.099465947931914e-14,  1.945116037302541e-15, -2.371243830674388e-16,  2.221843503243775e-17, -1.699648653390654e-18,  1.102715593896652e-19, -6.228610496382879e-21,
  3.121815577108183e-22, -1.408578333184897e-23,  5.786594723816981e-25, -2.181663655904773e-26,  2.379509757464439e-15, -9.129623922620964e-16,  1.867994354441693e-16,
 -2.611871198213216e-17,  2.781772558083680e-18, -2.398251691188213e-19,  1.739874901515763e-20, -1.091061903806168e-21,  6.031454169589408e-23, -2.983626993811954e-24,
  1.336409972472856e-25, -5.464768074509987e-27,  2.522231434176384e-16, -1.060357582417958e-16,  2.384471992971929e-17, -3.647340309584147e-18,  4.225492894897879e-19,
 -3.940329635619076e-20,  3.075634411417965e-21, -2.064968662505338e-22,  1.216665688887068e-23, -6.388145542465464e-25,  3.025460131470120e-26, -1.303346483336416e-27,
  1.091565731921091e-01, -5.030805504433793e-04,  2.443225146425328e-06, -1.238842494547910e-08,  6.436745070309081e-11, -3.438085310908128e-13,  1.804438802408076e-15,
 -1.021077619786651e-17,  4.652948956113493e-20, -3.836064987739078e-22,  2.390856393842024e-26, -2.390047834429663e-26,  8.763730942373016e-02, -5.050958940053972e-04,
  3.759373492142523e-06, -2.907219979382891e-08,  2.196018068222511e-10, -1.612168273588325e-12,  1.151433335480130e-14, -8.079380596726062e-17,  5.520852193290207e-19,
 -3.786490489298814e-21,  2.449164132253903e-23, -1.701054464708053e-25,  5.645042031725037e-02, -4.574540086867357e-04,  4.994225905537532e-06, -5.071736991224827e-08,
  4.821498959056554e-10, -4.370303361157639e-12,  3.819673362787995e-14, -3.234506011874548e-16,  2.671477961009254e-18, -2.149105385240519e-20,  1.703601520853900e-22,
 -1.311661625099314e-24,  2.913323059497442e-02, -3.406486540603289e-04,  4.916764886337052e-06, -6.160577654888264e-08,  7.120515287464616e-10, -7.759066094368599e-12,
  8.067834070354030e-14, -8.056605465162787e-16,  7.783368880053643e-18, -7.285732939363943e-20,  6.660738541592672e-22, -5.920536289539902e-24,  1.202190551800435e-02,
 -1.999378765627618e-04,  3.604347869426230e-06, -5.464259211750673e-08,  7.552926040017659e-10, -9.724536299974218e-12,  1.182617940637206e-13, -1.370579429545858e-15,
  1.525348561197447e-17, -1.637026810038672e-19,  1.703629856676451e-21, -1.721143767535957e-23,  3.956202400489993e-03, -9.123834803485352e-05,  2.002416092439799e-06,
 -3.637189151102347e-08,  5.940877151226964e-10, -8.932007499885535e-12,  1.256707987549963e-13, -1.672826495980689e-15,  2.124325948598461e-17, -2.588359869576829e-19,
  3.041548672668947e-21, -3.457660613529004e-23,  1.034998474474064e-03, -3.227330648403896e-05,  8.531049346540935e-07, -1.843607728168864e-08,  3.528707311294608e-10,
 -6.147889447615452e-12,  9.936940010910053e-14, -1.508948728815503e-15,  2.172718428101451e-17, -2.986537516813625e-19,  3.940294219973584e-21, -5.009600996577098e-23,
  2.145083514887743e-04, -8.849239359988886e-06,  2.805884873634421e-07, -7.176951615736367e-09,  1.601145633187715e-10, -3.217157242197614e-12,  5.947013739989219e-14,
 -1.025786600173886e-15,  1.667941785980437e-17, -2.576113577838444e-19,  3.801764294883671e-21, -5.385018363681725e-23,  3.509638350349819e-05, -1.882050830863135e-06,
  7.150662557311677e-08, -2.157664756833133e-09,  5.594390704291075e-11, -1.292946973673811e-12,  2.726639706404914e-14, -5.329388706773638e-16,  9.763233589168078e-18,
 -1.690462093378726e-19,  2.784363826818939e-21, -4.384188342569217e-23,  4.519397938532381e-06, -3.107362259758996e-07,  1.415424688226161e-08, -5.031163999468535e-10,
  1.514597799566309e-11, -4.022810645155151e-13,  9.670063890581420e-15, -2.139932126369330e-16,  4.413004652352318e-18, -8.558227306700833e-20,  1.571824602983043e-21,
 -2.748551352592287e-23,  4.573141665001873e-07, -3.990036040007618e-08,  2.182336920558855e-09, -9.140876238614274e-11,  3.197218696927762e-12, -9.765338988459448e-14,
  2.677256297311476e-15, -6.711056831643170e-17,  1.558510757735216e-18, -3.386231749580989e-20,  6.936040601683741e-22, -1.347014335966664e-23,  3.642066030109643e-08,
 -4.002253866383733e-09,  2.634648227683196e-10, -1.302853188661872e-11,  5.305807312613132e-13, -1.867292325986236e-14,  5.849420367969692e-16, -1.663643334203966e-17,
  4.357117989730825e-19, -1.061986615308019e-20,  2.428657681830366e-22, -5.243049095137870e-24,  2.300696803652606e-09, -3.167486485757988e-10,  2.517177015178324e-11,
 -1.474274845473427e-12,  7.013622734272909e-14, -2.853031761422322e-15,  1.024134088550074e-16, -3.313487223811850e-18,  9.809814160219466e-20, -2.687776246600304e-21,
  6.875116010841723e-23, -1.652443501769249e-24,  1.175528223072018e-10, -2.019596583198625e-11,  1.943926322257399e-12, -1.353860286815791e-13,  7.554834185799177e-15,
 -3.565952925467398e-16,  1.472042748922631e-17, -5.435271460844675e-19,  1.824181407309550e-20, -5.632410533305643e-22,  1.614930835031902e-23, -4.329234949099820e-25,
  5.062951392685327e-12, -1.080945476681879e-12,  1.263528988388734e-13, -1.050418672405629e-14,  6.902849680947360e-16, -3.794895104714850e-17,  1.807662106264628e-18,
 -7.639908724491975e-20,  2.914185447581865e-21, -1.016162662775264e-22,  3.271463410572199e-24, -9.794298894178900e-26,  1.992077051858474e-13, -5.247417961108235e-14,
  7.446916075394000e-15, -7.400291042779104e-16,  5.737379055604604e-17, -3.679993367157086e-18,  2.025561826958164e-19, -9.808950815603285e-21,  4.254836301204944e-22,
 -1.675747015855314e-23,  6.055935133212264e-25, -2.023350870109453e-26,  8.282338576592948e-15, -2.650331523590823e-15,  4.529736517741717e-16, -5.350158323492611e-17,
  4.870213274472121e-18, -3.628153059529627e-19,  2.297230665776162e-20, -1.268709387859056e-21,  6.227770682186602e-23, -2.756186020840927e-24,  1.112077922399172e-25,
 -4.123117274895157e-27,  4.566661028015705e-16, -1.719033339210828e-16,  3.451169956711980e-17, -4.741177140671557e-18,  4.968412573649796e-19, -4.220143465479520e-20,
  3.019996524716465e-21, -1.870079758950971e-22,  1.021818087711156e-23, -5.000497497303089e-25,  2.217506440146391e-26, -8.984001041916420e-28,  3.956897736862452e-17,
 -1.654235099024526e-17,  3.698410484211984e-18, -5.626066916133515e-19,  6.484414378701750e-20, -6.017931505711247e-21,  4.676453591908314e-22, -3.126772780026233e-23,
  1.835172294142448e-24, -9.600942700587074e-26,  4.531738112164292e-27, -1.946090334531211e-28,  1.071824251191738e-01, -4.841123934954070e-04,  2.300523771992976e-06,
 -1.141129645432081e-08,  5.790200261137761e-11, -3.037773734456174e-13,  1.537295939097461e-15, -8.944587419881938e-18,  3.249636624095400e-20, -4.019813821532756e-22,
 -8.616109746457626e-25, -1.228668238707503e-26,  8.567494755109935e-02, -4.763589965914234e-04,  3.430571455015912e-06, -2.580223790777033e-08,  1.899484473852810e-10,
 -1.361094191807734e-12,  9.480216044695750e-15, -6.513278247182184e-17,  4.317348349791275e-19, -2.942010628661365e-21,  1.807915975027763e-23, -1.222368712220878e-25,
  5.469683415415076e-02, -4.198098242970812e-04,  4.429172785071043e-06, -4.365532574364887e-08,  4.032245124541379e-10, -3.553271595994382e-12,  3.022939145789537e-14,
 -2.491319227137701e-16,  2.007743599837652e-18, -1.570226791758857e-20,  1.219646088260544e-22, -9.146346228965797e-25,  2.784488087341300e-02, -3.040890806265061e-04,
  4.241052514021695e-06, -5.135639096850775e-08,  5.745415729711603e-10, -6.067594740416597e-12,  6.124640127778530e-14, -5.938854858842917e-16,  5.583381886434695e-18,
 -5.076964227563872e-20,  4.528459920236266e-22, -3.918577438557977e-24,  1.127594247268620e-02, -1.735343387996647e-04,  3.015192791768214e-06, -4.397174386233684e-08,
  5.863397855286088e-10, -7.296620718903246e-12,  8.591901543763722e-14, -9.649580699306346e-16,  1.042405445432913e-17, -1.085816836731624e-19,  1.098956415152901e-21,
 -1.079606457980732e-23,  3.620734883029678e-03, -7.681586400870048e-05,  1.617581111719960e-06, -2.814638042318231e-08,  4.421778802943960e-10, -6.409000987457862e-12,
  8.709944852681524e-14, -1.121332890976073e-15,  1.379241353428928e-17, -1.628901258766614e-19,  1.857692530519616e-21, -2.050831940812062e-23,  9.182779474711552e-04,
 -2.624598680158582e-05,  6.620736210450887e-07, -1.365729924132469e-08,  2.507068261457864e-10, -4.200409884451042e-12,  6.543053920523502e-14, -9.591261158288047e-16,
  1.335162190812117e-17, -1.776286241504457e-19,  2.270888935592974e-21, -2.800163139900376e-23,  1.831109787162483e-04, -6.909904653239332e-06,  2.079396531978866e-07,
 -5.061095373840016e-09,  1.079965915720974e-10, -2.081849611243367e-12,  3.701146783167220e-14, -6.151597641149592e-16,  9.654367414577556e-18, -1.441155901413945e-19,
  2.058138124871737e-21, -2.824153716821618e-23,  2.856745813861062e-05, -1.400106108543645e-06,  5.023461479703451e-08, -1.438381945287460e-09,  3.558131625695498e-11,
 -7.872557623800773e-13,  1.593702296706473e-14, -2.996694776429870e-16,  5.291025548301061e-18, -8.843163635421406e-20,  1.407930234120866e-21, -2.145506288164365e-23,
  3.469786142654078e-06, -2.180707375085572e-07,  9.341257767624656e-09, -3.143187015340481e-10,  9.007635399976899e-12, -2.286089383105568e-13,  5.266613661948927e-15,
 -1.119646502126488e-16,  2.222641963651232e-18, -4.156460897774706e-20,  7.372384748789807e-22, -1.246708004796205e-23,  3.267402259091593e-07, -2.608819863939345e-08,
  1.337692577928387e-09, -5.293691556296881e-11,  1.759446095282382e-12, -5.127302516632922e-14,  1.345478773862045e-15, -3.236629273744629e-17,  7.229020156240189e-19,
 -1.513472943752803e-20,  2.992120513881503e-22, -5.616947824180265e-24,  2.380864050750988e-08, -2.399699173300579e-09,  1.478316503581184e-10, -6.898121230996750e-12,
  2.666329045264165e-13, -8.944551739155922e-15,  2.679857416550208e-16, -7.310011145075739e-18,  1.840507703438659e-19, -4.321374553949016e-21,  9.537009927290919e-23,
 -1.990117216615954e-24,  1.346549258426474e-09, -1.706657531092466e-10,  1.269014614782459e-11, -7.011788974245876e-13,  3.165294002440704e-14, -1.227163553849851e-15,
  4.213076717320197e-17, -1.307486912708040e-18,  3.722188502635431e-20, -9.827697986851589e-22,  2.427092586970028e-23, -5.641998202232725e-25,  5.989955076003640e-11,
 -9.527069831383774e-12,  8.596554472973714e-13, -5.655863527878670e-14,  2.998199030727653e-15, -1.350232765093529e-16,  5.336854255600066e-18, -1.892366363469315e-19,
  6.114716948516874e-21, -1.821768723587557e-22,  5.050103399687516e-24, -1.311258855322116e-25,  2.167173330089081e-12, -4.319017631064312e-13,  4.754909187098359e-14,
 -3.747835357609302e-15,  2.347104754114822e-16, -1.234741732053378e-17,  5.647388966392063e-19, -2.298436417372491e-20,  8.463830323570356e-22, -2.855476069702927e-23,
  8.912050272745211e-25, -2.591281038577751e-26,  6.858234080389927e-14, -1.706387838389773e-14,  2.299921386169922e-15, -2.181992373184061e-16,  1.622051893301048e-17,
 -1.001182757497495e-18,  5.319353745949334e-20, -2.493059452046073e-21,  1.049048950695258e-22, -4.016194885793470e-24,  1.413438441597131e-25, -4.606707938402006e-27,
  2.193291943829294e-15, -6.736047356899135e-16,  1.107595874829434e-16, -1.262949924839951e-17,  1.113402639650671e-18, -8.055152058676534e-20,  4.965029675078373e-21,
 -2.675010211677063e-22,  1.283372010247753e-23, -5.560412417688708e-25,  2.199679090049944e-26, -8.007084417103486e-28,  9.109893824040967e-17, -3.353570771706085e-17,
  6.586466125887747e-18, -8.866811886798465e-19,  9.121005574361174e-20, -7.616965644265433e-21,  5.366672316006325e-22, -3.276046550941062e-23,  1.766621069216114e-24,
 -8.540834120743259e-26,  3.745088970933661e-27, -1.501557053165107e-28,  6.290909116961959e-18, -2.612794285818379e-18,  5.802054986602577e-19, -8.769921170380553e-20,
  1.004808456892155e-20, -9.274129096113033e-22,  7.170227082608199e-23, -4.771599638275884e-24,  2.788313929089845e-25, -1.452806268283761e-26,  6.831357925303418e-28,
 -2.923249981160419e-29,  1.052819383085128e-01, -4.662406453369701e-04,  2.168952579307272e-06, -1.053154737049062e-08,  5.217566947415154e-11, -2.697837700943395e-13,
  1.299179744980382e-15, -8.143332735067722e-18,  1.737361345796997e-20, -4.355298408778706e-22, -4.139569149897203e-25,  4.375326574623332e-26,  8.382251004805415e-02,
 -4.501032579085337e-04,  3.138319744076786e-06, -2.296906880198828e-08,  1.648617646061365e-10, -1.153985586602771e-12,  7.834931439216104e-15, -5.288197456094270e-17,
  3.376718680229856e-19, -2.312142057254770e-21,  1.378827025178566e-23, -7.053730396479743e-26,  5.308529184307980e-02, -3.863673767209949e-04,  3.941794779088695e-06,
 -3.773508536687086e-08,  3.388845241338347e-10, -2.904705033919484e-12,  2.407446911176950e-14, -1.930605375857451e-16,  1.521365182381978e-18, -1.154386399837125e-20,
  8.782703147687713e-23, -6.573055088431085e-25,  2.669268739099066e-02, -2.724782225031858e-04,  3.676171287084722e-06, -4.305998667317127e-08,  4.666394877080009e-10,
 -4.778608801169708e-12,  4.686729723593058e-14, -4.412759611894523e-16,  4.044057705549759e-18, -3.568615811615846e-20,  3.105753255650606e-22, -2.645384692732225e-24,
  1.062691774609044e-02, -1.513743617124415e-04,  2.539344073813271e-06, -3.565427991635801e-08,  4.590199226985055e-10, -5.524426915703679e-12,  6.303802597461962e-14,
 -6.862961651964899e-16,  7.203939401867323e-18, -7.282881817591079e-20,  7.171391504614807e-22, -6.874650518501229e-24,  3.337371421514533e-03, -6.511502234781040e-05,
  1.318384440563259e-06, -2.199323930760087e-08,  3.325950408040334e-10, -4.650454857106701e-12,  6.109243522584168e-14, -7.610542956212520e-16,  9.073849062019168e-18,
 -1.039062277827270e-19,  1.150630579654602e-21, -1.235118194177515e-23,  8.229377241718619e-04, -2.154262828525243e-05,  5.197349821559494e-07, -1.024106641558708e-08,
  1.804532061646864e-10, -2.909400565061666e-12,  4.370751103989518e-14, -6.188114473632360e-16,  8.333301279759548e-18, -1.073504006001865e-19,  1.330490543383177e-21,
 -1.592174278148393e-23,  1.584514123107744e-04, -5.462822504435128e-06,  1.563418840477887e-07, -3.623267395998010e-09,  7.400913793450387e-11, -1.369638510543352e-12,
  2.343280855877412e-14, -3.754894224924011e-16,  5.690814562532374e-18, -8.214012821371344e-20,  1.135649531695148e-21, -1.510285738072994e-23,  2.367371041169728e-05,
 -1.058667901533449e-06,  3.593052546334485e-08, -9.768027587228756e-10,  2.306911319250529e-11, -4.889180657365243e-13,  9.506035835508022e-15, -1.720352860154649e-16,
  2.928736357962469e-18, -4.726768926898772e-20,  7.276738521223545e-22, -1.073512176995760e-23,  2.726126281600743e-06, -1.562855236141826e-07,  6.302931308445790e-09,
 -2.008435085344614e-10,  5.481841525954806e-12, -1.329961145516533e-13,  2.937508438650253e-15, -6.001340141975751e-17,  1.147139704563692e-18, -2.069104420251489e-20,
  3.545057244830319e-22, -5.798509240166473e-24,  2.403528806077090e-07, -1.751695563864215e-08,  8.424582252552289e-10, -3.150177776086550e-11,  9.951332926716397e-13,
 -2.767402412506875e-14,  6.952097585520321e-16, -1.605103434974597e-17,  3.448262486754146e-19, -6.956867628353214e-21,  1.327532772460810e-22, -2.408978973621121e-24,
  1.613784505025210e-08, -1.487259541591259e-09,  8.571464480825879e-11, -3.772899748858997e-12,  1.383926925174107e-13, -4.424652256580962e-15,  1.267724226883642e-16,
 -3.316090238970752e-18,  8.025222630940046e-20, -1.814803399664926e-21,  3.864375957827795e-23, -7.792972280043448e-25,  8.237189612369679e-10, -9.575316695049946e-11,
  6.653735998132562e-12, -3.465265539146714e-13,  1.483357066837387e-14, -5.477722641059310e-16,  1.797657923426976e-17, -5.348465517163048e-19,  1.463377337278214e-20,
 -3.721466724500997e-22,  8.869117432854039e-24, -1.993013580242383e-25,  3.217572323758397e-11, -4.716713713579355e-12,  3.980962111758988e-13, -2.470149726342741e-14,
  1.242248816381074e-15, -5.331406764620678e-17,  2.015510663725242e-18, -6.856310869203681e-20,  2.130959027720668e-21, -6.120523294141192e-23,  1.638936083388651e-24,
 -4.118225897107514e-26,  9.858272592326805e-13, -1.824460985068146e-13,  1.885572787701288e-14, -1.405507701080791e-15,  8.370281913874288e-17, -4.205698046925230e-18,
  1.843845418203954e-19, -7.215095532886632e-21,  2.561214653264384e-22, -8.348787384805696e-24,  2.522744574937369e-25, -7.114949899731727e-27,  2.521592749237992e-14,
 -5.892300182452563e-15,  7.511028146164052e-16, -6.779840092012363e-17,  4.818407342061595e-18, -2.854582875052493e-19,  1.460570410074869e-20, -6.611012607723798e-22,
  2.693272258951123e-23, -1.000457621911969e-24,  3.423002495159553e-26, -1.086542286473737e-27,  6.181250950930390e-16, -1.811970616064009e-16,  2.853413207046044e-17,
 -3.129050119054015e-18,  2.662640799126110e-19, -1.865235241081036e-20,  1.116243869356807e-21, -5.852828729679349e-23,  2.738407506560153e-24, -1.159198292840676e-25,
  4.487767034905960e-27, -1.601124959193267e-28,  1.898840423749125e-17, -6.809411147735488e-18,  1.303776500472719e-18, -1.714690034837625e-19,  1.726774910049557e-20,
 -1.414387679662001e-21,  9.790628786785046e-23, -5.880533103071296e-24,  3.124215555857589e-25, -1.489829530396527e-26,  6.450472919860039e-28, -2.556137087758499e-29,
  1.015843128764961e-18, -4.186381948990144e-19,  9.222725477280851e-20, -1.383669451542168e-20,  1.574442263965533e-21, -1.443975386802408e-22,  1.109887464990341e-23,
 -7.346230459055337e-25,  4.271419593605271e-26, -2.215267317335550e-27,  1.037183400349929e-28, -4.420561240872047e-30,  1.034508980790443e-01, -4.493807466398199e-04,
  2.047410096068994e-06, -9.738284511689697e-09,  4.707359131903521e-11, -2.412912661423957e-13,  1.076601304384961e-15, -7.835685393232398e-18,  2.172242167915409e-21,
 -3.776936460444940e-22,  4.409821600725455e-24,  1.962012189768816e-25,  8.207062555809598e-02, -4.260560629524988e-04,  2.877787787358348e-06, -2.050618392902917e-08,
  1.435484975766221e-10, -9.825677888695941e-13,  6.493729185690884e-15, -4.330674180660874e-17,  2.637922356640187e-19, -1.802683921110718e-21,  1.224054448776094e-23,
  6.101947507422110e-27,  5.160014774305790e-02, -3.565563459273034e-04,  3.519686460333169e-06, -3.274803633121354e-08,  2.861573204748276e-10, -2.386645954898017e-12,
  1.929239226572199e-14, -1.504015204455022e-16,  1.162520404462295e-18, -8.559256045241996e-21,  6.244422216510981e-23, -5.142564414351625e-25,  2.565849077176578e-02,
 -2.450156918901023e-04,  3.201282046783003e-06, -3.630116958271682e-08,  3.813854820919823e-10, -3.788545755255876e-12,  3.614603015642070e-14, -3.302352499865059e-16,
  2.957334231783136e-18, -2.533197713881083e-20,  2.127736971979939e-22, -1.868951960386742e-24,  1.005950590718408e-02, -1.326540548455236e-04,  2.152161990516372e-06,
 -2.911776194550442e-08,  3.622290142896352e-10, -4.218298725402298e-12,  4.669123766673343e-14, -4.927255876113468e-16,  5.032928866759794e-18, -4.939985610641754e-20,
  4.717075674697487e-22, -4.477114533178179e-24,  3.096453004772820e-03, -5.553974129300528e-05,  1.083564980841538e-06, -1.734282316704681e-08,  2.526780393625587e-10,
 -3.410302823781582e-12,  4.334332601455009e-14, -5.226219422561363e-16,  6.045578797323828e-18, -6.715541951424099e-20,  7.216149415817402e-22, -7.564531242601784e-24,
  7.443685465220045e-04, -1.783131553692652e-05,  4.124152246483160e-07, -7.767715943615529e-09,  1.314933486330790e-10, -2.041442673212821e-12,  2.959912571296320e-14,
 -4.049371622987274e-16,  5.278949946594483e-18, -6.587975862188878e-20,  7.916719293692662e-22, -9.207716296467816e-24,  1.388521289624786e-04, -4.367773465639054e-06,
  1.191536246958340e-07, -2.630943556747134e-09,  5.148443314894404e-11, -9.152858330301610e-13,  1.507975778050113e-14, -2.330814716537049e-16,  3.413265631699228e-18,
 -4.765904830458699e-20,  6.381254704682601e-22, -8.230139462234323e-24,  1.994766133077779e-05, -8.125054734133953e-07,  2.613693819654211e-08, -6.749935424006030e-10,
  1.523074866412875e-11, -3.093789313989205e-13,  5.780579559779427e-15, -1.007336925689912e-16,  1.654253748800199e-18, -2.579139994857231e-20,  3.840535686964867e-22,
 -5.487216503983173e-24,  2.188433702970274e-06, -1.141913294919614e-07,  4.342297707615542e-09, -1.310875537540793e-10,  3.409648245932513e-12, -7.911385450271113e-14,
  1.676030580686021e-15, -3.291767629352003e-17,  6.060689634631738e-19, -1.054691863897773e-20,  1.745943072383352e-22, -2.762871372170216e-24,  1.817035188082152e-07,
 -1.205555043693722e-08,  5.442720696149427e-10, -1.923394889266711e-11,  5.776801307878289e-13, -1.533456939944318e-14,  3.688714531328548e-16, -8.175579900533862e-18,
  1.689656291845103e-19, -3.285386632180619e-21,  6.051838133094061e-23, -1.061628113846711e-24,  1.131896085061014e-08, -9.507881398520217e-10,  5.126557423463415e-11,
 -2.128278238895880e-12,  7.408182015057826e-14, -2.257284491409520e-15,  6.184585224274770e-17, -1.551261286170662e-18,  3.608244816811545e-20, -7.858076413221380e-22,
  1.614267198267157e-23, -3.145553168640258e-25,  5.255934632797586e-10, -5.582403656046971e-11,  3.621919700499913e-12, -1.776687265210792e-13,  7.208134703161497e-15,
 -2.534251230562669e-16,  7.946728209121035e-18, -2.265801118240554e-19,  5.955848576472886e-21, -1.458254750464364e-22,  3.352405520468684e-24, -7.279326376528721e-26,
  1.818941235977957e-11, -2.446442398636276e-12,  1.927615284767312e-13, -1.126386916841549e-14,  5.367761221195390e-16, -2.193168561010353e-17,  7.922858304461548e-19,
 -2.583437621828128e-20,  7.716818822705515e-22, -2.135023526021284e-23,  5.518305880561563e-25, -1.340859837616800e-26,  4.762497196361919e-13, -8.141192733535186e-14,
  7.874038099653225e-15, -5.537385388164320e-16,  3.129731306065205e-17, -1.499361227441401e-18,  6.291096938974734e-20, -2.363455706717551e-21,  8.076644725708650e-23,
 -2.540479538661546e-24,  7.423068632035755e-26, -2.028300225620578e-27,  9.914692895474931e-15, -2.162721373949402e-15,  2.596299171421500e-16, -2.222186368588428e-17,
  1.505514801493022e-18, -8.539120263949744e-20,  4.197935847182122e-21, -1.831244796209018e-22,  7.208907065425536e-24, -2.593614582456922e-25,  8.612448507743507e-27,
 -2.658275281063732e-28,  1.861771837322698e-16, -5.177268704819885e-17,  7.770247845613280e-18, -8.161230231941211e-19,  6.679767512151966e-20, -4.516833374079132e-21,
  2.617160010979256e-22, -1.332134122225098e-23,  6.064409002813249e-25, -2.502865820982610e-26,  9.464218752263473e-28, -3.303515093031583e-29,  4.159401160020971e-18,
 -1.446364004170030e-18,  2.688798306172717e-19, -3.442556774688693e-20,  3.383540459486895e-21, -2.710940809379510e-22,  1.839221029451349e-23, -1.084584656810062e-24,
  5.665971088083416e-26, -2.660386748378348e-27,  1.135531095109714e-28, -4.440922455518204e-30,  1.670614963565674e-19, -6.820956267148903e-20,  1.488580156509950e-20,
 -2.213780465493956e-21,  2.498796134400493e-22, -2.274885656253037e-23,  1.736761961145436e-24, -1.142419184882313e-25,  6.604582289678754e-27, -3.407230378427986e-28,
  1.587462414463231e-29, -6.735282611000557e-31,  1.016854111481487e-01, -4.334564575230325e-04,  1.934914838222108e-06, -9.022384364596238e-09,  4.248837226166346e-11,
 -2.180886205376955e-13,  8.564927086829160e-16, -7.928467800111707e-18, -5.498216806190665e-21,  4.716296401744680e-23,  1.897579119927454e-23,  4.898651378249421e-25,
  8.041094066134766e-02, -4.039804527587660e-04,  2.644872083957361e-06, -1.835854684453027e-08,  1.253621048455505e-10, -8.403720206584732e-13,  5.390248885990915e-15,
 -3.580688355335913e-17,  2.080557095682702e-19, -1.276070352204294e-21,  1.495159547213530e-23,  1.241815643129585e-25,  5.022785379109772e-02, -3.298963962676602e-04,
  3.152683694042350e-06, -2.852758495598120e-08,  2.427340411743533e-10, -1.970228328842692e-12,  1.555882315488025e-14, -1.176919178342083e-16,  8.940789192841603e-19,
 -6.495092478145408e-21,  4.105930483588922e-23, -4.732967976935993e-25,  2.472702885545253e-02, -2.210496220277221e-04,  2.799925109321832e-06, -3.076099645925626e-08,
  3.135925331340706e-10, -3.022094080700409e-12,  2.809805718822355e-14, -2.487008711419179e-16,  2.180124942045268e-18, -1.832051258612318e-20,  1.408311583645314e-22,
 -1.450868689173614e-24,  9.561242443608429e-03, -1.167419234765677e-04,  1.834923907106452e-06, -2.394052330234443e-08,  2.880389625427738e-10, -3.246587769722984e-12,
  3.490620057803229e-14, -3.568400748209290e-16,  3.551159366034293e-18, -3.399176405885708e-20,  3.091583863864001e-22, -3.035179272992414e-24,  2.890403653087133e-03,
 -4.763978818480023e-05,  8.976277705886287e-07, -1.379371212477966e-08,  1.937932516119144e-10, -2.525852863613967e-12,  3.109112390110888e-14, -3.628664917631334e-16,
  4.076112991458263e-18, -4.400585685778722e-20,  4.563868300256446e-22, -4.734202306044679e-24,  6.790982780506469e-04, -1.487194797876414e-05,  3.305939056414748e-07,
 -5.955393572656609e-09,  9.693997850366013e-11, -1.450024902494405e-12,  2.030869214613827e-14, -2.685588213124743e-16,  3.391527769639941e-18, -4.104347030979553e-20,
  4.775836426639548e-22, -5.420150809194614e-24,  1.231056256697630e-04, -3.528099651851591e-06,  9.197884640951415e-08, -1.935989940372370e-09,  3.632687857915919e-11,
 -6.207699220083101e-13,  9.856096995357467e-15, -1.470125479501507e-16,  2.081373935691452e-18, -2.813165681688644e-20,  3.647451368342394e-22, -4.568359659841726e-24,
  1.706981591528888e-05, -6.320925363605038e-07,  1.931701137701690e-08, -4.741257145386953e-10,  1.022967073190588e-11, -1.992723021630859e-13,  3.580245402935955e-15,
 -6.010386528793944e-17,  9.525831283497553e-19, -1.435384755403028e-20,  2.067906250889562e-22, -2.863079634713701e-24,  1.792349418453794e-06, -8.492518978220916e-08,
  3.050667432229861e-09, -8.728386506026822e-11,  2.164956934630228e-12, -4.806585273453900e-14,  9.771631721982016e-16, -1.845711680519782e-17,  3.274487488550898e-19,
 -5.499616628207656e-21,  8.798504401715936e-23, -1.347443670338217e-24,  1.409225021716893e-07, -8.488004070146260e-09,  3.601703164792629e-10, -1.203168065351425e-11,
  3.437238303245525e-13, -8.712264363055815e-15,  2.007386086552667e-16, -4.272103214505354e-18,  8.495739367871437e-20, -1.592378986852113e-21,  2.831903208525431e-23,
 -4.803055504837901e-25,  8.198812900707846e-09, -6.256425882472796e-10,  3.157416725106597e-11, -1.236204048906642e-12,  4.083856625286337e-14, -1.186006776531170e-15,
  3.107562523924582e-17, -7.474515627280601e-19,  1.671011522696843e-20, -3.504620845326036e-22,  6.945291594486487e-24, -1.307618836355446e-25,  3.490786678138828e-10,
 -3.374337318341887e-11,  2.043101926441082e-12, -9.434776436797190e-14,  3.626612510390245e-15, -1.213582703519240e-16,  3.635114483327298e-18, -9.929806839652443e-20,
  2.506875353004355e-21, -5.907793165745266e-23,  1.309696138652583e-24, -2.747066803718303e-26,  1.080112092463863e-11, -1.326681419094357e-12,  9.742894733294482e-14,
 -5.354919098050942e-15,  2.415809960568575e-16, -9.389079430877735e-18,  3.238670868340542e-19, -1.011530888418694e-20,  2.901831733429085e-22, -7.728439483437465e-24,
  1.926786385454732e-25, -4.524309004108839e-27,  2.440727390035554e-13, -3.832584355012539e-14,  3.459033365972040e-15, -2.289998327473101e-16,  1.226189521988350e-17,
 -5.592159806564768e-19,  2.242429187764636e-20, -8.077432792560238e-22,  2.653992057041287e-23, -8.046008291740227e-25,  2.270783430966517e-26, -6.004836269220493e-28,
  4.172153594097332e-15, -8.441346971535888e-16,  9.503510074556391e-17, -7.687432265846855e-18,  4.951064023210156e-19, -2.681981600534923e-20,  1.264058620227694e-21,
 -5.303578010742103e-23,  2.013688333559828e-24, -7.004667363361422e-26,  2.253757369885344e-27, -6.753646529599661e-29,  6.016392674403606e-17, -1.576384725611065e-17,
  2.243204739438369e-18, -2.247045449081987e-19,  1.762534162926049e-20, -1.146749074073295e-21,  6.414890818557754e-23, -3.161475507252116e-24,  1.397037100144763e-25,
 -5.609163876855097e-27,  2.067486343156139e-28, -7.047196364861391e-30,  9.635689535625730e-19, -3.231319215778019e-19,  5.805114342656106e-20, -7.206604956367081e-21,
  6.888882665405639e-22, -5.382519229311260e-23,  3.569391244261107e-24, -2.061557521629391e-25,  1.056689632039563e-26, -4.875713567701435e-28,  2.047934614583066e-29,
 -7.891623852760783e-31,  2.807481255192277e-20, -1.133448355181468e-20,  2.445910366053854e-21, -3.599885817030772e-22,  4.025028422168832e-23, -3.632867619579891e-24,
  2.751765451229788e-25, -1.797090275788989e-26,  1.032100791175032e-27, -5.292254469946145e-29,  2.451941714939855e-30, -1.034948673747916e-31,  9.998187414142388e-02,
 -4.183989810439293e-04,  1.830584581988080e-06, -8.376423477318188e-09,  3.831410303449086e-11, -2.002086702087276e-13,  6.336087928512501e-16, -7.881950845360775e-18,
  1.607162228559956e-20,  1.349358056237514e-21,  4.895639650811151e-23,  8.728196842476146e-25,  7.883598806456307e-02, -3.836698211815710e-04,  2.436071506840284e-06,
 -1.648051165270755e-08,  1.097708381886867e-10, -7.223228407297863e-13,  4.474856088877274e-15, -2.975550799824386e-17,  1.745796742071736e-19, -5.268363116078424e-22,
  2.354873030222766e-23,  2.651992557990159e-25,  4.895663246974097e-02, -3.059810954023702e-04,  2.832417585083908e-06, -2.493985304993738e-08,  2.068124966222453e-10,
 -1.633333801058569e-12,  1.263086813669637e-14, -9.254659013896754e-17,  6.847539338201372e-19, -5.274959533779732e-21,  1.972188056532536e-23, -5.026901039640696e-25,
  2.388540598280137e-02, -2.000458185550189e-04,  2.459015995002061e-06, -2.619264436440850e-08,  2.593684196327960e-10, -2.423994423578693e-12,  2.201902740514589e-14,
 -1.885229142820318e-16,  1.607226816803011e-18, -1.389774646870906e-20,  8.164372260501058e-23, -1.264087806697224e-24,  9.121918506260025e-03, -1.031379858037773e-04,
  1.573285307757133e-06, -1.980901604431743e-08,  2.307372388215941e-10, -2.516947736892794e-12,  2.633722519327321e-14, -2.606391072443812e-16,  2.520507320663759e-18,
 -2.401297023055436e-20,  1.959658561775307e-22, -2.181200500355922e-24,  2.713227889458020e-03, -4.107174446507861e-05,  7.491628041722787e-07, -1.105982063033844e-08,
  1.499854737539985e-10, -1.888197085701090e-12,  2.254173350810951e-14, -2.546275904268515e-16,  2.775513128944105e-18, -2.935703938012816e-20,  2.882798091887981e-22,
 -3.047827292117081e-24,  6.244819000735745e-04, -1.248873178765663e-05,  2.675576978649281e-07, -4.612227683370764e-09,  7.226250785069738e-11, -1.041832442461427e-12,
  1.411013161688950e-14, -1.804052528121508e-16,  2.207121084564659e-18, -2.598431291302126e-20,  2.910799347914847e-22, -3.252748346335096e-24,  1.103305561890764e-04,
 -2.876181993438544e-06,  7.186274904748679e-08, -1.442505941259877e-09,  2.597878232678688e-11, -4.269376025915322e-13,  6.537960438705568e-15, -9.414765610058800e-17,
  1.289100020006920e-18, -1.688950554204189e-20,  2.117381307874114e-22, -2.582641236373097e-24,  1.481804827064442e-05, -4.978071799745080e-07,  1.449172789154968e-08,
 -3.381817277819880e-10,  6.983133569671822e-12, -1.305227169890459e-13,  2.256509803062383e-15, -3.651012652833068e-17,  5.586830602520303e-19, -8.142298740581908e-21,
  1.134700998365064e-22, -1.523913912376640e-24,  1.495570242838150e-06, -6.418618243747349e-08,  2.183067494737822e-09, -5.921740429436630e-11,  1.401721374453512e-12,
 -2.979271843630168e-14,  5.815420349312477e-16, -1.056841969444853e-17,  1.807336802598137e-19, -2.930964271136715e-21,  4.532416227678267e-23, -6.720376722218315e-25,
  1.119352540909519e-07, -6.102392923854382e-09,  2.437863012187119e-10, -7.700050943608040e-12,  2.093550792275640e-13, -5.068825166840513e-15,  1.119107536357834e-16,
 -2.287619362696368e-18,  4.378632809051460e-20, -7.913253938385558e-22,  1.358901411827311e-23, -2.228784429331017e-25,  6.121076240320207e-09, -4.228497912019902e-10,
  1.999160259430374e-11, -7.381865681443899e-13,  2.315034900003779e-14, -6.408985568783073e-16,  1.606207992801408e-17, -3.705144088589357e-19,  7.962030981763657e-21,
 -1.608252122555669e-22,  3.074690082404042e-24, -5.593226175248497e-26,  2.408075618188728e-10, -2.109858832236820e-11,  1.192102926525347e-12, -5.180335982290861e-14,
  1.886325866146771e-15, -6.006951468348555e-17,  1.718486103315806e-18, -4.496604891738727e-20,  1.090100638339801e-21, -2.472150390515612e-23,  5.283792743047134e-25,
 -1.070297382865635e-26,  6.723188821435210e-12, -7.505149701719992e-13,  5.130898208074015e-14, -2.649810158725276e-15,  1.130846448485182e-16, -4.177887798212586e-18,
  1.375212590557932e-19, -4.111732252539436e-21,  1.132199343340453e-22, -2.901033243927014e-24,  6.972501295476700e-26, -1.581259024462931e-27,  1.324977155195412e-13,
 -1.900255457155812e-14,  1.596319710611018e-15, -9.929593930487216e-17,  5.029139137036488e-18, -2.180431469665911e-19,  8.345635148277722e-21, -2.879007598427839e-22,
  9.085176580204761e-24, -2.651866797694651e-25,  7.221564235377205e-27, -1.846301154952575e-28,  1.879269622813713e-15, -3.503010293132140e-16,  3.683557461857985e-17,
 -2.807170524252301e-18,  1.714184301770906e-19, -8.847985760370313e-21,  3.989733805747838e-22, -1.606976300221540e-23,  5.874392568201379e-25, -1.972395188607188e-26,
  6.139422230775066e-28, -1.783468843670030e-29,  2.093060451648477e-17, -5.128899718093959e-18,  6.882618581528385e-19, -6.546615445981359e-20,  4.902815797126232e-21,
 -3.059270950773794e-22,  1.647394157046143e-23, -7.840321048507023e-25,  3.354900381720738e-26, -1.307502972880237e-27,  4.687987664169088e-29, -1.557421909922936e-30,
  2.376772592062482e-19, -7.637064957937324e-20,  1.318781089893255e-20, -1.580224890030890e-21,  1.463418500677407e-22, -1.111248624545033e-23,  7.181318539825976e-25,
 -4.051432526867450e-26,  2.032600306929518e-27, -9.196335633625168e-29,  3.793637322867508e-30, -1.437803170704200e-31,  4.841130622759267e-21, -1.927845421738348e-21,
  4.104163499065960e-22, -5.966030085887087e-23,  6.596132795736135e-24, -5.893291022575786e-25,  4.423011145321796e-26, -2.864413209433852e-27,  1.632542533418716e-28,
 -8.312656485211966e-30,  3.826608434297576e-31, -1.605662500085889e-32,  9.833694528008864e-02, -4.041462505939939e-04,  1.733615991835827e-06, -7.794678257815128e-09,
  3.444466580393637e-11, -1.875319175652311e-13,  4.305740902893144e-16, -6.131901211067728e-18,  1.099548722051415e-19,  4.158469203418455e-21,  9.279008690636740e-23,
  1.038743325657215e-24,  7.733907415562263e-02, -3.649435173987359e-04,  2.248384789179362e-06, -1.483418675473574e-08,  9.633407512377070e-11, -6.243032878009477e-13,
  3.718500412070359e-15, -2.426585276238993e-17,  1.756657089440955e-19,  6.778193982883020e-22,  3.713471404880722e-23,  3.232164900057850e-25,  4.777620761312846e-02,
 -2.844649945285410e-04,  2.551966395742269e-06, -2.187655455853930e-08,  1.769794017183850e-10, -1.358983654571940e-12,  1.031861746222634e-14, -7.356438338289314e-17,
  5.036502050588863e-19, -4.935390682599317e-21, -2.733331697437663e-24, -4.976599582311834e-25,  2.312267128792277e-02, -1.815638957463133e-04,  2.168092138298486e-06,
 -2.240357184498251e-08,  2.157736753871987e-10, -1.953512144221473e-12,  1.738908381253372e-14, -1.445729118167424e-16,  1.152649952445602e-18, -1.170336739301435e-20,
  2.928253553080209e-23, -1.092062985138663e-24,  8.733117468689489e-03, -9.144338990136721e-05,  1.356171546751784e-06, -1.648791516356050e-08,  1.861719849104408e-10,
 -1.964064040119178e-12,  2.004831231668402e-14, -1.924782205941551e-16,  1.775663457525401e-18, -1.791407381087376e-20,  1.131785019967898e-22, -1.598768531111746e-24,
  2.560141007287616e-03, -3.557120780166555e-05,  6.296863537796906e-07, -8.935025428104555e-09,  1.171020475882011e-10, -1.423617159980312e-12,  1.651116304407019e-14,
 -1.807364791760283e-16,  1.897074389538185e-18, -2.016652605189014e-20,  1.788467302680770e-22, -1.998458335288171e-24,  5.784831685941404e-04, -1.055147375537633e-05,
  2.185157884896506e-07, -3.605905340635145e-09,  5.444098201989983e-11, -7.566149388957033e-13,  9.921477632213377e-15, -1.227509129051916e-16,  1.450701253307511e-18,
 -1.678204320472260e-20,  1.782245201980461e-22, -1.984383519912407e-24,  9.987518674353401e-05, -2.364051745544301e-06,  5.679021667593834e-08, -1.087449023881427e-09,
  1.881751692706185e-11, -2.975072179148874e-13,  4.398418561350024e-15, -6.118933830688551e-17,  8.096013055476542e-19, -1.032275974077276e-20,  1.245463622772892e-22,
 -1.485184189890342e-24,  1.303542748150176e-05, -3.963875339990172e-07,  1.102644528321521e-08, -2.447071522995733e-10,  4.840832375426938e-12, -8.685617836385308e-14,
  1.446010338701250e-15, -2.256244774496876e-17,  3.333311838899542e-19, -4.706377894058261e-21,  6.336955653728835e-23, -8.266725200524148e-25,  1.269738276008981e-06,
 -4.922362352316724e-08,  1.589568036260598e-09, -4.088835618996370e-11,  9.244730913173270e-13, -1.881944741963279e-14,  3.529281080347391e-16, -6.173917268875082e-18,
  1.017985426115519e-19, -1.595256887145085e-21,  2.384197536877149e-23, -3.424665075624806e-25,  9.091236876514446e-08, -4.471614505056401e-09,  1.685577477417890e-10,
 -5.034683365748963e-12,  1.303676889833623e-13, -3.016273409147407e-15,  6.384086527170343e-17, -1.253931789338541e-18,  2.310654381466721e-20, -4.028049665558585e-22,
  6.680064232013665e-24, -1.059788706498404e-25,  4.701198225402348e-09, -2.929067418228214e-10,  1.299212522760060e-11, -4.524501532746543e-13,  1.347578984792587e-14,
 -3.557174670227821e-16,  8.529195054354994e-18, -1.887286846175212e-19,  3.898870320676573e-21, -7.585847410744710e-23,  1.399184710924971e-24, -2.459442297243001e-26,
  1.721698227173045e-10, -1.361386209927337e-11,  7.181435574629075e-13, -2.935878274117426e-14,  1.012737460403994e-15, -3.068909943064274e-17,  8.385032491322901e-19,
 -2.101517663927754e-20,  4.891759153495124e-22, -1.067441134532935e-23,  2.199273078504011e-25, -4.301592515320700e-27,  4.377000944870544e-12, -4.418284900288777e-13,
  2.809928600639281e-14, -1.362438698319577e-15,  5.497353098872181e-17, -1.929678777313555e-18,  6.058570664886207e-20, -1.733303573021539e-21,  4.579143756022667e-23,
 -1.128314114182211e-24,  2.613134141442677e-26, -5.720969820159917e-28,  7.605128381368735e-14, -9.902544496853938e-15,  7.726309945131479e-16, -4.507979262915643e-17,
  2.156788206680593e-18, -8.879227884929505e-20,  3.240462173301542e-21, -1.069508096300621e-22,  3.238342902496621e-24, -9.092354409884065e-26,  2.386976280802808e-27,
 -5.894956040127685e-29,  9.056704593812247e-16, -1.544327671325294e-16,  1.510980999971792e-17, -1.081656255934373e-18,  6.247358854144128e-20, -3.066134180887134e-21,
  1.320220268152459e-22, -5.095750455645501e-24,  1.790498298093705e-25, -5.793786361926678e-27,  1.742067312644936e-28, -4.898835883772119e-30,  7.860663348030575e-18,
 -1.786856415363128e-18,  2.248708132937771e-19, -2.022086803124329e-20,  1.440506258255500e-21, -8.592435049821659e-23,  4.441112121990718e-24, -2.035717743947886e-25,
  8.414708340239122e-27, -3.176156112855446e-28,  1.105450163329485e-29, -3.572389056913132e-31,  6.286746400908586e-20, -1.920897306535377e-20,  3.168976821362344e-21,
 -3.646632106114696e-22,  3.257581757290251e-23, -2.395025532015556e-24,  1.503303185486198e-25, -8.259814238519033e-27,  4.045313459998373e-28, -1.790380907304202e-29,
  7.237751708631794e-31, -2.692647814937702e-32,  8.609927486260135e-22, -3.371135638246631e-22,  7.059600850296608e-23, -1.011029350148387e-23,  1.102940550334159e-24,
 -9.736315126021681e-26,  7.228423372746148e-27, -4.635517082331747e-28,  2.618514925267170e-29, -1.322516258798707e-30,  6.042927126150040e-32, -2.518450388890297e-33,
  9.674751859325656e-02, -3.906423799210642e-04,  1.643264450461181e-06, -7.273056425697956e-09,  3.078620005997794e-11, -1.786948014416360e-13,  3.362453297634074e-16,
  5.819662572626243e-19,  3.365162315101412e-19,  8.660403292827291e-21,  1.268909259114680e-22,  2.775483425628797e-25,  7.591418262398447e-02, -3.476431957181157e-04,
  2.079225683260729e-06, -1.338810034244133e-08,  8.468883248709203e-11, -5.425439447198919e-13,  3.123618916201275e-15, -1.794165716924886e-17,  2.298884453587963e-19,
  2.403859826618355e-21,  4.726771026640159e-23,  5.645750467616062e-26,  4.667758182191740e-02, -2.650531811711964e-04,  2.305582580932988e-06, -1.924953572409343e-08,
  1.521180623043077e-10, -1.134399213593052e-12,  8.457352603205507e-15, -6.035184100526992e-17,  3.191331222336547e-19, -5.433355881600754e-21, -2.025169427191574e-23,
 -2.293418684579462e-25,  2.242948162753029e-02, -1.652386682125907e-04,  1.918744091600199e-06, -1.924238588791203e-08,  1.805688322280672e-10, -1.580966084770581e-12,
  1.379518806935627e-14, -1.142909086219195e-16,  7.418292282222798e-19, -1.137583572412839e-20, -8.959377233054489e-24, -5.410426112933921e-25,  8.387857329729192e-03,
 -8.133762285711912e-05,  1.174972732400198e-06, -1.379899487770270e-08,  1.512965167198101e-10, -1.541724300811174e-12,  1.536295145164115e-14, -1.452289717632009e-16,
  1.196889707430998e-18, -1.461501489171118e-20,  5.667824892612736e-23, -9.183225106619762e-25,  2.427294376421162e-03, -3.093277852007963e-05,  5.328335789863429e-07,
 -7.269246189140741e-09,  9.221524592893990e-11, -1.081842327957888e-12,  1.220020886453597e-14, -1.304228118304540e-16,  1.280850112482756e-18, -1.453263783754147e-20,
  1.085162460469075e-22, -1.215223819094929e-24,  5.395189657001129e-04, -8.962694398491151e-06,  1.800108206450134e-07, -2.844051321292560e-09,  4.143634702130930e-11,
 -5.550110241419595e-13,  7.052440888881892e-15, -8.477393995416215e-17,  9.562110744991308e-19, -1.114269025876025e-20,  1.094617198658739e-22, -1.195155004177978e-24,
  9.125165047588428e-05, -1.957226840698446e-06,  4.536806034303214e-08, -8.287683066279748e-10,  1.379800402862894e-11, -2.098891924014577e-13,  2.998131058589406e-15,
 -4.038131912966663e-17,  5.138537810072986e-19, -6.439251686684793e-21,  7.414962270831231e-23, -8.610661263104590e-25,  1.160940177512610e-05, -3.187259642239604e-07,
  8.502923487958095e-09, -1.794601808163771e-10,  3.405203078047231e-12, -5.866826219471412e-14,  9.412383584261448e-16, -1.418075615085792e-17,  2.019419822155423e-19,
 -2.772998074600416e-21,  3.598414913844121e-23, -4.556664524117509e-25,  1.095490079034913e-06, -3.824414628746434e-08,  1.176581095452424e-09, -2.870045345229312e-11,
  6.204834880769020e-13, -1.210265192967401e-14,  2.181899656988392e-16, -3.677078649151454e-18,  5.843597631468060e-20, -8.862832700510673e-22,  1.279490237359742e-23,
 -1.780605277410908e-25,  7.538483102824536e-08, -3.333454894986621e-09,  1.189064291880184e-10, -3.358744940146443e-12,  8.290112201326478e-14, -1.833618667423551e-15,
  3.722337163577007e-17, -7.028857109769754e-19,  1.247051524639546e-20, -2.098394101390462e-22,  3.360725040995330e-24, -5.158417165819270e-26,  3.707602149870369e-09,
 -2.074983553596344e-10,  8.653290799256588e-12, -2.842021928159708e-13,  8.043819473882690e-15, -2.025151044419922e-16,  4.647213410120932e-18, -9.866958621063551e-20,
  1.959846465560300e-21, -3.674066716488431e-23,  6.538463724383524e-25, -1.110664786532261e-26,  1.273086686531341e-10, -9.042892420655793e-12,  4.458691096579970e-13,
 -1.714408819747066e-14,  5.603635938280568e-16, -1.615968959981354e-17,  4.217114397296794e-19, -1.012408710101397e-20,  2.262710445345290e-22, -4.750926907416674e-24,
  9.435122478126967e-26, -1.781771953381119e-27,  2.973532331143329e-12, -2.699695896090768e-13,  1.597096884855501e-14, -7.265475022599068e-16,  2.770869219410515e-17,
 -9.238064171666421e-19,  2.765708008592143e-20, -7.568803349343840e-22,  1.917813146669780e-23, -4.542808792054612e-25,  1.013440854336759e-26, -2.141115273940782e-28,
  4.605670423190978e-14, -5.410507747460862e-15,  3.914619687203873e-16, -2.139301666719103e-17,  9.658220967498755e-19, -3.771956453292443e-20,  1.311388557834874e-21,
 -4.137515462600144e-23,  1.201088549956735e-24, -3.241309283123515e-26,  8.196824641562390e-28, -1.953905415230105e-29,  4.664987944979184e-16, -7.222387002562451e-17,
  6.552332457676934e-18, -4.394340612793660e-19,  2.395381646630013e-20, -1.115701998836096e-21,  4.579396389660428e-23, -1.691102352176138e-24,  5.702857033558401e-26,
 -1.775887810147973e-27,  5.150983516473938e-29, -1.400339978784320e-30,  3.193196674938881e-18, -6.674446443271716e-19,  7.833614768449152e-20, -6.630461665025169e-21,
  4.476779808960789e-22, -2.544583034372259e-23,  1.258791726833870e-24, -5.543011402907362e-26,  2.208046480652673e-27, -8.053959843142299e-29,  2.715450138397172e-30,
 -8.519570751402861e-32,  1.796055738977279e-20, -5.172259175657547e-21,  8.096707208558475e-22, -8.898006971227608e-23,  7.631406096062248e-24, -5.410269286732609e-25,
  3.286531181808720e-26, -1.753033102054557e-27,  8.357203605219776e-29, -3.608730068182411e-30,  1.426271327331780e-31, -5.197243768062894e-33,  1.589475931847061e-22,
 -6.093549089690322e-23,  1.250607257255834e-23, -1.758985556260083e-24,  1.888299698569266e-25, -1.643188529723732e-26,  1.204368632821055e-27, -7.634777028844735e-29,
  4.267950488863638e-30, -2.135267456955247e-31,  9.672829091740607e-33, -3.999686417765354e-34,  9.521070002003169e-02, -3.778372658165170e-04,  1.558826806876517e-06,
 -6.808598462395784e-09,  2.730196181254987e-11, -1.688894401530263e-13,  5.571284646398877e-16,  1.730819442193102e-17,  7.372046206283749e-19,  1.335490232246387e-20,
  8.801066515616231e-23, -2.458979201040604e-24,  7.455589142204996e-02, -3.316297826928281e-04,  1.926353294029706e-06, -1.211596755196781e-08,  7.455161322705769e-11,
 -4.726812919232944e-13,  2.739825191565945e-15, -8.842687064608579e-18,  3.491902417625796e-19,  4.127618888780488e-21,  3.207191268156212e-23, -8.887765806601100e-25,
  4.565285168068206e-02, -2.474927775380230e-04,  2.088476981540997e-06, -1.698667837370336e-08,  1.313281403185210e-10, -9.507336034674284e-13,  6.879891032986686e-15,
 -5.343430420557927e-17,  1.082470203570145e-19, -6.245287228274619e-21, -1.406598947533633e-23,  6.374844595545298e-25,  2.179783074984292e-02, -1.507655266984321e-04,
  1.704182034700476e-06, -1.658929488687110e-08,  1.520133896958182e-10, -1.285982549769566e-12,  1.086514618302215e-14, -9.720127567182774e-17,  3.231403434181379e-19,
 -1.186177397167000e-20, -4.638127570601811e-24,  9.355810579747188e-25,  8.080312842591001e-03, -7.256125993457274e-05,  1.022953010984421e-06, -1.160620401045778e-08,
  1.238401157879130e-10, -1.217954604032839e-12,  1.175639564884853e-14, -1.149710008426202e-16,  7.044955266718209e-19, -1.285251911435937e-20,  4.022013087680889e-23,
  2.920051745032499e-25,  2.311569502599805e-03, -2.699549804508378e-05,  4.537896011513959e-07, -5.952152168287195e-09,  7.323263718259657e-11, -8.286836279082581e-13,
  9.048974027247683e-15, -9.705963238484740e-17,  8.250025555129241e-19, -1.103080847698406e-20,  7.255216173169333e-23, -3.910489277172676e-25,  5.063470833118418e-04,
 -7.648639248582523e-06,  1.495215111519817e-07, -2.261424459539080e-09,  3.185284428593954e-11, -4.111216106673658e-13,  5.052331399876389e-15, -5.984036665719606e-17,
  6.228469326652800e-19, -7.638617995235457e-21,  6.988441919752722e-23, -6.238835655910027e-25,  8.409055332291685e-05, -1.630605592748044e-06,  3.662061075673212e-08,
 -6.380265067084808e-10,  1.023694980799104e-11, -1.498394954297655e-13,  2.066501384964439e-15, -2.714101769922061e-17,  3.274466934658438e-19, -4.107528828156973e-21,
  4.516152518090593e-23, -4.850216278770767e-25,  1.045810503378012e-05, -2.584722720571739e-07,  6.641215912473132e-09, -1.332594329009431e-10,  2.428988831171287e-12,
 -4.019625283898572e-14,  6.214144694989549e-16, -9.072993228091470e-18,  1.238315005191992e-19, -1.666086366731854e-21,  2.083290250700714e-23, -2.524049322208127e-25,
  9.593737024676619e-07, -3.005705487318111e-08,  8.845886971088976e-10, -2.045617207695218e-11,  4.234351133350122e-13, -7.916581810107545e-15,  1.372389964183209e-16,
 -2.232365763595101e-18,  3.412386732024723e-20, -5.024010697905779e-22,  7.006161426983381e-24, -9.411699593017102e-26,  6.372676948808699e-08, -2.523376068543328e-09,
  8.549053211296018e-11, -2.283127971551480e-12,  5.377469764815213e-14, -1.137485620658536e-15,  2.215581295954131e-17, -4.026218461193249e-19,  6.873864672880809e-21,
 -1.117835522042030e-22,  1.729235295197507e-24, -2.566047503438894e-26,  2.997189468229318e-09, -1.499984622086361e-10,  5.898750443461898e-12, -1.826694165610287e-13,
  4.917093869586439e-15, -1.181109652476583e-16,  2.594754709925960e-18, -5.289159841086614e-20,  1.010054450938991e-21, -1.825357095803235e-23,  3.134707036571154e-25,
 -5.145442531060176e-27,  9.715483043505892e-11, -6.167851912153422e-12,  2.848190058898007e-13, -1.029736563861795e-14,  3.190609693842925e-16, -8.757456221653701e-18,
  2.183166297953041e-19, -5.021447802118723e-21,  1.077557048687339e-22, -2.177279545813926e-24,  4.167917492316544e-26, -7.598961752742819e-28,  2.103017563229871e-12,
 -1.707405328266384e-13,  9.402486971821084e-15, -4.010797484335214e-16,  1.445682564914541e-17, -4.577114392803368e-19,  1.306423290210834e-20, -3.419417867272568e-22,
  8.308103651820441e-24, -1.891476098665234e-25,  4.063564198384717e-27, -8.282495788297830e-29,  2.935942040273520e-14, -3.090877026099250e-15,  2.071947285409181e-16,
 -1.059257264712636e-17,  4.509032084124443e-19, -1.669277957523118e-20,  5.524915655449862e-22, -1.665241732850514e-23,  4.631504943876948e-25, -1.200540829327417e-26,
  2.922613748666376e-28, -6.719995667487624e-30,  2.564125881680971e-16, -3.575762602989217e-17,  2.999294377423946e-18, -1.879965971960252e-19,  9.653548898560144e-21,
 -4.260055723813833e-22,  1.664259507856141e-23, -5.871745575081023e-25,  1.897851189433608e-26, -5.680147646170962e-28,  1.587324057660557e-29, -4.166767497204680e-31,
  1.404612788624497e-18, -2.673989052839014e-19,  2.911218004267233e-20, -2.309699509609078e-21,  1.472919736538167e-22, -7.953639389752864e-24,  3.755658142178079e-25,
 -1.584770657044132e-26,  6.069770703995357e-28, -2.134914560014948e-29,  6.958769838571539e-31, -2.115622824813809e-32,  5.580890542894763e-21, -1.499255038864231e-21,
  2.210446318294864e-22, -2.306090824721416e-23,  1.889352903139922e-24, -1.285997106588309e-25,  7.531481496372328e-27, -3.886694748012482e-28,  1.798072452248618e-29,
 -7.554266562351173e-31,  2.911575842165226e-32, -1.036781069263466e-33,  3.070198513208638e-23, -1.146142764285865e-23,  2.294500909885813e-24, -3.156997889279682e-25,
  3.323987233384040e-26, -2.843283240948670e-27,  2.052382199521466e-28, -1.283398453518701e-29,  7.086819953535799e-31, -3.506465669594108e-32,  1.572557351415103e-33,
 -6.443433763358728e-35,  9.372378488489004e-02, -3.656862889128359e-04,  1.479636078416506e-06, -6.397844278076601e-09,  2.411286821875692e-11, -1.465752340408964e-13,
  1.447530585148512e-15,  4.897852722371883e-17,  1.242796359376538e-18,  1.330094134865343e-20, -1.306326953781125e-22, -7.926132703722969e-24,  7.325930083986233e-02,
 -3.167809403273999e-04,  1.787818070293405e-06, -1.099525765346350e-08,  6.574262321889277e-11, -4.084901980843410e-13,  2.672193932523400e-15,  4.852353652189585e-18,
  5.071627210678899e-19,  4.143647215113049e-21, -4.497655952295617e-23, -2.765716576468637e-24,  4.469505380977999e-02, -2.315659903283505e-04,  1.896644540170351e-06,
 -1.502907846457189e-08,  1.138445860083168e-10, -8.033885361377964e-13,  5.398091439543212e-15, -5.359621746142016e-17, -1.160448060539598e-19, -5.805546035476449e-21,
  4.852632015967218e-23,  2.345593176509674e-24,  2.122083067565804e-02, -1.378888761036426e-04,  1.518898438555705e-06, -1.434957908796189e-08,  1.286852897095381e-10,
 -1.057103300703253e-12,  8.224494048128341e-15, -9.360692072581059e-17, -9.086832633883996e-20, -1.049794564151487e-20,  9.322885169929401e-23,  3.729428129314381e-24,
  7.805598212385477e-03, -6.490280608503598e-05,  8.948101309420206e-07, -9.805358604388982e-09,  1.020531998993928e-10, -9.722991490335347e-13,  8.785774026451437e-15,
 -9.946351271746038e-17,  2.786575640376308e-19, -1.044736111375560e-20,  9.494562157134256e-23,  2.334482628873195e-24,  2.210422332342057e-03, -2.363215258402616e-05,
  3.888829945928406e-07, -4.902094335084943e-09,  5.862451888445678e-11, -6.414845015542298e-13,  6.645089055306597e-15, -7.646965462040679e-17,  4.786235638557957e-19,
 -8.179004186195825e-21,  7.781064558596022e-23,  6.749556137843020e-25,  4.779844604947560e-04, -6.552936335754329e-06,  1.251908257115720e-07, -1.811502402982261e-09,
  2.471788163830812e-11, -3.079557694745675e-13,  3.618076516152142e-15, -4.381420950763143e-17,  3.929374798056142e-19, -5.241119754986195e-21,  5.368654066391633e-23,
 -1.158991115327182e-25,  7.810922200576769e-05, -1.365692979302722e-06,  2.985621639509641e-08, -4.957536263617415e-10,  7.680146261611705e-12, -1.083039060304781e-13,
  1.433287431086017e-15, -1.871681861711682e-17,  2.076917234716835e-19, -2.647640415807399e-21,  2.965409291735579e-23, -2.341060773207633e-25,  9.521206006783569e-06,
 -2.111345446667891e-07,  5.251162917052958e-09, -1.000956637589532e-10,  1.755724025002247e-12, -2.793321963289240e-14,  4.148631514464922e-16, -5.928525862411653e-18,
  7.653765187875336e-20, -1.016075453202796e-21,  1.251149204014542e-23, -1.359289839533621e-25,  8.518923131936764e-07, -2.385803490463623e-08,  6.750660008027922e-10,
 -1.478813236936847e-11,  2.935510691147253e-13, -5.264489810882405e-15,  8.764464089382290e-17, -1.382856552621736e-18,  2.022437839727527e-20, -2.899754149187281e-22,
  3.933736636186694e-24, -5.007491313126321e-26,  5.484618119213773e-08, -1.935973876127043e-09,  6.258872135012365e-11, -1.579268434353513e-12,  3.554349124353905e-14,
 -7.194616994445643e-16,  1.344068282598889e-17, -2.356280256918630e-19,  3.863772842707415e-21, -6.081362437744364e-23,  9.107026774037264e-25, -1.300213150625068e-26,
  2.479369152415074e-09, -1.103989446571915e-10,  4.110532422687440e-12, -1.199549326486742e-13,  3.074239972288743e-15, -7.048656224357730e-17,  1.482495131509209e-18,
 -2.904653615878580e-20,  5.330207348370436e-22, -9.292149899468328e-24,  1.540988654449131e-25, -2.441656924122115e-27,  7.636496753482661e-11, -4.308462358520612e-12,
  1.869071587960302e-13, -6.350518433900037e-15,  1.866628163211617e-16, -4.877774896077213e-18,  1.161710052430611e-19, -2.561299016310203e-21,  5.276691078753713e-23,
 -1.026282857930434e-24,  1.894044556126501e-26, -3.333211903491628e-28,  1.544769365765418e-12, -1.114394656970969e-13,  5.722729542296542e-15, -2.287542170899634e-16,
  7.794632502104268e-18, -2.343447680540337e-19,  6.376417768480372e-21, -1.596268281751528e-22,  3.718375219767666e-24, -8.135665544963724e-26,  1.682954378120748e-27,
 -3.308568675884198e-29,  1.965075080662836e-14, -1.840489637778741e-15,  1.143166713474646e-16, -5.461339696761571e-18,  2.190921356896434e-19, -7.684453227493996e-21,
  2.420005543761492e-22, -6.964717727162890e-24,  1.854944695912171e-25, -4.616086855988874e-27,  1.081208710542000e-28, -2.396677474135779e-30,  1.500851892328922e-16,
 -1.869133852955711e-17,  1.446456239128500e-18, -8.455906195855531e-20,  4.083941392797443e-21, -1.705110626084799e-22,  6.332039454924096e-24, -2.131806768444558e-25,
  6.596406677322365e-27, -1.895346750936825e-28,  5.097380246545555e-30, -1.290628408684389e-31,  6.691502764910188e-19, -1.148266862913453e-19,  1.153900796453493e-20,
 -8.547678458381199e-22,  5.131953022989539e-23, -2.625349921000730e-24,  1.180300308120380e-25, -4.761592766301578e-27,  1.749690284308972e-28, -5.922327413578507e-30,
  1.862634590051524e-31, -5.477324991992107e-33,  1.898309740349174e-21, -4.701187914279925e-22,  6.476378486190267e-23, -6.373984298301970e-24,  4.962456591880428e-25,
 -3.228292643782853e-26,  1.815537056863508e-27, -9.032475599588263e-29,  4.041974276167252e-30, -1.647405823811567e-31,  6.175369204167556e-33, -2.143600976105412e-34,
  6.266375664961849e-24, -2.261434860953362e-24,  4.389523171465744e-25, -5.878974550066064e-26,  6.046105179059426e-27, -5.066079567615848e-28,  3.590773649567678e-29,
 -2.209263584914503e-30,  1.202375581399793e-31, -5.872198298414538e-33,  2.602748250579934e-34, -1.055183239940557e-35,  9.228423665461541e-02, -3.541499459800767e-04,
  1.405087637175955e-06, -6.033050553740884e-09,  2.166476479138009e-11, -9.049651735462178e-14,  3.435945515296260e-15,  9.459625765634298e-17,  1.524840839154162e-18,
 -9.576682569957498e-22, -6.333546758615447e-22, -1.483572901014043e-23,  7.201997098361201e-02, -3.029888840362127e-04,  1.661928163251247e-06, -1.000516879288008e-08,
  5.823514725469882e-11, -3.407744973567890e-13,  3.053634197139533e-15,  2.284107081965247e-17,  5.882171514777410e-19, -7.949381334641622e-22, -2.194610362829735e-22,
 -5.135349060369996e-24,  4.379803611195029e-02, -2.170844420357412e-04,  1.726715826589608e-06, -1.332958822579706e-08,  9.894787979808566e-11, -6.924363111183958e-13,
  3.818016786117586e-15, -6.003900441485889e-17, -2.594127965182657e-19, -1.159365521280608e-21,  1.996685441933516e-22,  4.495432747973745e-24,  2.069253435729773e-02,
 -1.263930075745430e-04,  1.358391871145399e-06, -1.244992743888090e-08,  1.093017444003305e-10, -8.918103360776303e-13,  5.513269983272180e-15, -1.014589751802671e-16,
 -3.526873680206734e-19, -2.447903397110491e-21,  3.350039544213747e-22,  7.212518601894271e-24,  7.559596070928228e-03, -5.818863188373820e-05,  7.863357758365280e-07,
 -8.317551533307919e-09,  8.449406610716349e-11, -7.941682170098834e-13,  6.075698707767005e-15, -9.558620291995759e-17,  2.384638944576433e-21, -3.856172346987595e-21,
  2.528555724724442e-22,  4.805403713526528e-24,  2.121764583676994e-03, -2.074136554470132e-05,  3.352885841452661e-07, -4.058774470230109e-09,  4.722409104516457e-11,
 -5.062142239483472e-13,  4.678821182149408e-15, -6.518469602590493e-17,  2.506056644591009e-19, -4.116398865009346e-21,  1.340168220264001e-22,  1.855144189085593e-24,
  4.536470049058505e-04, -5.632077996352203e-06,  1.056366627214935e-07, -1.460964884568308e-09,  1.933439102385727e-11, -2.345822546596569e-13,  2.541889513546013e-15,
 -3.384594618043080e-17,  2.429954904758852e-19, -3.052399874870612e-21,  5.915046528495620e-23,  3.475294360660191e-25,  7.308921868883031e-05, -1.148703734988126e-06,
  2.457858390626733e-08, -3.884966279019632e-10,  5.819143386365837e-12, -7.952316469579522e-14,  9.894663236466286e-16, -1.338340851057441e-17,  1.317775413194209e-19,
 -1.609920502090479e-21,  2.354067499804962e-23, -5.469976185174659e-26,  8.753701492385321e-06, -1.734914814182411e-07,  4.201737808691026e-09, -7.598427434233370e-11,
  1.284479524995363e-12, -1.972233663837972e-14,  2.782823138786225e-16, -3.978251412393253e-18,  4.774151387509475e-20, -6.120774196065678e-22,  8.195420891109005e-24,
 -6.609815930787145e-26,  7.662403666450776e-07, -1.909481127463223e-08,  5.226519095647659e-10, -1.083130775044954e-11,  2.065003277464961e-13, -3.561184076436969e-15,
  5.660989406999256e-17, -8.761388745353576e-19,  1.216197696042424e-20, -1.686315500769571e-22,  2.305690101490462e-24, -2.628951385289864e-26,  4.799601870541610e-08,
 -1.502391071728118e-09,  4.662602801914338e-11, -1.110175254078392e-12,  2.391007253265095e-14, -4.638815817318999e-16,  8.289272923854628e-18, -1.409670218131288e-19,
  2.212792933849824e-21, -3.364563114287093e-23,  4.934846078050794e-25, -6.667628839405147e-27,  2.095478870899636e-09, -8.253215324657342e-11,  2.925261245557310e-12,
 -8.035719479351569e-14,  1.963219147451427e-15, -4.301015004904825e-17,  8.650995844694758e-19, -1.633482441303118e-20,  2.877046786254141e-22, -4.836942556151590e-24,
  7.773805496641515e-26, -1.183828678130589e-27,  6.170200385490200e-11, -3.073796195235434e-12,  1.258327218048698e-13, -4.014212098868281e-15,  1.120375569500017e-16,
 -2.789004351418513e-18,  6.343697910055051e-20, -1.342223416865367e-21,  2.653831017756798e-23, -4.968690542668280e-25,  8.849232515425470e-27, -1.501713672902126e-28,
  1.175773260103897e-12, -7.482654475495781e-14,  3.594592826429455e-15, -1.345287542649139e-16,  4.335538560165456e-18, -1.238033739265245e-19,  3.210789325290563e-21,
 -7.690461044818931e-23,  1.717217307999069e-24, -3.610685573868596e-26,  7.192632108005029e-28, -1.363430730614033e-29,  1.377376143839041e-14, -1.138423855790328e-15,
  6.560802638677423e-17, -2.925755191251219e-18,  1.105964118092177e-19, -3.673963072878642e-21,  1.100447385319573e-22, -3.023288301184618e-24,  7.707510819229716e-26,
 -1.840691761669954e-27,  4.146614339602555e-29, -8.857219627167341e-31,  9.332025471682101e-17, -1.028179970790782e-17,  7.333509433018786e-19, -3.990996219881859e-20,
  1.810795461000973e-21, -7.144956134114282e-23,  2.519495346868689e-24, -8.086235043105278e-26,  2.392997332511748e-27, -6.594624852370982e-29,  1.705253113030121e-30,
 -4.160563644491590e-32,  3.449823140332744e-19, -5.276141066823551e-20,  4.873201522214896e-21, -3.358449431199023e-22,  1.892978995724766e-23, -9.151104092816413e-25,
  3.908141945969211e-26, -1.504145689413631e-27,  5.292208486480735e-29, -1.720567035813441e-30,  5.212046411161654e-32, -1.479909020507058e-33,  7.107011926011285e-22,
 -1.600719204495619e-22,  2.043598278490907e-23, -1.885259908435171e-24,  1.387398524216533e-25, -8.586925933320005e-27,  4.618539601661202e-28, -2.207146949273550e-29,
  9.522425803982063e-31, -3.753781494996808e-32,  1.364758313969695e-33, -4.606277026607502e-35,  1.367881392843538e-24, -4.726035868788736e-25,  8.826467158003700e-26,
 -1.143655014801098e-26,  1.143034556037015e-27, -9.342232201563655e-29,  6.478624686716065e-30, -3.909840984171520e-31,  2.091682123955405e-32, -1.005979264211217e-33,
  4.397745166873936e-35, -1.760890309592372e-36,  9.088966794155312e-02, -3.431930420721135e-04,  1.334728328274354e-06, -5.695415916793547e-09,  2.092162321107840e-11,
  2.902436510771238e-14,  6.719890112812800e-15,  1.365864173471756e-16,  8.645279755874832e-19, -4.059174531678054e-20, -1.360967029816894e-21, -1.630319481195764e-23,
  7.083386761872121e-02, -2.901583577473260e-04,  1.547245383406581e-06, -9.123693727367594e-09,  5.221495587400810e-11, -2.577842255273106e-13,  3.937612566365462e-15,
  3.904007921010485e-17,  3.428317080031728e-19, -1.452076363569116e-20, -4.712088212549731e-22, -5.645350107891084e-24,  4.295634939387562e-02, -2.038846448975752e-04,
  1.575817281481808e-06, -1.185282158592914e-08,  8.587453070985140e-11, -6.218883996848603e-13,  2.027800786627580e-15, -6.705274146417613e-17, -1.058406350183163e-19,
  1.116929929023359e-20,  4.206716027100114e-22,  4.950293995796952e-24,  2.020779064001371e-02, -1.160950527802880e-04,  1.218917707984696e-06, -1.083758871945743e-08,
  9.255206575153642e-11, -7.948301282195255e-13,  2.523423179364795e-15, -1.109041865941176e-16, -1.168130378624197e-19,  1.792868084544194e-20,  6.903571004960449e-22,
  7.978033371140773e-24,  7.338821695426591e-03, -5.227536594756131e-05,  6.941356124552201e-07, -7.085701376971990e-09,  6.985186914927550e-11, -6.805074225386331e-13,
  3.395954738407601e-15, -9.533421729397749e-17,  1.010825072960085e-19,  1.093771624641998e-20,  4.917711275388740e-22,  5.392507837427366e-24,  2.043872437831402e-03,
 -1.824176591955508e-05,  2.908008058270200e-07, -3.378687718545770e-09,  3.807913533218272e-11, -4.150140773763502e-13,  2.952020028914823e-15, -5.832709397712011e-17,
  2.207545473060597e-19,  3.096323530801336e-21,  2.293267581620055e-22,  2.188360572820437e-24,  4.327048257443447e-04, -4.852188624318993e-06,  8.981625345063949e-08,
 -1.186140703500508e-09,  1.518020922085650e-11, -1.841548276950626e-13,  1.690003963930544e-15, -2.733582876836407e-17,  1.802451526200350e-19, -2.919716870485979e-22,
  8.020753156645382e-23,  5.200730560815722e-25,  6.886022036148859e-05, -9.692531872521817e-07,  2.042662749254631e-08, -3.069432357870005e-10,  4.438057261099837e-12,
 -5.984341953061388e-14,  6.663339536904647e-16, -9.914575009468843e-18,  9.052118028533599e-20, -6.816566570314881e-22,  2.351142590201459e-23,  3.102372902564363e-26,
  8.121645037972250e-06, -1.432032422848076e-07,  3.401298741571861e-09, -5.826030229536863e-11,  9.486114991660109e-13, -1.422584338785111e-14,  1.853892226101380e-16,
 -2.744659702950285e-18,  3.103166956155264e-20, -3.291319237685638e-22,  6.222894004581267e-24, -2.903193140673159e-26,  6.974730894268116e-07, -1.538230250974836e-08,
  4.103679563181927e-10, -8.030888287718427e-12,  1.470815698390052e-13, -2.457975398099762e-15,  3.672910102803235e-17, -5.682762310137851e-19,  7.513432896625972e-21,
 -9.518121741573581e-23,  1.458364896638351e-24, -1.367757756763288e-26,  4.265643037800645e-08, -1.176808717319767e-09,  3.532479490630360e-11, -7.922370848807716e-13,
  1.633921072017365e-14, -3.052983668652630e-16,  5.175622155553116e-18, -8.623201017939557e-20,  1.296546781355419e-21, -1.866662448782403e-23,  2.786921557820960e-25,
 -3.457484514246316e-27,  1.806723348619963e-09, -6.251196192540934e-11,  2.124327476603268e-12, -5.483788139532862e-14,  1.278357272655591e-15, -2.683763415752664e-17,
  5.141929198477352e-19, -9.402933503374309e-21,  1.589539210627997e-22, -2.560714737614212e-24,  4.039370703525044e-26, -5.855189749906814e-28,  5.115310297160842e-11,
 -2.233101329881036e-12,  8.681382128121918e-14, -2.596371544726225e-15,  6.887195934740848e-17, -1.635912403835887e-18,  3.547608984967280e-20, -7.219892321835360e-22,
  1.369957061726491e-23, -2.464834158512884e-25,  4.252184504651257e-27, -6.939608106920042e-29,  9.252034431665593e-13, -5.151212432810569e-14,  2.326550082324160e-15,
 -8.141586403482506e-17,  2.483274998388954e-18, -6.740308240209359e-20,  1.665056940912014e-21, -3.819161130192668e-23,  8.174030399165070e-25, -1.650991757193604e-26,
  3.169841627671324e-28, -5.789655655050209e-30,  1.008356501725729e-14, -7.286907400060921e-16,  3.908815194206079e-17, -1.625000922241021e-18,  5.788795133823283e-20,
 -1.821435159800820e-21,  5.186605921428491e-23, -1.360304831609545e-24,  3.318590728368584e-26, -7.603234597021462e-28,  1.647148792864579e-29, -3.388810372021902e-31,
  6.146855515764943e-17, -5.928666922881611e-18,  3.899716136503357e-19, -1.972196053720371e-20,  8.399655899869278e-22, -3.129701521101772e-23,  1.047027213947242e-24,
 -3.201103872995147e-26,  9.052796171928799e-28, -2.390843722610574e-29,  5.939557752194263e-31, -1.395311957289645e-32,  1.921633273595041e-19, -2.586660579579506e-20,
  2.189235780283937e-21, -1.399135391638918e-22,  7.385631707443155e-24, -3.366615767432263e-25,  1.363040451266423e-26, -4.995483964654566e-28,  1.679919363394978e-29,
 -5.237037999720996e-31,  1.525494221263024e-32, -4.175727075527474e-34,  2.940798020373370e-22, -5.931623380264665e-23,  6.961716984253580e-24, -5.981879092838278e-25,
  4.139577151099777e-26, -2.426607105148970e-27,  1.243273675509970e-28, -5.686597340395117e-30,  2.357590844265565e-31, -8.961655109074699e-33,  3.151241255986323e-34,
 -1.031474847886383e-35,  3.240190578318297e-25, -1.057948525864666e-25,  1.882881393318983e-26, -2.342410316524655e-27,  2.261226692711532e-28, -1.793532506288621e-29,
  1.211663806709895e-30, -7.146154372972903e-32,  3.746021078990899e-33, -1.769270914053488e-34,  7.610154345789959e-36, -3.003164566066170e-37,  8.953782674674919e-02,
 -3.327827970685529e-04,  1.268442996606804e-06, -5.345928001413078e-09,  2.343361712335141e-11,  2.375632591573987e-13,  1.062973094491278e-14,  1.291396717677808e-16,
 -1.719993018600293e-18, -1.057218016766278e-19, -1.750479474121462e-21,  3.966734468374630e-24,  6.969731629143650e-02, -2.782044860734502e-04,  1.442621242283430e-06,
 -8.323978849491262e-09,  4.809668889519854e-11, -1.495484616117993e-13,  5.077271780884082e-15,  3.758447559391844e-17, -5.689165911351328e-19, -3.708310637213131e-20,
 -6.070478894305183e-22,  1.324339184935227e-24,  4.216515482367082e-02, -1.918246154772249e-04,  1.441423748566789e-06, -1.057632623811924e-08,  7.377141219069003e-11,
 -5.956363508928614e-13,  1.887207523983919e-16, -6.038778514878597e-17,  6.425039372971648e-19,  3.122426614550675e-20,  5.373905839303261e-22, -1.291637267931056e-24,
  1.976212342317135e-02, -1.068399332164171e-04,  1.097234830267091e-06, -9.481691717554195e-09,  7.701064635992369e-11, -7.711517209217355e-13, -4.956310447965684e-16,
 -9.838736841869581e-17,  1.095692936670095e-18,  5.075895065200077e-20,  8.794030591201373e-22, -2.048992809744530e-24,  7.140313378315217e-03, -4.704440506500628e-05,
  6.153757340000601e-07, -6.073419262044264e-09,  5.684449333483756e-11, -6.301612277423825e-13,  8.605555387434242e-16, -8.159854998036069e-17,  8.962238415608526e-19,
  3.412956807148354e-20,  6.188396863255907e-22, -1.454843118827617e-24,  1.975315225699296e-03, -1.606778746235811e-05,  2.536492318037250e-07, -2.832513309142365e-09,
  3.035985966961965e-11, -3.627947017915651e-13,  1.448116643234130e-15, -4.754524493562867e-17,  5.164677991989298e-19,  1.368696681334378e-20,  2.795353853518797e-22,
 -7.029453670890482e-25,  4.146484612802435e-04, -4.186731175316309e-06,  7.692477883528965e-08, -9.707667731585356e-10,  1.184412708276277e-11, -1.521143702832174e-13,
  1.008416208313742e-15, -2.107836483043397e-17,  2.319574997589731e-19,  3.241603047273224e-21,  9.078461337207668e-23, -2.764420083009258e-25,  6.528829682148031e-05,
 -8.194520533679974e-07,  1.713243587207197e-08, -2.447290912629595e-10,  3.380242028075801e-12, -4.687150477636764e-14,  4.268971943442980e-16, -7.226971248419861e-18,
  8.312241271595252e-20,  2.694142912833399e-22,  2.310932907341815e-23, -1.002072989844101e-25,  7.599162653498354e-06, -1.185514991602193e-07,  2.784569038273719e-09,
 -4.514113987501862e-11,  7.029026868333567e-13, -1.059578529653019e-14,  1.209888347745843e-16, -1.895473177545950e-18,  2.338374516968056e-20, -1.033436267689149e-22,
  5.037716477725246e-24, -3.337780840983318e-26,  6.419513341542501e-07, -1.244828526685374e-08,  3.266363212697905e-10, -6.027922492269853e-12,  1.055765503202316e-13,
 -1.743039569527989e-15,  2.374233722534783e-17, -3.724655170566546e-19,  5.010072417763945e-21, -4.699833709945432e-23,  9.831384793904576e-25, -9.245323687654325e-27,
  3.845989529045262e-08, -9.282174370363434e-10,  2.720482307237567e-11, -5.736522721445715e-13,  1.130167177601532e-14, -2.059197998856404e-16,  3.254742125775207e-18,
 -5.360623578843463e-20,  7.936439775054313e-22, -1.002130597597898e-23,  1.644677671657702e-25, -1.953841711553622e-27,  1.586939159628092e-09, -4.783869010455364e-11,
  1.573232437668285e-12, -3.808784444164985e-14,  8.463310419722603e-16, -1.715677134604373e-17,  3.102264033665628e-19, -5.523627027613502e-21,  9.058157219080539e-23,
 -1.360497206611868e-24,  2.167314763067994e-26, -3.010055299724574e-28,  4.343590393112531e-11, -1.646700291166017e-12,  6.132237680435218e-14, -1.715982004307083e-15,
  4.325556935923114e-17, -9.846948301340177e-19,  2.026733923011519e-20, -3.979096303413792e-22,  7.272836837714971e-24, -1.246333568224581e-25,  2.102771833787149e-27,
 -3.300430874371436e-29,  7.510264430899334e-13, -3.622219183253597e-14,  1.549622067849510e-15, -5.061339267639458e-17,  1.461436629019714e-18, -3.779098907653608e-20,
  8.874689653464508e-22, -1.952128384770735e-23,  4.009094536281154e-25, -7.759271900201140e-27,  1.439842102700833e-28, -2.532651648906552e-30,  7.689775618171448e-15,
 -4.806257461379558e-16,  2.413150564702809e-17, -9.336655134262029e-19,  3.134928461171933e-20, -9.350877320919770e-22,  2.529163730392088e-23, -6.335090824469959e-25,
  1.479060297342036e-26, -3.248576552123259e-28,  6.770875423426110e-30, -1.341154125332351e-31,  4.276396928320327e-17, -3.567083340285927e-18,  2.170011255116029e-19,
 -1.017934388532126e-20,  4.067674840407764e-22, -1.430745377873192e-23,  4.537321628651242e-25, -1.320867268131024e-26,  3.567584975383547e-28, -9.023104742942288e-30,
  2.152443699695845e-31, -4.865137995085756e-33,  1.153738386286862e-19, -1.347576391467222e-20,  1.043893717977022e-21, -6.168589015225253e-23,  3.043630394079588e-24,
 -1.305909427239371e-25,  5.003751925959296e-27, -1.743535919240042e-28,  5.595444120350333e-30, -1.670095244607828e-31,  4.671151816286607e-33, -1.230881990087962e-34,
  1.348333990558048e-22, -2.392854668451611e-23,  2.563168322805030e-24, -2.038988470898147e-25,  1.320387326874732e-26, -7.299651226767708e-28,  3.549047632189566e-29,
 -1.548277728025385e-30,  6.148570045446391e-32, -2.246993395862926e-33,  7.620750469846522e-35, -2.412848439330132e-36,  8.471024529484895e-26, -2.568923634595651e-26,
  4.305439969858639e-27, -5.095871045789820e-28,  4.716588587066648e-29, -3.608547955068758e-30,  2.362806329160326e-31, -1.355938180283368e-32,  6.938535413517148e-34,
 -3.207788324413241e-35,  1.353705056168179e-36, -5.251774349407213e-38,  8.822659395062118e-02, -3.228850270661470e-04,  1.206746161816783e-06, -4.918050943008539e-09,
  3.098014918480934e-11,  5.258712200035528e-13,  1.281244122053577e-14,  8.400364928945418e-19, -6.617697043931327e-18, -1.577429549996404e-19, -4.158753350950642e-22,
  6.336032864424708e-23,  6.860696589016206e-02, -2.670501675533327e-04,  1.347274373489574e-06, -7.571435413444805e-09,  4.639305328345393e-11, -1.851604489933937e-14,
  5.642660514933448e-15, -6.274078575488662e-18, -2.283223912447199e-18, -5.518634385659541e-20, -1.475731343428113e-22,  2.189833027424516e-23,  4.142014247430685e-02,
 -1.807817297262522e-04,  1.321196128134036e-06, -9.491557753197126e-09,  6.178395184707882e-11, -6.078942562699813e-13, -1.017568760299275e-15, -1.805271090837857e-17,
  2.101023774516486e-18,  4.714076322926469e-20,  1.256639800148227e-22, -1.942593157301036e-23,  1.935162685520067e-02, -9.849740950893341e-05,  9.903341622189240e-07,
 -8.374393395204386e-09,  6.127400851648615e-11, -8.102233322727030e-13, -2.439446757051261e-15, -2.787583779670993e-17,  3.471747388618456e-18,  7.694345872644526e-20,
  2.143887592289867e-22, -3.148349874649617e-23,  6.961540760205584e-03, -4.239841573417657e-05,  5.475375556171961e-07, -5.264313354603709e-09,  4.428490074790024e-11,
 -6.323861799646011e-13, -8.059767576102127e-16, -2.888398767454171e-17,  2.511873509326562e-18,  5.265388754932646e-20,  1.587285379775265e-22, -2.176886894159749e-23,
  1.914898136595735e-03, -1.416683763263266e-05,  2.223391493064140e-07, -2.403326831473426e-09,  2.335553485850255e-11, -3.416187227686513e-13,  4.367675584123393e-16,
 -2.115528179689749e-17,  1.184481625805178e-18,  2.212311395910960e-20,  7.817412957808018e-23, -9.464581675262997e-24,  3.990628076996629e-04, -3.614931747147280e-06,
  6.631596935330102e-08, -8.044680218331221e-10,  9.000933843294312e-12, -1.340242624639120e-13,  5.443776799244792e-16, -1.114556346935083e-17,  4.057430895182238e-19,
  6.015130143539202e-21,  2.923986175047667e-23, -2.826645449267352e-24,  6.226721641964976e-05, -6.932880839827933e-07,  1.449088343416585e-08, -1.976512038488490e-10,
  2.530490115748657e-12, -3.873865374520931e-14,  2.644293281802856e-16, -4.248671320621624e-18,  1.073618334032038e-19,  9.860161317886638e-22,  9.027208810226608e-24,
 -6.052951479337414e-25,  7.166328904696517e-06, -9.826569613544839e-08,  2.303826143535875e-09, -3.544880776753696e-11,  5.161525723398674e-13, -8.246508324288483e-15,
  7.808919438053539e-17, -1.171468251507413e-18,  2.281438096200717e-20,  5.445054619925550e-23,  2.381516912903351e-24, -9.768548335288942e-26,  5.969635338782285e-07,
 -1.009828277197696e-08,  2.633775391385223e-10, -4.589861461696691e-12,  7.565708630802881e-14, -1.281567430010310e-15,  1.535288299555673e-17, -2.324396405663898e-19,
  3.924286352386157e-21, -1.632872748404280e-23,  5.227923454131568e-25, -1.298954827947939e-26,  3.514266419650277e-08, -7.353278682202777e-10,  2.128251866862055e-11,
 -4.219910628264785e-13,  7.856404604650939e-15, -1.432397491969294e-16,  2.063224602618579e-18, -3.286823674714208e-20,  5.323345541943211e-22, -4.983067184591443e-24,
  9.009565365644258e-26, -1.583425840155568e-27,  1.418155069722809e-09, -3.687453412950541e-11,  1.187282361558906e-12, -2.693431356847682e-14,  5.666429909608277e-16,
 -1.127959405610139e-17,  1.898395270351988e-19, -3.264392712398158e-21,  5.444046812764116e-23, -7.137112888859419e-25,  1.155032388558165e-26, -1.784877934713045e-28,
  3.771467842493417e-11, -1.228064982929546e-12,  4.430952128076629e-14, -1.158378321119290e-15,  2.764360476776652e-17, -6.093065218952420e-19,  1.181070659396699e-20,
 -2.232068202255786e-22,  4.004749233350407e-24, -6.376913208384824e-26,  1.058415431177895e-27, -1.664955832145450e-29,  6.275789294979580e-13, -2.590789816479132e-14,
  1.060914386129594e-15, -3.228242042036653e-17,  8.808611538223757e-19, -2.182436058211708e-20,  4.853067165343077e-22, -1.023651209309259e-23,  2.030540394733696e-25,
 -3.734864456537624e-27,  6.720177672568124e-29, -1.148653213778301e-30,  6.092819905446888e-15, -3.250961672850775e-16,  1.541229341688973e-17, -5.539015606855370e-19,
  1.751726389640500e-20, -4.966526591516958e-22,  1.273647205722577e-23, -3.047584521536526e-25,  6.821303245633988e-27, -1.432857770453565e-28,  2.876436448914282e-30,
 -5.492137258267171e-32,  3.132572979755218e-17, -2.227487201169225e-18,  1.260772599127086e-19, -5.474460400796769e-21,  2.051374462417434e-22, -6.815637000399473e-24,
  2.046794071448199e-25, -5.672287076633075e-27,  1.463087887440102e-28, -3.540451893199712e-30,  8.108346403950165e-32, -1.762615791916751e-33,  7.443686632318057e-20,
 -7.420751554375639e-21,  5.270052276087799e-22, -2.871358067703818e-23,  1.322242315309211e-24, -5.333808648556648e-26,  1.931214457390277e-27, -6.389849629493131e-29,
  1.954532505230515e-30, -5.578036085805912e-32,  1.496219291866400e-33, -3.790631029596526e-35,  6.854662484185222e-23, -1.048748454548488e-23,  1.019706153635080e-24,
 -7.467643695983976e-26,  4.505445598159682e-27, -2.340041176115522e-28,  1.075830079116328e-29, -4.462012916366286e-31,  1.692215862476343e-32, -5.928719038805098e-34,
  1.934198725971207e-35, -5.908700393294653e-37,  2.490538079717426e-26, -6.855816994386367e-27,  1.066877446685863e-27, -1.188588108332177e-28,  1.045862948171753e-29,
 -7.664295243569908e-31,  4.835322434267634e-32, -2.686379834083075e-33,  1.336083748181981e-34, -6.023366239107108e-36,  2.485624825624262e-37, -9.452519057041529e-39,
  8.695400109372686e-02, -3.134577916875078e-04,  1.151103678449416e-06, -4.322011346449388e-09,  4.442861845056739e-11,  8.045211916799276e-13,  9.033049178482770e-15,
 -2.981561572489218e-16, -1.171354395136553e-17, -9.569284583334971e-20,  4.046850288389308e-21,  1.336410972531105e-22,  6.755976401770314e-02, -2.566227638761177e-04,
  1.260881923572198e-06, -6.824982845556723e-09,  4.731231056647229e-11,  1.047227369432395e-13,  4.150607398513906e-15, -1.098951215862897e-16, -4.070515072461732e-18,
 -3.380843898606381e-20,  1.402095553927798e-21,  4.659780111341749e-23,  4.071745583072232e-02, -1.706518830868442e-04,  1.212823089303749e-06, -8.601619649062310e-09,
  4.938679512561380e-11, -6.292307056218810e-13, -3.314938442279024e-16,  7.521145481213051e-17,  3.618929958966788e-18,  2.814659229769892e-20, -1.233904450748937e-21,
 -4.049438536651783e-23,  1.897286798897844e-02, -9.096129305648064e-05,  8.951785848175183e-07, -7.526832807847479e-09,  4.449655562641267e-11, -8.630436811402016e-13,
 -1.255486635002881e-15,  1.257972507863722e-16,  5.957909042339016e-18,  4.644953350139240e-20, -2.000989219442598e-21, -6.631309626735906e-23,  6.800323339058722e-03,
 -3.825972551584911e-05,  4.881960575776157e-07, -4.658076853754477e-09,  3.143259254706994e-11, -6.506116335856229e-13, -2.089105988398017e-16,  8.069874096717102e-17,
  4.218368232619872e-18,  3.194278571178685e-20, -1.377269632509739e-21, -4.611373637124034e-23,  1.861613847389197e-03, -1.249764763479128e-05,  1.955173910794889e-07,
 -2.083842614137738e-09,  1.660526527047408e-11, -3.332279170391261e-13,  4.933607496594671e-16,  2.907214268376592e-17,  1.905279541613828e-18,  1.347751537929203e-20,
 -5.906117586654598e-22, -2.013375192257879e-23,  3.856061897303996e-04, -3.120769718853789e-06,  5.744006545090337e-08, -6.812642171424092e-10,  6.434259389107354e-12,
 -1.230359381516641e-13,  4.465275545183040e-16,  5.224034405185944e-18,  6.040441368723152e-19,  3.678701523033089e-21, -1.699336141948505e-22, -6.005550439449851e-24,
  5.971179341576744e-05, -5.862167944300247e-07,  1.233745271836165e-08, -1.630497608153228e-10,  1.811693901369288e-12, -3.339791286346161e-14,  1.990346911995133e-16,
 -2.400551771395224e-19,  1.410374512387879e-19,  6.062717106722073e-22, -3.293982839150294e-23, -1.261348296865213e-24,  6.807615678787768e-06, -8.140815862617340e-08,
  1.922851411363696e-09, -2.841762000747752e-11,  3.677425949890039e-13, -6.681255420580316e-15,  5.587756042969159e-17, -4.017872188418178e-19,  2.519114109007330e-20,
  3.495200428093812e-23, -4.048333946175067e-24, -1.897841524199385e-25,  5.604622496661040e-07, -8.192824964040460e-09,  2.147758535444752e-10, -3.566342013110512e-12,
  5.325471743866095e-14, -9.774368959618085e-16,  1.053588237848955e-17, -1.134930590459463e-19,  3.553157377968355e-21, -9.279033986455977e-24, -2.309305820607075e-25,
 -2.102050401963344e-26,  3.251255179257087e-08, -5.833880121468311e-10,  1.688624179107580e-11, -3.167966838866921e-13,  5.421562799503395e-15, -1.029854770119109e-16,
  1.358587512463069e-18, -1.814744078192878e-20,  4.005427559090959e-22, -2.830443155529027e-24,  1.560024822960706e-26, -1.827611213737651e-27,  1.287803283589728e-09,
 -2.853067292974325e-11,  9.117486825420425e-13, -1.945302098409890e-14,  3.801360341679379e-16, -7.644338669670657e-18,  1.195150445472333e-19, -1.858588891663700e-21,
  3.531725130495058e-23, -3.934726529574357e-25,  4.743677450491328e-27, -1.384180223639101e-28,  3.343284251420841e-11, -9.225075750454857e-13,  3.270528073200938e-14,
 -8.000574810839099e-16,  1.785260876968730e-17, -3.882273993781511e-19,  7.060682349948779e-21, -1.248873977326227e-22,  2.318383997837502e-24, -3.356464101855213e-26,
  5.026090182355232e-28, -9.582620103305799e-30,  5.387676649780670e-13, -1.876004171879367e-14,  7.454962587647594e-16, -2.113336802833232e-17,  5.409590368720328e-19,
 -1.299010425741202e-20,  2.726330328785103e-22, -5.456650996762502e-24,  1.068049942873424e-25, -1.845784405314185e-27,  3.153523141374119e-29, -5.537626033733667e-31,
  5.002787032390602e-15, -2.242802000458988e-16,  1.016616194968000e-17, -3.389930173001325e-19,  1.005957772529520e-20, -2.727858710229154e-22,  6.618297511725798e-24,
 -1.508026560890720e-25,  3.259498297743928e-27, -6.517546384337405e-29,  1.255589598554151e-30, -2.340368447425799e-32,  2.408397042697416e-17, -1.434705638296796e-18,
  7.631564252867731e-20, -3.061658050869230e-21,  1.073883511142830e-22, -3.378814313141653e-24,  9.595593955016313e-26, -2.529316387624890e-27,  6.240368675475794e-29,
 -1.442301341832931e-30,  3.169453502838113e-32, -6.637349774522064e-34,  5.142202128369301e-20, -4.290599711164273e-21,  2.809310630532972e-22, -1.407491889310395e-23,
  6.039825559877001e-25, -2.290232611953425e-26,  7.824584152501199e-28, -2.455821027237739e-29,  7.154606062183764e-31, -1.949788822087782e-32,  5.010796668591410e-34,
 -1.219446336533714e-35,  3.859127465757960e-23, -4.970723787397861e-24,  4.376940025908691e-25, -2.935671362325843e-26,  1.643964887359376e-27, -7.995830058059271e-29,
  3.465123598111496e-30, -1.362401557584272e-31,  4.920925018664205e-33, -1.648488649178603e-34,  5.160503425679942e-36, -1.517419952060361e-37,  8.393835245669767e-27,
 -2.035483818398821e-27,  2.895557322633492e-28, -3.000254042795119e-29,  2.486131020489728e-30, -1.731468550462621e-31,  1.045557649092927e-32, -5.591786386433952e-34,
  2.689751975192568e-35, -1.177367713677348e-36,  4.733031514881550e-38, -1.758444956855349e-39,  };
  int offset = -19;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 19;
    if (std::isnan(t)) {
      fill_n(rr+offset, 19, 0.5);
      fill_n(ww+offset, 19, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 19; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=19; ++j) {
        const int boxof = it*228+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
