#ifndef ATL_stGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,360,480,720,1440,2160,2880
 * N : 25,360,480,720,1440,2160,2880
 * NB : 2,16,20,24,40,120,120
 */
#define ATL_stGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 192) (nb_) = 2; \
   else if ((n_) < 420) (nb_) = 16; \
   else if ((n_) < 600) (nb_) = 20; \
   else if ((n_) < 1080) (nb_) = 24; \
   else if ((n_) < 1800) (nb_) = 40; \
   else (nb_) = 120; \
}


#endif    /* end ifndef ATL_stGetNB_geqrf */
