/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler;

import java.security.AccessControlContext;
import java.security.Permission;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.commons.nullanalysis.Nullable;

public final class Sandbox {
    private static final Map<ClassLoader, AccessControlContext> CONFINED_CLASS_LOADERS = Collections.synchronizedMap(new WeakHashMap());

    private Sandbox() {
    }

    public static void confine(ClassLoader classLoader, AccessControlContext accessControlContext) {
        if (CONFINED_CLASS_LOADERS.containsKey(classLoader)) {
            throw new SecurityException("Attempt to change the access control context for '" + classLoader + "'");
        }
        CONFINED_CLASS_LOADERS.put(classLoader, accessControlContext);
    }

    public static void confine(ClassLoader classLoader, ProtectionDomain protectionDomain) {
        Sandbox.confine(classLoader, new AccessControlContext(new ProtectionDomain[]{protectionDomain}));
    }

    public static void confine(ClassLoader classLoader, Permissions permissions) {
        Sandbox.confine(classLoader, new ProtectionDomain(null, permissions));
    }

    static {
        final SecurityManager previousSecurityManager = System.getSecurityManager();
        System.setSecurityManager(new SecurityManager(){

            @Override
            public void checkPermission(@Nullable Permission perm) {
                assert (perm != null);
                if (previousSecurityManager != null) {
                    previousSecurityManager.checkPermission(perm);
                }
                for (Class<?> clasS : this.getClassContext()) {
                    AccessControlContext acc = (AccessControlContext)CONFINED_CLASS_LOADERS.get(clasS.getClassLoader());
                    if (acc == null) continue;
                    acc.checkPermission(perm);
                }
            }
        });
    }
}

