/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import org.cojen.classfile.ClassFile;
import org.cojen.util.Cache;
import org.cojen.util.KeyFactory;
import org.cojen.util.WeakKeyCache;
import org.cojen.util.WeakValueCache;

public class RuntimeClassFile
extends ClassFile {
    private static final boolean DEBUG = Boolean.getBoolean("org.cojen.classfile.RuntimeClassFile.DEBUG") || Boolean.getBoolean("org.cojen.util.ClassInjector.DEBUG") || Boolean.getBoolean("cojen.util.ClassInjector.DEBUG");
    private static final Random cRandom = new Random();
    private static Cache<Object, Loader> cLoaders = new WeakValueCache<Object, Loader>(11);
    private final Loader mLoader;

    public RuntimeClassFile() {
        this(null, null, null, null, false, null);
    }

    public RuntimeClassFile(String className) {
        this(className, null, null, null, false, null);
    }

    public RuntimeClassFile(String className, String superClassName) {
        this(className, superClassName, null, null, false, null);
    }

    public RuntimeClassFile(String className, String superClassName, ClassLoader parentLoader) {
        this(className, superClassName, parentLoader, null, false, null);
    }

    public RuntimeClassFile(String className, String superClassName, ClassLoader parentLoader, ProtectionDomain domain) {
        this(className, superClassName, parentLoader, domain, false, null);
    }

    public RuntimeClassFile(String className, String superClassName, ClassLoader parentLoader, ProtectionDomain domain, boolean explicit) {
        this(className, superClassName, parentLoader, domain, explicit, null);
    }

    private RuntimeClassFile(String className, String superClassName, ClassLoader parentLoader, ProtectionDomain domain, boolean explicit, LoaderAndName loaderAndName) {
        loaderAndName = RuntimeClassFile.loaderAndName(className, parentLoader, domain, explicit);
        super(loaderAndName.mClassName, superClassName);
        this.mLoader = loaderAndName.mLoader;
    }

    public Class defineClass() {
        byte[] bytes;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.writeTo(bout);
            bytes = bout.toByteArray();
        }
        catch (IOException e) {
            InternalError ie = new InternalError(e.toString());
            ie.initCause(e);
            throw ie;
        }
        if (DEBUG) {
            File file = new File(this.getClassName().replace('.', '/') + ".class");
            try {
                File tempDir = new File(System.getProperty("java.io.tmpdir"));
                file = new File(tempDir, file.getPath());
            }
            catch (SecurityException e) {
                // empty catch block
            }
            try {
                file.getParentFile().mkdirs();
                System.out.println("RuntimeClassFile writing to " + file);
                FileOutputStream out = new FileOutputStream(file);
                ((OutputStream)out).write(bytes);
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.mLoader.define(this.getClassName(), bytes);
    }

    public ClassLoader getClassLoader() {
        return this.mLoader;
    }

    private static LoaderAndName loaderAndName(String className, ClassLoader parentLoader, ProtectionDomain domain, boolean explicit) {
        Object loaderKey;
        Loader loader;
        if (className == null) {
            if (explicit) {
                throw new IllegalArgumentException("Explicit class name not provided");
            }
            className = RuntimeClassFile.class.getName();
        }
        if (parentLoader == null && (parentLoader = RuntimeClassFile.class.getClassLoader()) == null) {
            parentLoader = ClassLoader.getSystemClassLoader();
        }
        if ((loader = cLoaders.get(loaderKey = RuntimeClassFile.createLoaderKey(className, parentLoader, domain))) == null) {
            loader = parentLoader == null ? new Loader(domain) : new Loader(parentLoader, domain);
            cLoaders.put(loaderKey, loader);
        }
        if (explicit) {
            return new LoaderAndName(loader, className);
        }
        for (int tryCount = 0; tryCount < 1000; ++tryCount) {
            long id = cRandom.nextInt();
            switch (tryCount) {
                case 0: {
                    id &= 0xFFL;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    id &= 0xFFFFL;
                    break;
                }
                default: {
                    id &= 0xFFFFFFFFL;
                }
            }
            String mangled = className + '$' + id;
            if (!loader.reserveName(mangled, false)) continue;
            return new LoaderAndName(loader, mangled);
        }
        throw new InternalError("Unable to create unique class name");
    }

    private static Object createLoaderKey(String className, ClassLoader parentLoader, ProtectionDomain domain) {
        int index = className.lastIndexOf(46);
        String packageName = index < 0 ? "" : className.substring(0, index);
        String domainKey = null;
        CodeSource csKey = null;
        HashSet<Permission> permsKey = null;
        Object principalsKey = null;
        if (domain != null) {
            Principal[] principals;
            domainKey = "";
            csKey = domain.getCodeSource();
            PermissionCollection pc = domain.getPermissions();
            if (pc != null) {
                ArrayList<Permission> permList = Collections.list(pc.elements());
                if (permList.size() == 1) {
                    permsKey = (HashSet<Permission>)permList.get(0);
                } else if (permList.size() > 1) {
                    permsKey = new HashSet<Permission>(permList);
                }
            }
            if ((principals = domain.getPrincipals()) != null && principals.length > 0) {
                if (principals.length == 1) {
                    principalsKey = principals[0];
                } else {
                    HashSet<Principal> principalSet = new HashSet<Principal>(principals.length);
                    for (Principal principal : principals) {
                        principalSet.add(principal);
                    }
                    principalsKey = principalSet;
                }
            }
        }
        return KeyFactory.createKey(new Object[]{parentLoader, packageName, domainKey, csKey, permsKey, principalsKey});
    }

    private static final class LoaderAndName {
        final Loader mLoader;
        final String mClassName;

        LoaderAndName(Loader loader, String className) {
            this.mLoader = loader;
            this.mClassName = className;
        }
    }

    private static final class Loader
    extends ClassLoader {
        private final Cache<String, Boolean> mReservedNames = new WeakKeyCache<String, Boolean>(17);
        private final ProtectionDomain mDomain;

        Loader(ClassLoader parent, ProtectionDomain domain) {
            super(parent);
            this.mDomain = Loader.prepareDomain(domain, this);
        }

        Loader(ProtectionDomain domain) {
            this.mDomain = Loader.prepareDomain(domain, this);
        }

        private static ProtectionDomain prepareDomain(ProtectionDomain domain, ClassLoader loader) {
            if (domain == null) {
                return null;
            }
            return new ProtectionDomain(domain.getCodeSource(), domain.getPermissions(), loader, domain.getPrincipals());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean reserveName(String name, boolean explicit) {
            Cache<String, Boolean> cache = this.mReservedNames;
            synchronized (cache) {
                if (this.mReservedNames.put(name, Boolean.TRUE) != null && !explicit) {
                    return false;
                }
            }
            try {
                this.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return true;
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
            return false;
        }

        Class define(String name, byte[] b) {
            try {
                Class<?> clazz = this.mDomain == null ? this.defineClass(name, b, 0, b.length) : this.defineClass(name, b, 0, b.length, this.mDomain);
                this.resolveClass(clazz);
                Class<?> clazz2 = clazz;
                return clazz2;
            }
            catch (LinkageError e) {
                try {
                    this.loadClass(name);
                    throw new IllegalStateException("Class already defined: " + name);
                }
                catch (ClassNotFoundException e2) {
                    throw e;
                }
            }
            finally {
                this.mReservedNames.remove(name);
            }
        }
    }
}

