/*
 * Copyright 2018-2019, ARM Limited and Contributors. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef IMX_IO_MUX_H
#define IMX_IO_MUX_H

#include <stdint.h>
#include <lib/utils_def.h>

/*
 * i.MX 7Solo Applications Processor Reference Manual, Rev. 0.1, 08/2016
 * Section 8.2.7 IOMUXC Memory Map/Register Definition
 */

#define IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO08_OFFSET		0x0014
#define IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO09_OFFSET		0x0018
#define IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO10_OFFSET		0x001C
#define IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO11_OFFSET		0x0020
#define IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO12_OFFSET		0x0024
#define IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO13_OFFSET		0x0028

#define IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO14_OFFSET		0x002C
#define IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO14_ALT1_SD3_CD_B	BIT(0)

#define IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO15_OFFSET		0x0030

#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA00_OFFSET	0x0034
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA01_OFFSET	0x0038
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA02_OFFSET	0x003C
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA03_OFFSET	0x0040
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA04_OFFSET	0x0044
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA05_OFFSET	0x0048
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA06_OFFSET	0x004C
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA07_OFFSET	0x0050
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA08_OFFSET	0x0054
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA09_OFFSET	0x0058
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA10_OFFSET	0x005C
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA11_OFFSET	0x0060
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA12_OFFSET	0x0064
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA13_OFFSET	0x0068
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA14_OFFSET	0x006C
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA15_OFFSET	0x0070

#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCLK_OFFSET		0x0074
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDLE_OFFSET		0x0078
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDOE_OFFSET		0x007C
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDSHR_OFFSET		0x0080
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE0_OFFSET		0x0084
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE1_OFFSET		0x0088
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE2_OFFSET		0x008C
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE3_OFFSET		0x0090

#define IOMUXC_SW_MUX_CTL_PAD_EPDC_GDCLK_OFFSET		0x0094
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_GDOE_OFFSET		0x0098
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_GDRL_OFFSET		0x009C
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_GDSP_OFFSET		0x00A0
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_BDR0_OFFSET		0x00A4
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_BDR1_OFFSET		0x00A8
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_COM_OFFSET	0x00AC
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_STAT_OFFSET	0x00B0

#define IOMUXC_SW_MUX_CTL_PAD_LCD_CLK_OFFSET		0x00B4
#define IOMUXC_SW_MUX_CTL_PAD_LCD_ENABLE_OFFSET		0x00B8
#define IOMUXC_SW_MUX_CTL_PAD_LCD_HSYNC_OFFSET		0x00BC
#define IOMUXC_SW_MUX_CTL_PAD_LCD_VSYNC_OFFSET		0x00C0
#define IOMUXC_SW_MUX_CTL_PAD_LCD_RESET_OFFSET		0x00C4
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA00_OFFSET		0x00C8
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA01_OFFSET		0x00CC
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA02_OFFSET		0x00D0
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA03_OFFSET		0x00D4
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA04_OFFSET		0x00D8
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA05_OFFSET		0x00DC
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA06_OFFSET		0x00E0
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA07_OFFSET		0x00E4
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA08_OFFSET		0x00E8
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA09_OFFSET		0x00EC
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA10_OFFSET		0x00F0
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA11_OFFSET		0x00F4
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA12_OFFSET		0x00F8
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA13_OFFSET		0x00FC
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA14_OFFSET		0x0100
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA15_OFFSET		0x0104
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA16_OFFSET		0x0108
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA17_OFFSET		0x010C
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA18_OFFSET		0x0110
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA19_OFFSET		0x0114
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA20_OFFSET		0x0118
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA21_OFFSET		0x011C
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA22_OFFSET		0x0120
#define IOMUXC_SW_MUX_CTL_PAD_LCD_DATA23_OFFSET		0x0124

#define IOMUXC_SW_MUX_CTL_PAD_UART1_RX_DATA_OFFSET	0x0128
#define IOMUXC_SW_MUX_CTL_PAD_UART1_RX_DATA_ALT0_UART1_RX_DATA	0x00
#define IOMUXC_SW_MUX_CTL_PAD_UART1_RX_DATA_ALT1_I2C1_SCL	BIT(0)
#define IOMUXC_SW_MUX_CTL_PAD_UART1_RX_DATA_ALT2_PMIC_READY	BIT(1)
#define IOMUXC_SW_MUX_CTL_PAD_UART1_RX_DATA_ALT3_ECSPI1_SS1	(BIT(1) | BIT(0))
#define IOMUXC_SW_MUX_CTL_PAD_UART1_RX_DATA_ALT4_ENET2_1588_EVENT0_IN BIT(3)
#define IOMUXC_SW_MUX_CTL_PAD_UART1_RX_DATA_ALT5_GPIO4_IO0	(BIT(2) | BIT(0))
#define IOMUXC_SW_MUX_CTL_PAD_UART1_RX_DATA_ALT6_ENET1_MDIO	(BIT(2) | BIT(1))
#define IOMUXC_SW_MUX_CTL_PAD_UART1_RX_DATA_SION		BIT(3)

#define IOMUXC_SW_MUX_CTL_PAD_UART1_TX_DATA_OFFSET	0x012C
#define IOMUXC_SW_MUX_CTL_PAD_UART1_TX_DATA_ALT0_UART1_TX_DATA	0x00
#define IOMUXC_SW_MUX_CTL_PAD_UART1_TX_DATA_ALT1_I2C1_SDA	BIT(0)
#define IOMUXC_SW_MUX_CTL_PAD_UART1_TX_DATA_ALT2_SAI3_MCLK	BIT(1)
#define IOMUXC_SW_MUX_CTL_PAD_UART1_TX_DATA_ALT3_ECSPI1_SS2	(BIT(1) | BIT(0))
#define IOMUXC_SW_MUX_CTL_PAD_UART1_TX_DATA_ALT4_ENET2_1588_EVENT0_OUT BIT(3)
#define IOMUXC_SW_MUX_CTL_PAD_UART1_TX_DATA_ALT5_GPIO4_IO1	(BIT(2) | BIT(0))
#define IOMUXC_SW_MUX_CTL_PAD_UART1_TX_DATA_ALT6_ENET1_MDC	(BIT(2) | BIT(1))
#define IOMUXC_SW_MUX_CTL_PAD_UART1_TX_DATA_SION		BIT(3)

#define IOMUXC_SW_MUX_CTL_PAD_UART2_RX_DATA_OFFSET	0x0130
#define IOMUXC_SW_MUX_CTL_PAD_UART2_TX_DATA_OFFSET	0x0134
#define IOMUXC_SW_MUX_CTL_PAD_UART3_RX_DATA_OFFSET	0x0138
#define IOMUXC_SW_MUX_CTL_PAD_UART3_TX_DATA_OFFSET	0x013C
#define IOMUXC_SW_MUX_CTL_PAD_UART3_RTS_B_OFFSET	0x0140
#define IOMUXC_SW_MUX_CTL_PAD_UART3_CTS_B_OFFSET	0x0144

#define IOMUXC_SW_MUX_CTL_PAD_I2C1_SCL_OFFSET		0x0148
#define IOMUXC_SW_MUX_CTL_PAD_I2C1_SDA_OFFSET		0x014C
#define IOMUXC_SW_MUX_CTL_PAD_I2C2_SCL_OFFSET		0x0150
#define IOMUXC_SW_MUX_CTL_PAD_I2C2_SDA_OFFSET		0x0154
#define IOMUXC_SW_MUX_CTL_PAD_I2C3_SCL_OFFSET		0x0158
#define IOMUXC_SW_MUX_CTL_PAD_I2C3_SDA_OFFSET		0x015C

#define IOMUXC_SW_MUX_CTL_PAD_I2C4_SCL_OFFSET		0x0160
#define IOMUXC_SW_MUX_CTL_PAD_I2C4_SCL_ALT0_I2C4_SCL		0x0
#define IOMUXC_SW_MUX_CTL_PAD_I2C4_SCL_ALT1_UART5_RX_DATA	BIT(0)
#define IOMUXC_SW_MUX_CTL_PAD_I2C4_SCL_ALT2_WDOG4_WDOG_B	BIT(1)
#define IOMUXC_SW_MUX_CTL_PAD_I2C4_SCL_ALT3_CSI_PIXCLK		(BIT(1) | BIT(0))
#define IOMUXC_SW_MUX_CTL_PAD_I2C4_SCL_ALT4_USB_OTG1_ID		BIT(2)
#define IOMUXC_SW_MUX_CTL_PAD_I2C4_SCL_ALT5_GPIO4_IO14		(BIT(2) | BIT(0))
#define IOMUXC_SW_MUX_CTL_PAD_I2C4_SCL_ALT6_EPDC_VCOM0		(BIT(2) | BIT(1))

#define IOMUXC_SW_MUX_CTL_PAD_I2C4_SDA_OFFSET		0x0164
#define IOMUXC_SW_MUX_CTL_PAD_I2C4_SDA_ALT0_I2C4_SDA		0x0
#define IOMUXC_SW_MUX_CTL_PAD_I2C4_SDA_ALT1_UART5_TX_DATA	BIT(0)
#define IOMUXC_SW_MUX_CTL_PAD_I2C4_SDA_ALT2_WDOG4_WDOG_RST_B_DEB BIT(1)
#define IOMUXC_SW_MUX_CTL_PAD_I2C4_SDA_ALT3_CSI_MCLK		(BIT(1) | BIT(0))
#define IOMUXC_SW_MUX_CTL_PAD_I2C4_SDA_ALT4_USB_OTG2_ID		BIT(2)
#define IOMUXC_SW_MUX_CTL_PAD_I2C4_SDA_ALT5_GPIO4_IO15		(BIT(1) | BIT(0))
#define IOMUXC_SW_MUX_CTL_PAD_I2C4_SDA_ALT6_EPDC_VCOM1		(BIT(2) | BIT(1))

#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_SCLK_OFFSET	0x0168
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_SCLK_ALT0_ECSPI1_SCLK	0x00
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_SCLK_ALT1_UART6_RX_DATA	BIT(0)
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_SCLK_ALT2_SD2_DATA4	BIT(1)
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_SCLK_ALT3_CSI_DATA2	(BIT(1) | BIT(0))
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_SCLK_ALT5_GPIO4_IO16	(BIT(2) | BIT(0))
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_SCLK_ALT6_EPDC_PWR_COM	(BIT(2) | (BIT(1))

#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_MOSI_OFFSET	0x016C
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_MOSI_ALT0_ECSPI1_MOSI	0x00
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_MOSI_ALT1_UART6_TX_DATA	BIT(0)
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_MOSI_ALT2_SD2_DATA5	BIT(1)
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_MOSI_ALT3_CSI_DATA3	(BIT(1) | BIT(0))
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_MOSI_ALT5_GPIO4_IO17	(BIT(2) | BIT(0))
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_MOSI_ALT6_EPDC_PWR_STAT	(BIT(2) | (BIT(1))

#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_MISO_OFFSET	0x0170
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_SS0_OFFSET		0x0174
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI2_SCLK_OFFSET	0x0178
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI2_MOSI_OFFSET	0x017C
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI2_MISO_OFFSET	0x0180
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI2_SS0_OFFSET		0x0184

#define IOMUXC_SW_MUX_CTL_PAD_SD1_CD_B_OFFSET		0x0188
#define IOMUXC_SW_MUX_CTL_PAD_SD1_WP_OFFSET		0x018C
#define IOMUXC_SW_MUX_CTL_PAD_SD1_RESET_B_OFFSET	0x0190
#define IOMUXC_SW_MUX_CTL_PAD_SD1_CLK_OFFSET		0x0194
#define IOMUXC_SW_MUX_CTL_PAD_SD1_CMD_OFFSET		0x0198
#define IOMUXC_SW_MUX_CTL_PAD_SD1_DATA0_OFFSET		0x019C
#define IOMUXC_SW_MUX_CTL_PAD_SD1_DATA1_OFFSET		0x01A0
#define IOMUXC_SW_MUX_CTL_PAD_SD1_DATA2_OFFSET		0x01A4
#define IOMUXC_SW_MUX_CTL_PAD_SD1_DATA3_OFFSET		0x01A8
#define IOMUXC_SW_MUX_CTL_PAD_SD2_CD_B_OFFSET		0x01AC
#define IOMUXC_SW_MUX_CTL_PAD_SD2_WP_OFFSET		0x01B0
#define IOMUXC_SW_MUX_CTL_PAD_SD2_RESET_B_OFFSET	0x01B4
#define IOMUXC_SW_MUX_CTL_PAD_SD2_CLK_OFFSET		0x01B8
#define IOMUXC_SW_MUX_CTL_PAD_SD2_CMD_OFFSET		0x01BC
#define IOMUXC_SW_MUX_CTL_PAD_SD2_DATA0_OFFSET		0x01C0
#define IOMUXC_SW_MUX_CTL_PAD_SD2_DATA1_OFFSET		0x01C4
#define IOMUXC_SW_MUX_CTL_PAD_SD2_DATA2_OFFSET		0x01C8
#define IOMUXC_SW_MUX_CTL_PAD_SD2_DATA3_OFFSET		0x01CC

#define IOMUXC_SW_MUX_CTL_PAD_SD3_CLK_OFFSET		0x01D0
#define IOMUXC_SW_MUX_CTL_PAD_SD3_CMD_OFFSET		0x01D4
#define IOMUXC_SW_MUX_CTL_PAD_SD3_DATA0_OFFSET		0x01D8
#define IOMUXC_SW_MUX_CTL_PAD_SD3_DATA1_OFFSET		0x01DC
#define IOMUXC_SW_MUX_CTL_PAD_SD3_DATA2_OFFSET		0x01E0
#define IOMUXC_SW_MUX_CTL_PAD_SD3_DATA3_OFFSET		0x01E4
#define IOMUXC_SW_MUX_CTL_PAD_SD3_DATA4_OFFSET		0x01E8
#define IOMUXC_SW_MUX_CTL_PAD_SD3_DATA5_OFFSET		0x01EC
#define IOMUXC_SW_MUX_CTL_PAD_SD3_DATA6_OFFSET		0x01F0
#define IOMUXC_SW_MUX_CTL_PAD_SD3_DATA7_OFFSET		0x01F4
#define IOMUXC_SW_MUX_CTL_PAD_SD3_STROBE_OFFSET		0x01F8
#define IOMUXC_SW_MUX_CTL_PAD_SD3_RESET_B_OFFSET	0x01FC

#define IOMUXC_SW_MUX_CTL_PAD_SAI1_RX_DATA_OFFSET	0x0200
#define IOMUXC_SW_MUX_CTL_PAD_SAI1_TX_BCLK_OFFSET	0x0204
#define IOMUXC_SW_MUX_CTL_PAD_SAI1_TX_SYNC_OFFSET	0x0208
#define IOMUXC_SW_MUX_CTL_PAD_SAI1_TX_DATA_OFFSET	0x020C
#define IOMUXC_SW_MUX_CTL_PAD_SAI1_RX_SYNC_OFFSET	0x0210
#define IOMUXC_SW_MUX_CTL_PAD_SAI1_RX_BCLK_OFFSET	0x0214
#define IOMUXC_SW_MUX_CTL_PAD_SAI1_MCLK_OFFSET		0x0218
#define IOMUXC_SW_MUX_CTL_PAD_SAI2_TX_SYNC_OFFSET	0x021C
#define IOMUXC_SW_MUX_CTL_PAD_SAI2_TX_BCLK_OFFSET	0x0220
#define IOMUXC_SW_MUX_CTL_PAD_SAI2_RX_DATA_OFFSET	0x0224
#define IOMUXC_SW_MUX_CTL_PAD_SAI2_TX_DATA_OFFSET	0x0228

#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_RD0_OFFSET	0x022C
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_RD1_OFFSET	0x0230
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_RD2_OFFSET	0x0234
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_RD3_OFFSET	0x0238
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_RX_CTL_OFFSET	0x023C
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_RXC_OFFSET	0x0240
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_TD0_OFFSET	0x0244
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_TD1_OFFSET	0x0248
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_TD2_OFFSET	0x024C
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_TD3_OFFSET	0x0250
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_TX_CTL_OFFSET	0x0254
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RGMII_TXC_OFFSET	0x0258
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_TX_CLK_OFFSET	0x025C
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_RX_CLK_OFFSET	0x0260
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_CRS_OFFSET		0x0264
#define IOMUXC_SW_MUX_CTL_PAD_ENET1_COL_OFFSET		0x0268

#define IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO08_OFFSET		0x026C
#define IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO09_OFFSET		0x0270
#define IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO10_OFFSET		0x0274
#define IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO11_OFFSET		0x0278
#define IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO12_OFFSET		0x027C
#define IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO13_OFFSET		0x0280
#define IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO14_OFFSET		0x0284
#define IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO15_OFFSET		0x0288

#define IOMUXC_SW_PAD_CTL_PAD_JTAG_MOD_OFFSET		0x028C
#define IOMUXC_SW_PAD_CTL_PAD_JTAG_TCK_OFFSET		0x0290
#define IOMUXC_SW_PAD_CTL_PAD_JTAG_TDI_OFFSET		0x0294
#define IOMUXC_SW_PAD_CTL_PAD_JTAG_TDO_OFFSET		0x0298
#define IOMUXC_SW_PAD_CTL_PAD_JTAG_TMS_OFFSET		0x029C
#define IOMUXC_SW_PAD_CTL_PAD_JTAG_TRST_B_OFFSET	0x02A0

#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_OFFSET	0x02A4
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_OFFSET	0x02A8
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_OFFSET	0x02AC
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_OFFSET	0x02B0
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_OFFSET	0x02B4
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_OFFSET	0x02B8
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_OFFSET	0x02BC
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_OFFSET	0x02C0
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA08_OFFSET	0x02C4
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA09_OFFSET	0x02C8
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA10_OFFSET	0x02CC
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA11_OFFSET	0x02D0
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA12_OFFSET	0x02D4
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA13_OFFSET	0x02D8
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA14_OFFSET	0x02DC
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA15_OFFSET	0x02E0

#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_OFFSET		0x02E4
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_OFFSET		0x02E8
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_OFFSET		0x02EC
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDSHR_OFFSET		0x02F0
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE0_OFFSET		0x02F4
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_OFFSET		0x02F8
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE2_OFFSET		0x02FC
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE3_OFFSET		0x0300
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_OFFSET		0x0304
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_OFFSET		0x0308
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_OFFSET		0x030C
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_OFFSET		0x0310
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR0_OFFSET		0x0314
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR1_OFFSET		0x0318
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_COM_OFFSET	0x031C
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_STAT_OFFSET	0x0320

#define IOMUXC_SW_PAD_CTL_PAD_LCD_CLK_OFFSET		0x0324
#define IOMUXC_SW_PAD_CTL_PAD_LCD_ENABLE_OFFSET		0x0328
#define IOMUXC_SW_PAD_CTL_PAD_LCD_HSYNC_OFFSET		0x032C
#define IOMUXC_SW_PAD_CTL_PAD_LCD_VSYNC_OFFSET		0x0330
#define IOMUXC_SW_PAD_CTL_PAD_LCD_RESET_OFFSET		0x0334
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA00_OFFSET		0x0338
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA01_OFFSET		0x033C
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA02_OFFSET		0x0340
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA03_OFFSET		0x0344
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA04_OFFSET		0x0348
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA05_OFFSET		0x034C
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA06_OFFSET		0x0350
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA07_OFFSET		0x0354
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA08_OFFSET		0x0358
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA09_OFFSET		0x035C
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA10_OFFSET		0x0360
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA11_OFFSET		0x0364
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA12_OFFSET		0x0368
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA13_OFFSET		0x036C
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA14_OFFSET		0x0370
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA15_OFFSET		0x0374
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA16_OFFSET		0x0378
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA17_OFFSET		0x037C
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA18_OFFSET		0x0380
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA19_OFFSET		0x0384
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA20_OFFSET		0x0388
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA21_OFFSET		0x038C
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA22_OFFSET		0x0390
#define IOMUXC_SW_PAD_CTL_PAD_LCD_DATA23_OFFSET		0x0394
#define IOMUXC_SW_PAD_CTL_PAD_UART1_RX_DATA_OFFSET	0x0398
#define IOMUXC_SW_PAD_CTL_PAD_UART1_RX_DATA_DSE_0_X1		0
#define IOMUXC_SW_PAD_CTL_PAD_UART1_RX_DATA_DSE_1_X4		BIT(0)
#define IOMUXC_SW_PAD_CTL_PAD_UART1_RX_DATA_DSE_2_X2		BIT(1)
#define IOMUXC_SW_PAD_CTL_PAD_UART1_RX_DATA_DSE_3_X6		(BIT(1) | BIT(0))
#define IOMUXC_SW_PAD_CTL_PAD_UART1_RX_DATA_SRE_FAST		0
#define IOMUXC_SW_PAD_CTL_PAD_UART1_RX_DATA_SRE_SLOW		BIT(2)
#define IOMUXC_SW_PAD_CTL_PAD_UART1_RX_DATA_HYS_DIS		0
#define IOMUXC_SW_PAD_CTL_PAD_UART1_RX_DATA_HYS_EN		BIT(3)
#define IOMUXC_SW_PAD_CTL_PAD_UART1_RX_DATA_PE_DIS		0
#define IOMUXC_SW_PAD_CTL_PAD_UART1_RX_DATA_PE_EN		BIT(4)
#define IOMUXC_SW_PAD_CTL_PAD_UART1_RX_DATA_PS_0_100K_PD	0
#define IOMUXC_SW_PAD_CTL_PAD_UART1_RX_DATA_PS_1_5K_PU		BIT(5)
#define IOMUXC_SW_PAD_CTL_PAD_UART1_RX_DATA_PS_2_47K_PU		BIT(6)
#define IOMUXC_SW_PAD_CTL_PAD_UART1_RX_DATA_PS_3_100K_PU	(BIT(6) | BIT(5))

#define IOMUXC_SW_PAD_CTL_PAD_UART1_TX_DATA_OFFSET	0x039C
#define IOMUXC_SW_PAD_CTL_PAD_UART1_TX_DATA_DSE_0_X1		0
#define IOMUXC_SW_PAD_CTL_PAD_UART1_TX_DATA_DSE_1_X4		BIT(0)
#define IOMUXC_SW_PAD_CTL_PAD_UART1_TX_DATA_DSE_2_X2		BIT(1)
#define IOMUXC_SW_PAD_CTL_PAD_UART1_TX_DATA_DSE_3_X6		(BIT(1) | BIT(0))
#define IOMUXC_SW_PAD_CTL_PAD_UART1_TX_DATA_SRE_FAST		0
#define IOMUXC_SW_PAD_CTL_PAD_UART1_TX_DATA_SRE_SLOW		BIT(2)
#define IOMUXC_SW_PAD_CTL_PAD_UART1_TX_DATA_HYS_DIS		0
#define IOMUXC_SW_PAD_CTL_PAD_UART1_TX_DATA_HYS_EN		BIT(3)
#define IOMUXC_SW_PAD_CTL_PAD_UART1_TX_DATA_PE_DIS		0
#define IOMUXC_SW_PAD_CTL_PAD_UART1_TX_DATA_PE_EN		BIT(4)
#define IOMUXC_SW_PAD_CTL_PAD_UART1_TX_DATA_PS_0_100K_PD	0
#define IOMUXC_SW_PAD_CTL_PAD_UART1_TX_DATA_PS_1_5K_PU		BIT(5)
#define IOMUXC_SW_PAD_CTL_PAD_UART1_TX_DATA_PS_2_47K_PU		BIT(6)
#define IOMUXC_SW_PAD_CTL_PAD_UART1_TX_DATA_PS_3_100K_PU	(BIT(6) | BIT(5))

#define IOMUXC_SW_PAD_CTL_PAD_UART2_RX_DATA_OFFSET	0x03A0
#define IOMUXC_SW_PAD_CTL_PAD_UART2_TX_DATA_OFFSET	0x03A4
#define IOMUXC_SW_PAD_CTL_PAD_UART3_RX_DATA_OFFSET	0x03A8
#define IOMUXC_SW_PAD_CTL_PAD_UART3_TX_DATA_OFFSET	0x03AC
#define IOMUXC_SW_PAD_CTL_PAD_UART3_RTS_B_OFFSET	0x03B0
#define IOMUXC_SW_PAD_CTL_PAD_UART3_CTS_B_OFFSET	0x03B4

#define IOMUXC_SW_PAD_CTL_PAD_I2C1_SCL_OFFSET		0x03B8
#define IOMUXC_SW_PAD_CTL_PAD_I2C1_SDA_OFFSET		0x03BC
#define IOMUXC_SW_PAD_CTL_PAD_I2C2_SCL_OFFSET		0x03C0
#define IOMUXC_SW_PAD_CTL_PAD_I2C2_SDA_OFFSET		0x03C4
#define IOMUXC_SW_PAD_CTL_PAD_I2C3_SCL_OFFSET		0x03C8
#define IOMUXC_SW_PAD_CTL_PAD_I2C3_SDA_OFFSET		0x03CC
#define IOMUXC_SW_PAD_CTL_PAD_I2C4_SCL_OFFSET		0x03D0
#define IOMUXC_SW_PAD_CTL_PAD_I2C4_SDA_OFFSET		0x03D4

#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SCLK_OFFSET	0x03D8
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SCLK_DSE_0_X1	0
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SCLK_DSE_1_X4	BIT(0)
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SCLK_DSE_2_X2	BIT(1)
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SCLK_DSE_3_X6	(BIT(1) | BIT(0))
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SCLK_SRE_FAST	0
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SCLK_SRE_SLOW	BIT(2)
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SCLK_HYS_DIS	0
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SCLK_HYS_EN	BIT(3)
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SCLK_PE_DIS	0
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SCLK_PE_EN		BIT(4)
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SCLK_PS_0_100K_PD	0
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SCLK_PS_1_5K_PU	BIT(5)
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SCLK_PS_2_47K_PU	BIT(6)
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SCLK_PS_3_100K_PU	(BIT(6) | BIT(5))

#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MOSI_OFFSET	0x03DC
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MOSI_DSE_0_X1	0
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MOSI_DSE_1_X4	BIT(0)
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MOSI_DSE_2_X2	BIT(1)
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MOSI_DSE_3_X6	(BIT(1) | BIT(0))
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MOSI_SRE_FAST	0
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MOSI_SRE_SLOW	BIT(2)
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MOSI_HYS_DIS	0
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MOSI_HYS_EN	BIT(3)
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MOSI_PE_DIS	0
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MOSI_PE_EN		BIT(4)
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MOSI_PS_0_100K_PD	0
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MOSI_PS_1_5K_PU	BIT(5)
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MOSI_PS_2_47K_PU	BIT(6)
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MOSI_PS_3_100K_PU	(BIT(6) | BIT(5))

#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MISO_OFFSET	0x03E0
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SS0_OFFSET		0x03E4
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI2_SCLK_OFFSET	0x03E8
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI2_MOSI_OFFSET	0x03EC
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI2_MISO_OFFSET	0x03F0
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI2_SS0_OFFSET		0x03F4

#define IOMUXC_SW_PAD_CTL_PAD_SD1_CD_B_OFFSET		0x03F8
#define IOMUXC_SW_PAD_CTL_PAD_SD1_WP_OFFSET		0x03FC
#define IOMUXC_SW_PAD_CTL_PAD_SD1_RESET_B_OFFSET	0x0400
#define IOMUXC_SW_PAD_CTL_PAD_SD1_CLK_OFFSET		0x0404
#define IOMUXC_SW_PAD_CTL_PAD_SD1_CMD_OFFSET		0x0408
#define IOMUXC_SW_PAD_CTL_PAD_SD1_DATA0_OFFSET		0x040C
#define IOMUXC_SW_PAD_CTL_PAD_SD1_DATA1_OFFSET		0x0410
#define IOMUXC_SW_PAD_CTL_PAD_SD1_DATA2_OFFSET		0x0414
#define IOMUXC_SW_PAD_CTL_PAD_SD1_DATA3_OFFSET		0x0418
#define IOMUXC_SW_PAD_CTL_PAD_SD2_CD_B_OFFSET		0x041C
#define IOMUXC_SW_PAD_CTL_PAD_SD2_WP_OFFSET		0x0420
#define IOMUXC_SW_PAD_CTL_PAD_SD2_RESET_B_OFFSET	0x0424
#define IOMUXC_SW_PAD_CTL_PAD_SD2_CLK_OFFSET		0x0428
#define IOMUXC_SW_PAD_CTL_PAD_SD2_CMD_OFFSET		0x042C
#define IOMUXC_SW_PAD_CTL_PAD_SD2_DATA0_OFFSET		0x0430
#define IOMUXC_SW_PAD_CTL_PAD_SD2_DATA1_OFFSET		0x0434
#define IOMUXC_SW_PAD_CTL_PAD_SD2_DATA2_OFFSET		0x0438
#define IOMUXC_SW_PAD_CTL_PAD_SD2_DATA3_OFFSET		0x043C

#define IOMUXC_SW_PAD_CTL_PAD_SD3_CLK_OFFSET		0x0440
#define IOMUXC_SW_PAD_CTL_PAD_SD3_CMD_OFFSET		0x0444
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DATA0_OFFSET		0x0448
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DATA1_OFFSET		0x044C
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DATA2_OFFSET		0x0450
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DATA3_OFFSET		0x0454
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DATA4_OFFSET		0x0458
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DATA5_OFFSET		0x045C
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DATA6_OFFSET		0x0460
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DATA7_OFFSET		0x0464
#define IOMUXC_SW_PAD_CTL_PAD_SD3_STROBE_OFFSET		0x0468
#define IOMUXC_SW_PAD_CTL_PAD_SD3_RESET_B_OFFSET	0x046C
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DSE_0_X1		0
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DSE_1_X4		BIT(0)
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DSE_2_X2		BIT(1)
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DSE_3_X6		(BIT(1) | BIT(0))
#define IOMUXC_SW_PAD_CTL_PAD_SD3_DSE_1_X4		BIT(0)
#define IOMUXC_SW_PAD_CTL_PAD_SD3_SLEW_SLOW		BIT(2)
#define IOMUXC_SW_PAD_CTL_PAD_SD3_SLEW_FAST		0
#define IOMUXC_SW_PAD_CTL_PAD_SD3_HYS			BIT(3)
#define IOMUXC_SW_PAD_CTL_PAD_SD3_PE			BIT(4)
#define IOMUXC_SW_PAD_CTL_PAD_SD3_PD_100K		(0 << 5)
#define IOMUXC_SW_PAD_CTL_PAD_SD3_PU_5K			(1 << 5)
#define IOMUXC_SW_PAD_CTL_PAD_SD3_PU_47K		(2 << 5)
#define IOMUXC_SW_PAD_CTL_PAD_SD3_PU_100K		(3 << 5)

#define IOMUXC_SW_PAD_CTL_PAD_SAI1_RX_DATA_OFFSET	0x0470
#define IOMUXC_SW_PAD_CTL_PAD_SAI1_TX_BCLK_OFFSET	0x0474
#define IOMUXC_SW_PAD_CTL_PAD_SAI1_TX_SYNC_OFFSET	0x0478
#define IOMUXC_SW_PAD_CTL_PAD_SAI1_TX_DATA_OFFSET	0x047C
#define IOMUXC_SW_PAD_CTL_PAD_SAI1_RX_SYNC_OFFSET	0x0480
#define IOMUXC_SW_PAD_CTL_PAD_SAI1_RX_BCLK_OFFSET	0x0484
#define IOMUXC_SW_PAD_CTL_PAD_SAI1_MCLK_OFFSET		0x0488
#define IOMUXC_SW_PAD_CTL_PAD_SAI2_TX_SYNC_OFFSET	0x048C
#define IOMUXC_SW_PAD_CTL_PAD_SAI2_TX_BCLK_OFFSET	0x0490
#define IOMUXC_SW_PAD_CTL_PAD_SAI2_RX_DATA_OFFSET	0x0494
#define IOMUXC_SW_PAD_CTL_PAD_SAI2_TX_DATA_OFFSET	0x0498

#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_RD0_OFFSET	0x049C
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_RD1_OFFSET	0x04A0
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_RD2_OFFSET	0x04A4
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_RD3_OFFSET	0x04A8
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_RX_CTL_OFFSET	0x04AC
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_RXC_OFFSET	0x04B0
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_TD0_OFFSET	0x04B4
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_TD1_OFFSET	0x04B8
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_TD2_OFFSET	0x04BC
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_TD3_OFFSET	0x04C0
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_TX_CTL_OFFSET	0x04C4
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RGMII_TXC_OFFSET	0x04C8
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_TX_CLK_OFFSET	0x04CC
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_RX_CLK_OFFSET	0x04D0
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_CRS_OFFSET		0x04D4
#define IOMUXC_SW_PAD_CTL_PAD_ENET1_COL_OFFSET		0x04D8

#define IOMUXC_FLEXCAN1_RX_SELECT_INPUT_OFFSET		0x04DC
#define IOMUXC_FLEXCAN2_RX_SELECT_INPUT_OFFSET		0x04E0

#define IOMUXC_CCM_EXT_CLK_1_SELECT_INPUT_OFFSET	0x04E4
#define IOMUXC_CCM_EXT_CLK_2_SELECT_INPUT_OFFSET	0x04E8
#define IOMUXC_CCM_EXT_CLK_3_SELECT_INPUT_OFFSET	0x04EC
#define IOMUXC_CCM_EXT_CLK_4_SELECT_INPUT_OFFSET	0x04F0

#define IOMUXC_CCM_PMIC_READY_SELECT_INPUT_OFFSET	0x04F4

#define IOMUXC_CSI_DATA2_SELECT_INPUT_OFFSET		0x04F8
#define IOMUXC_CSI_DATA3_SELECT_INPUT_OFFSET		0x04FC
#define IOMUXC_CSI_DATA4_SELECT_INPUT_OFFSET		0x0500
#define IOMUXC_CSI_DATA5_SELECT_INPUT_OFFSET		0x0504
#define IOMUXC_CSI_DATA6_SELECT_INPUT_OFFSET		0x0508
#define IOMUXC_CSI_DATA7_SELECT_INPUT_OFFSET		0x050C
#define IOMUXC_CSI_DATA8_SELECT_INPUT_OFFSET		0x0510
#define IOMUXC_CSI_DATA9_SELECT_INPUT_OFFSET		0x0514
#define IOMUXC_CSI_HSYNC_SELECT_INPUT_OFFSET		0x0518
#define IOMUXC_CSI_PIXCLK_SELECT_INPUT_OFFSET		0x051C
#define IOMUXC_CSI_VSYNC_SELECT_INPUT_OFFSET		0x0520

#define IOMUXC_ECSPI1_SCLK_SELECT_INPUT_OFFSET		0x0524
#define IOMUXC_ECSPI1_MISO_SELECT_INPUT_OFFSET		0x0528
#define IOMUXC_ECSPI1_MOSI_SELECT_INPUT_OFFSET		0x052C
#define IOMUXC_ECSPI1_SS0_B_SELECT_INPUT_OFFSET		0x0530
#define IOMUXC_ECSPI2_SCLK_SELECT_INPUT_OFFSET		0x0534
#define IOMUXC_ECSPI2_MISO_SELECT_INPUT_OFFSET		0x0538
#define IOMUXC_ECSPI2_MOSI_SELECT_INPUT_OFFSET		0x053C
#define IOMUXC_ECSPI2_SS0_B_SELECT_INPUT_OFFSET		0x0540
#define IOMUXC_ECSPI3_SCLK_SELECT_INPUT_OFFSET		0x0544
#define IOMUXC_ECSPI3_MISO_SELECT_INPUT_OFFSET		0x0548
#define IOMUXC_ECSPI3_MOSI_SELECT_INPUT_OFFSET		0x054C
#define IOMUXC_ECSPI3_SS0_B_SELECT_INPUT_OFFSET		0x0550
#define IOMUXC_ECSPI4_SCLK_SELECT_INPUT_OFFSET		0x0554
#define IOMUXC_ECSPI4_MISO_SELECT_INPUT_OFFSET		0x0558
#define IOMUXC_ECSPI4_MOSI_SELECT_INPUT_OFFSET		0x055C
#define IOMUXC_ECSPI4_SS0_B_SELECT_INPUT_OFFSET		0x0560

#define IOMUXC_CCM_ENET1_REF_CLK_SELECT_INPUT_OFFSET	0x0564
#define IOMUXC_ENET1_MDIO_SELECT_INPUT_OFFSET		0x0568
#define IOMUXC_ENET1_RX_CLK_SELECT_INPUT_OFFSET		0x056C
#define IOMUXC_CCM_ENET2_REF_CLK_SELECT_INPUT_OFFSET	0x0570
#define IOMUXC_ENET2_MDIO_SELECT_INPUT_OFFSET		0x0574
#define IOMUXC_ENET2_RX_CLK_SELECT_INPUT_OFFSET		0x0578

#define IOMUXC_EPDC_PWR_IRQ_SELECT_INPUT_OFFSET		0x057C
#define IOMUXC_EPDC_PWR_STAT_SELECT_INPUT_OFFSET	0x0580

#define IOMUXC_FLEXTIMER1_CH0_SELECT_INPUT_OFFSET	0x0584
#define IOMUXC_FLEXTIMER1_CH1_SELECT_INPUT_OFFSET	0x0588
#define IOMUXC_FLEXTIMER1_CH2_SELECT_INPUT_OFFSET	0x058C
#define IOMUXC_FLEXTIMER1_CH3_SELECT_INPUT_OFFSET	0x0590
#define IOMUXC_FLEXTIMER1_CH4_SELECT_INPUT_OFFSET	0x0594
#define IOMUXC_FLEXTIMER1_CH5_SELECT_INPUT_OFFSET	0x0598
#define IOMUXC_FLEXTIMER1_CH6_SELECT_INPUT_OFFSET	0x059C
#define IOMUXC_FLEXTIMER1_CH7_SELECT_INPUT_OFFSET	0x05A0
#define IOMUXC_FLEXTIMER1_PHA_SELECT_INPUT_OFFSET	0x05A4
#define IOMUXC_FLEXTIMER1_PHB_SELECT_INPUT_OFFSET	0x05A8
#define IOMUXC_FLEXTIMER2_CH0_SELECT_INPUT_OFFSET	0x05AC
#define IOMUXC_FLEXTIMER2_CH1_SELECT_INPUT_OFFSET	0x05B0
#define IOMUXC_FLEXTIMER2_CH2_SELECT_INPUT_OFFSET	0x05B4
#define IOMUXC_FLEXTIMER2_CH3_SELECT_INPUT_OFFSET	0x05B8
#define IOMUXC_FLEXTIMER2_CH4_SELECT_INPUT_OFFSET	0x05BC
#define IOMUXC_FLEXTIMER2_CH5_SELECT_INPUT_OFFSET	0x05C0
#define IOMUXC_FLEXTIMER2_CH6_SELECT_INPUT_OFFSET	0x05C4
#define IOMUXC_FLEXTIMER2_CH7_SELECT_INPUT_OFFSET	0x05C8
#define IOMUXC_FLEXTIMER2_PHA_SELECT_INPUT_OFFSET	0x05CC
#define IOMUXC_FLEXTIMER2_PHB_SELECT_INPUT_OFFSET	0x05D0

#define IOMUXC_I2C1_SCL_SELECT_INPUT_OFFSET		0x05D4
#define IOMUXC_I2C1_SDA_SELECT_INPUT_OFFSET		0x05D8
#define IOMUXC_I2C2_SCL_SELECT_INPUT_OFFSET		0x05DC
#define IOMUXC_I2C2_SDA_SELECT_INPUT_OFFSET		0x05E0
#define IOMUXC_I2C3_SCL_SELECT_INPUT_OFFSET		0x05E4
#define IOMUXC_I2C3_SDA_SELECT_INPUT_OFFSET		0x05E8
#define IOMUXC_I2C4_SCL_SELECT_INPUT_OFFSET		0x05EC
#define IOMUXC_I2C4_SDA_SELECT_INPUT_OFFSET		0x05F0

#define IOMUXC_KPP_COL0_SELECT_INPUT_OFFSET		0x05F4
#define IOMUXC_KPP_COL1_SELECT_INPUT_OFFSET		0x05F8
#define IOMUXC_KPP_COL2_SELECT_INPUT_OFFSET		0x05FC
#define IOMUXC_KPP_COL3_SELECT_INPUT_OFFSET		0x0600
#define IOMUXC_KPP_COL4_SELECT_INPUT_OFFSET		0x0604
#define IOMUXC_KPP_COL5_SELECT_INPUT_OFFSET		0x0608
#define IOMUXC_KPP_COL6_SELECT_INPUT_OFFSET		0x060C
#define IOMUXC_KPP_COL7_SELECT_INPUT_OFFSET		0x0610
#define IOMUXC_KPP_ROW0_SELECT_INPUT_OFFSET		0x0614
#define IOMUXC_KPP_ROW1_SELECT_INPUT_OFFSET		0x0618
#define IOMUXC_KPP_ROW2_SELECT_INPUT_OFFSET		0x061C
#define IOMUXC_KPP_ROW3_SELECT_INPUT_OFFSET		0x0620
#define IOMUXC_KPP_ROW4_SELECT_INPUT_OFFSET		0x0624
#define IOMUXC_KPP_ROW5_SELECT_INPUT_OFFSET		0x0628
#define IOMUXC_KPP_ROW6_SELECT_INPUT_OFFSET		0x062C
#define IOMUXC_KPP_ROW7_SELECT_INPUT_OFFSET		0x0630

#define IOMUXC_LCD_BUSY_SELECT_INPUT_OFFSET		0x0634
#define IOMUXC_LCD_DATA00_SELECT_INPUT_OFFSET		0x0638
#define IOMUXC_LCD_DATA01_SELECT_INPUT_OFFSET		0x063C
#define IOMUXC_LCD_DATA02_SELECT_INPUT_OFFSET		0x0640
#define IOMUXC_LCD_DATA03_SELECT_INPUT_OFFSET		0x0644
#define IOMUXC_LCD_DATA04_SELECT_INPUT_OFFSET		0x0648
#define IOMUXC_LCD_DATA05_SELECT_INPUT_OFFSET		0x064C
#define IOMUXC_LCD_DATA06_SELECT_INPUT_OFFSET		0x0650
#define IOMUXC_LCD_DATA07_SELECT_INPUT_OFFSET		0x0654
#define IOMUXC_LCD_DATA08_SELECT_INPUT_OFFSET		0x0658
#define IOMUXC_LCD_DATA09_SELECT_INPUT_OFFSET		0x065C
#define IOMUXC_LCD_DATA10_SELECT_INPUT_OFFSET		0x0660
#define IOMUXC_LCD_DATA11_SELECT_INPUT_OFFSET		0x0664
#define IOMUXC_LCD_DATA12_SELECT_INPUT_OFFSET		0x0668
#define IOMUXC_LCD_DATA13_SELECT_INPUT_OFFSET		0x066C
#define IOMUXC_LCD_DATA14_SELECT_INPUT_OFFSET		0x0670
#define IOMUXC_LCD_DATA15_SELECT_INPUT_OFFSET		0x0674
#define IOMUXC_LCD_DATA16_SELECT_INPUT_OFFSET		0x0678
#define IOMUXC_LCD_DATA17_SELECT_INPUT_OFFSET		0x067C
#define IOMUXC_LCD_DATA18_SELECT_INPUT_OFFSET		0x0680
#define IOMUXC_LCD_DATA19_SELECT_INPUT_OFFSET		0x0684
#define IOMUXC_LCD_DATA20_SELECT_INPUT_OFFSET		0x0688
#define IOMUXC_LCD_DATA21_SELECT_INPUT_OFFSET		0x068C
#define IOMUXC_LCD_DATA22_SELECT_INPUT_OFFSET		0x0690
#define IOMUXC_LCD_DATA23_SELECT_INPUT_OFFSET		0x0694
#define IOMUXC_LCD_VSYNC_SELECT_INPUT_OFFSET		0x0698

#define IOMUXC_SAI1_RX_BCLK_SELECT_INPUT_OFFSET		0x069C
#define IOMUXC_SAI1_RX_DATA_SELECT_INPUT_OFFSET		0x06A0
#define IOMUXC_SAI1_RX_SYNC_SELECT_INPUT_OFFSET		0x06A4
#define IOMUXC_SAI1_TX_BCLK_SELECT_INPUT_OFFSET		0x06A8
#define IOMUXC_SAI1_TX_SYNC_SELECT_INPUT_OFFSET		0x06AC
#define IOMUXC_SAI2_RX_BCLK_SELECT_INPUT_OFFSET		0x06B0
#define IOMUXC_SAI2_RX_DATA_SELECT_INPUT_OFFSET		0x06B4
#define IOMUXC_SAI2_RX_SYNC_SELECT_INPUT_OFFSET		0x06B8
#define IOMUXC_SAI2_TX_BCLK_SELECT_INPUT_OFFSET		0x06BC
#define IOMUXC_SAI2_TX_SYNC_SELECT_INPUT_OFFSET		0x06C0
#define IOMUXC_SAI3_RX_BCLK_SELECT_INPUT_OFFSET		0x06C4
#define IOMUXC_SAI3_RX_DATA_SELECT_INPUT_OFFSET		0x06C8
#define IOMUXC_SAI3_RX_SYNC_SELECT_INPUT_OFFSET		0x06CC
#define IOMUXC_SAI3_TX_BCLK_SELECT_INPUT_OFFSET		0x06D0
#define IOMUXC_SAI3_TX_SYNC_SELECT_INPUT_OFFSET		0x06D4
#define IOMUXC_SDMA_EVENTS0_SELECT_INPUT_OFFSET		0x06D8
#define IOMUXC_SDMA_EVENTS1_SELECT_INPUT_OFFSET		0x06DC

#define IOMUXC_SIM1_PORT1_PD_SELECT_INPUT_OFFSET	0x06E0
#define IOMUXC_SIM1_PORT1_TRXD_SELECT_INPUT_OFFSET	0x06E4
#define IOMUXC_SIM2_PORT1_PD_SELECT_INPUT_OFFSET	0x06E8
#define IOMUXC_SIM2_PORT1_TRXD_SELECT_INPUT_OFFSET	0x06EC

#define IOMUXC_UART1_RTS_B_SELECT_INPUT_OFFSET		0x06F0
#define IOMUXC_UART1_RX_DATA_SELECT_INPUT_OFFSET	0x06F4
#define IOMUXC_UART2_RTS_B_SELECT_INPUT_OFFSET		0x06F8
#define IOMUXC_UART2_RX_DATA_SELECT_INPUT_OFFSET	0x06FC
#define IOMUXC_UART3_RTS_B_SELECT_INPUT_OFFSET		0x0700
#define IOMUXC_UART3_RX_DATA_SELECT_INPUT_OFFSET	0x0704
#define IOMUXC_UART4_RTS_B_SELECT_INPUT_OFFSET		0x0708
#define IOMUXC_UART4_RX_DATA_SELECT_INPUT_OFFSET	0x070C
#define IOMUXC_UART5_RTS_B_SELECT_INPUT_OFFSET		0x0710

#define IOMUXC_UART5_RX_DATA_SELECT_INPUT_OFFSET	0x0714
#define IOMUXC_UART5_RX_DATA_SELECT_INPUT_I2C4_SCL_ALT1	0x00
#define IOMUXC_UART5_RX_DATA_SELECT_INPUT_I2C4_SDA_ALT1	BIT(0)
#define IOMUXC_UART5_RX_DATA_SELECT_INPUT_SAI1_RX_DATA_ALT2	BIT(1)
#define IOMUXC_UART5_RX_DATA_SELECT_INPUT_SAI1_TX_BCLK_ALT2	(BIT(1) | BIT(0))
#define IOMUXC_UART5_RX_DATA_SELECT_INPUT_GPIO1_IO06_ALT3	BIT(2)
#define IOMUXC_UART5_RX_DATA_SELECT_INPUT_GPIO1_IO07_ALT3	(BIT(2) | BIT(1))

#define IOMUXC_UART6_RTS_B_SELECT_INPUT_OFFSET		0x0718
#define IOMUXC_UART6_RX_DATA_SELECT_INPUT_OFFSET	0x071C
#define IOMUXC_UART7_RTS_B_SELECT_INPUT_OFFSET		0x0720
#define IOMUXC_UART7_RX_DATA_SELECT_INPUT_OFFSET	0x0724

#define IOMUXC_USB_OTG2_OC_SELECT_INPUT_OFFSET		0x0728
#define IOMUXC_USB_OTG1_OC_SELECT_INPUT_OFFSET		0x072C
#define IOMUXC_USB_OTG2_ID_SELECT_INPUT_OFFSET		0x0730
#define IOMUXC_USB_OTG1_ID_SELECT_INPUT_OFFSET		0x0734
#define IOMUXC_SD3_CD_B_SELECT_INPUT_OFFSET		0x0738
#define IOMUXC_SD3_WP_SELECT_INPUT_OFFSET		0x073C

/* Pad mux/feature set routines */

void imx_io_muxc_set_pad_alt_function(uint32_t pad_mux_offset, uint32_t alt_function);
void imx_io_muxc_set_pad_features(uint32_t pad_feature_offset, uint32_t pad_features);

#endif /* IMX_IO_MUX_H */
