# Copyright (C) 2005 JanRain, Inc.
# Copyright (C) 2009, 2010 Canonical Ltd
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from apache_openid import logging

known_handlers = {}

class UnknownHandlerException(Exception):
    pass

class Factory(object):
    def __init__(self, request, response, options, session, action_path):
        self.request = request
        self.response = response
        self.options = options
        self.session = session
        self.action_path = action_path

    def get_handler(self, requested_handler):
        logging.debug("Looking for handler: %s", requested_handler)
        for handler in known_handlers:
            logging.debug("Found handler: %s", handler)
            if handler == requested_handler:
                return known_handlers[handler](self.request, self.response,
                    self.options, self.session, self.action_path)
        raise UnknownHandlerException()

