#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (c) 2021, Cisco Systems
# GNU General Public License v3.0+ (see LICENSE or https://www.gnu.org/licenses/gpl-3.0.txt)

DOCUMENTATION = r"""
---
module: devices_camera_wireless_profiles
short_description: Resource module for devices _camera _wirelessprofiles
description:
- Manage operation update of the resource devices _camera _wirelessprofiles.
- >
   Assign wireless profiles to the given camera. Incremental updates are not supported, all profile assignment need
   to be supplied at once.
version_added: '2.16.0'
extends_documentation_fragment:
  - cisco.meraki.module
author: Francisco Munoz (@fmunoz)
options:
  ids:
    description: The ids of the wireless profile to assign to the given camera.
    suboptions:
      backup:
        description: The id of the backup wireless profile.
        type: str
      primary:
        description: The id of the primary wireless profile.
        type: str
      secondary:
        description: The id of the secondary wireless profile.
        type: str
    type: dict
  serial:
    description: Serial path parameter.
    type: str
requirements:
- meraki >= 2.4.9
- python >= 3.5
seealso:
- name: Cisco Meraki documentation for devices updateDeviceCameraWirelessProfiles
  description: Complete reference of the updateDeviceCameraWirelessProfiles API.
  link: https://developer.cisco.com/meraki/api-v1/#!update-device-camera-wireless-profiles
notes:
  - SDK Method used are
    devices.Devices.update_device_camera_wireless_profiles,

  - Paths used are
    put /devices/{serial}/camera/wirelessProfiles,
"""

EXAMPLES = r"""
- name: Update all
  cisco.meraki.devices_camera_wireless_profiles:
    meraki_api_key: "{{meraki_api_key}}"
    meraki_base_url: "{{meraki_base_url}}"
    meraki_single_request_timeout: "{{meraki_single_request_timeout}}"
    meraki_certificate_path: "{{meraki_certificate_path}}"
    meraki_requests_proxy: "{{meraki_requests_proxy}}"
    meraki_wait_on_rate_limit: "{{meraki_wait_on_rate_limit}}"
    meraki_nginx_429_retry_wait_time: "{{meraki_nginx_429_retry_wait_time}}"
    meraki_action_batch_retry_wait_time: "{{meraki_action_batch_retry_wait_time}}"
    meraki_retry_4xx_error: "{{meraki_retry_4xx_error}}"
    meraki_retry_4xx_error_wait_time: "{{meraki_retry_4xx_error_wait_time}}"
    meraki_maximum_retries: "{{meraki_maximum_retries}}"
    meraki_output_log: "{{meraki_output_log}}"
    meraki_log_file_prefix: "{{meraki_log_file_prefix}}"
    meraki_log_path: "{{meraki_log_path}}"
    meraki_print_console: "{{meraki_print_console}}"
    meraki_suppress_logging: "{{meraki_suppress_logging}}"
    meraki_simulate: "{{meraki_simulate}}"
    meraki_be_geo_id: "{{meraki_be_geo_id}}"
    meraki_use_iterator_for_get_pages: "{{meraki_use_iterator_for_get_pages}}"
    meraki_inherit_logging_config: "{{meraki_inherit_logging_config}}"
    state: present
    ids:
      backup: '1'
      primary: '3'
      secondary: '2'
    serial: string

"""
RETURN = r"""
meraki_response:
  description: A dictionary or list with the response returned by the Cisco Meraki Python SDK
  returned: always
  type: dict
  sample: >
    {}
"""
